/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.AbstractRowMarkerSupport;
import com.jidesoft.range.IntegerRange;
import java.awt.Point;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TextAreaRowMarkerSupport
extends AbstractRowMarkerSupport {
    private JTextArea _textArea;

    public TextAreaRowMarkerSupport(JTextArea jTextArea) {
        this._textArea = jTextArea;
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        if (n <= n2) {
            if (n2 >= this._textArea.getDocument().getLength()) {
                n2 = this._textArea.getDocument().getLength() - 1;
            }
            if (bl) {
                this._textArea.setCaretPosition(n);
                this._textArea.moveCaretPosition(n2);
            } else {
                this._textArea.setCaretPosition(n2);
            }
        } else {
            if (n >= this._textArea.getDocument().getLength()) {
                n = this._textArea.getDocument().getLength() - 1;
            }
            if (bl) {
                this._textArea.setCaretPosition(n2);
                this._textArea.moveCaretPosition(n);
            } else {
                this._textArea.setCaretPosition(n2);
            }
        }
        this._textArea.requestFocus();
    }

    @Override
    public Point indexToPoint(int n, int n2) {
        try {
            int n3 = this._textArea.getLineOfOffset(n);
            return super.indexToPoint(n3, n2);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public IntegerRange pointToIndexRange(Point point, int n) {
        IntegerRange integerRange = super.pointToIndexRange(point, n);
        try {
            return new IntegerRange(this._textArea.getLineStartOffset(integerRange.getMin()), this._textArea.getLineEndOffset(integerRange.getMax()));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getRowHeight() {
        return this._textArea.getFontMetrics(this._textArea.getFont()).getHeight();
    }

    @Override
    public int getRowCount() {
        return this._textArea.getLineCount();
    }
}

