/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.lucene.LuceneDocumentProvider;
import com.jidesoft.lucene.LuceneFilterField;
import com.jidesoft.lucene.LuceneFilterMenuSupport;
import com.jidesoft.lucene.LuceneFilterableTableModel;
import com.jidesoft.swing.JidePopupMenu;
import java.util.HashSet;
import javax.swing.table.TableModel;

public class LuceneQuickTableFilterField
extends QuickTableFilterField
implements LuceneFilterField {
    private boolean _luceneInputMode = false;
    private LuceneFilterMenuSupport _luceneFilterMenuSupport;

    public LuceneQuickTableFilterField() {
        this(null, null, null);
    }

    public LuceneQuickTableFilterField(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public LuceneQuickTableFilterField(TableModel tableModel, int[] nArray) {
        this(tableModel, nArray, null);
    }

    public LuceneQuickTableFilterField(TableModel tableModel, int[] nArray, String[] stringArray) {
        super(tableModel, nArray, stringArray);
    }

    @Override
    public void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        if (this.getDisplayTableModel() != null) {
            this._luceneFilterMenuSupport = new LuceneFilterMenuSupport(this, ((LuceneFilterableTableModel)this.getDisplayTableModel()).getLuceneSupport());
        }
    }

    @Override
    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            throw new IllegalArgumentException("LuceneFilterableTableModel cannot work with TreeTableModel so far.");
        }
        return new LuceneFilterableTableModel(tableModel){
            private static final long serialVersionUID = -2393614942784983642L;

            @Override
            public boolean isColumnVisible(int n) {
                return LuceneQuickTableFilterField.this.shouldColumnBeIncluded(n) && super.isColumnVisible(n);
            }
        };
    }

    String[] getDisplayColumnNames() {
        String[] stringArray;
        block2: {
            TableModel tableModel;
            block3: {
                tableModel = this.getTableModel();
                stringArray = null;
                if (tableModel == null) break block2;
                if (this.getColumnIndices() != null && this.getColumnIndices().length != 0) break block3;
                stringArray = new String[tableModel.getColumnCount()];
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    stringArray[i] = !this.getDisplayTableModel().isColumnVisible(i) ? null : tableModel.getColumnName(i);
                }
                break block2;
            }
            if (this.getColumnIndices() == null) break block2;
            stringArray = new String[this.getColumnIndices().length];
            for (int i = 0; i < this.getColumnIndices().length; ++i) {
                stringArray[i] = !this.getDisplayTableModel().isColumnVisible(i) ? null : (this.getDisplayNames() != null ? this.getDisplayNames()[i] : tableModel.getColumnName(i));
            }
        }
        return stringArray;
    }

    public LuceneDocumentProvider getLuceneDocumentProvider() {
        if (this.getDisplayTableModel() instanceof LuceneDocumentProvider) {
            return (LuceneDocumentProvider)((Object)this.getDisplayTableModel());
        }
        return null;
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        JidePopupMenu jidePopupMenu = super.createContextMenu();
        if (this.getDisplayTableModel() instanceof LuceneFilterableTableModel && this._luceneFilterMenuSupport != null) {
            this._luceneFilterMenuSupport.customizePopupMenu(jidePopupMenu, this.getDisplayColumnNames());
        }
        return jidePopupMenu;
    }

    @Override
    public void applyFilter(String string) {
        if (this.getDisplayTableModel() instanceof LuceneFilterableTableModel) {
            if (!this.isLuceneInputMode()) {
                super.changeFilter();
            }
            this.parseInputText(string, this.isLuceneInputMode());
            boolean bl = ((LuceneFilterableTableModel)this.getDisplayTableModel()).isNeedAdjustFilter();
            try {
                ((LuceneFilterableTableModel)this.getDisplayTableModel()).setNeedAdjustFilter(!this.isLuceneInputMode() && string != null && string.contains(" "));
                this.getDisplayTableModel().setFiltersApplied(true);
            }
            finally {
                ((LuceneFilterableTableModel)this.getDisplayTableModel()).setNeedAdjustFilter(bl);
            }
            this.adjustMismatchColor(this.getDisplayTableModel().getRowCount() != 0);
        }
    }

    private boolean isValidInput(String string) {
        char[] cArray;
        if (string == null || string.length() == 0) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (c == '*' || c == '?') continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFromStart(boolean bl) {
        super.setFromStart(bl);
        if (bl) {
            ((LuceneFilterableTableModel)this.getDisplayTableModel()).setAllowLeadingWildcard(true);
        }
    }

    @Override
    public void setFromEnd(boolean bl) {
        super.setFromEnd(bl);
        if (bl) {
            ((LuceneFilterableTableModel)this.getDisplayTableModel()).setAllowLeadingWildcard(true);
        }
    }

    private void parseInputText(String string, boolean bl) {
        IFilterableTableModel iFilterableTableModel = this.getDisplayTableModel();
        if (iFilterableTableModel == null || iFilterableTableModel.getColumnCount() == 0 || !(iFilterableTableModel instanceof LuceneFilterableTableModel)) {
            return;
        }
        String string2 = string;
        if (!bl) {
            if (!this.isValidInput(string)) {
                ((LuceneFilterableTableModel)iFilterableTableModel).getLuceneSupport().clearQuery();
                return;
            }
            string = this.escapeInput(string);
            HashSet hashSet = new HashSet(this._actualSearchingColumnIndices);
            string2 = "";
            int n = iFilterableTableModel.getColumnCount();
            boolean bl2 = this.isSearchingAllColumns();
            for (int i = 0; i < n; ++i) {
                if (!hashSet.contains(i) && !bl2) continue;
                string2 = string2 + ((LuceneFilterableTableModel)iFilterableTableModel).getFieldNameForColumn(i) + ":";
                if (this.isFromStart()) {
                    string2 = string2 + string;
                    if (!(this.isFromEnd() || string.contains(" ") || "*".equals(string.substring(string.length() - 1)))) {
                        string2 = string2 + "*";
                    }
                } else {
                    if (!"*".equals(string.substring(0, 1))) {
                        string2 = string2 + "*";
                    }
                    string2 = string2 + string;
                    if (!string.contains(" ") && !"*".equals(string.substring(string.length() - 1, string.length()))) {
                        string2 = string2 + "*";
                    }
                }
                string2 = string2 + " OR ";
            }
            string2 = string2.substring(0, string2.length() - " OR ".length());
        } else {
            int n = iFilterableTableModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                string2 = string2.replaceAll(iFilterableTableModel.getColumnName(i) + ":", ((LuceneFilterableTableModel)iFilterableTableModel).getFieldNameForColumn(i) + ":");
            }
        }
        ((LuceneFilterableTableModel)iFilterableTableModel).getLuceneSupport().createQuery(string2, iFilterableTableModel.getColumnName(0).toLowerCase());
    }

    private String escapeInput(String string) {
        String[] stringArray;
        String string2 = "\\ + - & | ! ( ) { } [ ] ^ \" ~ * ? :";
        for (String string3 : stringArray = string2.split(" ")) {
            string = string.replace(string3, "\\" + string3);
        }
        return string;
    }

    @Override
    public boolean isLuceneInputMode() {
        return this._luceneInputMode;
    }

    @Override
    public void setLuceneInputMode(boolean bl) {
        this._luceneInputMode = bl;
        this.applyFilter(this.getSearchingText());
    }

    @Deprecated
    public static String getLuceneHelpURL() {
        return LuceneFilterMenuSupport.getLuceneHelpURL();
    }

    @Deprecated
    public static void setLuceneHelpURL(String string) {
        LuceneFilterMenuSupport.setLuceneHelpURL(string);
    }
}

