/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.HtmlUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class ImagePreviewPanel
extends JPanel {
    private static final int MISSING_IMAGE_SIZE = 100;
    private static final int DETAIL_PANEL_WIDTH = 60;
    private Color _gridForeground;
    private Color _gridBackground;
    private Color _highlightBackground;
    private ImageIcon _icon;
    private String _imageTitle;
    private Dimension _imageSize;
    private String _imageDescription;
    private boolean _selected;
    private boolean _focused;
    private int _showDetails = 255;
    private ImagePanel _imagePanel;
    private JLabel _titleField;
    private JLabel _sizeField;
    private JTextArea _descriptionField;

    public ImagePreviewPanel() {
        this.initComponents();
    }

    public ImagePreviewPanel(String string, ImageIcon imageIcon, Dimension dimension, String string2, int n) {
        this._imageTitle = string;
        this._icon = imageIcon;
        this._imageSize = dimension;
        this._imageDescription = string2;
        this._showDetails = n;
        this.initComponents();
    }

    public Dimension getImageSize() {
        return this._imageSize;
    }

    public void setImageSize(Dimension dimension) {
        this._imageSize = dimension;
        this.updateSize();
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        this._imagePanel = new ImagePanel(this._icon);
        this.add(this._imagePanel);
        if (this.getShowDetails() != 0) {
            JComponent jComponent = this.createDetailsPanel();
            JideSwingUtilities.setOpaqueRecursively(jComponent, false);
            this.add((Component)jComponent, "After");
        }
        this.updateTooltip();
    }

    protected JComponent createDetailsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1, 2));
        if ((this.getShowDetails() & 1) != 0) {
            this._titleField = new JLabel(this.getImageTitle() != null ? this.getImageTitle() : ""){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 12);
                }
            };
            jPanel.add(this.createLabel(this.getResourceString("ImagePreviewList.title"), this._titleField));
        }
        if ((this.getShowDetails() & 4) != 0) {
            this._sizeField = new JLabel(this.getSizeString()){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 12);
                }
            };
            jPanel.add(this.createLabel(this.getResourceString("ImagePreviewList.size"), this._sizeField));
        }
        if ((this.getShowDetails() & 2) != 0) {
            this._descriptionField = new MultilineLabel(this.getImageDescription() != null ? this.getImageDescription() : ""){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 20);
                }
            };
            JScrollPane jScrollPane = new JScrollPane(this._descriptionField);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)this.createDescription(this.getResourceString("ImagePreviewList.description"), jScrollPane), "vary");
        } else {
            jPanel.add(Box.createGlue(), "vary");
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        return jPanel;
    }

    private String getSizeString() {
        Dimension dimension = this.getImageSize();
        if (dimension == null) {
            return this.getIcon() != null ? this.getIcon().getIconWidth() + " x " + this.getIcon().getIconHeight() : "";
        }
        return dimension.width + " x " + dimension.height;
    }

    protected JComponent createDescription(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(UIDefaultsLookup.getFont("TitledBorder.font"));
        jPanel.add((Component)jLabel, "First");
        jPanel.add(jComponent);
        return jPanel;
    }

    protected JComponent createLabel(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(UIDefaultsLookup.getFont("TitledBorder.font"));
        jPanel.add((Component)jLabel, "Before");
        if (jComponent instanceof JTextComponent) {
            ((JTextComponent)jComponent).setEditable(false);
        }
        jComponent.setBorder(BorderFactory.createEmptyBorder());
        jComponent.setOpaque(false);
        jPanel.add(jComponent);
        return jPanel;
    }

    public ImagePreviewPanel(String string, ImageIcon imageIcon) {
        this._imageTitle = string;
        this._icon = imageIcon;
    }

    @Override
    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        graphics.setColor(this.getGridBackground());
        graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        graphics.setColor(this.getGridForeground());
        graphics.drawRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        super.paint(graphics);
        if (this.isSelected()) {
            Color color = this.getHighlightBackground();
            graphics.setColor(color);
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
        if (this.isFocused()) {
            graphics.setColor(new Color(~this.getBackground().getRGB()));
            BasicGraphicsUtils.drawDashedRect(graphics, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean bl) {
        this._selected = bl;
        this.repaint();
    }

    public boolean isFocused() {
        return this._focused;
    }

    public void setFocused(boolean bl) {
        this._focused = bl;
        this.repaint();
    }

    public ImageIcon getIcon() {
        return this._icon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this._icon = imageIcon;
        this._imagePanel.setImageIcon(imageIcon);
        this.updateSize();
        this.repaint();
    }

    private void updateSize() {
        String string = this.getSizeString();
        if (this._sizeField != null && !JideSwingUtilities.equals(this._sizeField.getText(), string)) {
            this._sizeField.setText(string);
        }
    }

    public String getImageTitle() {
        return this._imageTitle;
    }

    public void setImageTitle(String string) {
        this._imageTitle = string;
        if (this._titleField != null && !JideSwingUtilities.equals(this._titleField.getText(), this._imageTitle)) {
            this._titleField.setText(this._imageTitle);
        }
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.getImageTitle() == null && this.getImageDescription() == null) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText("<HTML>" + (this.getImageTitle() != null ? "<B>" + HtmlUtils.formatHtmlSubString(this.getResourceString("ImagePreviewList.title")) + "</B> " + HtmlUtils.formatHtmlSubString(this.getImageTitle()) : "") + (this.getImageDescription() != null ? "<BR><B>" + HtmlUtils.formatHtmlSubString(this.getResourceString("ImagePreviewList.description")) + "</B> " + HtmlUtils.formatHtmlSubString(this.getImageDescription()) : "") + "</HTML>");
        }
    }

    public String getImageDescription() {
        return this._imageDescription;
    }

    public void setImageDescription(String string) {
        this._imageDescription = string;
        if (this._descriptionField != null && !JideSwingUtilities.equals(this._descriptionField.getText(), this._imageDescription)) {
            this._descriptionField.setText(this._imageDescription);
        }
        this.updateTooltip();
    }

    public int getShowDetails() {
        return this._showDetails;
    }

    public void setShowDetails(int n) {
        int n2 = this._showDetails;
        if (n2 != n) {
            this._showDetails = n;
            this.initComponents();
        }
    }

    private static BufferedImage createThumbnail(Component component, ImageIcon imageIcon, int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (n >= imageIcon.getIconWidth() / 2) {
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
            graphics2D.dispose();
            return bufferedImage;
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), component);
        graphics2D.dispose();
        return JideSwingUtilities.getFasterScaledInstance(bufferedImage, n, n2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public Color getGridForeground() {
        return this._gridForeground;
    }

    public void setGridForeground(Color color) {
        this._gridForeground = color;
    }

    public Color getGridBackground() {
        return this._gridBackground;
    }

    public void setGridBackground(Color color) {
        this._gridBackground = color;
    }

    public Color getHighlightBackground() {
        return this._highlightBackground;
    }

    public void setHighlightBackground(Color color) {
        this._highlightBackground = color;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.list.list", this.getLocale()).getString(string);
    }

    private class ImagePanel
    extends JComponent {
        private ImageIcon _imageIcon;
        private int _borderSize = 12;

        public ImagePanel() {
            this.setDoubleBuffered(true);
        }

        public ImagePanel(ImageIcon imageIcon) {
            this._imageIcon = imageIcon;
            this.setDoubleBuffered(true);
        }

        public void setImageIcon(ImageIcon imageIcon) {
            this._imageIcon = imageIcon;
        }

        public int getBorderSize() {
            return this._borderSize;
        }

        public void setBorderSize(int n) {
            this._borderSize = n;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            if (this.isOpaque()) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n5, n6);
            }
            if ((n4 = this._imageIcon != null ? this._imageIcon.getIconWidth() : 100) * (n3 = n6 - 2 * this._borderSize) > (n2 = n5 - 2 * this._borderSize) * (n = this._imageIcon != null ? this._imageIcon.getIconHeight() : 100)) {
                n3 = n2 * n / n4;
            } else if (n4 * n3 < n2 * n) {
                n2 = n3 * n4 / n;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n3 > n) {
                n3 = n;
            }
            if (n2 < 0 || n3 < 0) {
                return;
            }
            int n7 = (n5 - n2) / 2;
            int n8 = (n6 - n3) / 2;
            JideSwingUtilities.drawShadow(graphics2D, this, n7, n8, n2, n3);
            graphics2D.setColor(ImagePreviewPanel.this.getGridForeground());
            graphics2D.drawRect(n7 - 1, n8 - 1, n2 + 1, n3 + 1);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n7, n8, n2, n3);
            if (this._imageIcon != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(n4 == n2 ? this._imageIcon.getImage() : ImagePreviewPanel.createThumbnail(this, this._imageIcon, n2, n3), n7, n8, this);
            }
            graphics2D.dispose();
        }
    }
}

