/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ImagePreviewCellRenderer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListModel;

public class ImagePreviewList
extends JList {
    private Dimension _cellDimension;
    private Color _gridForeground;
    private Color _gridBackground;
    private Color _highlightBackground;
    private int _showDetails = 255;
    private ImagePreviewCellRenderer _renderer;
    public static final int SHOW_NONE = 0;
    public static final int SHOW_TITLE = 1;
    public static final int SHOW_DESCRIPTION = 2;
    public static final int SHOW_SIZE = 4;
    public static final int SHOW_ALL = 255;

    public ImagePreviewList() {
        this.configureList();
    }

    public ImagePreviewList(Vector<?> vector) {
        super(vector);
        this.configureList();
    }

    public ImagePreviewList(Object[] objectArray) {
        super(objectArray);
        this.configureList();
    }

    public ImagePreviewList(ListModel listModel) {
        super(listModel);
        this.configureList();
    }

    protected void configureList() {
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.setSelectionMode(2);
        this._renderer = new ImagePreviewCellRenderer();
        this.setCellRenderer(this._renderer);
        this.setFixedCellHeight(this.getCellDimension().height);
        this.setFixedCellWidth(this.getCellDimension().width);
    }

    public int getShowDetails() {
        return this._showDetails;
    }

    public void setShowDetails(int n) {
        this._showDetails = n;
        this.repaint();
    }

    public Dimension getCellDimension() {
        if (this._cellDimension == null) {
            return this._showDetails != 0 ? new Dimension(250, 130) : new Dimension(130, 130);
        }
        return this._cellDimension;
    }

    public void setCellDimension(Dimension dimension) {
        this._cellDimension = dimension;
        this.setFixedCellHeight(this.getCellDimension().height);
        this.setFixedCellWidth(this.getCellDimension().width);
    }

    private static Color getSelectionColor() {
        Color color = ImagePreviewList.getBaseColor();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color2 = Color.getHSBColor(fArray[0], (double)fArray[1] > 0.01 ? 0.45f : fArray[0], 0.8f);
        return new Color(color2.getRGB() & 0x64FFFFFF, true);
    }

    private static Color getBaseColor() {
        return UIDefaultsLookup.getColor("activeCaption");
    }

    private static Color getControlColor() {
        return UIDefaultsLookup.getColor("Label.background");
    }

    public Color getGridForeground() {
        return this._gridForeground == null ? ImagePreviewList.getControlColor() : this._gridForeground;
    }

    public void setGridForeground(Color color) {
        this._gridForeground = color;
        this.repaint();
    }

    public Color getGridBackground() {
        return this._gridBackground == null ? UIDefaultsLookup.getColor("MenuItem.background") : this._gridBackground;
    }

    public void setGridBackground(Color color) {
        this._gridBackground = color;
        this.repaint();
    }

    public Color getHighlightBackground() {
        return this._highlightBackground == null ? ImagePreviewList.getSelectionColor() : this._highlightBackground;
    }

    public void setHighlightBackground(Color color) {
        this._highlightBackground = color;
        if (this.getSelectedIndex() != -1) {
            this.repaint();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(ImagePreviewList.class.getName(), 4);
        }
    }

    public static interface PreviewImageIcon {
        public ImageIcon getImageIcon();

        public String getTitle();

        public Dimension getSize();

        public String getDescription();
    }
}

