/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.DualListModel;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DualListModelSupport
implements DualListModel {
    protected DualListModel _target;
    protected EventListenerList _listenerList = new EventListenerList();
    protected List<Integer> _selectedIndices = new ArrayList<Integer>();
    protected List<Integer> _freezeIndices = new ArrayList<Integer>();
    protected int _selectionMode = 0;
    private int _firstChangedIndex = Integer.MAX_VALUE;
    private int _lastChangedIndex = -1;
    protected boolean _valueIsAdjusting = false;

    public DualListModelSupport(DualListModel dualListModel) {
        this._target = dualListModel;
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._selectedIndices.add(i);
        }
        this._firstChangedIndex = Collections.min(Arrays.asList(n, n2, this._firstChangedIndex));
        this._lastChangedIndex = Collections.max(Arrays.asList(n, n2, this._lastChangedIndex));
        this.fireValueChanged(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        this.removeSelectionIntervalImpl(n, n2);
        this._firstChangedIndex = Collections.min(Arrays.asList(n, n2, this._firstChangedIndex));
        this._lastChangedIndex = Collections.max(Arrays.asList(n, n2, this._lastChangedIndex));
        this.fireValueChanged(n, n2);
    }

    private void removeSelectionIntervalImpl(int n, int n2) {
        List<Integer> list = this._selectedIndices.subList(0, n);
        List<Integer> list2 = this._selectedIndices.subList(n2 + 1, this._selectedIndices.size());
        this._selectedIndices = new ArrayList<Integer>();
        this._selectedIndices.addAll(list);
        this._selectedIndices.addAll(list2);
    }

    @Override
    public void moveSelection(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (n2 < n) {
            int n6 = n2;
            n2 = n;
            n = n6;
        }
        if (n <= n3 && n3 <= n2) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this._selectedIndices.subList(n, n2 + 1));
        this.removeSelectionIntervalImpl(n, n2);
        if (n2 < n3) {
            n3 -= n2 - n + 1;
        }
        int n7 = n3;
        if (!bl) {
            ++n7;
        }
        this._selectedIndices.addAll(n7, arrayList);
        if (n3 < n) {
            n5 = n3;
            n4 = n2;
        } else {
            assert (n2 <= n3);
            n5 = n;
            n4 = n3 + (n2 - n + 1);
        }
        this._firstChangedIndex = Math.min(this._firstChangedIndex, n5);
        this._lastChangedIndex = Math.max(this._lastChangedIndex, n4);
        this.fireValueChanged(n5, n4);
    }

    @Override
    public void clearSelection() {
        int n = this._selectedIndices.size();
        this._selectedIndices.clear();
        this._firstChangedIndex = 0;
        this._lastChangedIndex = n - 1;
        this.fireValueChanged(this._firstChangedIndex, this._lastChangedIndex);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._selectedIndices.isEmpty();
    }

    @Override
    public void selectAll() {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (this._selectionMode != 2 && this._selectedIndices.contains(i)) continue;
            this._selectedIndices.add(i);
        }
        this._firstChangedIndex = 0;
        this._lastChangedIndex = n - 1;
        this.fireValueChanged(this._firstChangedIndex, this._lastChangedIndex);
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        if (bl != this._valueIsAdjusting) {
            this._valueIsAdjusting = bl;
            this.fireValueChanged(bl);
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this._valueIsAdjusting;
    }

    @Override
    public void setSelectionMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this._selectionMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid selectionMode");
            }
        }
    }

    @Override
    public int getSelectionMode() {
        return this._selectionMode;
    }

    @Override
    public void addFreezeIndex(int n) {
        if (n >= 0 && n < this.getSize() && !this.isFreezeIndex(n)) {
            this._freezeIndices.add(n);
        }
    }

    @Override
    public void removeFreezeIndex(int n) {
        for (int i = 0; i < this._freezeIndices.size(); ++i) {
            if (this._freezeIndices.get(i) != n) continue;
            this._freezeIndices.remove(i);
            break;
        }
    }

    @Override
    public int[] getFrozenIndices() {
        Integer[] integerArray = this._freezeIndices.toArray(new Integer[this._freezeIndices.size()]);
        int[] nArray = new int[this._freezeIndices.size()];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    @Override
    public boolean isFreezeIndex(int n) {
        for (Integer n2 : this._freezeIndices) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this._listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this._listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this._listenerList.getListeners(ListSelectionListener.class);
    }

    protected void fireValueChanged(boolean bl) {
        if (this._lastChangedIndex == -1) {
            return;
        }
        int n = this._firstChangedIndex;
        int n2 = this._lastChangedIndex;
        this._firstChangedIndex = Integer.MAX_VALUE;
        this._lastChangedIndex = -1;
        this.fireValueChanged(n, n2, bl);
    }

    protected void fireValueChanged(int n, int n2) {
        this.fireValueChanged(n, n2, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this._listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListSelectionListener.class) continue;
            if (listSelectionEvent == null) {
                listSelectionEvent = new ListSelectionEvent(this._target, n, n2, bl);
            }
            ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
        }
    }

    @Override
    public boolean isSelectedIndex(int n) {
        return this._selectedIndices.contains(n);
    }

    public int[] internalGetSelectedIndices() {
        int[] nArray = new int[this._selectedIndices.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this._selectedIndices.get(i);
        }
        return nArray;
    }

    @Override
    public int[] getSelectedIndices() {
        Integer[] integerArray = this._selectedIndices.toArray(new Integer[this._selectedIndices.size()]);
        int[] nArray = new int[this._selectedIndices.size()];
        int n = 0;
        for (Integer n2 : integerArray) {
            if (n2 >= 0 && n2 < this.getSize()) {
                nArray[n] = n2;
                ++n;
                continue;
            }
            this._selectedIndices.remove(n2);
        }
        return DualListModelSupport.copyOfRange(nArray, 0, n);
    }

    private static int[] copyOfRange(int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n, nArray2, 0, Math.min(nArray.length - n, n3));
        return nArray2;
    }

    @Override
    public int getSize() {
        return this._target.getSize();
    }

    public Object getElementAt(int n) {
        return this._target.getElementAt(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

