/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.AbstractDualListModel;
import com.jidesoft.list.DefaultDisableableListSelectionModel;
import com.jidesoft.list.DefaultDualListModel;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.DelegateToDualListModelSupport;
import com.jidesoft.list.DualListModel;
import com.jidesoft.list.DualListTransferHandler;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.ListUtils;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class DualList
extends JideSplitPane {
    public static final String COMMAND_MOVE_LEFT = "moveLeft";
    public static final String COMMAND_MOVE_RIGHT = "moveRight";
    public static final String COMMAND_MOVE_ALL_LEFT = "moveAllLeft";
    public static final String COMMAND_MOVE_ALL_RIGHT = "moveAllRight";
    public static final String COMMAND_MOVE_UP = "moveUp";
    public static final String COMMAND_MOVE_DOWN = "moveDown";
    public static final String COMMAND_MOVE_TO_TOP = "moveToTop";
    public static final String COMMAND_MOVE_TO_BOTTOM = "moveToBottom";
    static final String CLIENT_PROPERTY_DUAL_LIST = "DualList.dualList";
    private static final Logger LOGGER;
    protected DualListModel _model;
    private JList _originalList;
    private JList _selectedList;
    private Container _buttonPanelMiddle;
    private Container _buttonPanelRight;
    private boolean _allowDuplicates = true;
    private ListCellRenderer _cellRenderer;
    private ListCellRenderer _disabledCellRenderer;
    private ListCellRenderer _selectedCellRenderer;
    private static ListCellRenderer _defaultRenderer;
    private ListCellRenderer _defaultDisabledRenderer;
    private Map<String, Action> _actions;
    private ActionHandler _handler;
    public JComponent _originalListPane;
    public JComponent _selectedListPane;
    public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "DualList.alwaysDisabled";
    protected DefaultListModelWrapper _selectedListModel;
    protected DefaultListModelWrapper _originalListModel;
    private boolean _doubleClickEnabled = true;

    public DualList() {
        this(new DefaultDualListModel());
    }

    public DualList(final Object[] objectArray) {
        this(new AbstractDualListModel(){
            private static final long serialVersionUID = -2352415305921530997L;

            @Override
            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n) {
                return objectArray[n];
            }
        });
    }

    public DualList(final List<?> list) {
        this(new AbstractDualListModel(){
            private static final long serialVersionUID = 7421165004351692957L;

            @Override
            public int getSize() {
                return list.size();
            }

            public Object getElementAt(int n) {
                return list.get(n);
            }
        });
    }

    public DualList(DualListModel dualListModel) {
        if (dualListModel == null) {
            throw new NullPointerException("model must be non null");
        }
        this.initComponent();
        this.setModel(dualListModel);
    }

    protected JList createList(ListModel listModel, boolean bl) {
        JList jList = new JList(listModel){

            @Override
            public int getNextMatch(String string, int n, Position.Bias bias) {
                return -1;
            }
        };
        jList.setName(bl ? "DualList.leftList" : "DualList.rightList");
        return jList;
    }

    protected void setupList(JList jList, boolean bl) {
        if (bl) {
            jList.setSelectionModel(new DefaultDisableableListSelectionModel(jList));
        }
        if (SystemInfo.isJdk6Above()) {
            jList.setTransferHandler(new DualListTransferHandler());
            jList.setDragEnabled(true);
            jList.setDropMode(DropMode.INSERT);
            jList.putClientProperty(CLIENT_PROPERTY_DUAL_LIST, this);
        }
        jList.addMouseListener(this._handler);
        jList.addListSelectionListener(this._handler);
        SearchableUtils.installSearchable(jList);
    }

    private void initComponent() {
        this._handler = new ActionHandler();
        this.addPropertyChangeListener("model", this._handler);
        this.addPropertyChangeListener("componentOrientation", this._handler);
        this._actions = new HashMap<String, Action>();
        this._actions.put(COMMAND_MOVE_RIGHT, this.createAction(COMMAND_MOVE_RIGHT));
        this._actions.put(COMMAND_MOVE_LEFT, this.createAction(COMMAND_MOVE_LEFT));
        this._actions.put(COMMAND_MOVE_ALL_RIGHT, this.createAction(COMMAND_MOVE_ALL_RIGHT));
        this._actions.put(COMMAND_MOVE_ALL_LEFT, this.createAction(COMMAND_MOVE_ALL_LEFT));
        this._actions.put(COMMAND_MOVE_UP, this.createAction(COMMAND_MOVE_UP));
        this._actions.put(COMMAND_MOVE_DOWN, this.createAction(COMMAND_MOVE_DOWN));
        this._actions.put(COMMAND_MOVE_TO_TOP, this.createAction(COMMAND_MOVE_TO_TOP));
        this._actions.put(COMMAND_MOVE_TO_BOTTOM, this.createAction(COMMAND_MOVE_TO_BOTTOM));
        this._originalListModel = new DefaultListModelWrapper();
        this._originalList = this.createList(this._originalListModel, true);
        this.setupList(this._originalList, true);
        this._selectedListModel = new DefaultListModelWrapper();
        this._selectedList = this.createList(this._selectedListModel, false);
        this.setupList(this._selectedList, false);
        this._originalListPane = new NullPanel(new BorderLayout());
        this._originalListPane.setOpaque(false);
        this._selectedListPane = new NullPanel(new BorderLayout());
        this._selectedListPane.setOpaque(false);
        this._originalListPane.add(new JScrollPane(this._originalList));
        this._selectedListPane.add(new JScrollPane(this._selectedList));
        this._buttonPanelMiddle = this.createButtonPanel();
        if (this._buttonPanelMiddle instanceof JPanel) {
            ((JPanel)this._buttonPanelMiddle).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = -8373234859482038083L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = DualList.this.getOriginalListPane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_RIGHT))));
        AbstractButton abstractButton = this.createButton(this.getAction(COMMAND_MOVE_LEFT));
        this._buttonPanelMiddle.add(this.createDummyPanel(abstractButton));
        this._buttonPanelMiddle.add(Box.createVerticalStrut(abstractButton.getPreferredSize().height - 8));
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_ALL_RIGHT))));
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_ALL_LEFT))));
        this._buttonPanelMiddle.add(Box.createGlue(), "vary");
        this._buttonPanelRight = this.createButtonPanel();
        if (this._buttonPanelRight instanceof JPanel) {
            ((JPanel)this._buttonPanelRight).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = 9083356608227921869L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = DualList.this.getSelectedListPane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_TO_TOP))));
        AbstractButton abstractButton2 = this.createButton(this.getAction(COMMAND_MOVE_UP));
        this._buttonPanelRight.add(this.createDummyPanel(abstractButton2));
        this._buttonPanelRight.add(Box.createVerticalStrut(abstractButton2.getPreferredSize().height - 8));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_DOWN))));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this.getAction(COMMAND_MOVE_TO_BOTTOM))));
        this._buttonPanelRight.add(Box.createGlue(), "vary");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this._selectedListPane, "Center");
        jPanel.add((Component)this._buttonPanelRight, "After");
        this.installKeyboardAction();
        this.setOrientation(1);
        this.setDividerSize(this._buttonPanelMiddle.getPreferredSize().width);
        this.add((Component)this._originalListPane, "flexible");
        this.add((Component)jPanel, "flexible");
        this.addButtonPanel(this.getDividerAt(0), this._buttonPanelMiddle);
    }

    public JList getOriginalList() {
        return this._originalList;
    }

    public JList getSelectedList() {
        return this._selectedList;
    }

    public JComponent getOriginalListPane() {
        return this._originalListPane;
    }

    public JComponent getSelectedListPane() {
        return this._selectedListPane;
    }

    protected void addButtonPanel(Container container, Component component) {
        container.setLayout(new BorderLayout());
        container.add(component, "First");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this._buttonPanelMiddle != null) {
            dimension.height = Math.max(dimension.height, this._buttonPanelMiddle.getPreferredSize().height);
        }
        if (this._originalList != null) {
            dimension.height = Math.max(dimension.height, this._originalList.getPreferredScrollableViewportSize().height);
        }
        if (this._selectedList != null) {
            dimension.height = Math.max(dimension.height, this._selectedList.getPreferredScrollableViewportSize().height);
        }
        return dimension;
    }

    protected Container createButtonPanel() {
        NullPanel nullPanel = new NullPanel();
        nullPanel.setOpaque(false);
        nullPanel.setLayout(new JideBoxLayout(nullPanel, 1, 4));
        return nullPanel;
    }

    private Action createAction(String string) {
        ActionHandler actionHandler = new ActionHandler();
        actionHandler.putValue("ActionCommandKey", string);
        this.updateAction(actionHandler, string);
        return actionHandler;
    }

    private void updateAction(Action action, String string) {
        block21: {
            Object object;
            String string2;
            block20: {
                String string3;
                block19: {
                    block18: {
                        block17: {
                            string2 = "dualList." + string + ".";
                            try {
                                string3 = this.getResourceString(string2 + "text");
                                if (string3 != null && string3.trim().length() > 0) {
                                    action.putValue("Name", string3);
                                }
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                                LOGGER.fine(exception.getMessage());
                            }
                        }
                        string3 = null;
                        try {
                            string3 = this.getResourceString(string2 + "icon");
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block18;
                            LOGGER.fine(exception.getMessage());
                        }
                    }
                    if (string3 != null) {
                        if (string3.trim().length() == 0) {
                            string3 = String.format("icons/%s.png", string);
                        }
                        object = this.getImageIcon(string3);
                        action.putValue("SmallIcon", object);
                    }
                    string3 = null;
                    try {
                        string3 = this.getResourceString(string2 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.fine(exception.getMessage());
                    }
                }
                if (string3 != null) {
                    if (string3.trim().length() == 0) {
                        string3 = String.format("icons/%s_disabled.png", string);
                    }
                    object = this.getImageIcon(string3);
                    action.putValue("disabledIcon", object);
                }
                try {
                    object = this.getResourceString(string2 + "tooltip");
                    if (object != null && ((String)object).trim().length() > 0) {
                        action.putValue("ShortDescription", object);
                    }
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block20;
                    LOGGER.fine(exception.getMessage());
                }
            }
            try {
                object = this.getResourceString(string2 + "mnemonic");
                if (object != null && ((String)object).trim().length() > 1) {
                    action.putValue("MnemonicKey", Character.valueOf(((String)object).charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINE)) break block21;
                LOGGER.fine(exception.getMessage());
            }
        }
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(DualList.class, string);
    }

    protected AbstractButton createButton(final Action action) {
        final JideButton jideButton = new JideButton(action);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("disabledIcon".equals(propertyChangeEvent.getPropertyName())) {
                    jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
                }
            }
        });
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        return jideButton;
    }

    private void updateOriginalList() {
        DefaultDisableableListSelectionModel defaultDisableableListSelectionModel = (DefaultDisableableListSelectionModel)this._originalList.getSelectionModel();
        if (this._model.getSelectionMode() == 1) {
            defaultDisableableListSelectionModel.setDisabledIndices(this.getSelectedIndices());
            this.updateOriginalRenderer();
        } else {
            defaultDisableableListSelectionModel.setDisabledIndices(null);
        }
        int[] nArray = this._originalListModel.getIndexes();
        if (nArray == null) {
            nArray = new int[]{};
        }
        this._originalListModel.setActualModel(this._model);
        if (this._model.getSelectionMode() == 0) {
            this._originalListModel.setIndexes(this.getUnselectedIndices());
        } else {
            this._originalListModel.reallocateIndexes();
        }
        this._originalListModel.fireEvents(nArray, this._originalListModel.getIndexes());
    }

    private void updateOriginalRenderer() {
        this._originalList.setCellRenderer(new ListCellRenderer(){
            private Set<Integer> selectedIndices;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ListCellRenderer listCellRenderer;
                int n2 = DualList.this._model.getSelectionMode();
                boolean bl3 = DualList.this._model.isFreezeIndex(ListModelWrapperUtils.getActualIndexAt(DualList.this._originalList.getModel(), n, DualList.this._model));
                if (n2 != 1) {
                    listCellRenderer = bl3 ? DualList.this.getDisabledCellRenderer() : DualList.this.getCellRenderer();
                } else {
                    if (!bl3) {
                        if (this.selectedIndices == null) {
                            this.selectedIndices = new HashSet<Integer>();
                            for (int n3 : DualList.this.getSelectedIndices()) {
                                this.selectedIndices.add(n3);
                            }
                        }
                        bl3 = this.selectedIndices.contains(n);
                    }
                    listCellRenderer = bl3 ? DualList.this.getDisabledCellRenderer() : DualList.this.getCellRenderer();
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
    }

    private void updateSelectedList() {
        DefaultListModelWrapper defaultListModelWrapper = this._selectedListModel;
        int[] nArray = defaultListModelWrapper.getIndexes();
        if (nArray == null) {
            nArray = new int[]{};
        }
        defaultListModelWrapper.setActualModel(this._model);
        defaultListModelWrapper.setIndexes(this.getSelectedIndices());
        defaultListModelWrapper.fireEvents(nArray, defaultListModelWrapper.getIndexes());
        this._selectedList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                boolean bl3 = DualList.this._model.isFreezeIndex(ListModelWrapperUtils.getActualIndexAt(DualList.this._selectedList.getModel(), n, DualList.this._model));
                ListCellRenderer listCellRenderer = bl3 ? DualList.this.getDisabledCellRenderer() : DualList.this.getSelectedCellRenderer();
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
    }

    public void enableAction(String string, boolean bl) {
        Action action = this.getAction(string);
        if (action != null) {
            if (!Boolean.TRUE.equals(action.getValue("DualList.alwaysDisabled"))) {
                action.setEnabled(bl);
            } else {
                action.setEnabled(false);
            }
        }
    }

    public Action getAction(String string) {
        return this._actions.get(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._originalList.clearSelection();
        this._originalList.setEnabled(bl);
        this._selectedList.clearSelection();
        this._selectedList.setEnabled(bl);
        this.setButtonEnabled(COMMAND_MOVE_ALL_LEFT, bl);
        this.setButtonEnabled(COMMAND_MOVE_ALL_RIGHT, bl);
        super.setEnabled(bl);
    }

    /*
     * WARNING - void declaration
     */
    private void updateButtonPanel() {
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        Object[] objectArray2;
        Object[] objectArray3;
        boolean bl;
        Object[] objectArray4 = this._originalList.getSelectedValues();
        boolean bl2 = bl = objectArray4.length > 0;
        if (bl) {
            bl = false;
            objectArray3 = this._originalList.getSelectedIndices();
            objectArray2 = objectArray3;
            n4 = objectArray2.length;
            for (n3 = 0; n3 < n4; n3 += 1) {
                n2 = objectArray2[n3];
                boolean bl3 = bl = !this._model.isFreezeIndex(ListModelWrapperUtils.getActualIndexAt(this._originalList.getModel(), n2, this._model));
                if (bl) break;
            }
        }
        if (bl && this.getSelectionMode() == 2 && !this.isAllowDuplicates()) {
            objectArray3 = this.getSelectedValues();
            objectArray2 = objectArray4;
            n4 = objectArray2.length;
            for (n3 = 0; n3 < n4; n3 += 1) {
                int n5 = objectArray2[n3];
                objectArray = objectArray3;
                int n6 = objectArray.length;
                for (n = 0; n < n6; n += 1) {
                    int n7 = objectArray[n];
                    if (n5 != n7) continue;
                    bl = false;
                    break;
                }
                if (!bl) break;
            }
        }
        boolean bl4 = false;
        int[] nArray = objectArray2 = this.getUnselectedIndices();
        n3 = nArray.length;
        for (n2 = 0; n2 < n3; n2 += 1) {
            int n8 = nArray[n2];
            if (this._model.isFreezeIndex(n8)) continue;
            bl4 = true;
            break;
        }
        int n8 = n3 = (nArray = this._selectedList.getSelectedIndices()).length > 0 ? 1 : 0;
        if (n3) {
            void bl6;
            n3 = 0;
            int[] nArray2 = nArray;
            int n9 = nArray2.length;
            boolean bl5 = false;
            while (bl6 < n9) {
                n = nArray2[bl6];
                int n10 = n3 = !this._model.isFreezeIndex(ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), n, this._model)) ? 1 : 0;
                if (n3) break;
                ++bl6;
            }
        }
        boolean bl5 = false;
        for (int n11 : objectArray = this._model.getSelectedIndices()) {
            if (this._model.isFreezeIndex(n11)) continue;
            bl5 = true;
            break;
        }
        this.enableAction(COMMAND_MOVE_RIGHT, bl);
        this.enableAction(COMMAND_MOVE_ALL_RIGHT, this.getSelectionMode() == 2 || bl4);
        this.enableAction(COMMAND_MOVE_LEFT, n3 != 0);
        this.enableAction(COMMAND_MOVE_ALL_LEFT, bl5);
        boolean bl6 = this._selectedList.getMaxSelectionIndex() >= this._selectedList.getSelectedIndices().length;
        n = this._selectedList.getMinSelectionIndex() >= 0 && this._selectedList.getMinSelectionIndex() < this._selectedList.getModel().getSize() - this._selectedList.getSelectedIndices().length ? 1 : 0;
        this.enableAction(COMMAND_MOVE_UP, bl6);
        this.enableAction(COMMAND_MOVE_DOWN, n != 0);
        this.enableAction(COMMAND_MOVE_TO_TOP, bl6);
        this.enableAction(COMMAND_MOVE_TO_BOTTOM, n != 0);
    }

    private void layoutImpl() {
        int n = this.getPreferredSize().width;
        int n2 = this.getDividerSize();
        if (this._buttonPanelMiddle.isVisible()) {
            n2 = this._buttonPanelMiddle.getPreferredSize().width;
        }
        int n3 = n - n2 >> 1;
        PortingUtils.setPreferredSize(this._originalList.getParent().getParent(), new Dimension(n3, this.getHeight()));
        PortingUtils.setPreferredSize(this._selectedList.getParent().getParent(), new Dimension(n3, this.getHeight()));
    }

    public int[] getSelectedIndices() {
        return this._model.getSelectedIndices();
    }

    public int[] getUnselectedIndices() {
        int n;
        int[] nArray = this._model.getSelectedIndices();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        block0: for (int i = 0; i < this._model.getSize(); ++i) {
            if (hashSet.contains(i)) continue;
            while (n2 < nArray.length) {
                n = nArray[n2];
                ++n2;
                hashSet.add(n);
                if (n != i) continue;
                continue block0;
            }
            arrayList.add(i);
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        return nArray2;
    }

    protected void installKeyboardAction() {
        this._originalList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    boolean bl = DualList.this.getComponentOrientation().isLeftToRight();
                    if (n == 39 && bl || n == 37 && !bl) {
                        DualList.this._selectedList.requestFocusInWindow();
                        if (DualList.this._selectedList.getSelectedIndex() == -1 && DualList.this._selectedList.getModel().getSize() > 0) {
                            DualList.this._selectedList.setSelectedIndex(0);
                        }
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = DualList.this.getComponentOrientation().isLeftToRight();
                    if (n == 10 || n == 39 && bl || n == 37 && !bl) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_RIGHT);
                        keyEvent.consume();
                    }
                }
            }
        });
        this._selectedList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    if (n == 38) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_UP);
                        keyEvent.consume();
                    } else if (n == 40) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_DOWN);
                        keyEvent.consume();
                    } else if (n == 36) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_TO_TOP);
                        keyEvent.consume();
                    } else if (n == 35) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_TO_BOTTOM);
                        keyEvent.consume();
                    }
                    boolean bl = DualList.this.getComponentOrientation().isLeftToRight();
                    if (n == 37 && bl || n == 39 && !bl) {
                        DualList.this._originalList.requestFocusInWindow();
                        if (DualList.this._originalList.getSelectedIndex() == -1 && DualList.this._originalList.getModel().getSize() > 0) {
                            DualList.this._originalList.setSelectedIndex(0);
                        }
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = DualList.this.getComponentOrientation().isLeftToRight();
                    if (n == 10 || n == 127 || n == 37 && bl || n == 39 && !bl) {
                        DualList.this.performAction(DualList.COMMAND_MOVE_LEFT);
                        keyEvent.consume();
                    } else if (n == 27 && !DualList.this._selectedList.getSelectionModel().isSelectionEmpty()) {
                        DualList.this._selectedList.clearSelection();
                        DualList.this._selectedList.getSelectionModel().setAnchorSelectionIndex(-1);
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    public DualListModel getModel() {
        return this._model;
    }

    public void setModel(DualListModel dualListModel) {
        if (dualListModel == null) {
            throw new NullPointerException("The model must not be null.");
        }
        if (!JideSwingUtilities.equals(this._model, dualListModel)) {
            if (this._model != null) {
                this._model.removeListSelectionListener(this._handler);
                this._model.removeListDataListener(this._handler);
                this._model.removePropertyChangeListener(this._handler);
            }
            DualListModel dualListModel2 = this._model;
            this._model = dualListModel;
            this._model.addPropertyChangeListener(this._handler);
            this._model.addListDataListener(this._handler);
            this._model.addListSelectionListener(this._handler);
            this.firePropertyChange("model", dualListModel2, dualListModel);
        }
    }

    public Object[] getSelectedValues() {
        int[] nArray = this.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this._model.getElementAt(nArray[i]);
        }
        return objectArray;
    }

    public Object[] getUnselectedValues() {
        int[] nArray = this.getUnselectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this._model.getElementAt(nArray[i]);
        }
        return objectArray;
    }

    public boolean isSelectedIndex(int n) {
        return this._model.isSelectedIndex(n);
    }

    public void clearSelection() {
        this._model.clearSelection();
    }

    @Deprecated
    public void addSelectionInteval(int n, int n2) {
        this.addSelectionInterval(n, n2);
    }

    @Deprecated
    public void removeSelectionInteval(int n, int n2) {
        this.removeSelectionInterval(n, n2);
    }

    public void addSelectionInterval(int n, int n2) {
        this._model.addSelectionInterval(n, n2);
    }

    public void removeSelectionInterval(int n, int n2) {
        this._model.removeSelectionInterval(n, n2);
    }

    public boolean isSelectionEmpty() {
        return this._model.isSelectionEmpty();
    }

    public int getSelectionMode() {
        return this._model.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this._model.setSelectionMode(n);
    }

    public void setButtonVisible(String string, boolean bl) {
        String string2;
        Container container;
        int n;
        boolean bl2 = true;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelMiddle.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelMiddle.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelMiddle.setVisible(false);
        }
        bl2 = true;
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelRight.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelRight.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelRight.setVisible(false);
        }
    }

    public boolean isButtonVisible(String string) {
        Component component;
        int n;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelMiddle.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelRight.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        throw new NoSuchElementException();
    }

    public void setButtonEnabled(String string, boolean bl) {
        Action action = this.getAction(string);
        if (action != null) {
            if (bl) {
                action.putValue("DualList.alwaysDisabled", null);
            } else {
                action.putValue("DualList.alwaysDisabled", true);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.updateButtonPanel();
    }

    public boolean isButtonEnabled(String string) {
        Action action = this.getAction(string);
        if (action != null) {
            return !Boolean.TRUE.equals(action.getValue("DualList.alwaysDisabled"));
        }
        throw new NoSuchElementException();
    }

    @Deprecated
    public void setButtonPanelVisible(boolean bl) {
        this.setMiddleButtonPanelVisible(bl);
    }

    @Deprecated
    public boolean isButtonPanelVisible() {
        return this.isMiddleButtonPanelVisible();
    }

    public void setMiddleButtonPanelVisible(boolean bl) {
        this._buttonPanelMiddle.setVisible(bl);
    }

    public boolean isMiddleButtonPanelVisible() {
        return this._buttonPanelMiddle.isVisible();
    }

    public void setRightButtonPanelVisible(boolean bl) {
        this._buttonPanelRight.setVisible(bl);
    }

    public boolean isRightButtonPanelVisible() {
        return this._buttonPanelRight.isVisible();
    }

    public ListCellRenderer getCellRenderer() {
        if (this._cellRenderer != null) {
            return this._cellRenderer;
        }
        if (_defaultRenderer == null) {
            _defaultRenderer = new DefaultListCellRenderer();
        }
        return _defaultRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._cellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._cellRenderer;
            this._cellRenderer = listCellRenderer;
            this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public ListCellRenderer getSelectedCellRenderer() {
        return this._selectedCellRenderer != null ? this._selectedCellRenderer : this.getCellRenderer();
    }

    public void setSelectedCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._selectedCellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._selectedCellRenderer;
            this._selectedCellRenderer = listCellRenderer;
            this.firePropertyChange("selectedRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public ListCellRenderer getDisabledCellRenderer() {
        if (this._disabledCellRenderer != null) {
            return this._disabledCellRenderer;
        }
        if (this._defaultDisabledRenderer == null) {
            this._defaultDisabledRenderer = new DefaultDisabledRenderer();
        }
        return this._defaultDisabledRenderer;
    }

    public void setDisabledCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._disabledCellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._disabledCellRenderer;
            this._disabledCellRenderer = listCellRenderer;
            this.firePropertyChange("disabledRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public void moveLeft() {
        int n;
        int[] nArray = this._selectedList.getSelectedIndices();
        this._model.setValueIsAdjusting(true);
        ListModel listModel = this._selectedList.getModel();
        ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel);
        while (listModel != null && listModel instanceof ListModelWrapper && ((ListModelWrapper)((Object)listModel)).getActualModel() != listModel2) {
            listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
        }
        int[] nArray2 = new int[nArray.length];
        for (n = nArray.length - 1; n >= 0; --n) {
            nArray2[n] = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[n], listModel);
        }
        Arrays.sort(nArray2);
        for (n = nArray2.length - 1; n >= 0; --n) {
            int n2 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray2[n], this._model);
            if (this._model.isFreezeIndex(n2) || nArray2[n] < 0) continue;
            this._model.removeSelectionInterval(nArray2[n], nArray2[n]);
        }
        this._model.setValueIsAdjusting(false);
        if (this._model.getSelectionMode() != 2) {
            this._originalList.clearSelection();
        }
        if (nArray.length > 0) {
            n = nArray[nArray.length - 1];
            if (n >= this._selectedList.getModel().getSize()) {
                n = this._selectedList.getModel().getSize() - 1;
            }
            if (n >= 0) {
                this._selectedList.setSelectedIndex(n);
            }
        }
        this.updateButtonPanel();
        this.updateOriginalRenderer();
    }

    public void moveRight() {
        int n;
        int n2;
        int[] nArray = this._originalList.getSelectedIndices();
        int n3 = this._selectedList.getSelectionModel().getAnchorSelectionIndex();
        this._model.setValueIsAdjusting(true);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = ListModelWrapperUtils.getActualIndexAt(this._originalList.getModel(), nArray[n2], this._model);
            if (this._model.isFreezeIndex(n)) continue;
            this._model.addSelectionInterval(n, n);
            int n4 = this._selectedList.getModel().getSize() + n2;
            if (n3 == -1) continue;
            this._model.moveSelection(n4, n4, n3 + n2, true);
        }
        if (n3 != -1) {
            int[] nArray2 = new int[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                nArray2[n] = n3 + n;
            }
            this._selectedList.setSelectedIndices(nArray2);
            this._selectedList.getSelectionModel().setLeadSelectionIndex(n3);
            this._selectedList.getSelectionModel().setAnchorSelectionIndex(n3);
        }
        this._model.setValueIsAdjusting(false);
        if (nArray.length > 0) {
            n2 = nArray[nArray.length - 1];
            if (n2 >= this._originalList.getModel().getSize()) {
                n2 = this._originalList.getModel().getSize() - 1;
            }
            if (n2 >= 0) {
                this._originalList.setSelectedIndex(n2);
            }
        }
        this._selectedList.ensureIndexIsVisible(n3);
        this.updateButtonPanel();
        this.updateOriginalRenderer();
    }

    public void moveAllLeft() {
        if (this._model.getFrozenIndices().length <= 0) {
            this._model.clearSelection();
        } else {
            ListModel listModel = this._selectedList.getModel();
            ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel);
            while (listModel != null && listModel instanceof ListModelWrapper && ((ListModelWrapper)((Object)listModel)).getActualModel() != listModel2) {
                listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
            }
            this._model.setValueIsAdjusting(true);
            int[] nArray = this.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                if (n < 0 || n >= this._model.getSize() || this._model.isFreezeIndex(n)) continue;
                int n2 = ListModelWrapperUtils.getIndexAt(listModel, n);
                this._model.removeSelectionInterval(n2, n2);
            }
            this._model.setValueIsAdjusting(false);
        }
        this.updateOriginalRenderer();
    }

    public void moveAllRight() {
        if (this._model.getFrozenIndices().length <= 0) {
            this._model.selectAll();
        } else {
            ListModel listModel = this._selectedList.getModel();
            ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel);
            while (listModel != null && listModel instanceof ListModelWrapper && ((ListModelWrapper)((Object)listModel)).getActualModel() != listModel2) {
                listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
            }
            int n = this._selectedList.getSelectionModel().getAnchorSelectionIndex();
            this._model.setValueIsAdjusting(true);
            int[] nArray = this.getUnselectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                this._model.addSelectionInterval(nArray[i], nArray[i]);
                int n2 = this._selectedList.getModel().getSize() + i;
                if (n == -1) continue;
                this._model.moveSelection(n2, n2, n + i, true);
            }
            this._model.setValueIsAdjusting(false);
        }
        int n = this._selectedList.getModel().getSize();
        this._selectedList.setSelectionInterval(0, n - 1);
        this.updateOriginalRenderer();
    }

    public void moveUp() {
        int[] nArray = this._selectedList.getSelectedIndices();
        this._model.setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= i) continue;
            int n = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i], this._selectedListModel);
            int n2 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i] - 1, this._selectedListModel);
            this._model.moveSelection(n, n, n2, true);
            int n3 = i;
            nArray[n3] = nArray[n3] - 1;
        }
        this._model.setValueIsAdjusting(false);
        this._selectedList.setSelectedIndices(nArray);
        ListUtils.ensureSelectionVisible(this._selectedList);
    }

    public void moveDown() {
        int[] nArray = this._selectedList.getSelectedIndices();
        int n = this._selectedList.getModel().getSize();
        this._model.setValueIsAdjusting(true);
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= n - (nArray.length - i)) continue;
            int n2 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i], this._selectedListModel);
            int n3 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i] + 1, this._selectedListModel);
            this._model.moveSelection(n2, n2, n3, false);
            int n4 = i;
            nArray[n4] = nArray[n4] + 1;
        }
        this._model.setValueIsAdjusting(false);
        this._selectedList.setSelectedIndices(nArray);
        ListUtils.ensureSelectionVisible(this._selectedList);
    }

    public void moveToTop() {
        int[] nArray = this._selectedList.getSelectedIndices();
        this._model.setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            int n = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i], this._selectedListModel);
            int n2 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), i, this._selectedListModel);
            this._model.moveSelection(n, n, n2, true);
        }
        this._model.setValueIsAdjusting(false);
        this._selectedList.getSelectionModel().setSelectionInterval(0, nArray.length - 1);
        ListUtils.ensureSelectionVisible(this._selectedList);
    }

    public void moveToBottom() {
        int[] nArray = this._selectedList.getSelectedIndices();
        int n = this._selectedList.getModel().getSize();
        this._model.setValueIsAdjusting(true);
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n2 = ListModelWrapperUtils.getActualIndexAt(this._selectedList.getModel(), nArray[i], this._selectedListModel);
            this._model.moveSelection(n2, n2, n - (nArray.length - i), false);
        }
        this._model.setValueIsAdjusting(false);
        this._selectedList.getSelectionModel().setSelectionInterval(n - nArray.length, n - 1);
        ListUtils.ensureSelectionVisible(this._selectedList);
    }

    public void setVisibleRowCount(int n) {
        int n2 = this._originalList.getVisibleRowCount();
        n = Math.max(0, n);
        this._originalList.setVisibleRowCount(n);
        this._selectedList.setVisibleRowCount(n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getVisibleRowCount() {
        return this._originalList.getVisibleRowCount();
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this._allowDuplicates = bl;
        this.updateButtonPanel();
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this._doubleClickEnabled = bl;
    }

    private void updateArrowButtons() {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        this.updateAction(this.getAction(COMMAND_MOVE_LEFT), bl ? COMMAND_MOVE_LEFT : COMMAND_MOVE_RIGHT);
        this.updateAction(this.getAction(COMMAND_MOVE_RIGHT), bl ? COMMAND_MOVE_RIGHT : COMMAND_MOVE_LEFT);
        this.updateAction(this.getAction(COMMAND_MOVE_ALL_LEFT), bl ? COMMAND_MOVE_ALL_LEFT : COMMAND_MOVE_ALL_RIGHT);
        this.updateAction(this.getAction(COMMAND_MOVE_ALL_RIGHT), bl ? COMMAND_MOVE_ALL_RIGHT : COMMAND_MOVE_ALL_LEFT);
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.list.dualList", this.getLocale()).getString(string);
    }

    protected void performAction(String string) {
        Action action = this.getAction(string);
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(new Object(), 0, string));
        }
    }

    private JComponent createDummyPanel(Component component) {
        JPanel jPanel = JideSwingUtilities.createCenterPanel(component);
        jPanel.setCursor(Cursor.getDefaultCursor());
        return jPanel;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(DualList.class.getName(), 4);
        }
        LOGGER = Logger.getLogger(DualList.class.getName());
    }

    private class DefaultDisabledRenderer
    extends DefaultListCellRenderer {
        private DefaultDisabledRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = DualList.this.getCellRenderer().getListCellRendererComponent(jList, object, n, bl, bl2);
            component.setEnabled(false);
            return component;
        }
    }

    private class ActionHandler
    extends AbstractAction
    implements MouseListener,
    ListDataListener,
    ListSelectionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 4970089188727578646L;

        private ActionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            int[] nArray = DualList.this.getModel().getSelectedIndices();
            int n = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < listDataEvent.getIndex0()) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + n;
            }
            DualList.this.getModel().setValueIsAdjusting(true);
            DualList.this.getModel().clearSelection();
            for (int n3 : nArray) {
                DualList.this.getModel().addSelectionInterval(n3, n3);
            }
            DualList.this.getModel().setValueIsAdjusting(false);
            this.modelChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            if (DualList.this.getModel() instanceof DelegateToDualListModelSupport) {
                int[] nArray = ((DelegateToDualListModelSupport)((Object)DualList.this.getModel())).internalGetSelectedIndices();
                int n = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] > listDataEvent.getIndex1()) {
                        int n2 = i;
                        nArray[n2] = nArray[n2] - n;
                        continue;
                    }
                    if (nArray[i] < listDataEvent.getIndex0()) continue;
                    nArray[i] = -1;
                }
                DualList.this.getModel().setValueIsAdjusting(true);
                DualList.this.getModel().clearSelection();
                for (int n3 : nArray) {
                    if (n3 < 0) continue;
                    DualList.this.getModel().addSelectionInterval(n3, n3);
                }
                DualList.this.getModel().setValueIsAdjusting(false);
            }
            this.modelChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.modelChanged();
        }

        private void modelChanged() {
            DualList.this.updateOriginalList();
            DualList.this.updateOriginalRenderer();
            DualList.this.updateSelectedList();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (DualList.COMMAND_MOVE_LEFT.equals(string)) {
                DualList.this.moveLeft();
            } else if (DualList.COMMAND_MOVE_RIGHT.equals(string)) {
                DualList.this.moveRight();
            } else if (DualList.COMMAND_MOVE_ALL_LEFT.equals(string)) {
                DualList.this.moveAllLeft();
            } else if (DualList.COMMAND_MOVE_ALL_RIGHT.equals(string)) {
                DualList.this.moveAllRight();
            } else if (DualList.COMMAND_MOVE_UP.equals(string)) {
                DualList.this.moveUp();
            } else if (DualList.COMMAND_MOVE_DOWN.equals(string)) {
                DualList.this.moveDown();
            } else if (DualList.COMMAND_MOVE_TO_TOP.equals(string)) {
                DualList.this.moveToTop();
            } else if (DualList.COMMAND_MOVE_TO_BOTTOM.equals(string)) {
                DualList.this.moveToBottom();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object object = listSelectionEvent.getSource();
                if (object == DualList.this._model || object == DualList.this._selectedList) {
                    DualList.this.updateSelectedList();
                    if (DualList.this._model.getSelectionMode() != 2) {
                        DualList.this.updateOriginalList();
                    }
                }
                DualList.this.updateButtonPanel();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && DualList.this.isDoubleClickEnabled()) {
                Object object = mouseEvent.getSource();
                if (object == DualList.this._originalList && DualList.this._originalList.getSelectedIndex() != -1) {
                    DualList.this.performAction(DualList.COMMAND_MOVE_RIGHT);
                } else if (object == DualList.this._selectedList && DualList.this._selectedList.getSelectedIndex() != -1) {
                    DualList.this.performAction(DualList.COMMAND_MOVE_LEFT);
                }
            }
            DualList.this.updateButtonPanel();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl;
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl2 = "selectionMode".equals(string) && object == DualList.this._model;
            boolean bl3 = "model".equals(string) && object == DualList.this;
            boolean bl4 = bl = "componentOrientation".equals(string) && object == DualList.this;
            if (bl2 || bl3) {
                DualList.this.updateOriginalList();
                DualList.this.updateOriginalRenderer();
            }
            if (bl2) {
                this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (bl3) {
                DualList.this.updateButtonPanel();
                DualList.this.updateSelectedList();
                DualList.this.layoutImpl();
            }
            if (bl) {
                DualList.this.updateArrowButtons();
                DualList.this.repaint();
            }
        }
    }
}

