/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.GroupableListModel;
import com.jidesoft.list.ListGroupChangeEvent;
import com.jidesoft.list.ListGroupChangeListener;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class DefaultGroupableListModel
extends DefaultListModel
implements GroupableListModel {
    private Vector<Object> _availableGroups;
    private Vector<Object> _groups = new Vector();

    public void setGroupAt(Object object, int n) {
        if (!JideSwingUtilities.equals(this.getGroupAt(n), object)) {
            this.setGroupAtImpl(object, n);
            this.fireGroupChanged(this);
        }
    }

    private void setGroupAtImpl(Object object, int n) {
        if (n >= this.getSize()) {
            throw new IllegalArgumentException("index must be less than size");
        }
        if (n >= this._groups.size()) {
            this._groups.setSize(this.getSize());
        }
        this._groups.set(n, object);
        if (this._availableGroups == null) {
            this._availableGroups = new Vector();
        }
        if (this._availableGroups.contains(object)) {
            this._availableGroups.add(object);
        }
    }

    public void setGroups(Object[] objectArray) {
        boolean bl = false;
        Object[] objectArray2 = this.getGroups();
        if (objectArray2 == null || objectArray2.length == 0) {
            if (objectArray != null && objectArray.length != 0) {
                bl = true;
            }
        } else if (!JideSwingUtilities.equals(objectArray2, objectArray)) {
            bl = true;
        }
        if (bl) {
            this._groups.clear();
            if (this._availableGroups == null) {
                this._availableGroups = new Vector();
            }
            this._availableGroups.addAll(Arrays.asList(objectArray));
            this.fireGroupChanged(this);
        }
    }

    @Override
    public Object getGroupAt(int n) {
        return n < this._groups.size() ? this._groups.get(n) : null;
    }

    @Override
    public Object[] getGroups() {
        return this._availableGroups == null ? new Object[]{} : this._availableGroups.toArray();
    }

    public void renameGroup(Object object, Object object2) {
        if (!object.equals(object2)) {
            int n;
            boolean bl = false;
            if (this._availableGroups != null) {
                for (n = 0; n < this._availableGroups.size(); ++n) {
                    if (!JideSwingUtilities.equals(this._availableGroups.get(n), object)) continue;
                    this._availableGroups.set(n, object2);
                    bl = true;
                }
            }
            for (n = 0; n < this.getSize(); ++n) {
                if (!JideSwingUtilities.equals(this.getGroupAt(n), object)) continue;
                this.setGroupAtImpl(object2, n);
                bl = true;
            }
            if (bl) {
                this.fireGroupChanged(this);
            }
        }
    }

    @Override
    public void addListGroupChangeListener(ListGroupChangeListener listGroupChangeListener) {
        this.listenerList.add(ListGroupChangeListener.class, listGroupChangeListener);
    }

    @Override
    public void removeListGroupChangeListener(ListGroupChangeListener listGroupChangeListener) {
        this.listenerList.remove(ListGroupChangeListener.class, listGroupChangeListener);
    }

    public ListGroupChangeListener[] getListGroupChangeListeners() {
        return (ListGroupChangeListener[])this.listenerList.getListeners(ListGroupChangeListener.class);
    }

    protected void fireGroupChanged(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListGroupChangeEvent listGroupChangeEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListGroupChangeListener.class) continue;
            if (listGroupChangeEvent == null) {
                listGroupChangeEvent = new ListGroupChangeEvent(object);
            }
            ((ListGroupChangeListener)objectArray[i + 1]).groupChanged(listGroupChangeEvent);
        }
    }
}

