/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.swing.JideLabel;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class VerticalTableCellRenderer
extends JideLabel
implements TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 57326451614897121L;
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public VerticalTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(this.getNoFocusBorder());
        this.setName("Table.cellRenderer");
        this.setOrientation(1);
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("Table.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Object object2;
        Color color2 = null;
        Color color3 = null;
        if (SystemInfo.isJdk6Above() && (object2 = jTable.getDropLocation()) != null && !((JTable.DropLocation)object2).isInsertRow() && !((JTable.DropLocation)object2).isInsertColumn() && ((JTable.DropLocation)object2).getRow() == n && ((JTable.DropLocation)object2).getColumn() == n2) {
            color2 = UIManager.getColor("Table.dropCellForeground");
            color3 = UIManager.getColor("Table.dropCellBackground");
            bl = true;
        }
        if (bl) {
            super.setForeground(color2 == null ? jTable.getSelectionForeground() : color2);
            super.setBackground(color3 == null ? jTable.getSelectionBackground() : color3);
        } else {
            Object object3 = object2 = this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground();
            if ((object2 == null || object2 instanceof javax.swing.plaf.UIResource) && (color = UIManager.getColor("Table.alternateRowColor")) != null && n % 2 == 0) {
                object2 = color;
            }
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground((Color)object2);
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            object2 = null;
            if (bl) {
                object2 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (object2 == null) {
                object2 = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder((Border)object2);
            if (!bl && jTable.isCellEditable(n, n2)) {
                color = UIManager.getColor("Table.focusCellForeground");
                if (color != null) {
                    super.setForeground(color);
                }
                if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(color);
                }
            }
        } else {
            this.setBorder(this.getNoFocusBorder());
        }
        this.setValue(object);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string) || "labelFor".equals(string) || "displayedMnemonic".equals(string) || ("font".equals(string) || "foreground".equals(string)) && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public static class UIResource
    extends VerticalTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

