/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableUndoableSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableTableModelEvent
extends TableModelEvent
implements UndoableEdit {
    private static final long serialVersionUID = 3431442868294186078L;
    private List<TableModelEdit> _edits;
    private boolean _hasBeenDone = true;
    private boolean _alive = true;
    private boolean _undoRedo = false;

    public UndoableTableModelEvent(TableModel tableModel) {
        super(tableModel);
    }

    public UndoableTableModelEvent(TableModel tableModel, int n) {
        super(tableModel, n);
    }

    public UndoableTableModelEvent(TableModel tableModel, int n, int n2) {
        super(tableModel, n, n2);
    }

    public UndoableTableModelEvent(TableModel tableModel, int n, int n2, int n3) {
        super(tableModel, n, n2, n3);
    }

    public UndoableTableModelEvent(TableModel tableModel, int n, int n2, int n3, int n4) {
        super(tableModel, n, n2, n3, n4);
    }

    public void addEdit(int n, Vector<Object> vector, Vector<Object> vector2) {
        if (this._edits == null) {
            this._edits = new ArrayList<TableModelEdit>();
        }
        this._edits.add(new TableModelEdit(n, vector, vector2));
    }

    public void addEdit(int n, int n2, Object object, Object object2) {
        if (this._edits == null) {
            this._edits = new ArrayList<TableModelEdit>();
        }
        this._edits.add(new TableModelEdit(n, n2, object, object2));
    }

    void removeLastEdit() {
        if (this._edits != null && this._edits.size() > 0) {
            this._edits.remove(this._edits.size() - 1);
        }
    }

    @Override
    public void die() {
        this._alive = false;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this._hasBeenDone = false;
        if (this._edits != null && this.getSource() instanceof TableUndoableSupport) {
            ((TableUndoableSupport)this.getSource()).beginCompoundEdit(true);
            for (int i = this._edits.size() - 1; i >= 0; --i) {
                TableModelEdit tableModelEdit = this._edits.get(i);
                if (tableModelEdit.getColumnIndex() < 0) {
                    if (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) {
                        ((TableUndoableSupport)this.getSource()).undoableInsertRow(tableModelEdit.getRowIndex(), tableModelEdit.getOldRowData());
                        continue;
                    }
                    if (tableModelEdit.getOldRowData() == null || tableModelEdit.getOldRowData().size() == 0) {
                        ((TableUndoableSupport)this.getSource()).undoableRemoveRow(tableModelEdit.getRowIndex());
                        continue;
                    }
                    ((TableUndoableSupport)this.getSource()).undoableUpdateRow(tableModelEdit.getRowIndex(), tableModelEdit.getOldRowData());
                    continue;
                }
                ((TableUndoableSupport)this.getSource()).undoableUpdateCell(tableModelEdit.getRowIndex(), tableModelEdit.getColumnIndex(), tableModelEdit.getOldCellData());
            }
            ((TableUndoableSupport)this.getSource()).endCompoundEdit();
        }
    }

    @Override
    public boolean canUndo() {
        return this._alive && this._hasBeenDone;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this._hasBeenDone = true;
        if (this._edits != null && this.getSource() instanceof TableUndoableSupport) {
            ((TableUndoableSupport)this.getSource()).beginCompoundEdit(true);
            for (TableModelEdit tableModelEdit : this._edits) {
                if (tableModelEdit.getColumnIndex() < 0) {
                    if (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) {
                        ((TableUndoableSupport)this.getSource()).undoableRemoveRow(tableModelEdit.getRowIndex());
                        continue;
                    }
                    if (tableModelEdit.getOldRowData() == null || tableModelEdit.getOldRowData().size() == 0) {
                        ((TableUndoableSupport)this.getSource()).undoableInsertRow(tableModelEdit.getRowIndex(), tableModelEdit.getNewRowData());
                        continue;
                    }
                    ((TableUndoableSupport)this.getSource()).undoableUpdateRow(tableModelEdit.getRowIndex(), tableModelEdit.getNewRowData());
                    continue;
                }
                ((TableUndoableSupport)this.getSource()).undoableUpdateCell(tableModelEdit.getRowIndex(), tableModelEdit.getColumnIndex(), tableModelEdit.getNewCellData());
            }
            ((TableUndoableSupport)this.getSource()).endCompoundEdit();
        }
    }

    @Override
    public boolean canRedo() {
        return this._alive && !this._hasBeenDone;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "";
    }

    @Override
    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
        return string;
    }

    @Override
    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
        return string;
    }

    public void setUndoRedo(boolean bl) {
        this._undoRedo = bl;
    }

    public boolean isUndoRedo() {
        return this._undoRedo;
    }

    public TableModelEdit[] getEdits() {
        return this._edits == null ? new TableModelEdit[]{} : this._edits.toArray(new TableModelEdit[this._edits.size()]);
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setFirstRow(int n) {
        this.firstRow = n;
    }

    public void setLastRow(int n) {
        this.lastRow = n;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    private static int getEventType(TableModelEdit tableModelEdit) {
        if (tableModelEdit != null && tableModelEdit.getColumnIndex() < 0) {
            if (tableModelEdit.getOldRowData() == null || tableModelEdit.getOldRowData().size() == 0) {
                return 1;
            }
            if (tableModelEdit.getNewRowData() == null || tableModelEdit.getNewRowData().size() == 0) {
                return -1;
            }
        }
        return 0;
    }

    public static void fireTableModelEvent(AbstractTableModel abstractTableModel, TableModelEvent tableModelEvent) {
        TableModelEdit[] tableModelEditArray;
        if (tableModelEvent.getSource() != abstractTableModel) {
            return;
        }
        if (tableModelEvent instanceof UndoableTableModelEvent && (tableModelEditArray = ((UndoableTableModelEvent)tableModelEvent).getEdits()) != null) {
            int n;
            int n2;
            int n3;
            TableModelEdit tableModelEdit2;
            if (tableModelEditArray.length <= 0) {
                return;
            }
            if (tableModelEditArray.length == 1) {
                ((UndoableTableModelEvent)tableModelEvent).setFirstRow(tableModelEditArray[0].getRowIndex());
                ((UndoableTableModelEvent)tableModelEvent).setLastRow(tableModelEditArray[0].getRowIndex());
                ((UndoableTableModelEvent)tableModelEvent).setColumn(tableModelEditArray[0].getColumnIndex());
                ((UndoableTableModelEvent)tableModelEvent).setType(UndoableTableModelEvent.getEventType(tableModelEditArray[0]));
                abstractTableModel.fireTableChanged(tableModelEvent);
                return;
            }
            int n4 = Integer.MIN_VALUE;
            for (TableModelEdit tableModelEdit2 : tableModelEditArray) {
                n3 = UndoableTableModelEvent.getEventType(tableModelEdit2);
                if (n4 == Integer.MIN_VALUE) {
                    n4 = n3;
                    continue;
                }
                if (n4 == n3) continue;
                n4 = Integer.MAX_VALUE;
            }
            if (n4 == 1) {
                int n5 = -1;
                n2 = -1;
                for (TableModelEdit tableModelEdit3 : tableModelEditArray) {
                    int n6 = UndoableTableModelEvent.getEventType(tableModelEdit3);
                    if (n6 != n4 || tableModelEdit3.getRowIndex() < 0) {
                        n5 = -1;
                        break;
                    }
                    if (n5 == -1 && n2 == -1) {
                        n5 = tableModelEdit3.getRowIndex();
                        n2 = tableModelEdit3.getRowIndex();
                        continue;
                    }
                    if (tableModelEdit3.getRowIndex() >= n5 && tableModelEdit3.getRowIndex() <= n2 + 1) {
                        ++n2;
                        continue;
                    }
                    n5 = -1;
                    break;
                }
                if (n5 >= 0 && n2 >= n5) {
                    ((UndoableTableModelEvent)tableModelEvent).setFirstRow(n5);
                    ((UndoableTableModelEvent)tableModelEvent).setLastRow(n2);
                    ((UndoableTableModelEvent)tableModelEvent).setColumn(-1);
                    ((UndoableTableModelEvent)tableModelEvent).setType(n4);
                    abstractTableModel.fireTableChanged(tableModelEvent);
                    return;
                }
            } else if (n4 == -1) {
                int n7 = -1;
                n2 = -1;
                for (n = tableModelEditArray.length - 1; n >= 0; --n) {
                    tableModelEdit2 = tableModelEditArray[n];
                    n3 = UndoableTableModelEvent.getEventType(tableModelEdit2);
                    if (n3 != n4 || tableModelEdit2.getRowIndex() < 0) {
                        n7 = -1;
                        break;
                    }
                    if (n7 == -1 && n2 == -1) {
                        n7 = tableModelEdit2.getRowIndex();
                        n2 = tableModelEdit2.getRowIndex();
                        continue;
                    }
                    if (tableModelEdit2.getRowIndex() >= n7 && tableModelEdit2.getRowIndex() <= n2 + 1) {
                        ++n2;
                        continue;
                    }
                    n7 = -1;
                    break;
                }
                if (n7 >= 0 && n2 >= n7) {
                    ((UndoableTableModelEvent)tableModelEvent).setFirstRow(n7);
                    ((UndoableTableModelEvent)tableModelEvent).setLastRow(n2);
                    ((UndoableTableModelEvent)tableModelEvent).setColumn(-1);
                    ((UndoableTableModelEvent)tableModelEvent).setType(n4);
                    abstractTableModel.fireTableChanged(tableModelEvent);
                    return;
                }
            } else if (n4 == 0) {
                int n8 = -1;
                n2 = -1;
                for (n = tableModelEditArray.length - 1; n >= 0; --n) {
                    tableModelEdit2 = tableModelEditArray[n];
                    n3 = UndoableTableModelEvent.getEventType(tableModelEdit2);
                    if (n3 != n4 || tableModelEdit2.getRowIndex() < 0 || tableModelEdit2.getColumnIndex() >= 0) {
                        n8 = -1;
                        break;
                    }
                    if (n8 == -1 && n2 == -1) {
                        n8 = tableModelEdit2.getRowIndex();
                        n2 = tableModelEdit2.getRowIndex();
                        continue;
                    }
                    if (tableModelEdit2.getRowIndex() >= n2) {
                        n2 = tableModelEdit2.getRowIndex();
                        continue;
                    }
                    if (tableModelEdit2.getRowIndex() > n8) continue;
                    n8 = tableModelEdit2.getRowIndex();
                }
                if (n8 >= 0 && n2 >= n8 && n2 - n8 <= tableModelEditArray.length) {
                    ((UndoableTableModelEvent)tableModelEvent).setFirstRow(n8);
                    ((UndoableTableModelEvent)tableModelEvent).setLastRow(n2);
                    ((UndoableTableModelEvent)tableModelEvent).setColumn(-1);
                    ((UndoableTableModelEvent)tableModelEvent).setType(n4);
                    abstractTableModel.fireTableChanged(tableModelEvent);
                    return;
                }
            }
        }
        abstractTableModel.fireTableChanged(tableModelEvent);
    }

    class TableModelEdit {
        private int _rowIndex;
        private int _columnIndex;
        private Vector<Object> _oldRowData;
        private Vector<Object> _newRowData;
        private Object _oldCellData;
        private Object _newCellData;

        public TableModelEdit(int n, Vector<Object> vector, Vector<Object> vector2) {
            this._rowIndex = n;
            this._columnIndex = -1;
            this._oldRowData = vector;
            this._newRowData = vector2;
        }

        public TableModelEdit(int n, int n2, Object object, Object object2) {
            this._rowIndex = n;
            this._columnIndex = n2;
            this._oldCellData = object;
            this._newCellData = object2;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return this._columnIndex;
        }

        public Vector<Object> getOldRowData() {
            return this._oldRowData;
        }

        public Vector<Object> getNewRowData() {
            return this._newRowData;
        }

        public Object getOldCellData() {
            return this._oldCellData;
        }

        public Object getNewCellData() {
            return this._newCellData;
        }
    }
}

