/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.CachedTableModel;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.WrappedRow;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class TreeTableUtils {
    public static int getChildrenCount(TableModel tableModel, Row row) {
        return TreeTableUtils.getChildren(tableModel, row).size();
    }

    public static int getChildIndex(TableModel tableModel, Row row, Row row2) {
        Row row3 = row;
        while (row3 instanceof WrappedRow) {
            row3 = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        while (row2 instanceof WrappedRow) {
            row2 = ((WrappedRow)((Object)row2)).getOriginalRow();
        }
        if (row2 == null || row3 == null || row2.getParent() != row3) {
            return -1;
        }
        List<Row> list = TreeTableUtils.getChildren(tableModel, row);
        if (row3 != row) {
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Row row4 : list) {
                while (row4 instanceof WrappedRow) {
                    row4 = ((WrappedRow)((Object)row4)).getOriginalRow();
                }
                if (!(row4 instanceof Row)) continue;
                arrayList.add(row4);
            }
            list = arrayList;
        }
        return list.indexOf(row2);
    }

    public static Row getChildAt(TableModel tableModel, Row row, int n) {
        List<Row> list = TreeTableUtils.getChildren(tableModel, row);
        if (n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    public static Row getRow(TableModel tableModel, int n) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getRow(((CachedTableModel)tableModel).getActualModel(), n);
        }
        if (tableModel instanceof ITreeTableModel) {
            return ((ITreeTableModel)((Object)tableModel)).getRowAt(n);
        }
        return null;
    }

    public static List<Row> getChildren(TableModel tableModel, Row row) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getChildren(((CachedTableModel)tableModel).getActualModel(), row);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return arrayList;
        }
        int n = ((ITreeTableModel)((Object)tableModel)).getRowIndex(row);
        if (n < 0 && !JideSwingUtilities.equals(row, ((ITreeTableModel)((Object)tableModel)).getRoot())) {
            return arrayList;
        }
        int n2 = n + TreeTableUtils.getDescendantCount(tableModel, row, false, false);
        for (int i = n + 1; i <= n2; ++i) {
            Row row2 = ((ITreeTableModel)((Object)tableModel)).getRowAt(i);
            if ((!(row instanceof WrappedRow) || !JideSwingUtilities.equals(row2.getParent(), row)) && (row instanceof WrappedRow || row2.getParent() != row)) continue;
            arrayList.add(row2);
        }
        return arrayList;
    }

    public static List<Row> getDescendants(TableModel tableModel, Row row, boolean bl, boolean bl2, boolean bl3) {
        Row row2;
        int n;
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getDescendants(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2, bl3);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return arrayList;
        }
        int n2 = ((ITreeTableModel)((Object)tableModel)).getRowIndex(row);
        if (n2 < 0 && row != ((ITreeTableModel)((Object)tableModel)).getRoot()) {
            return arrayList;
        }
        int n3 = n2 + TreeTableUtils.getDescendantCount(tableModel, row, false, false);
        for (n = n2 + 1; n <= n3; ++n) {
            row2 = ((ITreeTableModel)((Object)tableModel)).getRowAt(n);
            if (bl && row2.getParent() != row) continue;
            arrayList.add(row2);
        }
        if (bl3) {
            if (arrayList.size() == 0 && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren() && !((Expandable)((Object)row)).isExpanded()) {
                arrayList.addAll(TreeTableUtils.getCollapsedValidChildren(tableModel, (Expandable)((Object)row), bl));
            } else if (!bl) {
                for (n = arrayList.size() - 1; n >= 0; --n) {
                    row2 = (Row)arrayList.get(n);
                    if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).isExpandable() || !((Expandable)((Object)row2)).hasChildren() || ((Expandable)((Object)row2)).isExpanded()) continue;
                    List<Row> list = TreeTableUtils.getCollapsedValidChildren(tableModel, (Expandable)((Object)row2), false);
                    arrayList.addAll(n + 1, list);
                }
            }
        }
        if (bl2) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                row2 = (Row)arrayList.get(n);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).isExpandable() || !((Expandable)((Object)row2)).hasChildren()) continue;
                arrayList.remove(n);
            }
        }
        return arrayList;
    }

    private static List<Row> getCollapsedValidChildren(TableModel tableModel, Expandable expandable, boolean bl) {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        int n = expandable.getChildren().size();
        for (int i = 0; i < n; ++i) {
            Object object = expandable.getChildAt(i);
            if (!(object instanceof Row)) continue;
            if (TreeTableUtils.isChildVisibleInThisModel(tableModel, object)) {
                arrayList.add((Row)object);
            }
            if (bl || !(object instanceof Expandable) || !((Expandable)object).hasChildren()) continue;
            arrayList.addAll(TreeTableUtils.getCollapsedValidChildren(tableModel, (Expandable)object, false));
        }
        return arrayList;
    }

    public static boolean hasDescendant(TableModel tableModel, Row row, boolean bl, boolean bl2) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.hasDescendant(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return false;
        }
        if (!bl && bl2) {
            IndexedRowTableModelWrapper indexedRowTableModelWrapper;
            if (tableModel instanceof IExpandableTreeTableModel) {
                return ((Expandable)((Object)row)).hasChildren();
            }
            if (tableModel instanceof DefaultTableModelWrapper) {
                if (((DefaultTableModelWrapper)tableModel)._indexes == null) {
                    return TreeTableUtils.hasDescendant(((DefaultTableModelWrapper)tableModel).getActualModel(), row, bl, bl2);
                }
            } else if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
                return TreeTableUtils.hasDescendant(indexedRowTableModelWrapper.getActualModel(), row, bl, bl2);
            }
        }
        int n = row != ((ITreeTableModel)((Object)tableModel)).getRoot() ? TreeTableUtils.internalGetDescendantCount(tableModel, row) : tableModel.getRowCount();
        int n2 = 0;
        if (bl) {
            int n3;
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n4 = iTreeTableModel.getRowIndex(row);
            int n5 = tableModel.getRowCount();
            for (int i = 0; i < n && (n3 = n4 + i + 1) < n5; ++i) {
                Row row2 = iTreeTableModel.getRowAt(n3);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren()) continue;
                ++n2;
            }
        }
        if (n - n2 > 0) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        return TreeTableUtils.hasCollapsedValidChildren(tableModel, (Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded());
    }

    public static int getDescendantCount(TableModel tableModel, Row row, boolean bl, boolean bl2) {
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.getDescendantCount(((CachedTableModel)tableModel).getActualModel(), row, bl, bl2);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            return 0;
        }
        int n = row != ((ITreeTableModel)((Object)tableModel)).getRoot() ? TreeTableUtils.internalGetDescendantCount(tableModel, row) : tableModel.getRowCount();
        int n2 = 0;
        if (bl) {
            int n3;
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n4 = iTreeTableModel.getRowIndex(row);
            int n5 = tableModel.getRowCount();
            for (int i = 0; i < n && (n3 = n4 + i + 1) < n5; ++i) {
                Row row2 = iTreeTableModel.getRowAt(n3);
                if (!(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren()) continue;
                ++n2;
            }
        }
        return n - n2 + (bl2 ? TreeTableUtils.getCollapsedValidChildrenCount(tableModel, (Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded(), bl) : 0);
    }

    private static boolean hasCollapsedValidChildren(TableModel tableModel, Expandable expandable, boolean bl) {
        if (expandable == null || expandable.getChildren() == null) {
            return false;
        }
        for (Object obj : expandable.getChildren()) {
            if (bl && TreeTableUtils.isChildVisibleInThisModel(tableModel, obj)) {
                return true;
            }
            if (!(obj instanceof Expandable) || !((Expandable)obj).hasChildren() || !TreeTableUtils.hasCollapsedValidChildren(tableModel, (Expandable)obj, bl || !((AbstractExpandable)obj).isExpanded())) continue;
            return true;
        }
        return false;
    }

    private static int getCollapsedValidChildrenCount(TableModel tableModel, Expandable expandable, boolean bl, boolean bl2) {
        int n = 0;
        List<?> list = expandable.getChildren();
        if (list != null) {
            for (Object obj : list) {
                if (obj instanceof Expandable && ((Expandable)obj).hasChildren()) {
                    n += TreeTableUtils.getCollapsedValidChildrenCount(tableModel, (Expandable)obj, bl || !((AbstractExpandable)obj).isExpanded(), bl2) + (!bl || bl2 ? 0 : 1);
                    continue;
                }
                if (!bl || !TreeTableUtils.isChildVisibleInThisModel(tableModel, obj)) continue;
                ++n;
            }
        }
        return n;
    }

    private static boolean isChildVisibleInThisModel(TableModel tableModel, Object object) {
        boolean bl = true;
        if (tableModel instanceof TableModelWrapperImpl) {
            TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, FilterableTreeTableModel.class);
            while (tableModel2 instanceof FilterableTreeTableModel) {
                Boolean bl2;
                Map<Row, Boolean> map = ((FilterableTreeTableModel)tableModel2).getRowVisibleCache();
                if (map != null && (bl2 = map.get(object)) != null && !bl2.booleanValue()) {
                    bl = false;
                    break;
                }
                tableModel2 = TableModelWrapperUtils.getActualTableModel(((FilterableTreeTableModel)tableModel2).getActualModel(), FilterableTreeTableModel.class);
            }
        }
        return bl;
    }

    private static int internalGetDescendantCount(TableModel tableModel, Row row) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        if (tableModel instanceof CachedTableModel) {
            return TreeTableUtils.internalGetDescendantCount(((CachedTableModel)tableModel).getActualModel(), row);
        }
        if (!(tableModel instanceof ITreeTableModel) || !(row instanceof Expandable)) {
            if (tableModel instanceof TableModelWrapper) {
                return TreeTableUtils.internalGetDescendantCount(((TableModelWrapper)((Object)tableModel)).getActualModel(), row);
            }
            return 0;
        }
        if (tableModel instanceof IExpandableTreeTableModel) {
            int n;
            int n2;
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)tableModel);
            while (row instanceof WrappedRow) {
                row = ((WrappedRow)((Object)row)).getOriginalRow();
            }
            int n3 = n2 = iExpandableTreeTableModel.getRowIndex(row);
            while (row instanceof Expandable && ((Expandable)((Object)row)).isExpanded() && (n = iExpandableTreeTableModel.getChildCount(row)) > 0) {
                int n4 = 1;
                Row row2 = (Row)iExpandableTreeTableModel.getChild(row, n - n4);
                int n5 = iExpandableTreeTableModel.getRowIndex(row2);
                while (n5 == -1 && ++n4 <= n) {
                    row2 = (Row)((Expandable)((Object)row)).getChildAt(n - n4);
                    n5 = iExpandableTreeTableModel.getRowIndex(row2);
                }
                if (n5 == -1) break;
                n3 = n5;
                row = row2;
            }
            return n3 - n2;
        }
        if (tableModel instanceof TableModelWrapper) {
            int n = TreeTableUtils.internalGetDescendantCount(((TableModelWrapper)((Object)tableModel)).getActualModel(), row);
            if (n <= 0) {
                return 0;
            }
            ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
            int n6 = iTreeTableModel.getRowIndex(row) + 1;
            int n7 = Math.min(n6 + n - 1, tableModel.getRowCount() - 1);
            int n8 = n6;
            int n9 = n7;
            do {
                int n10;
                if (TreeTableUtils.isAncientNodeOf((Expandable)((Object)row), iTreeTableModel.getRowAt(n10 = (n8 + n9) / 2))) {
                    n8 = n10;
                    continue;
                }
                n9 = n10;
            } while (n9 > n8 + 1);
            if (TreeTableUtils.isAncientNodeOf((Expandable)((Object)row), iTreeTableModel.getRowAt(n9))) {
                return n9 - n6 + 1;
            }
            if (n8 != n9 && TreeTableUtils.isAncientNodeOf((Expandable)((Object)row), iTreeTableModel.getRowAt(n8))) {
                return n8 - n6 + 1;
            }
            return n8 - n6;
        }
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            int n = TreeTableUtils.internalGetDescendantCount(indexedRowTableModelWrapper.getActualModel(), row);
            int n11 = ((ITreeTableModel)((Object)indexedRowTableModelWrapper.getActualModel())).getRowIndex(row);
            int n12 = indexedRowTableModelWrapper.getVisualRowAt(n11 + 1);
            if (n12 < 0) {
                n12 = 0;
                if ((n -= indexedRowTableModelWrapper.getActualRowAt(0) - n11 - 1) < 0) {
                    n = 0;
                }
            }
            int n13 = Math.min(n12 + n - 1, tableModel.getRowCount() - 1);
            return n13 - n12 + 1;
        }
        return 0;
    }

    private static boolean isAncientNodeOf(Expandable expandable, Row row) {
        Expandable expandable2;
        if (row == null) {
            return false;
        }
        while (expandable instanceof WrappedRow) {
            expandable = ((WrappedRow)((Object)expandable)).getOriginalRow();
        }
        while (row instanceof WrappedRow) {
            row = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        for (expandable2 = row.getParent(); expandable2 != null && expandable2 != expandable; expandable2 = expandable2.getParent()) {
        }
        return expandable2 != null;
    }
}

