/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TreeTableCellRenderer;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.grid.UndoableTableModelEvent;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class TreeTable
extends SortableTable {
    private static final String uiClassID = "TreeTableUI";
    public static final String PROPERTY_SHOW_TREE_LINES = "showTreeLines";
    public static final String PROPERTY_SHOW_LEAF_NODE_TREE_LINES = "showLeafNodeTreeLines";
    public static final String PROPERTY_TREE_LINE_COLOR = "treeLineColor";
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    public static final String PROPERTY_EXPANDABLE_COLUMN = "expandableColumn";
    public static final String PROPERTY_SELECT_ROW_WHEN_TOGGLING = "selectRowWhenToggling";
    public static final String CLIENT_PROPERTY_DO_NOT_PAINT_CELL_CONTENT_BACKGROUND = "TreeTable.doNotPaintCellContentBackground";
    private boolean _doubleClickEnabled = true;
    private boolean _showsRootHandles = true;
    private boolean _showsRootHandlesSet = false;
    private boolean _showTreeLines = false;
    private boolean _showTreeLinesSet = false;
    private boolean _showLeafNodeTreeLines = true;
    private boolean _showLeafNodeTreeLinesSet = false;
    private boolean _respectRenderPreferredHeight = false;
    private Color _treeLineColor;
    private int _indent = 16;
    private int _leftMargin = 16;
    private TableCellRenderer _renderer;
    private boolean _init;
    private boolean _expandAllAllowed = true;
    private boolean _expandable = true;
    private int _expandableColumn = -1;
    private boolean _selectRowWhenToggling = false;
    private boolean _selectParentRowWhenCollapsing = true;
    private boolean _compareCurrentSelection = false;
    private boolean _exportCollapsedRowsToExcel = false;
    private int _dragExpandDelay = 200;
    Row[] _savedTreeTableSelection;
    Map<Row, Integer> _savedTreeTableRowHeights;
    private Row _collapsedRow;
    private boolean _expandableColumnSet = false;

    public TreeTable() {
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(int n, int n2) {
        super(n, n2);
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeTable();
        this.installDefaults();
    }

    public TreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeTable();
        this.installDefaults();
    }

    private void initializeTable() {
        if (!this._init) {
            Object object;
            this.putClientProperty("AutoResize.highPerformance", false);
            this.setSelectInsertedRows(false);
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                object = this.getMouseListeners();
                MouseListener mouseListener = null;
                for (MouseListener mouseListener2 : object) {
                    if (mouseListener2.getClass().getName().indexOf("TableUI") == -1) continue;
                    mouseListener = mouseListener2;
                    this.removeMouseListener(mouseListener2);
                    if (!(mouseListener2 instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
                    break;
                }
                if (mouseListener != null && mouseListener instanceof MouseInputListener) {
                    MouseInputListener mouseInputListener = this.createExpandMouseInputListener((MouseInputListener)mouseListener);
                    JideSwingUtilities.insertMouseListener(this, mouseInputListener, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, mouseInputListener, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object, 0);
            }
            this._renderer = this.createCellRenderer();
            if (SystemInfo.isJdk6Above()) {
                this.addPropertyChangeListener("dropLocation", new PropertyChangeListener(){
                    private Timer _timer;

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getNewValue() instanceof JTable.DropLocation) {
                            Row row;
                            int n = ((JTable.DropLocation)propertyChangeEvent.getNewValue()).getRow();
                            if (n == -1 || propertyChangeEvent.getOldValue() instanceof JTable.DropLocation && ((JTable.DropLocation)propertyChangeEvent.getOldValue()).getRow() == n) {
                                return;
                            }
                            if (this._timer != null) {
                                this._timer.stop();
                            }
                            if ((row = TreeTable.this.getRowAt(n)) instanceof Expandable && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren() && !((Expandable)((Object)row)).isExpanded()) {
                                int n2 = TreeTable.this.getDragExpandDelay();
                                if (n2 > 0) {
                                    this._timer = new Timer(n2, new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            TreeTable.this.expand((Expandable)((Object)row), true);
                                            _timer.stop();
                                            _timer = null;
                                        }
                                    });
                                    this._timer.start();
                                } else {
                                    TreeTable.this.expand((Expandable)((Object)row), true);
                                }
                            }
                        }
                    }
                });
            }
            this._init = true;
        }
    }

    @Override
    public void clearSavedSelections(boolean bl) {
        this._savedTreeTableSelection = null;
        super.clearSavedSelections(bl);
    }

    @Override
    void clearSavedSelectionOnEvent() {
    }

    @Override
    void saveTableSelection() {
        this._savedTreeTableSelection = this.mergeSavedTreeTableSelection(this._savedTreeTableSelection, TableUtils.saveSelection(this));
    }

    @Override
    void loadTableSelection() {
        TableUtils.loadSelection(this, this._savedTreeTableSelection, false, this.isCompareCurrentSelection(), this._loadInsertedRowsOnly);
    }

    @Override
    void saveTableRowHeights() {
        this._savedTreeTableRowHeights = this.mergeSavedTreeTableRowHeights(this._savedTreeTableRowHeights, TableUtils.saveTreeTableRowHeights(this));
    }

    @Override
    void loadTableRowHeights() {
        TableUtils.loadTreeTableRowHeights(this, this._savedTreeTableRowHeights);
    }

    @Override
    void updateSelectionFromUndoableEdit(UndoableTableModelEvent undoableTableModelEvent) {
        if (!(undoableTableModelEvent.getSource() instanceof ITreeTableModel)) {
            return;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        UndoableTableModelEvent.TableModelEdit[] tableModelEditArray = undoableTableModelEvent.getEdits();
        ITreeTableModel iTreeTableModel = (ITreeTableModel)undoableTableModelEvent.getSource();
        TableUtils.ColumnSelectionRow columnSelectionRow = null;
        for (UndoableTableModelEvent.TableModelEdit tableModelEdit : tableModelEditArray) {
            if (tableModelEdit.getColumnIndex() >= 0 && columnSelectionRow == null) {
                columnSelectionRow = new TableUtils.ColumnSelectionRow(tableModelEdit.getColumnIndex());
            }
            arrayList.add(iTreeTableModel.getRowAt(tableModelEdit.getRowIndex()));
        }
        if (columnSelectionRow != null) {
            arrayList.add(columnSelectionRow);
        } else {
            arrayList.add(new TableUtils.ColumnSelectionRow(0));
        }
        this._savedTreeTableSelection = arrayList.toArray(new Row[arrayList.size()]);
    }

    private Map<Row, Integer> mergeSavedTreeTableRowHeights(Map<Row, Integer> map, Map<Row, Integer> map2) {
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        Set<Row> set = map2.keySet();
        for (Row row : map.keySet()) {
            boolean bl = set.contains(row);
            if (!bl) {
                for (Row row2 : set) {
                    if (!this.rowEquals(row, row2)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            map2.put(row, map.get(row));
        }
        return map2;
    }

    private Row[] mergeSavedTreeTableSelection(Row[] rowArray, Row[] rowArray2) {
        if (rowArray == null || rowArray.length <= 0) {
            return rowArray2;
        }
        if (rowArray2 == null || rowArray2.length <= 0) {
            return rowArray;
        }
        if (rowArray2.length > 20) {
            return rowArray2;
        }
        if (rowArray2.length >= 4 && rowArray2[1] instanceof TableUtils.ColumnSelectionRow && rowArray2[3] instanceof TableUtils.ColumnSelectionRow) {
            return rowArray2;
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row row : rowArray) {
            boolean bl = false;
            if (row instanceof TableUtils.ColumnSelectionRow) continue;
            for (Row row2 : rowArray2) {
                if (!this.rowEquals(row, row2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(row);
        }
        Row[] rowArray3 = new Row[rowArray2.length + arrayList.size()];
        System.arraycopy(rowArray2, 0, rowArray3, 0, rowArray2.length - 1);
        int n = rowArray2.length - 1;
        int n2 = 0;
        while (n < rowArray3.length - 1) {
            rowArray3[n] = (Row)arrayList.get(n2);
            ++n;
            ++n2;
        }
        rowArray3[rowArray3.length - 1] = rowArray2[rowArray2.length - 1];
        return rowArray3;
    }

    boolean rowEquals(Row row, Row row2) {
        return row == row2;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.installDefaults();
        this._renderer = this.createCellRenderer();
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    private void installDefaults() {
        if (!this._showsRootHandlesSet && UIDefaultsLookup.get("TreeTable.showsRootHandles") != null) {
            this._showsRootHandles = UIDefaultsLookup.getBoolean("TreeTable.showsRootHandles");
        }
        if (!this._showTreeLinesSet && UIDefaultsLookup.get("Tree.paintLines") != null) {
            this._showTreeLines = UIDefaultsLookup.getBoolean("Tree.paintLines");
        }
        if (!this._showLeafNodeTreeLinesSet && UIDefaultsLookup.get("TreeTable.paintLeafNodeLines") != null) {
            this._showLeafNodeTreeLines = UIDefaultsLookup.getBoolean("TreeTable.paintLeafNodeLines");
        }
        if (this._treeLineColor == null || this._treeLineColor instanceof UIResource) {
            this._treeLineColor = UIDefaultsLookup.getColor("Tree.hash");
        }
    }

    protected TableCellRenderer createCellRenderer() {
        return new TreeTableCellRenderer();
    }

    @Override
    protected void muteDefaultKeyStroke() {
        super.muteDefaultKeyStroke();
        this.replaceAction(KeyStroke.getKeyStroke(37, 0));
        this.replaceAction(KeyStroke.getKeyStroke(39, 0));
        this.replaceAction(KeyStroke.getKeyStroke(10, 0));
        this.replaceAction(KeyStroke.getKeyStroke(107, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(109, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(106, 0), 0);
        this.replaceAction(KeyStroke.getKeyStroke(111, 0), 0);
    }

    private boolean stopCellEditing() {
        if (this.isEditing()) {
            this.requestFocus();
            try {
                if (!this.getCellEditor().stopCellEditing()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private void cancelCellEditing() {
        if (this.isEditing()) {
            this.removeEditor();
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.stopCellEditing();
        this.cancelCellEditing();
        super.setModel(tableModel);
    }

    @Override
    void clearSavedRowHeights() {
        super.clearSavedRowHeights();
        this._savedTreeTableRowHeights = null;
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        Row row;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (!this.isExpandable()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isDoubleClickEnabled() && mouseEvent.getClickCount() == 2 && mouseEvent.getID() == 501) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            Row row2 = this.getRowAt(n);
            if (n != -1 && !this.isCellEditable(n, n2)) {
                if (row2 instanceof Expandable && ((Expandable)((Object)row2)).isExpanded() && TreeTableUtils.getDescendantCount(this.getModel(), row2, false, false) <= 0) {
                    return;
                }
                if (this.toggleRow(row2)) {
                    mouseEvent.consume();
                }
            }
        } else if (this.isExpandIconVisible() && (row = this.expandableRowAtPoint(mouseEvent.getPoint())) != null && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.getID() == 501 && this.toggleRow(row)) {
                mouseEvent.consume();
            } else {
                mouseEvent.consume();
            }
        }
    }

    TreePath getTreePathOf(Expandable expandable) {
        ArrayList<Expandable> arrayList = new ArrayList<Expandable>();
        do {
            arrayList.add(0, expandable);
        } while ((expandable = expandable.getParent()) != null);
        return new TreePath(arrayList.toArray());
    }

    protected boolean toggleRow(Row row) {
        return row instanceof Expandable && this.expand((Expandable)((Object)row), !((Expandable)((Object)row)).isExpanded());
    }

    public Row getRowAt(int n) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            return ((ITreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(this.getModel(), n, IExpandableTreeTableModel.class));
        }
        return null;
    }

    public int getRowIndex(Row row) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof ITreeTableModel) {
            return TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, ((ITreeTableModel)((Object)tableModel)).getRowIndex(row));
        }
        return -1;
    }

    public boolean expandRow(int n, boolean bl) {
        Expandable expandable;
        if (!this.stopCellEditing()) {
            return false;
        }
        Row row = this.getRowAt(n);
        if (row != null && row instanceof Expandable && ((expandable = (Expandable)((Object)row)).hasChildren() && bl && !expandable.isExpanded() || !bl && expandable.isExpanded()) && this.expand(expandable, bl)) {
            if (this.isSelectRowWhenToggling()) {
                this.setSelectedRow(row);
            }
            return true;
        }
        return false;
    }

    private boolean expand(Expandable expandable, boolean bl) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel && expandable.isExpanded() != bl) {
            if (!this.stopCellEditing()) {
                return false;
            }
            TreePath treePath = this.getTreePathOf(expandable);
            try {
                if (bl) {
                    this.fireTreeWillExpand(treePath);
                } else {
                    this.fireTreeWillCollapse(treePath);
                }
            }
            catch (ExpandVetoException expandVetoException) {
                return false;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandRow((ExpandableRow)expandable, bl);
            if (this.isSelectRowWhenToggling()) {
                this.setSelectedRow((ExpandableRow)expandable);
            }
            if (bl) {
                this.fireTreeExpanded(treePath);
            } else {
                this.fireTreeCollapsed(treePath);
            }
            return true;
        }
        return false;
    }

    @Override
    void tableRowsDeleted(TableModelEvent tableModelEvent, boolean bl) {
        super.tableRowsDeleted(tableModelEvent, bl);
        TableModel tableModel = this.getTreeTableModel();
        if (this._collapsedRow != null && this._savedTreeTableSelection != null && tableModel instanceof ITreeTableModel) {
            boolean bl2 = false;
            ArrayList<Row> arrayList = new ArrayList<Row>();
            for (Row row : this._savedTreeTableSelection) {
                Expandable expandable;
                if (row == null) continue;
                for (expandable = row.getParent(); expandable != null && expandable != this._collapsedRow; expandable = expandable.getParent()) {
                }
                if (expandable == this._collapsedRow) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(row);
            }
            this._savedTreeTableSelection = arrayList.toArray(new Row[arrayList.size()]);
            if (bl2) {
                int n = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, ((ITreeTableModel)((Object)tableModel)).getRowIndex(this._collapsedRow));
                this.getSelectionModel().addSelectionInterval(n, n);
            }
        }
        this._collapsedRow = null;
    }

    @Override
    boolean needLoadSelection(TableModelEvent tableModelEvent) {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getSource() == tableModel && tableModel instanceof IExpandableTreeTableModel) {
            Row row;
            if (tableModelEvent.getType() == 1) {
                Expandable expandable;
                Row row2 = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getFirstRow());
                if (row2 != null && (expandable = row2.getParent()).getChildrenCount() == tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1) {
                    return false;
                }
            } else if (tableModelEvent.getType() == -1 && (row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getFirstRow() - 1)) instanceof Expandable && !((Expandable)((Object)row)).isExpanded()) {
                this._collapsedRow = row;
                return false;
            }
        }
        return super.needLoadSelection(tableModelEvent);
    }

    public boolean isSelectRowWhenToggling() {
        return this._selectRowWhenToggling;
    }

    public void setSelectRowWhenToggling(boolean bl) {
        boolean bl2 = this._selectRowWhenToggling;
        if (this._selectRowWhenToggling != bl) {
            this._selectRowWhenToggling = bl;
            this.firePropertyChange(PROPERTY_SELECT_ROW_WHEN_TOGGLING, bl2, bl);
        }
    }

    public void setSelectedRow(Row row) {
        if (row == null) {
            this.clearSelection();
        } else {
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                boolean bl = false;
                for (Expandable expandable = row.getParent(); expandable != null; expandable = expandable.getParent()) {
                    if (expandable.isExpanded()) continue;
                    expandable.setExpanded(true);
                    bl = true;
                }
                if (bl) {
                    ((IExpandableTreeTableModel)((Object)tableModel)).refresh();
                }
                int n = this.getRowIndex(row);
                int n2 = this.getSelectedColumn();
                this.changeSelection(n, n2 == -1 ? 0 : n2, false, false);
            }
        }
    }

    public void addSelectedRow(Row row) {
        if (row == null) {
            return;
        }
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            boolean bl = false;
            for (Expandable expandable = row.getParent(); expandable != null; expandable = expandable.getParent()) {
                if (expandable.isExpanded()) continue;
                expandable.setExpanded(true);
                bl = true;
            }
            if (bl) {
                ((IExpandableTreeTableModel)((Object)tableModel)).refresh();
            }
            int n = this.getRowIndex(row);
            int n2 = this.getSelectedColumn();
            if (!this.isRowSelected(n)) {
                this.changeSelection(n, n2 == -1 ? 0 : n2, true, false);
            }
        }
    }

    public void removeSelectedRow(Row row) {
        int n;
        if (row == null) {
            return;
        }
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel && (n = this.getRowIndex(row)) >= 0 && this.isRowSelected(n)) {
            int n2 = this.getSelectedColumn();
            this.changeSelection(n, n2 == -1 ? 0 : n2, true, false);
        }
    }

    public void setSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            this.clearSelection();
            return;
        }
        this.setSelectedRow(rowArray[0]);
        for (int i = 1; i < rowArray.length; ++i) {
            this.addSelectedRow(rowArray[i]);
        }
    }

    public void addSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            return;
        }
        for (Row row : rowArray) {
            this.addSelectedRow(row);
        }
    }

    public void removeSelectedRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length <= 0) {
            return;
        }
        for (Row row : rowArray) {
            this.removeSelectedRow(row);
        }
    }

    public void expandAll() {
        if (this.isExpandAllAllowed()) {
            if (!this.stopCellEditing()) {
                return;
            }
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                ((IExpandableTreeTableModel)((Object)tableModel)).expandAll();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void expandFirstLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.stopCellEditing()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandFirstLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void expandNextLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.stopCellEditing()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).expandNextLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void collapseAll() {
        if (this.isExpandAllAllowed()) {
            if (!this.stopCellEditing()) {
                return;
            }
            TableModel tableModel = this.getTreeTableModel();
            if (tableModel instanceof IExpandableTreeTableModel) {
                ((IExpandableTreeTableModel)((Object)tableModel)).collapseAll();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void collapseFirstLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.stopCellEditing()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).collapseFirstLevel();
            this.revalidate();
            this.repaint();
        }
    }

    public void collapseLastLevel() {
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel instanceof IExpandableTreeTableModel) {
            if (!this.stopCellEditing()) {
                return;
            }
            ((IExpandableTreeTableModel)((Object)tableModel)).collapseLastLevel();
            this.revalidate();
            this.repaint();
        }
    }

    protected Rectangle getCellRect(Point point) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Rectangle rectangle = this.getCellRect(i, j, true);
                if (!rectangle.contains(point)) continue;
                if (j == this.getExpandableColumnViewIndex()) {
                    rectangle.x += this.getIndent();
                    rectangle.width -= this.getIndent();
                }
                return rectangle;
            }
        }
        return null;
    }

    protected Point getCellAt(Point point) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                Rectangle rectangle = this.getCellRect(i, j, true);
                if (!rectangle.contains(point)) continue;
                return new Point(j, i);
            }
        }
        return null;
    }

    public TableCellRenderer getActualCellRenderer(int n, int n2) {
        return super.getCellRenderer(n, n2);
    }

    @Override
    boolean loadInsertedRowsOnly(CompoundTableModelEvent compoundTableModelEvent) {
        TableModelEvent tableModelEvent = compoundTableModelEvent.getOriginalEvent();
        return tableModelEvent instanceof CompoundTableModelEvent && (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2;
        super.tableChanged(tableModelEvent);
        TableModel tableModel = this.getTreeTableModel();
        if (tableModel != null && tableModel.getRowCount() == 0) {
            this._renderer = null;
        }
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            tableModelEvent2 = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
            if (tableModelEvent2 == null) {
                return;
            }
        } else {
            tableModelEvent2 = tableModelEvent;
        }
        if (!(tableModelEvent2 instanceof CompoundTableModelEvent) && (tableModelEvent2 == null || tableModelEvent2.getFirstRow() == -1 && tableModelEvent2.getColumn() == -1 && tableModelEvent2.getType() == 0 || tableModelEvent2.getType() == 0 && tableModelEvent2.getFirstRow() == 0 && tableModelEvent2.getLastRow() == Integer.MAX_VALUE && tableModelEvent2.getColumn() == -1)) {
            this.clearSavedRowHeights();
            this.clearSavedSelections(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._renderer = null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == this.getExpandableColumnViewIndex()) {
            if (this._renderer == null) {
                this._renderer = this.createCellRenderer();
            }
            if (this._renderer instanceof TreeTableCellRenderer) {
                TableCellRenderer tableCellRenderer = this.getActualCellRenderer(n, n2);
                ((TreeTableCellRenderer)this._renderer).setActualCellRenderer(tableCellRenderer);
            }
            return this._renderer;
        }
        return this.getActualCellRenderer(n, n2);
    }

    @Override
    protected Action createDelegateAction(Action action, KeyStroke keyStroke) {
        return new TreeTableAction(action, keyStroke);
    }

    public boolean isCompareCurrentSelection() {
        return this._compareCurrentSelection;
    }

    public void setCompareCurrentSelection(boolean bl) {
        this._compareCurrentSelection = bl;
    }

    public boolean isExportCollapsedRowsToExcel() {
        return this._exportCollapsedRowsToExcel;
    }

    public void setExportCollapsedRowsToExcel(boolean bl) {
        this._exportCollapsedRowsToExcel = bl;
    }

    protected int getIndent(Row row) {
        return this.getIndent();
    }

    public int getDragExpandDelay() {
        return this._dragExpandDelay;
    }

    public void setDragExpandDelay(int n) {
        this._dragExpandDelay = n;
    }

    public boolean isSelectParentRowWhenCollapsing() {
        return this._selectParentRowWhenCollapsing;
    }

    public void setSelectParentRowWhenCollapsing(boolean bl) {
        this._selectParentRowWhenCollapsing = bl;
    }

    protected MouseInputListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(TreeExpansionListener.class, treeExpansionListener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(TreeExpansionListener.class);
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeExpanded(treeExpansionEvent);
        }
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeExpansionListener)objectArray[i + 1]).treeCollapsed(treeExpansionEvent);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(TreeWillExpandListener.class);
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillExpand(treeExpansionEvent);
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            if (treeExpansionEvent == null) {
                treeExpansionEvent = new TreeExpansionEvent(this, treePath);
            }
            ((TreeWillExpandListener)objectArray[i + 1]).treeWillCollapse(treeExpansionEvent);
        }
    }

    public boolean isShowTreeLines() {
        if (LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel")) {
            return false;
        }
        return this._showTreeLines;
    }

    public void setShowTreeLines(boolean bl) {
        boolean bl2 = this._showTreeLines;
        if (bl2 != bl) {
            this._showTreeLines = bl;
            this._showTreeLinesSet = true;
            this.firePropertyChange(PROPERTY_SHOW_TREE_LINES, bl2, bl);
            this.repaint();
        }
    }

    public boolean isShowLeafNodeTreeLines() {
        return this._showLeafNodeTreeLines;
    }

    public void setShowLeafNodeTreeLines(boolean bl) {
        boolean bl2 = this._showLeafNodeTreeLines;
        if (bl2 != bl) {
            this._showLeafNodeTreeLines = bl;
            this._showLeafNodeTreeLinesSet = true;
            this.firePropertyChange(PROPERTY_SHOW_LEAF_NODE_TREE_LINES, bl2, bl);
            this.repaint();
        }
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        boolean bl2 = this._doubleClickEnabled;
        if (bl2 != bl) {
            this._doubleClickEnabled = bl;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ENABLED, bl2, bl);
        }
    }

    public Color getTreeLineColor() {
        return this._treeLineColor;
    }

    public void setTreeLineColor(Color color) {
        Color color2 = this._treeLineColor;
        if (color2 == null || !color2.equals(color)) {
            this._treeLineColor = color;
            this.firePropertyChange(PROPERTY_TREE_LINE_COLOR, color2, this._treeLineColor);
        }
    }

    protected TableModel getTreeTableModel() {
        TableModel tableModel = this.getModel();
        while (true) {
            if (tableModel instanceof IExpandableTreeTableModel) {
                return tableModel;
            }
            if (!(tableModel instanceof TableModelWrapper)) break;
            tableModel = ((TableModelWrapper)((Object)tableModel)).getActualModel();
        }
        return null;
    }

    @Override
    protected ISortableTableModel createSortableTableModel(TableModel tableModel) {
        return new SortableTreeTableModel(tableModel);
    }

    public int getIndent() {
        return this._indent;
    }

    public void setIndent(int n) {
        this._indent = n;
        this.repaint();
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(int n) {
        this._leftMargin = n;
    }

    public boolean getShowsRootHandles() {
        return this._showsRootHandles;
    }

    public void setShowsRootHandles(boolean bl) {
        boolean bl2 = this._showsRootHandles;
        if (bl2 != bl) {
            this._showsRootHandles = bl;
            this._showsRootHandlesSet = true;
            this.firePropertyChange("showsRootHandles", bl2, this._showsRootHandles);
            this.invalidate();
        }
    }

    public boolean isExpandAllAllowed() {
        return this._expandAllAllowed;
    }

    public void setExpandAllAllowed(boolean bl) {
        this._expandAllAllowed = bl;
    }

    public boolean isExpandable() {
        return this._expandable;
    }

    public void setExpandable(boolean bl) {
        this._expandable = bl;
    }

    public int getExpandableColumnViewIndex() {
        if (!this._expandableColumnSet) {
            return 0;
        }
        return this.convertColumnIndexToView(this._expandableColumn);
    }

    public boolean shouldPaintHorizontalLeg(int n) {
        int n2;
        Row row = this.getRowAt(n);
        if (row == null) {
            return false;
        }
        Expandable expandable = row.getParent();
        return !(row instanceof Expandable) || ((Expandable)((Object)row)).hasChildren() || this.isShowLeafNodeTreeLines() || !(expandable instanceof Row) || n == (n2 = this.getRowIndex((Row)((Object)expandable)) + TableModelWrapperUtils.getVisibleChildrenCount(this.getModel(), (Row)((Object)expandable)));
    }

    public int getExpandableColumn() {
        return this._expandableColumn;
    }

    public void setExpandableColumn(int n) {
        if (this._expandableColumn != n) {
            int n2 = this._expandableColumn;
            this._expandableColumn = n;
            this._expandableColumnSet = this._expandableColumn != -1;
            this.firePropertyChange(PROPERTY_EXPANDABLE_COLUMN, n2, this._expandableColumn);
        }
    }

    public int getHorizontalLegPosition(int n) {
        return n / 2;
    }

    public int getVerticalLineStartPosition(int n) {
        return n;
    }

    public Row expandableRowAtPoint(Point point) {
        int n = this.rowAtPoint(point);
        if (n != -1) {
            Row row = this.getRowAt(n);
            int n2 = this.getExpandableColumnViewIndex();
            if (n2 >= 0 && row != null && row instanceof Expandable && ((Expandable)((Object)row)).hasChildren() && (!((Expandable)((Object)row)).isExpanded() || TreeTableUtils.getDescendantCount(this.getModel(), row, false, false) > 0)) {
                Rectangle rectangle = this.getCellRect(n, n2, true);
                int n3 = rectangle.x + row.getLevel() * this.getIndent() + (16 - this.getCollapsedIcon().getIconWidth()) / 2 - 1;
                if (!this.getShowsRootHandles()) {
                    n3 -= 16;
                }
                int n4 = n3 + this.getCollapsedIcon().getIconWidth() + 2;
                if (!this.getComponentOrientation().isLeftToRight()) {
                    n3 = rectangle.x + rectangle.width - (n3 - rectangle.x);
                    int n5 = n4 = rectangle.x + rectangle.width - (n4 - rectangle.x);
                    n4 = n3;
                    n3 = n5;
                }
                if (point.x > n3 && point.x < n4 && point.x < rectangle.x + rectangle.width) {
                    return row;
                }
            }
        }
        return null;
    }

    @Override
    public Rectangle getEditorCellRect(int n, int n2) {
        Rectangle rectangle = super.getCellRect(n, n2, false);
        if (n2 == this.getExpandableColumnViewIndex() && this.getCellRenderer(n, n2) instanceof TreeTableCellRenderer) {
            Row row = this.getRowAt(n);
            int n3 = 0;
            if (row != null) {
                n3 = row.getLevel() * this.getIndent() + this.getLeftMargin();
                if (!this.getShowsRootHandles()) {
                    n3 -= this.getLeftMargin();
                }
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x += n3;
                rectangle.width -= n3;
            } else {
                rectangle.width -= n3;
            }
        }
        return rectangle;
    }

    @Override
    public boolean alwaysCalculateCellRect() {
        return true;
    }

    @Override
    void internalReleaseRendererComponent(TableCellRenderer tableCellRenderer, int n, int n2, Component component, boolean bl) {
        super.internalReleaseRendererComponent(tableCellRenderer, n, n2, component, bl);
        if (tableCellRenderer instanceof TreeTableCellRenderer) {
            ((TreeTableCellRenderer)tableCellRenderer).releaseCellRenderer();
        }
    }

    public boolean isRespectRenderPreferredHeight() {
        return this._respectRenderPreferredHeight;
    }

    public void setRespectRenderPreferredHeight(boolean bl) {
        this._respectRenderPreferredHeight = bl;
        this.repaint();
    }

    public boolean shouldDisplayExpandIcon(Row row) {
        TableModel tableModel = this.getModel();
        while (tableModel != null) {
            if (!((tableModel = TableModelWrapperUtils.getActualTableModel(tableModel, FilterableTreeTableModel.class)) instanceof FilterableTreeTableModel)) continue;
            if (!((FilterableTreeTableModel)tableModel).isKeepAllChildren() && ((FilterableTreeTableModel)tableModel).hasFilter() && ((FilterableTreeTableModel)tableModel).isFiltersApplied()) {
                if (TreeTableUtils.hasDescendant(tableModel, row, false, true)) break;
                return false;
            }
            tableModel = ((FilterableTreeTableModel)tableModel).getActualModel();
        }
        return true;
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TreeTable.this.isColumnResizable() && TableUtils.getResizingColumn(TreeTable.this, mouseEvent.getPoint(), TreeTable.this.columnAtPoint(mouseEvent.getPoint())) != null) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            TreeTable.this.handleMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                super.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TreeTable.this._columnResizer != null && TreeTable.this._columnResizer.isResizing()) {
                return;
            }
            super.mouseMoved(mouseEvent);
        }
    }

    protected class ExpandMouseListener
    extends MouseInputAdapter {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TreeTable.this.handleMouseEvent(mouseEvent);
        }
    }

    protected static class TreeTableAction
    extends CellSpanTable.DelegateAction {
        private static final long serialVersionUID = 1263872415793628604L;

        public TreeTableAction(Action action, KeyStroke keyStroke) {
            super(action, keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreeTable treeTable = (TreeTable)actionEvent.getSource();
            if (!treeTable.isEditing()) {
                switch (this._keyStroke.getKeyCode()) {
                    case 37: 
                    case 109: {
                        if (!treeTable.isExpandable() || !this.expandSelectedRow(treeTable, false, true)) break;
                        return;
                    }
                    case 39: 
                    case 107: {
                        if (!treeTable.isExpandable() || !this.expandSelectedRow(treeTable, true, true)) break;
                        return;
                    }
                    case 106: {
                        if (!treeTable.isExpandable()) break;
                        this.expandAll(treeTable);
                        return;
                    }
                    case 111: {
                        if (!treeTable.isExpandable()) break;
                        this.collapseAll(treeTable);
                        return;
                    }
                    case 10: {
                        if (!this.stopEditing(treeTable)) break;
                        return;
                    }
                }
            }
            super.actionPerformed(actionEvent);
        }

        protected void expandAll(TreeTable treeTable) {
            treeTable.expandAll();
        }

        protected void collapseAll(TreeTable treeTable) {
            treeTable.collapseAll();
        }

        protected boolean expandSelectedRow(TreeTable treeTable, boolean bl, boolean bl2) {
            int n;
            int n2 = treeTable.getSelectionModel().getLeadSelectionIndex();
            int n3 = n = treeTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            CellSpan cellSpan = treeTable.getCellSpanAt(n2, n);
            if (cellSpan != null) {
                n = cellSpan.getColumn();
                n3 = n + cellSpan.getColumnSpan() - 1;
            }
            int n4 = treeTable.getExpandableColumnViewIndex();
            if (n2 != -1 && (!bl2 || n <= n4 && n3 >= n4)) {
                Expandable expandable;
                Row row;
                boolean bl3 = treeTable.expandRow(n2, bl);
                TableModel tableModel = treeTable.getTreeTableModel();
                if (!bl3 && !bl && tableModel instanceof ITreeTableModel && treeTable.isSelectParentRowWhenCollapsing() && (row = ((ITreeTableModel)((Object)tableModel)).getRowAt(n2)) != null && (expandable = row.getParent()) instanceof Row && !(expandable instanceof RootExpandableRow)) {
                    treeTable.setSelectedRow((Row)((Object)expandable));
                    bl3 = true;
                }
                return bl3;
            }
            return false;
        }

        protected boolean stopEditing(TreeTable treeTable) {
            return treeTable.isEditing() && treeTable.stopCellEditing();
        }

        protected boolean cancelEditing(TreeTable treeTable) {
            if (treeTable.isEditing()) {
                treeTable.cancelCellEditing();
                return true;
            }
            return false;
        }
    }
}

