/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.TableSelectionModel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class TableSelectionModelGroup
implements Serializable {
    protected List<TableSelectionModel> _models = new Vector<TableSelectionModel>();
    protected TableSelectionListener _tableSelectionListener = new TableSelectionListener(){

        @Override
        public void valueChanged(TableSelectionEvent tableSelectionEvent) {
            if (!tableSelectionEvent.getValueIsAdjusting() && tableSelectionEvent.getSource() instanceof TableSelectionModel && !((TableSelectionModel)tableSelectionEvent.getSource()).isSelectionEmpty()) {
                TableSelectionModelGroup.this.disableListener();
                for (TableSelectionModel tableSelectionModel : TableSelectionModelGroup.this._models) {
                    if (tableSelectionModel == tableSelectionEvent.getSource()) continue;
                    tableSelectionModel.clearSelection();
                }
                TableSelectionModelGroup.this.enableListener();
            }
        }
    };

    private void disableListener() {
        for (TableSelectionModel tableSelectionModel : this._models) {
            tableSelectionModel.removeTableSelectionListener(this._tableSelectionListener);
        }
    }

    private void enableListener() {
        for (TableSelectionModel tableSelectionModel : this._models) {
            tableSelectionModel.addTableSelectionListener(this._tableSelectionListener);
        }
    }

    public void add(TableSelectionModel tableSelectionModel) {
        if (tableSelectionModel == null) {
            return;
        }
        this._models.add(tableSelectionModel);
        tableSelectionModel.addTableSelectionListener(this._tableSelectionListener);
    }

    public void add(int n, TableSelectionModel tableSelectionModel) {
        if (tableSelectionModel == null) {
            return;
        }
        this._models.add(n, tableSelectionModel);
        tableSelectionModel.addTableSelectionListener(this._tableSelectionListener);
    }

    public void remove(TableSelectionModel tableSelectionModel) {
        if (tableSelectionModel == null) {
            return;
        }
        this._models.remove(tableSelectionModel);
        tableSelectionModel.removeTableSelectionListener(this._tableSelectionListener);
    }

    public TableSelectionModel[] getTableModels() {
        return this._models.toArray(new TableSelectionModel[this._models.size()]);
    }

    public Enumeration<TableSelectionModel> getElements() {
        final TableSelectionModel[] tableSelectionModelArray = this.getTableModels();
        return new Enumeration(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < tableSelectionModelArray.length - 1;
            }

            public Object nextElement() {
                return tableSelectionModelArray[++this.index];
            }
        };
    }

    public int getModelCount() {
        if (this._models == null) {
            return 0;
        }
        return this._models.size();
    }
}

