/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortItemSupport;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableModelsWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class SortableTableModel
extends DefaultTableModelWrapper
implements ISortableTableModel {
    protected SortItemSupport _sortItemSupport = new SortItemSupport();
    private boolean _autoResort = true;
    private boolean[] _columnsSortable;
    private boolean _sortable = true;
    private ColumnComparatorContextProvider _columnComparatorContextProvider;
    private transient Comparator[] _cachedComparators;
    private transient int[] _masterSortColumns = null;
    private transient List<ISortableTableModel.SortItem> _sortingColumns = null;
    private boolean _sortingPaused = false;
    private boolean _alwaysUseComparators = false;
    private boolean _resetOnTableStructureChangeEvent = true;
    private static final Logger LOGGER_EVENT = Logger.getLogger(SortableTableModel.class.getName());
    private static final long serialVersionUID = -2403018550641649960L;
    private boolean _optimized = true;

    public SortableTableModel(TableModel tableModel) {
        super(tableModel);
        this.setCacheEnabled(true);
    }

    @Override
    public int getSortedRowAt(int n) {
        return this.getVisualRowAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.fireIndexChanging();
        this._originalEvent = tableModelEvent instanceof CompoundTableModelEvent ? ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() : tableModelEvent;
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        TableModelEventHandleResult tableModelEventHandleResult = null;
        boolean bl = this.isCacheEnabled();
        try {
            tableModelEventHandleResult = this.internalTableChanged(compoundTableModelEvent, tableModelEvent);
        }
        finally {
            if (tableModelEventHandleResult != null && tableModelEventHandleResult._needDisableCache) {
                this.setCacheEnabled(false);
            }
            try {
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            }
            finally {
                this.setCacheEnabled(bl);
            }
            if (tableModelEventHandleResult != null && tableModelEventHandleResult._needFireSortEvent) {
                this.fireSortEvent();
            }
            this.fireIndexChanged(n);
            this._originalEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private TableModelEventHandleResult internalTableChanged(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2;
        int n;
        TableModelEventHandleResult tableModelEventHandleResult = new TableModelEventHandleResult();
        if (this.isSortingPaused()) {
            boolean bl = false;
            if (tableModelEvent.getType() == 1) {
                this.internalTableRowsInsertedSortingPaused(compoundTableModelEvent, tableModelEvent);
            } else if (tableModelEvent.getType() == 0) {
                if (this._indexes != null && this._model.getRowCount() != this._indexes.length) {
                    this.reallocateIndexes();
                    bl = true;
                }
                if ((tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) && tableModelEvent.getColumn() == -1) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, -1));
                    bl = true;
                } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                        void var7_19;
                        TableModelEvent[] objectArray = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                        n = objectArray.length;
                        boolean bl2 = false;
                        while (var7_19 < n) {
                            tableModelEvent2 = objectArray[var7_19];
                            this.internalTableChanged(compoundTableModelEvent, tableModelEvent2);
                            ++var7_19;
                        }
                    } else {
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    }
                } else {
                    this.internalTableRowsOrCellsUpdatedSortingPaused(compoundTableModelEvent, tableModelEvent);
                }
            } else if (tableModelEvent.getType() == -1) {
                this.internalTableRowsDeletedSortingPaused(compoundTableModelEvent, tableModelEvent);
            }
            if (tableModelEvent.getType() != 0 || !bl) {
                return tableModelEventHandleResult;
            }
        }
        List<ISortableTableModel.SortItem> list = this.getSortingColumns();
        if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
            ArrayList<ISortableTableModel.SortItem> bl = new ArrayList<ISortableTableModel.SortItem>();
            for (ISortableTableModel.SortItem sortItem : list) {
                if (sortItem.getColumn() < this.getColumnCount()) continue;
                bl.add(sortItem);
            }
            for (ISortableTableModel.SortItem sortItem : bl) {
                list.remove(sortItem);
            }
        }
        if (list.size() == 0) {
            this.setIndexes(null);
            if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                this._columnsSortable = null;
            }
            if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                void var7_23;
                TableModelEvent[] n3 = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                n = n3.length;
                boolean bl = false;
                while (var7_23 < n) {
                    tableModelEvent2 = n3[var7_23];
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), tableModelEvent2.getColumn(), tableModelEvent2.getType()));
                    ++var7_23;
                }
            } else {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
            }
            return tableModelEventHandleResult;
        }
        if (!this.isOptimized()) {
            this.fireSortingEvent();
            if (this.isAutoResort()) {
                this.sort();
            } else if (this.isRowCountChanged()) {
                list.clear();
                this.reallocateIndexes();
            }
            if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, -1));
                this._columnsSortable = null;
            } else {
                compoundTableModelEvent.addEvent(new TableModelEvent(this));
            }
            tableModelEventHandleResult._needFireSortEvent = true;
            return tableModelEventHandleResult;
        }
        if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1 || tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
            if (!(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).getEvents() == null || ((CompoundTableModelEvent)tableModelEvent).getEvents().length <= 0) {
                if (this.isAutoResort()) {
                    this.fireSortingEvent();
                    if (list.size() > 0) {
                        this.sort();
                    } else {
                        this.setIndexes(null);
                    }
                    tableModelEventHandleResult._needFireSortEvent = true;
                } else if (this.isRowCountChanged()) {
                    if (tableModelEvent.getFirstRow() == -1 || tableModelEvent.getLastRow() == -1) {
                        list.clear();
                    }
                    this.fireSortingEvent();
                    this.reallocateIndexes();
                    tableModelEventHandleResult._needFireSortEvent = true;
                }
                compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
            } else {
                void var7_25;
                TableModelEvent[] bl = ((CompoundTableModelEvent)tableModelEvent).getEvents();
                n = bl.length;
                boolean bl3 = false;
                while (var7_25 < n) {
                    tableModelEvent2 = bl[var7_25];
                    this.internalTableChanged(compoundTableModelEvent, tableModelEvent2);
                    ++var7_25;
                }
            }
        } else if (tableModelEvent.getColumn() != -1 && tableModelEvent.getType() == 0) {
            if (this.isAutoResort() && this.isColumnSorted(tableModelEvent.getColumn())) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    tableModelEventHandleResult._needFireSortEvent = true;
                } else {
                    tableModelEventHandleResult._needDisableCache = this.rowOrCellUpdatedSorting(compoundTableModelEvent, tableModelEvent);
                }
            } else if (this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow()) || !this.isAutoResort()) {
                tableModelEventHandleResult._needDisableCache = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    for (n = tableModelEvent.getFirstRow(); n <= tableModelEvent.getLastRow(); ++n) {
                        int n2 = this.getSortedRowAt(n);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n2, tableModelEvent.getColumn()));
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            } else {
                this.cacheComparators();
                this.fireSortingEvent();
                this.sort();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, tableModelEvent.getColumn()));
                tableModelEventHandleResult._needFireSortEvent = true;
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            if (this.isAutoResort()) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1));
                    tableModelEventHandleResult._needFireSortEvent = true;
                } else {
                    tableModelEventHandleResult._needDisableCache = this.rowOrCellUpdatedSorting(compoundTableModelEvent, tableModelEvent);
                }
            } else {
                tableModelEventHandleResult._needDisableCache = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    for (n = tableModelEvent.getFirstRow(); n <= tableModelEvent.getLastRow(); ++n) {
                        int n3 = this.getSortedRowAt(n);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n3, -1, 0));
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 1) {
            if (this.isAutoResort()) {
                this.cacheComparators();
                if (!this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, -1));
                    this.fireSortingEvent();
                    this.sort();
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
                    tableModelEventHandleResult._needFireSortEvent = true;
                } else if (this._indexes == null) {
                    if (this.getSortingColumns().size() != 0) {
                        this.reallocateIndexes();
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                } else {
                    int n4 = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                    for (n = 0; n < this._indexes.length; ++n) {
                        int n5 = this._indexes[n];
                        if (n5 < tableModelEvent.getFirstRow()) continue;
                        this._indexes[n] = n5 + n4;
                    }
                    for (n = tableModelEvent.getFirstRow(); n <= tableModelEvent.getLastRow(); ++n) {
                        int n6 = this.insert(n);
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n6, n6, -1, 1));
                    }
                }
            } else {
                int[] nArray = this.append(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                if (nArray != null && nArray.length >= 2) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], -1, 1));
                }
            }
        } else if (tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == -1) {
            if (this.isAutoResort() && !this.shouldOptimize(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow())) {
                this.fireSortingEvent();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount(), -1, -1));
                this.sort();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount(), -1, 1));
                tableModelEventHandleResult._needFireSortEvent = true;
            } else {
                tableModelEventHandleResult._needDisableCache = true;
                boolean bl = this.isCacheEnabled();
                this.setCacheEnabled(false);
                try {
                    void var7_31;
                    int n7 = n = tableModelEvent.getFirstRow();
                    while (var7_31 <= tableModelEvent.getLastRow()) {
                        int n8 = this.getSortedRowAt(n);
                        if (n8 != -1) {
                            this.remove(n);
                            compoundTableModelEvent.addEvent(new TableModelEvent(this, n8, n8, -1, -1));
                        }
                        ++var7_31;
                    }
                }
                finally {
                    this.setCacheEnabled(bl);
                }
            }
        } else if (this.isAutoResort()) {
            this.resort();
        } else {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, 0, this.getRowCount()));
        }
        return tableModelEventHandleResult;
    }

    private void internalTableRowsInsertedSortingPaused(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int[] nArray = this.getIndexes();
        int n = tableModelEvent.getFirstRow();
        if (this._indexes != null) {
            n = FilterableTableModel.getNearestRow(nArray, tableModelEvent.getFirstRow(), true);
            this._indexes = FilterableTableModel.insertIndexes(nArray, this._model.getRowCount(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), true);
        }
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n + tableModelEvent.getLastRow() - tableModelEvent.getFirstRow(), -1, 1));
    }

    /*
     * WARNING - void declaration
     */
    private void internalTableRowsDeletedSortingPaused(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        int n3 = n2 - n + 1;
        if (this._indexes == null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
        } else {
            int n4;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n4 = tableModelEvent.getFirstRow(); n4 <= tableModelEvent.getLastRow(); ++n4) {
                arrayList.add(this.getVisualRowAt(n4));
            }
            n4 = Integer.MAX_VALUE;
            for (Integer n5 : arrayList) {
                if (n5 >= n4) continue;
                n4 = n5;
            }
            boolean bl = true;
            int n6 = n4 + tableModelEvent.getLastRow() - tableModelEvent.getFirstRow();
            if (n4 < 0) {
                bl = false;
            } else {
                for (Integer object : arrayList) {
                    if (object >= n4 && object <= n6) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                void var11_16;
                Object object = new int[this._indexes.length - n3];
                if (n4 > 0) {
                    System.arraycopy(this._indexes, 0, object, 0, n4);
                }
                if (n4 < ((Object)object).length) {
                    System.arraycopy(this._indexes, n6 + 1, object, n4, ((Object)object).length - n4);
                }
                boolean i = false;
                while (var11_16 < ((Object)object).length) {
                    if (object[var11_16] > n2) {
                        Object object2 = object;
                        void v1 = var11_16;
                        object2[v1] = object2[v1] - n3;
                    }
                    ++var11_16;
                }
                this.setIndexes((int[])object);
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n6, -1, -1));
            } else {
                int n8 = 0;
                int[] nArray = new int[this._indexes.length - n3];
                for (int i = 0; i < this._indexes.length; ++i) {
                    if (this._indexes[i] < n) {
                        nArray[i - n8] = this._indexes[i];
                        continue;
                    }
                    if (this._indexes[i] > n2) {
                        nArray[i - n8] = this._indexes[i] - n3;
                        continue;
                    }
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, i, i, -1, -1));
                    ++n8;
                }
                this.setIndexes(nArray);
            }
        }
    }

    private void internalTableRowsOrCellsUpdatedSortingPaused(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n = this.getRowCount();
        for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
            int n2 = TableModelWrapperUtils.getRowAt(this, this._model, tableModelEvent.getFirstRow());
            if (n2 < 0 || n2 >= n) continue;
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n2, tableModelEvent.getColumn(), 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rowOrCellUpdatedSorting(CompoundTableModelEvent compoundTableModelEvent, TableModelEvent tableModelEvent) {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
            int n3;
            n = this.getSortedRowAt(n2);
            if (n == -1 || !this.isInSortRanges(n)) continue;
            if (n < this.getRowCount() - 1 && this.isInSortRanges(n + 1) && (n3 = this.compare(n2, this.getActualRowAt(n + 1))) > 0) {
                bl = true;
                break;
            }
            if (n <= 0 || !this.isInSortRanges(n - 1) || (n3 = this.compare(this.getActualRowAt(n - 1), n2)) <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n2 = tableModelEvent.getFirstRow(); n2 <= tableModelEvent.getLastRow(); ++n2) {
                n = this.getSortedRowAt(n2);
                if (n == -1) continue;
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n, tableModelEvent.getColumn(), tableModelEvent.getType()));
            }
        } else {
            n2 = this.isCacheEnabled() ? 1 : 0;
            this.setCacheEnabled(false);
            try {
                for (n = tableModelEvent.getFirstRow(); n <= tableModelEvent.getLastRow(); ++n) {
                    this.sortRowAt(compoundTableModelEvent, n, tableModelEvent.getColumn());
                }
            }
            finally {
                this.setCacheEnabled(n2 != 0);
            }
        }
        return bl;
    }

    protected boolean shouldOptimize(int n, int n2) {
        int n3 = n2 - n;
        return n3 == 1;
    }

    protected boolean isInSortRanges(int n) {
        int[] nArray = this.getSortRanges();
        if (nArray.length % 2 == 1) {
            throw new IllegalArgumentException("The sort range array must have even length");
        }
        for (int i = 0; i < nArray.length; i += 2) {
            int n2 = nArray[i];
            int n3 = nArray[i + 1];
            if (n < n2 || n >= n3) continue;
            return true;
        }
        return false;
    }

    private void sortRowAt(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        int n3;
        int n4 = this.getSortedRowAt(n);
        if (n4 == -1) {
            return;
        }
        if (!this.isInSortRanges(n4)) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, -1, 0));
            return;
        }
        boolean bl = false;
        if (n4 < this.getRowCount() - 1 && this.isInSortRanges(n4 + 1) && (n3 = this.compare(n, this.getActualRowAt(n4 + 1))) > 0) {
            bl = true;
        }
        if (n4 > 0 && this.isInSortRanges(n4 - 1) && (n3 = this.compare(this.getActualRowAt(n4 - 1), n)) > 0) {
            bl = true;
        }
        if (bl) {
            this.remove(n);
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, -1, -1));
            if (this._indexes != null) {
                for (n3 = 0; n3 < this._indexes.length; ++n3) {
                    int n5 = this._indexes[n3];
                    if (n5 < n) continue;
                    this._indexes[n3] = n5 + 1;
                }
                n4 = this.insert(n);
            } else {
                n4 = n;
            }
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, -1, 1));
        } else if (n2 != -1) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, n2));
        } else {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n4, -1, 0));
        }
    }

    protected void sort() {
        this.reallocateIndexes();
        if (this._indexes != null) {
            this.cacheComparators();
            int[] nArray = this.getSortRanges();
            if (nArray.length % 2 == 1) {
                throw new IllegalArgumentException("The sort range array must have even length");
            }
            for (int i = 0; i < nArray.length; i += 2) {
                int n = nArray[i];
                int n2 = nArray[i + 1];
                this.sort((int[])this._indexes.clone(), this._indexes, n, n2);
            }
        }
    }

    protected int[] getSortRanges() {
        int[] nArray;
        if (this._indexes == null) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = this._indexes.length;
        }
        return nArray;
    }

    private void remove(int n) {
        if (this._indexes == null) {
            return;
        }
        int n2 = this.getSortedRowAt(n);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n2);
        System.arraycopy(nArray, n2 + 1, this._indexes, n2, this._indexes.length - n2);
        for (int i = 0; i < this._indexes.length; ++i) {
            int n3 = this._indexes[i];
            if (n3 <= n) continue;
            this._indexes[i] = n3 - 1;
        }
    }

    protected int insert(int n) {
        int n2 = this.search(this._indexes, n);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n2);
        this._indexes[n2] = n;
        System.arraycopy(nArray, n2, this._indexes, n2 + 1, this._indexes.length - n2 - 1);
        return n2;
    }

    protected int[] append(int n, int n2) {
        if (this._indexes == null) {
            return new int[]{n, n2};
        }
        int n3 = n2 - n + 1;
        for (int i = 0; i < this._indexes.length; ++i) {
            int n4 = this._indexes[i];
            if (n4 < n) continue;
            this._indexes[i] = n4 + n3;
        }
        int[] nArray = new int[2];
        int[] nArray2 = (int[])this._indexes.clone();
        this._indexes = new int[nArray2.length + n3];
        if ("true".equals(SecurityUtils.getProperty("jide.sortableTableModel.append", "true"))) {
            System.arraycopy(nArray2, 0, this._indexes, 0, nArray2.length);
            for (int i = 0; i < n3; ++i) {
                this._indexes[nArray2.length + i] = n + i;
            }
            nArray[0] = nArray2.length;
            nArray[1] = nArray2.length + n3 - 1;
        } else {
            for (int i = 0; i < n3; ++i) {
                this._indexes[i] = n + i;
            }
            System.arraycopy(nArray2, 0, this._indexes, n3, nArray2.length);
            nArray[0] = 0;
            nArray[1] = n3 - 1;
        }
        return nArray;
    }

    protected int search(int[] nArray, int n) {
        return this.binarySearch(nArray, n);
    }

    private int binarySearch(int[] nArray, int n) {
        int n2;
        int[] nArray2 = this.getSortRanges();
        if (nArray2.length % 2 == 1) {
            throw new IllegalArgumentException("The sort range array must have even length");
        }
        int n3 = nArray2[0];
        int n4 = n2 = nArray2[1] - 1;
        boolean bl = false;
        while (n3 <= n2) {
            int n5 = n3 + n2 >> 1;
            int n6 = this.compare(nArray[n5], n);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 - 1;
                continue;
            }
            n4 = n5;
            bl = true;
            break;
        }
        if (!bl) {
            n4 = n3;
        }
        return n4;
    }

    protected void sort(int[] nArray, int[] nArray2, int n, int n2) {
        this.shuttleSort(nArray, nArray2, n, n2);
    }

    protected void cacheComparators() {
        this._masterSortColumns = this.getMasterSortColumns();
        this._sortingColumns = this.getSortingColumns();
        this._cachedComparators = new Comparator[this.getColumnCount()];
        for (ISortableTableModel.SortItem sortItem : this.getSortingColumns()) {
            int n = sortItem.getColumn();
            if (n < 0 || n >= this.getColumnCount()) continue;
            Comparator comparator = this.getComparator(n);
            if (comparator == null) {
                this._cachedComparators[n] = ObjectComparatorManager.getComparator(String.class);
                continue;
            }
            this._cachedComparators[n] = comparator;
        }
    }

    @Override
    public int[] getMasterSortColumns() {
        return this._sortItemSupport.getMasterSortColumns();
    }

    @Override
    public void setMasterSortColumns(int[] nArray) {
        this._sortItemSupport.setMasterSortColumns(nArray);
    }

    public int getMasterSortColumnIndex(int n) {
        return this.getMasterSortColumnIndex(n, this.getMasterSortColumns());
    }

    private int getMasterSortColumnIndex(int n, int[] nArray) {
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 != n) continue;
                return i;
            }
        }
        return -1;
    }

    protected int compare(int n, int n2) {
        if (this._sortingColumns != null) {
            for (ISortableTableModel.SortItem sortItem : this._sortingColumns) {
                int n3;
                int n4 = sortItem.getColumn();
                if (this._masterSortColumns != null) {
                    n3 = this.getMasterSortColumnIndex(n4, this._masterSortColumns);
                    for (int i = 0; i < this._masterSortColumns.length && i != n3; ++i) {
                        int n5 = this._masterSortColumns[i];
                        int n6 = this.compare(n, n2, n5);
                        if (n6 == 0) continue;
                        return n > n2 ? 1 : -1;
                    }
                }
                if ((n3 = this.compare(n, n2, n4)) == 0) continue;
                if (n3 == Integer.MAX_VALUE || n3 == Integer.MIN_VALUE) {
                    return n3;
                }
                return sortItem.isAscending() ? n3 : -n3;
            }
        }
        return 0;
    }

    private void shuttleSort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttleSort(nArray2, nArray, n, n3);
        this.shuttleSort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n2 - n);
            return;
        }
        for (int i = n; i < n2; ++i) {
            if (n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0) {
                nArray2[i] = nArray[n4];
                ++n4;
                continue;
            }
            nArray2[i] = nArray[n5];
            ++n5;
        }
    }

    public int compare(int n, int n2, int n3) {
        Object object = this._model.getValueAt(n, n3);
        Object object2 = this._model.getValueAt(n2, n3);
        return this.compare(object, object2, n3);
    }

    protected int compare(Object object, Object object2, int n) {
        try {
            if (this.isAlwaysUseComparators() && this._cachedComparators != null && n < this._cachedComparators.length && this._cachedComparators[n] != null) {
                return this._cachedComparators[n].compare(object, object2);
            }
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareToIgnoreCase((String)object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                return ((Comparable)object).compareTo(object2);
            }
            if (object instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
                return -((Comparable)object2).compareTo(object);
            }
            if (this._cachedComparators != null && n < this._cachedComparators.length && this._cachedComparators[n] != null) {
                return this._cachedComparators[n].compare(object, object2);
            }
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("SortableTableModel \" no way to compare between " + object + " and " + object2 + " at column " + n + ".");
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected Comparator getComparator(int n) {
        return ObjectComparatorManager.getComparator(this.getColumnClass(n), this.getColumnComparatorContext(n));
    }

    public ComparatorContext getColumnComparatorContext(int n) {
        ColumnComparatorContextProvider columnComparatorContextProvider = this.getColumnComparatorContextProvider();
        if (columnComparatorContextProvider == null) {
            return null;
        }
        return columnComparatorContextProvider.getColumnComparatorContext(this, n);
    }

    public boolean isResetOnTableStructureChangeEvent() {
        return this._resetOnTableStructureChangeEvent;
    }

    public void setResetOnTableStructureChangeEvent(boolean bl) {
        this._resetOnTableStructureChangeEvent = bl;
    }

    @Override
    public void fireTableStructureChanged() {
        if (this.isResetOnTableStructureChangeEvent()) {
            this._sortItemSupport.reset();
        }
        super.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (this.isResetOnTableStructureChangeEvent() && (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0)) {
            this._sortItemSupport.reset();
        }
        super.fireTableChanged(tableModelEvent);
    }

    public ColumnComparatorContextProvider getColumnComparatorContextProvider() {
        return this._columnComparatorContextProvider;
    }

    public void setColumnComparatorContextProvider(ColumnComparatorContextProvider columnComparatorContextProvider) {
        this._columnComparatorContextProvider = columnComparatorContextProvider;
        if (this._columnComparatorContextProvider != null) {
            this.setAlwaysUseComparators(true);
        }
    }

    @Override
    public synchronized void setIndexes(int[] nArray) {
        this.getSortingColumns().clear();
        super.setIndexes(nArray);
    }

    public JMenuItem[] getPopupMenuItems(final int n) {
        ResourceBundle resourceBundle = GridResource.getResourceBundle(Locale.getDefault());
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(new AbstractAction(resourceBundle.getString("Sort.ascending")){
            private static final long serialVersionUID = 2530096572929787133L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SortableTableModel.this.isColumnAscending(n)) {
                    SortableTableModel.this.sortColumn(n, true, true);
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setAction(new AbstractAction(resourceBundle.getString("Sort.descending")){
            private static final long serialVersionUID = 2434345236380501634L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SortableTableModel.this.isColumnAscending(n)) {
                    SortableTableModel.this.reverseColumnSortOrder(n);
                } else if (!SortableTableModel.this.isColumnSorted(n)) {
                    SortableTableModel.this.sortColumn(n, true, true);
                    SortableTableModel.this.reverseColumnSortOrder(n);
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setAction(new AbstractAction(resourceBundle.getString("Sort.unsort")){
            private static final long serialVersionUID = 5959338348674285285L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SortableTableModel.this.unsortColumn(n);
            }
        });
        return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3};
    }

    public static ISortableTableModel getSortableModel(TableModel tableModel) {
        while (true) {
            if (tableModel instanceof ISortableTableModel) {
                return (ISortableTableModel)tableModel;
            }
            if (tableModel instanceof TableModelWrapper) {
                tableModel = ((TableModelWrapper)((Object)tableModel)).getActualModel();
                continue;
            }
            if (!(tableModel instanceof TableModelsWrapper)) break;
            tableModel = ((TableModelsWrapper)((Object)tableModel)).getActualModel(0, 0);
        }
        return null;
    }

    public boolean isOptimized() {
        return this._optimized;
    }

    public void setOptimized(boolean bl) {
        this._optimized = bl;
    }

    public boolean isAutoResort() {
        return this._autoResort;
    }

    public void setAutoResort(boolean bl) {
        this._autoResort = bl;
    }

    @Override
    public void sortColumn(int n) {
        if (this._sortItemSupport.sortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl) {
        if (this._sortItemSupport.sortColumn(n, bl)) {
            this.resort();
        }
    }

    @Override
    public void unsortColumn(int n) {
        if (this._sortItemSupport.unsortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void reverseColumnSortOrder(int n) {
        if (this._sortItemSupport.reverseColumnSortOrder(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl, boolean bl2) {
        if (this._sortItemSupport.sortColumn(n, bl, bl2)) {
            this.resort();
        }
    }

    @Override
    public boolean isColumnSorted(int n) {
        return this._sortItemSupport.isColumnSorted(n);
    }

    @Override
    public boolean isColumnAscending(int n) {
        return this._sortItemSupport.isColumnAscending(n);
    }

    @Override
    public void reset() {
        if (this._sortItemSupport.reset()) {
            this.resort();
        }
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return this._sortItemSupport.getSortingColumns();
    }

    @Override
    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        if ((list == null || list.size() == 0) && this.getSortingColumns().size() == 0) {
            return;
        }
        this._sortItemSupport.setSortingColumns(list);
        this.resort();
    }

    @Override
    public int getColumnSortRank(int n) {
        return this._sortItemSupport.getColumnSortRank(n);
    }

    @Override
    public boolean isMultiColumnSortable() {
        return this._sortItemSupport.isMultiColumnSortable();
    }

    @Override
    public void setMultiColumnSortable(boolean bl) {
        this._sortItemSupport.setMultiColumnSortable(bl);
    }

    @Override
    public boolean isColumnSortable(int n) {
        if (this.getActualModel().getColumnCount() == 0) {
            return false;
        }
        if (!this.isSortable()) {
            return false;
        }
        if (n >= 0 && n < this.getActualModel().getColumnCount()) {
            this.initColumnsSortable();
            return this._columnsSortable[n];
        }
        return false;
    }

    @Override
    public void setColumnSortable(int n, boolean bl) {
        if (n >= 0 && n < this.getActualModel().getColumnCount()) {
            this.initColumnsSortable();
            this._columnsSortable[n] = bl;
        }
    }

    private void initColumnsSortable() {
        if (this._columnsSortable == null || this._columnsSortable.length != this.getActualModel().getColumnCount()) {
            this._columnsSortable = new boolean[this.getActualModel().getColumnCount()];
            Arrays.fill(this._columnsSortable, true);
        }
    }

    @Override
    public boolean isSortable() {
        return this._sortable;
    }

    @Override
    public void setSortable(boolean bl) {
        this._sortable = bl;
    }

    @Override
    public void resort() {
        this.fireSortingEvent();
        int n = this.fireIndexChanging();
        try {
            List<ISortableTableModel.SortItem> list = this.getSortingColumns();
            if (list != null && list.size() > 0) {
                this.sort();
            } else {
                this.setIndexes(null);
            }
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
        this.fireSortEvent();
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, SortListener.class, (EventListener)sortListener)) {
            this.listenerList.add(SortListener.class, sortListener);
        }
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    @Override
    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanged(sortEvent);
        }
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanging(sortEvent);
        }
    }

    @Override
    public int getSortPriority() {
        return this._sortItemSupport.getSortPriority();
    }

    @Override
    public void setSortPriority(int n) {
        this._sortItemSupport.setSortPriority(n);
    }

    @Override
    public int getMaximumSortColumns() {
        return this._sortItemSupport.getMaximumSortColumns();
    }

    @Override
    public void setMaximumSortColumns(int n) {
        this._sortItemSupport.setMaximumSortColumns(n);
    }

    public SortOrderHandler getSortOrderHandler() {
        if (this._sortItemSupport != null && this._sortItemSupport.getSortOrderHandler() instanceof SortOrderHandler) {
            return (SortOrderHandler)this._sortItemSupport.getSortOrderHandler();
        }
        return null;
    }

    public void setSortOrderHandler(SortOrderHandler sortOrderHandler) {
        if (this._sortItemSupport != null) {
            this._sortItemSupport.setSortOrderHandler(sortOrderHandler);
        }
    }

    @Override
    public void toggleSortOrder(int n, boolean bl) {
        boolean bl2 = this.isSortingPaused();
        if (bl2) {
            this.setSortingPaused(false);
        }
        if (!this.isColumnSortable(n)) {
            return;
        }
        if (this instanceof SortableTreeTableModel && ((SortableTreeTableModel)this).getSortableOption(n) == 0) {
            return;
        }
        boolean bl3 = this.getSortingColumns().size() == 1 && this.getSortingColumns().get(0).getColumn() == n;
        boolean bl4 = bl3 && this.getSortingColumns().get(0).isAscending();
        this._sortItemSupport.toggleSortOrder(n, bl);
        if (this.shouldReverseIndices(n, bl3, bl4)) {
            this.reverseIndices();
        } else {
            this.resort();
        }
        if (bl2) {
            this.setSortingPaused(true);
        }
    }

    protected boolean shouldReverseIndices(int n, boolean bl, boolean bl2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reverseIndices() {
        if (this._indexes == null) {
            return;
        }
        this.fireSortingEvent();
        int n = this.fireIndexChanging();
        try {
            for (int i = this._indexes.length / 2 - 1; i >= 0; --i) {
                int n2 = this._indexes[i];
                this._indexes[i] = this._indexes[this._indexes.length - 1 - i];
                this._indexes[this._indexes.length - 1 - i] = n2;
            }
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
        this.fireSortEvent();
    }

    public boolean isAlwaysUseComparators() {
        return this._alwaysUseComparators;
    }

    public void setAlwaysUseComparators(boolean bl) {
        this._alwaysUseComparators = bl;
    }

    public void setSortingPaused(boolean bl) {
        this._sortingPaused = bl;
    }

    public boolean isSortingPaused() {
        return this._sortingPaused;
    }

    private class TableModelEventHandleResult {
        boolean _needFireSortEvent;
        boolean _needDisableCache;

        private TableModelEventHandleResult() {
        }
    }

    public static interface SortOrderHandler
    extends SortItemSupport.SortOrderHandler {
    }

    public static interface ColumnComparatorContextProvider {
        public ComparatorContext getColumnComparatorContext(SortableTableModel var1, int var2);
    }
}

