/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ISortableTableModel;
import java.util.ArrayList;
import java.util.List;

public class SortItemSupport {
    protected List<ISortableTableModel.SortItem> _sortingColumns = new ArrayList<ISortableTableModel.SortItem>();
    private int _maximumSortColumns = -1;
    private int _sortPriority = 0;
    private boolean _multiColumnSortable = true;
    private boolean _sortable = true;
    private int[] _masterSortColumns;
    private SortOrderHandler _sortOrderHandler;

    public int[] getMasterSortColumns() {
        return this._masterSortColumns;
    }

    public void setMasterSortColumns(int[] nArray) {
        this._masterSortColumns = nArray;
    }

    public int getMasterSortColumnIndex(int n) {
        int[] nArray = this.getMasterSortColumns();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 != n) continue;
                return i;
            }
        }
        return -1;
    }

    ISortableTableModel.SortItem getSortItemForColumn(int n) {
        for (ISortableTableModel.SortItem sortItem : this._sortingColumns) {
            if (sortItem.getColumn() != n) continue;
            return sortItem;
        }
        return null;
    }

    protected void addSortItem(ISortableTableModel.SortItem sortItem) {
        if (this.getMaximumSortColumns() == -1 || this._sortingColumns.size() < this.getMaximumSortColumns()) {
            if (this.getSortPriority() == 1) {
                this._sortingColumns.add(0, sortItem);
            } else if (this.getSortPriority() == 0) {
                this._sortingColumns.add(sortItem);
            }
        } else if (this.getSortPriority() == 1) {
            this._sortingColumns.add(0, sortItem);
            this._sortingColumns.remove(this.getMaximumSortColumns());
        }
    }

    public boolean sortColumn(int n) {
        return this.sortColumn(n, false, true);
    }

    public boolean sortColumn(int n, boolean bl) {
        return this.sortColumn(n, bl, true);
    }

    public boolean unsortColumn(int n) {
        ISortableTableModel.SortItem sortItem = this.getSortItemForColumn(n);
        if (sortItem != null) {
            this._sortingColumns.remove(sortItem);
            return true;
        }
        return false;
    }

    public boolean reverseColumnSortOrder(int n) {
        ISortableTableModel.SortItem sortItem = this.getSortItemForColumn(n);
        if (sortItem != null) {
            sortItem.reverse();
            return true;
        }
        return false;
    }

    public boolean sortColumn(int n, boolean bl, boolean bl2) {
        ISortableTableModel.SortItem sortItem;
        if (bl) {
            this._sortingColumns.clear();
        }
        if ((sortItem = this.getSortItemForColumn(n)) != null) {
            if (sortItem.ascending != bl2) {
                sortItem.ascending = bl2;
                return true;
            }
            return false;
        }
        ISortableTableModel.SortItem sortItem2 = new ISortableTableModel.SortItem(n);
        sortItem2.ascending = bl2;
        this.addSortItem(sortItem2);
        return true;
    }

    public boolean isColumnSorted(int n) {
        return this.getSortItemForColumn(n) != null;
    }

    public boolean isColumnAscending(int n) {
        ISortableTableModel.SortItem sortItem = this.getSortItemForColumn(n);
        return sortItem != null && sortItem.isAscending();
    }

    public boolean reset() {
        if (!this.isEmpty()) {
            this._sortingColumns.clear();
            return true;
        }
        return false;
    }

    protected boolean isEmpty() {
        return this._sortingColumns == null || this._sortingColumns.size() == 0;
    }

    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return new ArrayList<ISortableTableModel.SortItem>(this._sortingColumns);
    }

    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        this._sortingColumns = list;
    }

    public int getColumnSortRank(int n) {
        for (int i = 0; i < this._sortingColumns.size(); ++i) {
            ISortableTableModel.SortItem sortItem = this._sortingColumns.get(i);
            if (sortItem.getColumn() != n) continue;
            return i;
        }
        return -1;
    }

    public boolean isMultiColumnSortable() {
        return this._multiColumnSortable;
    }

    public void setMultiColumnSortable(boolean bl) {
        boolean bl2 = this._multiColumnSortable;
        if (bl2 == bl) {
            return;
        }
        this._multiColumnSortable = bl;
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setSortable(boolean bl) {
        this._sortable = bl;
    }

    public int getSortPriority() {
        return this._sortPriority;
    }

    public void setSortPriority(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("sortPriority must be one the following value: SORT_PRIORITY_FILO (the default), or SORT_PRIORITY_FIFO");
        }
        this._sortPriority = n;
    }

    public int getMaximumSortColumns() {
        return this._maximumSortColumns;
    }

    public void setMaximumSortColumns(int n) {
        this._maximumSortColumns = n;
    }

    public SortOrderHandler getSortOrderHandler() {
        return this._sortOrderHandler;
    }

    public void setSortOrderHandler(SortOrderHandler sortOrderHandler) {
        this._sortOrderHandler = sortOrderHandler;
    }

    public void toggleSortOrder(int n, boolean bl) {
        SortOrderHandler sortOrderHandler = this.getSortOrderHandler();
        if (sortOrderHandler != null) {
            sortOrderHandler.toggleSortOrder(n, bl);
        } else if (this.isMultiColumnSortable() && bl) {
            if (!this.isColumnSorted(n)) {
                this.sortColumn(n, false, true);
            } else if (this.isColumnAscending(n)) {
                this.reverseColumnSortOrder(n);
            } else {
                this.unsortColumn(n);
            }
        } else if (!this.isColumnSorted(n)) {
            this.sortColumn(n, true, true);
        } else if (this.isColumnAscending(n)) {
            this.reverseColumnSortOrder(n);
        } else {
            this.reset();
        }
    }

    public static interface SortOrderHandler {
        public void toggleSortOrder(int var1, boolean var2);
    }
}

