/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.grid.AbstractTableFilter;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.swing.JideSwingUtilities;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Locale;

public class SingleValueFilter<T>
extends AbstractTableFilter<T>
implements SqlFilterSupport {
    private static final long serialVersionUID = -2966264431623894768L;
    private T _value = null;
    private boolean _splitArrayOrCollection = false;

    public SingleValueFilter() {
    }

    public SingleValueFilter(T t) {
        this._value = t;
    }

    public SingleValueFilter(String string, T t) {
        super(string);
        this._value = t;
    }

    @Override
    public boolean isValueFiltered(T t) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            return !JideSwingUtilities.equals(this._value, objectGrouper.getValue(t));
        }
        if (this.isSplitArrayOrCollection() && t != null && t.getClass().isArray()) {
            int n = Array.getLength(t);
            for (int i = 0; i < n; ++i) {
                Object object = Array.get(t, i);
                if (!JideSwingUtilities.equals(this._value, object)) continue;
                return false;
            }
            return true;
        }
        if (this.isSplitArrayOrCollection() && t instanceof Collection) {
            for (Object e : (Collection)t) {
                if (!JideSwingUtilities.equals(this._value, e)) continue;
                return false;
            }
            return true;
        }
        return !JideSwingUtilities.equals(this._value, t);
    }

    public T getValue() {
        return this._value;
    }

    public void setValue(T t) {
        this._value = t;
    }

    @Override
    public String getName() {
        String string = super.getName();
        return string != null ? string : "" + this.getValue();
    }

    @Override
    public boolean stricterThan(Filter filter) {
        return this.getClass() == filter.getClass() && JideSwingUtilities.equals(this.getObjectGrouper(), ((SingleValueFilter)filter).getObjectGrouper()) && JideSwingUtilities.equals(this.getValue(), ((SingleValueFilter)filter).getValue());
    }

    @Override
    public String getOperator() {
        return "=";
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        String string;
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            clazz = objectGrouper.getType();
            converterContext = objectGrouper.getConverterContext();
        }
        String string2 = string = this.getValue() == null ? GridResource.getResourceBundle(Locale.getDefault()).getString("Filter.null") : ObjectConverterManager.toString(this.getValue(), clazz, converterContext);
        if (objectGrouper != null) {
            string = string + '\t' + objectGrouper.getName();
        }
        return string;
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        String[] stringArray = string.split("\t");
        if (GridResource.getResourceBundle(Locale.getDefault()).getString("Filter.null").equals(stringArray[0])) {
            this.setValue(null);
        } else {
            this.setValue(ObjectConverterManager.fromString(stringArray[0], clazz, converterContext));
        }
        if (stringArray.length >= 2) {
            this.setObjectGrouperName(stringArray[1]);
        }
        return new Object[]{this.getValue()};
    }

    public boolean isSplitArrayOrCollection() {
        return this._splitArrayOrCollection;
    }

    public void setSplitArrayOrCollection(boolean bl) {
        this._splitArrayOrCollection = bl;
    }
}

