/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.RowHeightChangeEvent;
import com.jidesoft.grid.RowHeightChangeListener;
import javax.swing.SizeSequence;
import javax.swing.event.EventListenerList;

public class RowHeights {
    protected EventListenerList listenerList = new EventListenerList();
    protected SizeSequence _sizeSequence = new SizeSequence();
    protected int _rowCount = 0;
    private boolean _fireEvent = true;

    public RowHeights() {
    }

    public RowHeights(int n) {
        this(n, 0);
    }

    public RowHeights(int n, int n2) {
        this();
        this.insertRows(0, n, n2);
    }

    public RowHeights(int[] nArray) {
        this();
        this.setRowHeights(nArray);
    }

    public void setRowHeights(int[] nArray) {
        this._sizeSequence.setSizes(nArray);
        this.fireRowHeightChanged(new RowHeightChangeEvent(this));
    }

    public int[] getRowHeights() {
        return this._sizeSequence.getSizes();
    }

    public int getRowPosition(int n) {
        return this._sizeSequence.getPosition(n);
    }

    public int getRowIndex(int n) {
        return this._sizeSequence.getIndex(n);
    }

    public int getRowHeight(int n) {
        return this._sizeSequence.getSize(n);
    }

    public void setRowHeight(int n, int n2) {
        this._sizeSequence.setSize(n, n2);
        if (this.isFireEvent()) {
            this.fireRowHeightChanged(new RowHeightChangeEvent(this, n));
        }
    }

    public void insertRows(int n, int n2, int n3) {
        this._rowCount += n2;
        this._sizeSequence.insertEntries(n, n2, n3);
        this.fireRowHeightChanged(new RowHeightChangeEvent(this, n, n + n2 - 1, 1));
    }

    public void removeRows(int n, int n2) {
        if (n >= 0 && n < this._sizeSequence.getSizes().length) {
            n2 = Math.min(n2, this._sizeSequence.getSizes().length - n);
            this._rowCount -= n2;
            this._sizeSequence.removeEntries(n, n2);
            this.fireRowHeightChanged(new RowHeightChangeEvent(this, n, n + n2 - 1, -1));
        }
    }

    public void addRowHeightChangeListener(RowHeightChangeListener rowHeightChangeListener) {
        this.listenerList.add(RowHeightChangeListener.class, rowHeightChangeListener);
    }

    public void removeRowHeightChangeListener(RowHeightChangeListener rowHeightChangeListener) {
        this.listenerList.remove(RowHeightChangeListener.class, rowHeightChangeListener);
    }

    public RowHeightChangeListener[] getRowHeightChangeListeners() {
        return (RowHeightChangeListener[])this.listenerList.getListeners(RowHeightChangeListener.class);
    }

    public void fireRowHeightChanged(RowHeightChangeEvent rowHeightChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RowHeightChangeListener.class) continue;
            ((RowHeightChangeListener)objectArray[i + 1]).rowHeightChanged(rowHeightChangeEvent);
        }
    }

    boolean isFireEvent() {
        return this._fireEvent;
    }

    void setFireEvent(boolean bl) {
        this._fireEvent = bl;
    }

    int getRowCount() {
        return this._rowCount;
    }
}

