/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class PropertyPane
extends JPanel
implements ListSelectionListener {
    private boolean _showToolBar = true;
    private boolean _showDescription = true;
    public final String ACTION_CATEGORIED_VIEW = "CATEGORIED";
    public final String ACTION_ALPHEBETIC_VIEW = "ALPHEBETIC";
    public final String ACTION_TOGGLE_DESCRIPTION = "DESCRIPTION";
    public final String ACTION_EXPAND = "EXPAND";
    public final String ACTION_COLLAPSE = "COLLAPSE";
    private Action _alpheticViewAction;
    private Action _categoricViewAction;
    private Action _descriptionAction;
    private Action _expandAction;
    private Action _collapseAction;
    private JComponent _descriptionArea;
    protected JLabel _nameLabel;
    protected JComponent _descriptionPanel;
    private JComponent _toolBar;
    private PropertyTable _propertyTable;
    private JideButton _alpheticViewButton;
    private JideButton _categoricViewButton;
    private JideButton _descriptionViewButton;
    private Color _borderColor;
    private int _visibleButtons;
    public static final int BUTTONS_SORT = 1;
    public static final int BUTTONS_DESCRIPTION = 2;
    public static final int BUTTONS_EXPAND_COLLAPSE = 4;
    public static final int BUTTONS_ALL = -1;
    private int _order = 0;
    private TableModelListener _tableModelListener;
    private JScrollPane _scrollPane;

    public PropertyPane() {
        this(new PropertyTable());
    }

    public PropertyPane(PropertyTable propertyTable) {
        this(propertyTable, -1);
    }

    public PropertyPane(PropertyTable propertyTable, int n) {
        this._visibleButtons = n;
        this._propertyTable = propertyTable;
        this._propertyTable.getSelectionModel().addListSelectionListener(this);
        this._propertyTable.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.initAction();
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        if (this._visibleButtons != 0) {
            this._toolBar = this.createToolBar();
            jPanel.add((Component)this._toolBar, "First");
        }
        this._descriptionPanel = this.createDescriptionPanel();
        this.updateOrderFromTableModel();
        this._propertyTable.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyPane.this.updateOrderFromTableModel();
                PropertyPane.this.addModelListener();
            }
        });
        this._tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == -1) {
                    PropertyPane.this.updateOrderFromTableModel();
                }
            }
        };
        this.addModelListener();
        jPanel.add(this.createPropertyTablePanel(this._propertyTable), "Center");
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        ((JideBoxLayout)jideSplitPane.getLayout()).setResetWhenInvalidate(true);
        jideSplitPane.add((Component)jPanel, "vary");
        jideSplitPane.add((Component)this._descriptionPanel, "flexible");
        this.setLayout(new BorderLayout());
        this.add((Component)jideSplitPane, "Center");
        this.setMinimumSize(new Dimension(100, 20));
    }

    protected Component createPropertyTablePanel(PropertyTable propertyTable) {
        this._scrollPane = new JScrollPane(20, 31);
        this._scrollPane.setViewportView(propertyTable);
        this._scrollPane.getViewport().setBackground(propertyTable.getBackground());
        this._scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getBorderColor()), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        return this._scrollPane;
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void setViewportBackground(Color color) {
        if (this._scrollPane != null) {
            this._scrollPane.setBackground(color);
        }
    }

    private void addModelListener() {
        if (this._propertyTable.getModel() != null) {
            this._propertyTable.getModel().addTableModelListener(this._tableModelListener);
        }
    }

    private void updateOrderFromTableModel() {
        PropertyTableModel propertyTableModel = this._propertyTable.getPropertyTableModel();
        if (propertyTableModel != null) {
            int n = propertyTableModel.getOrder();
            this.updateButtons(n);
        }
    }

    protected JComponent createToolBar() {
        JComponent jComponent = this.createToolBarComponent();
        if ((this._visibleButtons & 1) != 0) {
            this._categoricViewButton = this.createButton(this._categoricViewAction);
            this._categoricViewButton.getAccessibleContext().setAccessibleName(this.getResourceString("Pane.categorized"));
            this._categoricViewButton.setToolTipText(this.getResourceString("Pane.categorized"));
            jComponent.add(this._categoricViewButton);
            this._alpheticViewButton = this.createButton(this._alpheticViewAction);
            this._alpheticViewButton.getAccessibleContext().setAccessibleName(this.getResourceString("Pane.alphabetic"));
            this._alpheticViewButton.setToolTipText(this.getResourceString("Pane.alphabetic"));
            jComponent.add(this._alpheticViewButton);
            this._categoricViewButton.setSelected(true);
            this._alpheticViewButton.setSelected(false);
        }
        if ((this._visibleButtons & 2) != 0) {
            if (jComponent.getComponentCount() > 0) {
                this.addSeparator(jComponent);
            }
            this._descriptionViewButton = this.createButton(this._descriptionAction);
            this._descriptionViewButton.getAccessibleContext().setAccessibleName(this.getResourceString("Pane.showdescription"));
            this._descriptionViewButton.setToolTipText(this.getResourceString("Pane.showdescription"));
            jComponent.add(this._descriptionViewButton);
            this._descriptionViewButton.setSelected(this.isShowDescription());
        }
        if ((this._visibleButtons & 4) != 0) {
            if (jComponent.getComponentCount() > 0) {
                this.addSeparator(jComponent);
            }
            JideButton jideButton = this.createButton(this._expandAction);
            jideButton.getAccessibleContext().setAccessibleName(this.getResourceString("Pane.expand"));
            jideButton.setToolTipText(this.getResourceString("Pane.expand"));
            jComponent.add(jideButton);
            JideButton jideButton2 = this.createButton(this._collapseAction);
            jideButton2.getAccessibleContext().setAccessibleName(this.getResourceString("Pane.collapse"));
            jideButton2.setToolTipText(this.getResourceString("Pane.collapse"));
            jComponent.add(jideButton2);
        }
        return jComponent;
    }

    private void addSeparator(JComponent jComponent) {
        try {
            Method method = jComponent.getClass().getMethod("addSeparator", new Class[0]);
            method.invoke((Object)jComponent, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JComponent createToolBarComponent() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        return jToolBar;
    }

    protected JideButton createButton(Action action) {
        JideButton jideButton = new JideButton(action){

            @Override
            public void setBorder(Border border) {
                if (border instanceof UIResource) {
                    super.setBorder(border);
                }
            }
        };
        jideButton.setRequestFocusEnabled(false);
        return jideButton;
    }

    private void initAction() {
        this._alpheticViewAction = new AbstractAction("", this.getImageIcon("icons/sort.gif")){
            private static final long serialVersionUID = -2410611962951871474L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPane.this.setOrder(1);
            }
        };
        this._categoricViewAction = new AbstractAction("", this.getImageIcon("icons/category.gif")){
            private static final long serialVersionUID = -8740721883660803790L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPane.this.setOrder(0);
            }
        };
        this._descriptionAction = new AbstractAction("", this.getImageIcon("icons/description.gif")){
            private static final long serialVersionUID = -2776851897383527121L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyPane.this.setShowDescription(!PropertyPane.this.isShowDescription());
            }
        };
        this._expandAction = new AbstractAction("", this.getImageIcon("icons/expand.gif")){
            private static final long serialVersionUID = -7464679467051917753L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Property property = PropertyPane.this._propertyTable.getSelectedProperty();
                PropertyPane.this._propertyTable.clearSelection();
                if (PropertyPane.this._propertyTable.isEditing()) {
                    PropertyPane.this._propertyTable.getCellEditor().stopCellEditing();
                }
                PropertyPane.this._propertyTable.expandAll();
                PropertyPane.this._propertyTable.setSelectedProperty(property);
            }
        };
        this._collapseAction = new AbstractAction("", this.getImageIcon("icons/collapse.gif")){
            private static final long serialVersionUID = 8746366434740536113L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Property property = PropertyPane.this._propertyTable.getSelectedProperty();
                PropertyPane.this._propertyTable.clearSelection();
                if (PropertyPane.this._propertyTable.isEditing()) {
                    PropertyPane.this._propertyTable.getCellEditor().stopCellEditing();
                }
                PropertyPane.this._propertyTable.collapseAll();
                while (property != null) {
                    if (property.getParent() == null || property.getParent() instanceof RootExpandableRow) {
                        PropertyPane.this._propertyTable.setSelectedProperty(property);
                        break;
                    }
                    property = (Property)property.getParent();
                }
            }
        };
    }

    public Action getAction(String string) {
        if ("ALPHEBETIC".equals(string)) {
            return this._alpheticViewAction;
        }
        if ("CATEGORIED".equals(string)) {
            return this._categoricViewAction;
        }
        if ("DESCRIPTION".equals(string)) {
            return this._descriptionAction;
        }
        if ("EXPAND".equals(string)) {
            return this._expandAction;
        }
        if ("COLLAPSE".equals(string)) {
            return this._collapseAction;
        }
        return null;
    }

    protected JComponent createDescriptionPanel() {
        this._nameLabel = new JLabel();
        this._nameLabel.setFont(this.getFont().deriveFont(1));
        this._descriptionArea = this.createDescriptionArea();
        this.resetDescription();
        PortingUtils.removeFocus(this._nameLabel);
        PortingUtils.removeFocus(this._descriptionArea);
        return this.createDescriptionPanel(this._nameLabel, this._descriptionArea);
    }

    protected JComponent createDescriptionArea() {
        MultilineLabel multilineLabel = new MultilineLabel();
        multilineLabel.setRows(3);
        return multilineLabel;
    }

    protected void updateDescription(String string, String string2) {
        if (this._nameLabel != null) {
            this._nameLabel.setText(string);
        }
        if (this._descriptionArea instanceof JTextComponent) {
            ((JTextComponent)this._descriptionArea).setText(string2);
        }
    }

    protected void resetDescription() {
        this.updateDescription(this.getResourceString("Pane.name"), this.getResourceString("Pane.description"));
    }

    protected JPanel createDescriptionPanel(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.getBorderColor()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        jPanel.add((Component)jComponent, "First");
        JScrollPane jScrollPane = new JScrollPane(jComponent2);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Property property = this._propertyTable.getPropertyAt(this._propertyTable.getSelectedRow());
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (property != null) {
                this.updateDescription(property.getDisplayName(), property.getDescription());
            } else {
                this.resetDescription();
            }
        }
    }

    public Color getBorderColor() {
        if (this._borderColor != null) {
            return this._borderColor;
        }
        return UIDefaultsLookup.getColor("controlShadow");
    }

    public void setBorderColor(Color color) {
        this._borderColor = color;
    }

    public JComponent getToolBar() {
        return this._toolBar;
    }

    public boolean isShowToolBar() {
        return this._showToolBar;
    }

    public void setShowToolBar(boolean bl) {
        this._showToolBar = bl;
        this._toolBar.setVisible(this.isShowToolBar());
    }

    public boolean isShowDescription() {
        return this._showDescription;
    }

    public void setShowDescription(boolean bl) {
        this._showDescription = bl;
        this._descriptionPanel.setVisible(this.isShowDescription());
        if (this._descriptionViewButton != null) {
            this._descriptionViewButton.setSelected(this.isShowDescription());
        }
    }

    @Override
    public void setFont(Font font) {
        if (this._nameLabel != null) {
            this._nameLabel.setFont(this.getFont().deriveFont(1));
            this._nameLabel.updateUI();
        }
        if (this._descriptionArea != null) {
            this._descriptionArea.setFont(font);
        }
        super.setFont(font);
    }

    public PropertyTable getPropertyTable() {
        return this._propertyTable;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int n) {
        PropertyTableModel propertyTableModel;
        this._order = n;
        Property property = this._propertyTable.getSelectedProperty();
        this._propertyTable.clearSelection();
        if (this._propertyTable.isEditing()) {
            this._propertyTable.getCellEditor().stopCellEditing();
        }
        if ((propertyTableModel = this._propertyTable.getPropertyTableModel()) != null) {
            propertyTableModel.setOrder(this._order);
        }
        this._propertyTable.revalidate();
        this._propertyTable.repaint();
        this.updateButtons(n);
        this._propertyTable.setSelectedProperty(property);
    }

    private void updateButtons(int n) {
        if (this._categoricViewButton == null || this._alpheticViewButton == null) {
            return;
        }
        switch (n) {
            case 2: {
                this._categoricViewButton.setSelected(false);
                this._alpheticViewButton.setSelected(false);
                break;
            }
            case 1: {
                this._categoricViewButton.setSelected(false);
                this._alpheticViewButton.setSelected(true);
                break;
            }
            case 0: {
                this._categoricViewButton.setSelected(true);
                this._alpheticViewButton.setSelected(false);
            }
        }
    }

    protected ImageIcon getImageIcon(String string) {
        return GridIconsFactory.getImageIcon(string);
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(PropertyPane.class.getName(), 4);
        }
    }
}

