/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorContextSupport;
import com.jidesoft.grid.EditorStyleSupport;
import com.jidesoft.grid.ExpandableCell;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.swing.JideSwingUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class Property
extends DefaultExpandableRow
implements ExpandableCell,
ConverterContextSupport,
EditorContextSupport,
EditorStyleSupport,
Comparable<Property>,
Serializable {
    protected String _name;
    protected String _displayName;
    protected String _focusDisplayName;
    protected String _description;
    protected Class<?> _type;
    protected ConverterContext _converterContext;
    protected EditorContext _editorContext;
    private int _editorStyle = 0;
    protected String _category;
    protected boolean _isCategoryRow;
    protected boolean _expert = false;
    protected boolean _hidden = false;
    protected boolean _preferred = false;
    protected boolean _required = false;
    protected boolean _editable = true;
    protected ObjectConverter _converter;
    private List<String> _dependingProperties;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_FOCUS_DISPLAY_NAME = "focusDisplayName";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_DEPENDING_PROPERTIES = "dependingProperties";
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_CONVERTER_CONTEXT = "converterContext";
    public static final String PROPERTY_EDITOR_CONTEXT = "editorContext";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_EXPERT = "expert";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_PREFERRED = "preferred";
    public static final String PROPERTY_REQUIRED = "required";
    protected boolean _indentNonCategoryRow = false;
    private CellEditor _cellEditor;
    private TableCellRenderer _tableCellRenderer;
    private static final long serialVersionUID = 4810115374945626089L;

    public Property(String string, String string2, Class<?> clazz, String string3, ConverterContext converterContext, List<Property> list) {
        this._name = string;
        this._description = string2;
        this._type = clazz;
        this._category = string3;
        this._converterContext = converterContext;
        this.setChildren(list);
    }

    public Property(String string, String string2, Class<?> clazz, String string3, ConverterContext converterContext) {
        this(string, string2, clazz, string3, converterContext, null);
    }

    public Property(String string, String string2, Class<?> clazz, String string3) {
        this(string, string2, clazz, string3, null);
    }

    public Property(String string, String string2, Class<?> clazz) {
        this(string, string2, clazz, "");
    }

    public Property(String string, String string2) {
        this(string, string2, null);
    }

    public Property(String string) {
        this(string, "");
    }

    protected Property() {
        this("");
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (!JideSwingUtilities.equals(this._name, string)) {
            String string2 = this._name;
            this._name = string;
            this.firePropertyChange(PROPERTY_NAME, string2, this._name);
            if (this._displayName == null) {
                this.firePropertyChange(PROPERTY_DISPLAY_NAME, string2, this._name);
            }
        }
    }

    @Override
    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        return this.getName();
    }

    public void setDisplayName(String string) {
        if (!JideSwingUtilities.equals(this._displayName, string)) {
            String string2 = this._displayName;
            this._displayName = string;
            this.firePropertyChange(PROPERTY_DISPLAY_NAME, string2, this._displayName);
        }
    }

    @Override
    public String getFocusDisplayName() {
        if (this._focusDisplayName != null) {
            return this._focusDisplayName;
        }
        return this.getName();
    }

    public void setFocusDisplayName(String string) {
        if (!JideSwingUtilities.equals(this._focusDisplayName, string)) {
            String string2 = this._focusDisplayName;
            this._focusDisplayName = string;
            this.firePropertyChange(PROPERTY_FOCUS_DISPLAY_NAME, string2, this._focusDisplayName);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        if (!JideSwingUtilities.equals(this._description, string)) {
            String string2 = this._description;
            this._description = string;
            this.firePropertyChange(PROPERTY_DESCRIPTION, string2, this._description);
        }
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public void setType(Class<?> clazz) {
        if (this._type != clazz) {
            Class<?> clazz2 = this._type;
            this._type = clazz;
            this.firePropertyChange(PROPERTY_TYPE, clazz2, this._type);
        }
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String string) {
        if (!JideSwingUtilities.equals(this._category, string)) {
            String string2 = this._category;
            this._category = string;
            this.firePropertyChange(PROPERTY_CATEGORY, string2, this._category);
        }
    }

    public String getFullName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        Property property = this;
        while (!(property.getParent() == null || property.getParent() instanceof RootExpandableRow || property.getParent() instanceof Property && ((Property)property.getParent()).isCategoryRow())) {
            Property property2 = (Property)property.getParent();
            stringBuffer.insert(0, ".");
            stringBuffer.insert(0, property2.getName());
            property = property2;
        }
        return new String(stringBuffer);
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            boolean bl2 = this._editable;
            this._editable = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, bl2, this._editable);
        }
    }

    @Override
    public boolean isCategoryRow() {
        return this._isCategoryRow;
    }

    public void setCategoryRow(boolean bl) {
        this._isCategoryRow = bl;
    }

    @Override
    public int getLevel() {
        if (this.isCategoryRow()) {
            return 0;
        }
        if (!this.isIndentNonCategoryRow() && (this.getParent() == null || this.getParent() instanceof RootExpandableRow || ((Property)this.getParent()).isCategoryRow())) {
            return 0;
        }
        return super.getLevel();
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._converterContext;
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        if (this._converterContext != converterContext) {
            ConverterContext converterContext2 = this._converterContext;
            this._converterContext = converterContext;
            this.firePropertyChange(PROPERTY_CONVERTER_CONTEXT, converterContext2, converterContext);
        }
    }

    @Override
    public EditorContext getEditorContext() {
        return this._editorContext;
    }

    @Override
    public void setEditorContext(EditorContext editorContext) {
        if (this._editorContext != editorContext) {
            EditorContext editorContext2 = this._editorContext;
            this._editorContext = editorContext;
            this.firePropertyChange(PROPERTY_EDITOR_CONTEXT, editorContext2, editorContext);
        }
    }

    public CellEditor getCellEditor() {
        return this._cellEditor;
    }

    public void setCellEditor(CellEditor cellEditor) {
        this._cellEditor = cellEditor;
    }

    public CellEditor getCellEditor(int n) {
        if (n == 1) {
            return this.getCellEditor();
        }
        return null;
    }

    public TableCellRenderer getTableCellRenderer() {
        return this._tableCellRenderer;
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this._tableCellRenderer = tableCellRenderer;
    }

    public TableCellRenderer getTableCellRenderer(int n) {
        if (n == 1) {
            return this.getTableCellRenderer();
        }
        return null;
    }

    public List<String> getDependingProperties() {
        return this._dependingProperties;
    }

    public boolean addDependingProperty(String string) {
        if (this._dependingProperties == null) {
            this._dependingProperties = new ArrayList<String>();
        }
        return this._dependingProperties.add(string);
    }

    public boolean addDependingProperty(String[] stringArray) {
        if (this._dependingProperties == null) {
            this._dependingProperties = new ArrayList<String>();
        }
        this._dependingProperties.addAll(Arrays.asList(stringArray));
        return true;
    }

    public boolean removeDependingProperty(String string) {
        return this._dependingProperties != null && this._dependingProperties.remove(string);
    }

    public void clearDependingProperties() {
        if (this._dependingProperties != null) {
            this._dependingProperties.clear();
        }
    }

    @Override
    public int compareTo(Property property) {
        if (property != null) {
            return this.getDisplayName().compareTo(property.getDisplayName());
        }
        return -1;
    }

    public boolean isExpert() {
        return this._expert;
    }

    public void setExpert(boolean bl) {
        this._expert = bl;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean bl) {
        this._hidden = bl;
    }

    public boolean isPreferred() {
        return this._preferred;
    }

    public void setPreferred(boolean bl) {
        this._preferred = bl;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean bl) {
        this._required = bl;
    }

    public boolean isIndentNonCategoryRow() {
        return this._indentNonCategoryRow;
    }

    public void setIndentNonCategoryRow(boolean bl) {
        this._indentNonCategoryRow = bl;
    }

    @Override
    public Object getValueAt(int n) {
        if (n == 0) {
            return this.getDisplayName();
        }
        return this.getValue();
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return true;
    }

    @Override
    public void setEditorStyle(int n) {
        this._editorStyle = n;
    }

    public int getEditorStyle() {
        return this._editorStyle;
    }
}

