/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigationTreeTable
extends TreeTable
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper _helper;
    private float _iconAlpha = 0.0f;
    private Animator _exitAnimator;
    private Animator _enterAnimator;
    private boolean _fadeIcon = true;
    public static final String PROPERTY_FADE_ICON = "fadeIcon";

    public NavigationTreeTable() {
        this.initComponents();
    }

    public NavigationTreeTable(int n, int n2) {
        super(n, n2);
        this.initComponents();
    }

    public NavigationTreeTable(TableModel tableModel) {
        super(tableModel);
        this.initComponents();
    }

    public NavigationTreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initComponents();
    }

    public NavigationTreeTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initComponents();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initComponents();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initComponents();
    }

    private void initComponents() {
        this.setAutoResizeMode(256);
        this.setFillsSelection(false);
        this.setShowGrid(false);
        this.setFillsGrids(false);
        this.setShowTreeLines(false);
        this.setShowLeafNodeTreeLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        this.setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        this._exitAnimator = new Animator(this, 100, 30, 30);
        this._exitAnimator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                float f = 1.0f * (float)(n - n2) / (float)n;
                if (f <= NavigationTreeTable.this.getIconAlpha()) {
                    NavigationTreeTable.this.setIconAlpha(f);
                }
                NavigationTreeTable.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(0.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this._enterAnimator = new Animator(this, 100, 5, 10);
        this._enterAnimator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                float f = 1.0f * (float)n2 / (float)n;
                if (f >= NavigationTreeTable.this.getIconAlpha()) {
                    NavigationTreeTable.this.setIconAlpha(f);
                }
                NavigationTreeTable.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(1.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this._helper = this.createNavigationHelper();
        this._helper.setup(this);
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeTableHelper();
    }

    private Rectangle getRowBounds(int n) {
        return this.getCellRect(n, 0, false).union(this.getCellRect(n, this.getColumnCount() - 1, false));
    }

    @Override
    public boolean isIconRollover(int n, int n2, int n3, int n4) {
        Point point = this._helper.getMousePosition();
        return point != null && point.x >= n && point.x <= n + n3 && point.y >= n2 && point.y <= n2 + n4;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._helper.paint(graphics, this);
    }

    @Override
    public float getIconAlpha() {
        return this._iconAlpha;
    }

    public void setIconAlpha(float f) {
        this._iconAlpha = f;
    }

    @Override
    public boolean isIconFade() {
        return this._fadeIcon;
    }

    public void setFadeIcon(boolean bl) {
        boolean bl2 = this._fadeIcon;
        if (bl != this._fadeIcon) {
            this._fadeIcon = bl;
            this.firePropertyChange(PROPERTY_FADE_ICON, bl2, this._fadeIcon);
            this.repaint();
        }
    }

    public int getNavigationRolloverRow() {
        return this._helper.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n) {
        int n2 = this._helper.getRolloverRow();
        if (n2 != n) {
            this._helper.setRolloverRow(n);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    public class NavigationTreeTableHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n) {
            return NavigationTreeTable.this.getRowBounds(n);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTreeTable.this.rowAtPoint(point);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTreeTable.this.getSelectedRows();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (NavigationTreeTable.this.isIconFade() && !NavigationTreeTable.this.hasFocus()) {
                NavigationTreeTable.this._enterAnimator.stop();
                NavigationTreeTable.this._exitAnimator.start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NavigationTreeTable.this.isIconFade() && !NavigationTreeTable.this.hasFocus()) {
                NavigationTreeTable.this._exitAnimator.stop();
                NavigationTreeTable.this._enterAnimator.start();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (NavigationTreeTable.this.isIconFade()) {
                NavigationTreeTable.this._exitAnimator.stop();
                NavigationTreeTable.this._enterAnimator.start();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (NavigationTreeTable.this.isIconFade()) {
                NavigationTreeTable.this._enterAnimator.stop();
                NavigationTreeTable.this._exitAnimator.start();
            }
        }
    }
}

