/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

class LazyList
extends AbstractList
implements Cloneable,
Serializable {
    private static final String[] __EMTPY_STRING_ARRAY = new String[0];
    private Object _first;
    private List _list;
    private Set _set;
    private static boolean _sorted = true;
    private static final long serialVersionUID = -725849535936808888L;

    private LazyList(Object object) {
        this._first = object;
    }

    private LazyList(List list) {
        this._list = list;
    }

    private static int binarySearch(List list, Object object) {
        return LazyList.binarySearch0(list, 0, list.size(), object);
    }

    private static int binarySearch0(List<?> list, int n, int n2, Object object) {
        int n3 = n;
        int n4 = n2;
        int n5 = n4 / 2;
        while (n3 < n4) {
            int n6 = ((Comparable)list.get(n5)).compareTo(object);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
            } else {
                n4 = n5;
            }
            n5 = n3 + (n4 - n3) / 2;
        }
        return 0 - n5 - 1;
    }

    public static LazyList add(LazyList lazyList, Object object) {
        if (lazyList == null) {
            return new LazyList(object);
        }
        if (lazyList._list != null) {
            if (LazyList.isSorted() && object instanceof Comparable) {
                int n = LazyList.binarySearch(lazyList._list, object);
                if (n < 0) {
                    lazyList._list.add(-n - 1, object);
                    lazyList._set.add(object);
                }
            } else if (!LazyList.isSorted() || !lazyList.contains(object)) {
                lazyList._list.add(object);
                lazyList._set.add(object);
            }
            return lazyList;
        }
        if (lazyList._first != null && lazyList._first.equals(object)) {
            return lazyList;
        }
        lazyList._list = new ArrayList(2);
        lazyList._set = new HashSet(2);
        lazyList._set.add(lazyList._first);
        lazyList._set.add(object);
        if (LazyList.isSorted() && lazyList._first instanceof Comparable) {
            int n = ((Comparable)lazyList._first).compareTo(object);
            if (n <= 0) {
                lazyList._list.add(lazyList._first);
                lazyList._list.add(object);
            } else {
                lazyList._list.add(object);
                lazyList._list.add(lazyList._first);
            }
        } else {
            lazyList._list.add(lazyList._first);
            lazyList._list.add(object);
        }
        lazyList._first = null;
        return lazyList;
    }

    public static LazyList add(LazyList lazyList, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            lazyList = LazyList.add(lazyList, iterator.next());
        }
        return lazyList;
    }

    public static LazyList add(LazyList lazyList, int n, Object object) {
        if (lazyList == null) {
            return new LazyList(object);
        }
        if (lazyList._list != null) {
            lazyList._list.add(object);
            return lazyList;
        }
        lazyList._list = new ArrayList(n);
        lazyList._list.add(lazyList._first);
        lazyList._list.add(object);
        return lazyList;
    }

    public static LazyList remove(LazyList lazyList, Object object) {
        if (lazyList == null) {
            return null;
        }
        if (lazyList._first != null && lazyList._first.equals(object)) {
            return null;
        }
        if (lazyList._list == null) {
            return null;
        }
        lazyList._list.remove(object);
        if (lazyList._list.size() == 1) {
            lazyList._first = lazyList._list.get(0);
            lazyList._list = null;
        }
        return lazyList;
    }

    public static void set(LazyList lazyList, Object object, Object object2) {
        if (lazyList == null) {
            return;
        }
        if (lazyList._first != null && lazyList._first.equals(object)) {
            lazyList._first = object2;
            return;
        }
        if (lazyList._list == null) {
            return;
        }
        int n = LazyList.isSorted() && object instanceof Comparable ? LazyList.binarySearch(lazyList._list, object) : lazyList._list.indexOf(object);
        if (n >= 0) {
            lazyList._list.set(n, object2);
        }
    }

    public static List getList(LazyList lazyList) {
        return LazyList.getList(lazyList, false);
    }

    public static List getList(LazyList lazyList, boolean bl) {
        if (lazyList == null) {
            return bl ? null : Collections.EMPTY_LIST;
        }
        if (lazyList._list == null) {
            return lazyList;
        }
        return lazyList._list;
    }

    public static Set getSet(LazyList lazyList, boolean bl) {
        if (lazyList == null) {
            return bl ? null : Collections.EMPTY_SET;
        }
        if (lazyList._set == null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(lazyList._first);
            return hashSet;
        }
        return lazyList._set;
    }

    public static String[] toStringArray(LazyList lazyList) {
        if (lazyList == null) {
            return __EMTPY_STRING_ARRAY;
        }
        if (lazyList._list != null) {
            String[] stringArray = new String[lazyList._list.size()];
            for (int i = lazyList._list.size() - 1; i >= 0; --i) {
                Object e = lazyList._list.get(i);
                if (e == null) continue;
                stringArray[i] = e.toString();
            }
            return stringArray;
        }
        return new String[]{lazyList._first == null ? null : lazyList._first.toString()};
    }

    public static int size(LazyList lazyList) {
        if (lazyList == null) {
            return 0;
        }
        if (lazyList._list == null) {
            return 1;
        }
        return lazyList._list.size();
    }

    public static Object get(LazyList lazyList, int n) {
        if (lazyList == null) {
            throw new IndexOutOfBoundsException();
        }
        if (lazyList._list == null) {
            if (n == 0) {
                return lazyList._first;
            }
            throw new IndexOutOfBoundsException();
        }
        return lazyList._list.get(n);
    }

    public static LazyList clone(LazyList lazyList) {
        if (lazyList == null) {
            return null;
        }
        return (LazyList)lazyList.clone();
    }

    @Override
    public Object get(int n) {
        if (this._list != null) {
            return this._list.get(n);
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return this._first;
    }

    @Override
    public int size() {
        if (this._list != null) {
            return this._list.size();
        }
        return 1;
    }

    @Override
    public ListIterator listIterator() {
        if (this._list != null) {
            return this._list.listIterator();
        }
        return new SIterator();
    }

    @Override
    public ListIterator listIterator(int n) {
        if (this._list != null) {
            return this._list.listIterator(n);
        }
        return new SIterator(n);
    }

    @Override
    public Iterator iterator() {
        if (this._list != null) {
            return this._list.iterator();
        }
        return new SIterator();
    }

    public Object clone() {
        if (this._list != null) {
            return new LazyList(new ArrayList(this._list));
        }
        return new LazyList(this._first);
    }

    @Override
    public String toString() {
        if (this._list == null) {
            return "[ LazyList: " + this._first + "]";
        }
        return this._list.toString();
    }

    public static String toString(LazyList lazyList) {
        if (lazyList == null) {
            return "[LazyList: Empty]";
        }
        return lazyList.toString();
    }

    static boolean isSorted() {
        return _sorted;
    }

    static void setSorted(boolean bl) {
        _sorted = bl;
    }

    @Override
    public boolean contains(Object object) {
        if (this._first != null && this._first == object) {
            return true;
        }
        return this._set != null ? this._set.contains(object) : super.contains(object);
    }

    private class SIterator
    implements ListIterator {
        int i;

        SIterator() {
            this.i = 0;
        }

        SIterator(int n) {
            if (n < 0 || n > 1) {
                throw new IndexOutOfBoundsException("index " + n);
            }
            this.i = n;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("LazyList.add()");
        }

        @Override
        public boolean hasNext() {
            return this.i == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.i == 1;
        }

        @Override
        public Object next() {
            if (this.i != 0) {
                throw new NoSuchElementException();
            }
            if (LazyList.this._list != null) {
                throw new ConcurrentModificationException();
            }
            ++this.i;
            return LazyList.this._first;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        public Object previous() {
            if (this.i != 1) {
                throw new NoSuchElementException();
            }
            --this.i;
            if (LazyList.this._list != null) {
                throw new ConcurrentModificationException();
            }
            return LazyList.this._first;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("LazyList.remove()");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("LazyList.add()");
        }
    }
}

