/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NavigableModel;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelsWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JoinTableModel
extends AbstractTableModel
implements ColumnIdentifierTableModel,
ContextSensitiveTableModel,
SpanModel,
StyleModel,
NavigableModel,
MultiTableModel,
TableModelsWrapper {
    private static final long serialVersionUID = -1212552638389898430L;
    protected List<TableModel> _models = new ArrayList<TableModel>();
    private TableChangeHandler _changeHandler = new TableChangeHandler();

    public JoinTableModel() {
        this(null);
    }

    public JoinTableModel(TableModel[] tableModelArray) {
        if (tableModelArray != null) {
            for (TableModel tableModel : tableModelArray) {
                this.addTableModel(tableModel);
            }
        }
    }

    public synchronized void addTableModel(TableModel tableModel) {
        this._models.add(tableModel);
        tableModel.addTableModelListener(this._changeHandler);
    }

    public synchronized void addTableModel(TableModel tableModel, int n) {
        this._models.add(n, tableModel);
        tableModel.addTableModelListener(this._changeHandler);
    }

    public synchronized void removeTableModel(TableModel tableModel) {
        for (int i = 0; i < this._models.size(); ++i) {
            if (!this._models.remove(tableModel)) continue;
            tableModel.removeTableModelListener(this._changeHandler);
            break;
        }
    }

    public synchronized void removeAllTableModels() {
        for (int i = this._models.size() - 1; i >= 0; --i) {
            TableModel tableModel = this._models.get(i);
            if (!this._models.remove(tableModel)) continue;
            tableModel.removeTableModelListener(this._changeHandler);
        }
    }

    public synchronized int getTableModelCount() {
        return this._models.size();
    }

    public synchronized TableModel getTableModel(int n) {
        return n >= 0 && n < this._models.size() ? this._models.get(n) : null;
    }

    @Override
    public Object getColumnIdentifier(int n) {
        int n2 = n;
        for (TableModel tableModel : this._models) {
            int n3 = tableModel.getColumnCount();
            if (n2 < n3) {
                if (tableModel instanceof ColumnIdentifierTableModel) {
                    return ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(n2);
                }
                return tableModel.getColumnName(n2);
            }
            if ((n2 -= n3) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public synchronized Class<?> getColumnClass(int n) {
        int n2 = n;
        for (TableModel tableModel : this._models) {
            int n3 = tableModel.getColumnCount();
            if (n2 < n3) {
                return tableModel.getColumnClass(n2);
            }
            if ((n2 -= n3) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public synchronized String getColumnName(int n) {
        int n2 = n;
        for (TableModel tableModel : this._models) {
            int n3 = tableModel.getColumnCount();
            if (n2 < n3) {
                return tableModel.getColumnName(n2);
            }
            if ((n2 -= n3) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (n3 < n4) {
                return n < tableModel.getRowCount() && tableModel.isCellEditable(n, n3);
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return false;
    }

    @Override
    public synchronized int getColumnCount() {
        int n = 0;
        for (TableModel tableModel : this._models) {
            n += tableModel.getColumnCount();
        }
        return n;
    }

    @Override
    public synchronized int getRowCount() {
        int n = 0;
        for (TableModel tableModel : this._models) {
            n = Math.max(n, tableModel.getRowCount());
        }
        return n;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (n3 < n4) {
                return n < tableModel.getRowCount() ? tableModel.getValueAt(n, n3) : null;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (n3 < n4 && n < tableModel.getRowCount()) {
                tableModel.setValueAt(object, n, n3);
                break;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
    }

    @Override
    public TableModel getActualModel(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (n3 < n4) {
                return tableModel;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof ContextSensitiveTableModel && n3 < n4) {
                return n < tableModel.getRowCount() ? ((ContextSensitiveTableModel)tableModel).getConverterContextAt(n, n3) : null;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof ContextSensitiveTableModel && n3 < n4) {
                return n < tableModel.getRowCount() ? ((ContextSensitiveTableModel)tableModel).getEditorContextAt(n, n3) : null;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof ContextSensitiveTableModel && n3 < n4) {
                return n < tableModel.getRowCount() ? ((ContextSensitiveTableModel)tableModel).getCellClassAt(n, n3) : null;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        for (TableModel tableModel : this._models) {
            int n5 = tableModel.getColumnCount();
            if (tableModel instanceof SpanModel && n3 < n5) {
                CellSpan cellSpan;
                CellSpan cellSpan2 = cellSpan = ((SpanModel)((Object)tableModel)).isCellSpanOn() && n < tableModel.getRowCount() ? ((SpanModel)((Object)tableModel)).getCellSpanAt(n, n3) : null;
                if (cellSpan != null) {
                    cellSpan.setColumn(n4 + cellSpan.getColumn());
                }
                return cellSpan;
            }
            if ((n3 -= n5) < 0) break;
            n4 += n5;
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        for (TableModel tableModel : this._models) {
            if (!(tableModel instanceof SpanModel) || !((SpanModel)((Object)tableModel)).isCellSpanOn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof StyleModel && n3 < n4) {
                return ((StyleModel)((Object)tableModel)).isCellStyleOn() && n < tableModel.getRowCount() ? ((StyleModel)((Object)tableModel)).getCellStyleAt(n, n3) : null;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        for (TableModel tableModel : this._models) {
            if (!(tableModel instanceof StyleModel) || !((StyleModel)((Object)tableModel)).isCellStyleOn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNavigableAt(int n, int n2) {
        int n3 = n2;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof NavigableModel && n3 < n4 && ((NavigableModel)((Object)tableModel)).isNavigationOn() && n < tableModel.getRowCount() && !((NavigableModel)((Object)tableModel)).isNavigableAt(n, n3)) {
                return false;
            }
            if ((n3 -= n4) >= 0) continue;
            break;
        }
        return true;
    }

    @Override
    public boolean isNavigationOn() {
        for (TableModel tableModel : this._models) {
            if (!(tableModel instanceof NavigableModel) || !((NavigableModel)((Object)tableModel)).isNavigationOn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnType(int n) {
        int n2 = n;
        int n3 = 0;
        for (TableModel tableModel : this._models) {
            int n4 = tableModel.getColumnCount();
            if (tableModel instanceof ContextSensitiveTableModel && n2 < n4) {
                return n3 == 0 ? 1 : (n3 == 1 ? 0 : (n3 == 2 ? 2 : -1));
            }
            if ((n2 -= n4) < 0) break;
            ++n3;
        }
        return -1;
    }

    @Override
    public int getTableIndex(int n) {
        return 0;
    }

    private class TableChangeHandler
    implements TableModelListener {
        private TableChangeHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() != null && tableModelEvent.getSource() != ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getSource() && JoinTableModel.this._models != null && JoinTableModel.this._models.indexOf(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent().getSource()) >= 0) {
                return;
            }
            CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(JoinTableModel.this);
            if (tableModelEvent instanceof CompoundTableModelEvent) {
                compoundTableModelEvent.setOriginalEvent(((CompoundTableModelEvent)tableModelEvent).getOriginalEvent());
                if (((CompoundTableModelEvent)tableModelEvent).getEvents() != null) {
                    for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                        compoundTableModelEvent.addEvent(new TableModelEvent(JoinTableModel.this, tableModelEvent2.getFirstRow(), tableModelEvent2.getLastRow(), -1, tableModelEvent2.getType()));
                    }
                }
            }
            if (compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length == 0) {
                compoundTableModelEvent.addEvent(new TableModelEvent(JoinTableModel.this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, tableModelEvent.getType()));
            }
            CompoundTableModelEvent.fireTableModelEvent(JoinTableModel.this, compoundTableModelEvent);
        }
    }
}

