/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractCalculatedColumn;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.Schema;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.expression.ColumnExpression;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;
import com.jidesoft.thirdparty.prefuse.data.expression.ExpressionVisitor;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ExpressionParser;
import com.jidesoft.thirdparty.prefuse.data.expression.parser.ParseException;
import com.jidesoft.utils.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;

public class ExpressionCalculatedColumn
extends AbstractCalculatedColumn {
    private String _expressionString;
    private Expression _expression;
    private int[] _dependingColumns = new int[0];
    public List<String> _dependingColumnNames;
    private static final long serialVersionUID = 5473239777873314116L;

    public ExpressionCalculatedColumn(TableModel tableModel, String string) throws IllegalArgumentException {
        super(tableModel);
        this.setExpressionString(string);
    }

    public ExpressionCalculatedColumn(TableModel tableModel, String string, String string2) throws IllegalArgumentException {
        super(tableModel, string);
        this.setExpressionString(string2);
    }

    public String getExpressionString() {
        return this._expressionString;
    }

    public void setExpressionString(String string) throws IllegalArgumentException {
        this._expressionString = string;
        TableModel tableModel = this.getActualModel();
        try {
            this._expression = ExpressionParser.parse(string);
            this.resetDependingColumnNames();
            this._expression.visit(new ExpressionVisitor(){

                @Override
                public void visitExpression(Expression expression) {
                    String string;
                    if (expression instanceof ColumnExpression && !ExpressionCalculatedColumn.this._dependingColumnNames.contains(string = ((ColumnExpression)expression).getColumnName())) {
                        ExpressionCalculatedColumn.this._dependingColumnNames.add(string);
                    }
                }

                @Override
                public void down() {
                }

                @Override
                public void up() {
                }
            });
            Schema schema = new Schema();
            if (this._dependingColumnNames.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    String string2 = tableModel.getColumnName(i);
                    if (!this._dependingColumnNames.contains(string2) || arrayList.contains(string2)) continue;
                    schema.addColumn(string2, TypeUtils.convertWrapperToPrimitiveType(tableModel.getColumnClass(i)));
                    arrayList.add(string2);
                }
            }
            this.setColumnClass(this._expression.getType(schema));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    @Override
    public Object getValueAt(int n) {
        Table table = new Table();
        table.addRow();
        TableModel tableModel = this.getActualModel();
        int[] nArray = this.getDependingColumns();
        if (nArray != null && nArray.length > 0) {
            for (int n2 : nArray) {
                Object object = tableModel.getValueAt(n, n2);
                String string = tableModel.getColumnName(n2);
                if (object == null) {
                    table.addColumn(string, Object.class, null);
                    continue;
                }
                table.addColumn(string, TypeUtils.convertWrapperToPrimitiveType(tableModel.getColumnClass(n2)), object);
            }
        } else {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                String string = tableModel.getColumnName(i);
                if (JideSwingUtilities.equals(this.getColumnName(), string)) continue;
                Object object = tableModel.getValueAt(n, i);
                if (object == null) {
                    table.addColumn(string, Object.class, null);
                    continue;
                }
                table.addColumn(string, TypeUtils.convertWrapperToPrimitiveType(tableModel.getColumnClass(i)), object);
            }
        }
        try {
            return this._expression.get(table.getTuple(0));
        }
        catch (DataTypeException dataTypeException) {
            return null;
        }
    }

    private void resetDependingColumnNames() {
        this._dependingColumnNames = new ArrayList<String>();
        this._dependingColumns = null;
    }

    public void setDependingColumns(int[] nArray) {
        this._dependingColumns = nArray;
    }

    @Override
    public int[] getDependingColumns() {
        if ((this._dependingColumns == null || this._dependingColumns.length == 0) && this._dependingColumnNames != null && this._dependingColumnNames.size() > 0) {
            TableModel tableModel = this.getActualModel();
            this._dependingColumns = new int[this._dependingColumnNames.size()];
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                String string = tableModel.getColumnName(i);
                int n = this._dependingColumnNames.indexOf(string);
                if (n == -1) continue;
                this._dependingColumns[n] = i;
            }
        }
        return this._dependingColumns;
    }
}

