/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellKey;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.MultiValuedMap;
import com.jidesoft.grid.SpanModelEvent;
import com.jidesoft.grid.SpanModelListener;
import com.jidesoft.grid.SpanTableModel;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class DefaultSpanTableModel
extends DefaultTableModel
implements SpanTableModel {
    private boolean _cellSpanOn = true;
    private HashMap _masterCellSpans = new HashMap();
    private MultiValuedMap _slaveCellSpans = new MultiValuedMap();

    public DefaultSpanTableModel() {
    }

    public DefaultSpanTableModel(int n, int n2) {
        super(n, n2);
    }

    public DefaultSpanTableModel(Vector vector, int n) {
        super(vector, n);
    }

    public DefaultSpanTableModel(Object[] objectArray, int n) {
        super(objectArray, n);
    }

    public DefaultSpanTableModel(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public DefaultSpanTableModel(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        CellSpan cellSpan = (CellSpan)this._masterCellSpans.get(new CellKey(n, n2));
        if (cellSpan == null) {
            cellSpan = (CellSpan)this._slaveCellSpans.get(new CellKey(n, n2), 0);
        }
        return cellSpan == null ? null : (CellSpan)cellSpan.clone();
    }

    public void addCellSpan(CellSpan cellSpan) {
        if (cellSpan.getRowSpan() <= 1 && cellSpan.getColumnSpan() <= 1) {
            return;
        }
        CellKey cellKey = new CellKey(cellSpan.getRow(), cellSpan.getColumn());
        if (this._masterCellSpans.get(cellKey) != null) {
            this.removeCellSpan(cellSpan.getRow(), cellSpan.getColumn());
        }
        this._masterCellSpans.put(cellKey, cellSpan);
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n2 = j + cellSpan.getColumn();
                if (i == 0 && j == 0) continue;
                CellKey cellKey2 = new CellKey(n, n2);
                this._slaveCellSpans.add(cellKey2, cellSpan);
            }
        }
        this.fireTableSpanAdded(cellSpan);
    }

    public void removeCellSpan(int n, int n2) {
        CellKey cellKey = new CellKey(n, n2);
        CellSpan cellSpan = (CellSpan)this._masterCellSpans.get(cellKey);
        if (cellSpan == null) {
            return;
        }
        this._masterCellSpans.remove(cellKey);
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n3 = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n4 = j + cellSpan.getColumn();
                if (i == 0 && j == 0) continue;
                CellKey cellKey2 = new CellKey(n3, n4);
                this._slaveCellSpans.remove(cellKey2, cellSpan);
            }
        }
        this.fireTableSpanRemoved(cellSpan);
    }

    public void removeAllCellSpans() {
        this._masterCellSpans.clear();
        this._slaveCellSpans.clear();
        this.fireTableSpanChanged();
    }

    @Override
    public boolean isCellSpanOn() {
        return this._cellSpanOn;
    }

    public void setCellSpanOn(boolean bl) {
        boolean bl2 = this._cellSpanOn;
        if (bl2 != bl) {
            this._cellSpanOn = bl;
            this.fireTableDataChanged();
        }
    }

    public void addSpanModelListener(SpanModelListener spanModelListener) {
        this.listenerList.add(SpanModelListener.class, spanModelListener);
    }

    public void removeSpanModelListener(SpanModelListener spanModelListener) {
        this.listenerList.remove(SpanModelListener.class, spanModelListener);
    }

    public SpanModelListener[] getSpanModelListeners() {
        return (SpanModelListener[])this.listenerList.getListeners(SpanModelListener.class);
    }

    public void fireTableSpanChanged() {
        this.fireTableSpanChanged(new SpanModelEvent(this));
        this.fireTableDataChanged();
    }

    public void fireTableSpanAdded(CellSpan cellSpan) {
        this.fireTableSpanChanged(new SpanModelEvent(this, cellSpan, 1));
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n2 = j + cellSpan.getColumn();
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    public void fireTableSpanRemoved(CellSpan cellSpan) {
        this.fireTableSpanChanged(new SpanModelEvent(this, cellSpan, -1));
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n2 = j + cellSpan.getColumn();
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    public void fireTableSpanChanged(SpanModelEvent spanModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SpanModelListener.class) continue;
            ((SpanModelListener)objectArray[i + 1]).spanChanged(spanModelEvent);
        }
    }

    @Override
    public void insertRow(int n, Object[] objectArray) {
        if (n < 0 || n > this.getRowCount()) {
            return;
        }
        boolean bl = false;
        for (int i = n; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                CellSpan cellSpan = this.removeCellSpanWithoutEvent(i, j);
                if (cellSpan == null) continue;
                bl = true;
                cellSpan.setRow(cellSpan.getRow() + 1);
                this.addCellSpanWithoutEvent(cellSpan);
            }
        }
        super.insertRow(n, objectArray);
        if (bl) {
            this.fireTableSpanChanged();
        }
    }

    public void insertRow(int n, Vector vector) {
        if (n < 0 || n > this.getRowCount()) {
            return;
        }
        boolean bl = false;
        for (int i = n; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                CellSpan cellSpan = this.removeCellSpanWithoutEvent(i, j);
                if (cellSpan == null) continue;
                bl = true;
                cellSpan.setRow(cellSpan.getRow() + 1);
                this.addCellSpanWithoutEvent(cellSpan);
            }
        }
        super.insertRow(n, vector);
        if (bl) {
            this.fireTableSpanChanged();
        }
    }

    @Override
    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n == n3) {
            return;
        }
        if (n2 - n <= 0) {
            return;
        }
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        if (n2 < 0 || n2 >= this.getRowCount()) {
            return;
        }
        if (n > n2) {
            return;
        }
        if (n3 < 0 || n3 > this.getRowCount() - (n2 - n + 1)) {
            return;
        }
        if (n < n3) {
            n6 = n2 + 1;
            n5 = n3 + (n2 - n + 1);
            n4 = n2 - n + 1;
            for (int i = n6; i < n5; ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    CellSpan cellSpan = this.removeCellSpanWithoutEvent(i, j);
                    if (cellSpan == null) continue;
                    cellSpan.setRow(cellSpan.getRow() - n4);
                    this.addCellSpanWithoutEvent(cellSpan);
                }
            }
        } else if (n > n3) {
            n6 = n2 - n + 1;
            for (n5 = n3; n5 < n; ++n5) {
                for (n4 = 0; n4 < this.getColumnCount(); ++n4) {
                    CellSpan cellSpan = this.removeCellSpanWithoutEvent(n5, n4);
                    if (cellSpan == null) continue;
                    cellSpan.setRow(cellSpan.getRow() + n6);
                    this.addCellSpanWithoutEvent(cellSpan);
                }
            }
        }
        for (n6 = n; n6 <= n2; ++n6) {
            for (n5 = 0; n5 < this.getColumnCount(); ++n5) {
                CellSpan cellSpan = this.removeCellSpanWithoutEvent(n6, n5);
                if (cellSpan == null) continue;
                cellSpan.setRow(n3 + (n6 - n));
                this.addCellSpanWithoutEvent(cellSpan);
            }
        }
        super.moveRow(n, n2, n3);
        this.fireTableSpanChanged();
    }

    @Override
    public void removeRow(int n) {
        int n2;
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            this.removeCellSpanWithoutEvent(n, n2);
        }
        for (n2 = n + 1; n2 < this.getRowCount(); ++n2) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                CellSpan cellSpan = this.removeCellSpanWithoutEvent(n2, i);
                if (cellSpan == null) continue;
                cellSpan.setRow(cellSpan.getRow() - 1);
                this.addCellSpanWithoutEvent(cellSpan);
            }
        }
        super.removeRow(n);
        this.fireTableSpanChanged();
    }

    @Override
    public void setRowCount(int n) {
        if (n < this.getRowCount()) {
            for (int i = n; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    this.removeCellSpan(i, j);
                }
            }
        }
        super.setRowCount(n);
    }

    private void addCellSpanWithoutEvent(CellSpan cellSpan) {
        if (cellSpan.getRowSpan() <= 1 && cellSpan.getColumnSpan() <= 1) {
            return;
        }
        CellKey cellKey = new CellKey(cellSpan.getRow(), cellSpan.getColumn());
        if (this._masterCellSpans.get(cellKey) != null) {
            this.removeCellSpanWithoutEvent(cellSpan.getRow(), cellSpan.getColumn());
        }
        this._masterCellSpans.put(cellKey, cellSpan);
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n2 = j + cellSpan.getColumn();
                if (i == 0 && j == 0) continue;
                CellKey cellKey2 = new CellKey(n, n2);
                this._slaveCellSpans.add(cellKey2, cellSpan);
            }
        }
    }

    private CellSpan removeCellSpanWithoutEvent(int n, int n2) {
        CellKey cellKey = new CellKey(n, n2);
        CellSpan cellSpan = (CellSpan)this._masterCellSpans.get(cellKey);
        if (cellSpan == null) {
            return null;
        }
        this._masterCellSpans.remove(cellKey);
        for (int i = 0; i < cellSpan.getRowSpan(); ++i) {
            int n3 = i + cellSpan.getRow();
            for (int j = 0; j < cellSpan.getColumnSpan(); ++j) {
                int n4 = j + cellSpan.getColumn();
                if (i == 0 && j == 0) continue;
                CellKey cellKey2 = new CellKey(n3, n4);
                this._slaveCellSpans.remove(cellKey2, cellSpan);
            }
        }
        return cellSpan;
    }
}

