/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Row;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

public class DefaultExpandable
extends AbstractExpandable {
    protected List<?> _children;
    public static final String PROPERTY_CHILDREN = "children";
    public static final Enumeration<Object> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public DefaultExpandable() {
    }

    public DefaultExpandable(List<Row> list) {
        this.setChildren(list);
    }

    @Override
    public List<?> getChildren() {
        return this._children;
    }

    @Override
    public void setChildren(List<?> list) {
        if (this._children != list) {
            List<?> list2 = this._children;
            this._children = list;
            if (this._children != null) {
                for (Object obj : this._children) {
                    if (!(obj instanceof Node)) continue;
                    ((Node)obj).setParent(this);
                }
            }
            this.firePropertyChange(PROPERTY_CHILDREN, list2, list);
        }
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    final class BreadthFirstEnumeration
    implements Enumeration<Object> {
        protected Queue queue;

        public BreadthFirstEnumeration(DefaultExpandable defaultExpandable2) {
            ArrayList<DefaultExpandable> arrayList = new ArrayList<DefaultExpandable>();
            arrayList.add(defaultExpandable2);
            this.queue = new Queue();
            this.queue.enqueue(new ListEnumeration(arrayList));
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        @Override
        public Object nextElement() {
            List<?> list;
            ListEnumeration listEnumeration;
            Enumeration enumeration = (Enumeration)this.queue.firstObject();
            DefaultExpandable defaultExpandable = (DefaultExpandable)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) {
                this.queue.dequeue();
            }
            if ((listEnumeration = new ListEnumeration(list = defaultExpandable.getChildren())).hasMoreElements()) {
                this.queue.enqueue(listEnumeration);
            }
            return defaultExpandable;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object object) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(object, null);
                } else {
                    this.tail = this.tail.next = new QNode(object, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object object = this.head.object;
                QNode qNode = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    qNode.next = null;
                }
                return object;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode qNode) {
                    this.object = object;
                    this.next = qNode;
                }
            }
        }
    }

    final class PostorderEnumeration
    implements Enumeration<Object> {
        protected DefaultExpandable _root;
        protected Enumeration<Object> _children;
        protected Enumeration<Object> _subTree;

        public PostorderEnumeration(DefaultExpandable defaultExpandable2) {
            this._root = defaultExpandable2;
            List<?> list = this._root.getChildren();
            this._children = new ListEnumeration(list);
            this._subTree = EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            return this._root != null;
        }

        @Override
        public Object nextElement() {
            Object object;
            if (this._subTree.hasMoreElements()) {
                object = this._subTree.nextElement();
            } else if (this._children.hasMoreElements()) {
                Object object2 = this._children.nextElement();
                if (object2 instanceof DefaultExpandable) {
                    this._subTree = new PostorderEnumeration((DefaultExpandable)object2);
                    object = this._subTree.nextElement();
                } else {
                    object = object2;
                }
            } else {
                object = this._root;
                this._root = null;
            }
            return object;
        }
    }

    final class PreorderEnumeration
    implements Enumeration<Object> {
        protected Stack _stack;

        public PreorderEnumeration(DefaultExpandable defaultExpandable2) {
            ArrayList<DefaultExpandable> arrayList = new ArrayList<DefaultExpandable>();
            arrayList.add(defaultExpandable2);
            this._stack = new Stack();
            this._stack.push(new ListEnumeration(arrayList));
        }

        @Override
        public boolean hasMoreElements() {
            return !this._stack.empty() && ((Enumeration)this._stack.peek()).hasMoreElements();
        }

        @Override
        public Object nextElement() {
            List<?> list;
            ListEnumeration listEnumeration;
            Enumeration enumeration = (Enumeration)this._stack.peek();
            Object e = enumeration.nextElement();
            if (!enumeration.hasMoreElements()) {
                this._stack.pop();
            }
            if (e instanceof DefaultExpandable && (listEnumeration = new ListEnumeration(list = ((DefaultExpandable)e).getChildren())).hasMoreElements()) {
                this._stack.push(listEnumeration);
            }
            return e;
        }
    }

    final class ListEnumeration
    implements Enumeration<Object> {
        private List _list;
        int _index = 0;

        public ListEnumeration(List list) {
            this._list = list;
        }

        @Override
        public boolean hasMoreElements() {
            return this._list != null && this._index < this._list.size();
        }

        @Override
        public Object nextElement() {
            return this._list == null || this._index < 0 || this._index >= this._list.size() ? null : this._list.get(this._index++);
        }
    }
}

