/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellEditorValueProvider;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.ContextSensitiveTableTransferHandler;
import com.jidesoft.grid.DynamicValueCellRenderer;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorContextSupport;
import com.jidesoft.grid.EditorStyleSupport;
import com.jidesoft.grid.EditorStyleTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.utils.CacheMap;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ContextSensitiveTable
extends JideTable {
    private boolean _cellEditorManagerEnabled = true;
    private boolean _cellRendererManagerEnabled = true;
    private TableCellRenderer _defaultCellRenderer;
    private static CacheMap<Object, EditorContext> _rendererCache = new CacheMap(EditorContext.DEFAULT_CONTEXT);

    public ContextSensitiveTable() {
        this.initializeTable();
    }

    public ContextSensitiveTable(int n, int n2) {
        super(n, n2);
        this.initializeTable();
    }

    public ContextSensitiveTable(TableModel tableModel) {
        super(tableModel);
        this.initializeTable();
    }

    public ContextSensitiveTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initializeTable();
    }

    public ContextSensitiveTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initializeTable();
    }

    public ContextSensitiveTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initializeTable();
    }

    public ContextSensitiveTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initializeTable();
    }

    private void initializeTable() {
    }

    @Override
    protected TransferHandler createDefaultTransferHandler() {
        return SystemInfo.isJdk6Above() ? new ContextSensitiveTableTransferHandler() : super.createDefaultTransferHandler();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getDefaultCellRenderer();
        if (tableCellRenderer == null) {
            if (this.isCellRendererManagerEnabled()) {
                if (this.isApplyColumnCellRenderer(n) && n2 >= 0 && n2 < this.getColumnModel().getColumnCount()) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    tableCellRenderer = tableColumn.getCellRenderer();
                }
                if (tableCellRenderer == null && this.getModel() instanceof ContextSensitiveTableModel) {
                    tableCellRenderer = this.getCellRendererFromManager(n, n2);
                }
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = super.getCellRenderer(n, n2);
            }
        }
        return tableCellRenderer;
    }

    protected TableCellRenderer getCellRendererFromManager(int n, int n2) {
        Class<?> clazz = this.getCellClassAt(n, n2);
        TableCellRenderer tableCellRenderer = null;
        if (clazz != null) {
            EditorContext editorContext = this.getEditorContextAt(n, n2);
            tableCellRenderer = this.getCellRendererFromCache(clazz, editorContext);
            if (tableCellRenderer instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellRenderer)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellRenderer)).setConverterContext(this.getConverterContextAt(n, n2));
            }
            if (tableCellRenderer instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellRenderer)).setEditorContext(editorContext);
            }
            if (tableCellRenderer instanceof DynamicValueCellRenderer) {
                ((DynamicValueCellRenderer)tableCellRenderer).setRowIndex(n);
                ((DynamicValueCellRenderer)tableCellRenderer).setColumnIndex(n2);
                ((DynamicValueCellRenderer)tableCellRenderer).setValueProvider((CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class)));
            }
        }
        return tableCellRenderer;
    }

    private TableCellRenderer getCellRendererFromCache(Class<?> clazz, EditorContext editorContext) {
        Object object;
        if (editorContext == null) {
            editorContext = EditorContext.DEFAULT_CONTEXT;
        }
        if ((object = _rendererCache.getMatchRegisteredObject(clazz, editorContext)) != null && object instanceof TableCellRenderer) {
            return (TableCellRenderer)object;
        }
        TableCellRenderer tableCellRenderer = CellRendererManager.getRenderer(clazz, editorContext);
        if (tableCellRenderer != null) {
            _rendererCache.register(clazz, tableCellRenderer, editorContext);
        }
        return tableCellRenderer;
    }

    public void invalidateCellRendererCache() {
        if (_rendererCache != null) {
            _rendererCache.clear();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.invalidateCellRendererCache();
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        TableColumn tableColumn;
        TableCellEditor tableCellEditor = null;
        if (this.isCellEditorManagerEnabled()) {
            if (n2 >= 0 && n2 < this.getColumnModel().getColumnCount()) {
                tableColumn = this.getColumnModel().getColumn(n2);
                tableCellEditor = tableColumn.getCellEditor();
            }
            if (tableCellEditor == null && this.getModel() instanceof ContextSensitiveTableModel) {
                tableCellEditor = this.getCellEditorFromManager(n, n2);
            }
        }
        if (tableCellEditor == null && (tableCellEditor = (tableColumn = this.getColumnModel().getColumn(n2)).getCellEditor()) == null) {
            tableCellEditor = this.getDefaultEditor(this.getCellClassAt(n, n2));
        }
        return tableCellEditor;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        int n3;
        if (tableCellEditor instanceof EditorStyleSupport && this.getModel() instanceof EditorStyleTableModel && ((EditorStyleSupport)((Object)tableCellEditor)).isEditorStyleSupported(n3 = ((EditorStyleTableModel)((Object)this.getModel())).getEditorStyleAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2)))) {
            ((EditorStyleSupport)((Object)tableCellEditor)).setEditorStyle(n3);
        }
        return super.prepareEditor(tableCellEditor, n, n2);
    }

    protected TableCellEditor getCellEditorFromManager(final int n, final int n2) {
        TableCellEditor tableCellEditor = null;
        Class<?> clazz = this.getCellClassAt(n, n2);
        if (clazz != null) {
            CellEditorValueProvider cellEditorValueProvider;
            EditorContext editorContext = this.getEditorContextAt(n, n2);
            if (EditorContext.DEFAULT_CONTEXT_DYNAMIC_VALUE.equals(editorContext) && (cellEditorValueProvider = (CellEditorValueProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getModel(), CellEditorValueProvider.class))) != null) {
                tableCellEditor = new ListComboBoxCellEditor(cellEditorValueProvider.getPossibleValues(n, n2), clazz){
                    private static final long serialVersionUID = 6796931878361962037L;

                    @Override
                    protected ListExComboBox createListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
                        ListExComboBox listExComboBox = new ListExComboBox(comboBoxModel, clazz);
                        listExComboBox.setConverter(cellEditorValueProvider.getConverter(n, n2));
                        listExComboBox.setEditable(false);
                        return listExComboBox;
                    }
                };
            }
            if (tableCellEditor == null) {
                tableCellEditor = (TableCellEditor)CellEditorManager.getEditor(clazz, editorContext);
            }
            if (tableCellEditor instanceof ConverterContextSupport) {
                ((ConverterContextSupport)((Object)tableCellEditor)).setType(clazz);
                ((ConverterContextSupport)((Object)tableCellEditor)).setConverterContext(this.getConverterContextAt(n, n2));
            }
            if (tableCellEditor instanceof EditorContextSupport) {
                ((EditorContextSupport)((Object)tableCellEditor)).setEditorContext(editorContext);
            }
        }
        return tableCellEditor;
    }

    public boolean isCellEditorManagerEnabled() {
        return this._cellEditorManagerEnabled;
    }

    public void setCellEditorManagerEnabled(boolean bl) {
        this._cellEditorManagerEnabled = bl;
    }

    boolean isApplyColumnCellRenderer(int n) {
        return true;
    }

    public boolean isCellRendererManagerEnabled() {
        return this._cellRendererManagerEnabled;
    }

    public void setCellRendererManagerEnabled(boolean bl) {
        this._cellRendererManagerEnabled = bl;
    }

    public TableCellRenderer getDefaultCellRenderer() {
        return this._defaultCellRenderer;
    }

    public void setDefaultCellRenderer(TableCellRenderer tableCellRenderer) {
        this._defaultCellRenderer = tableCellRenderer;
    }

    public ConverterContext getConverterContextAt(int n, int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getConverterContextAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
        }
        return null;
    }

    public EditorContext getEditorContextAt(int n, int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getEditorContextAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
        }
        return null;
    }

    public Class<?> getCellClassAt(int n, int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getCellClassAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
        }
        return tableModel.getColumnClass(this.convertColumnIndexToModel(n2));
    }

    @Override
    protected String convertElementToString(Object object, int n, int n2) {
        return ObjectConverterManager.toString(object, this.getCellClassAt(n, n2), this.getConverterContextAt(n, n2));
    }
}

