/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Property;
import com.jidesoft.introspector.BeanIntrospector;
import com.jidesoft.introspector.BeanProperty;
import com.jidesoft.introspector.Introspector;
import com.jidesoft.introspector.IntrospectorContext;
import com.jidesoft.introspector.IntrospectorManager;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class BasicTableModel<T>
extends AbstractTableModel
implements ContextSensitiveTableModel,
PropertyChangeListener {
    private List<T> _objects;
    private Introspector _introspector;
    private String[] _propertyNames;
    private transient Property[] _properties;
    private Method _addPropertyChangeListenerMethod;
    private boolean _addChecked = false;
    private Method _removePropertyChangeListenerMethod;
    private boolean _removeChecked = false;
    private boolean _editable = true;
    private PropertyChangeSupport _changeSupport;
    public static final String PROPERTY_EDITABLE = "editable";
    private static final long serialVersionUID = -4884343983492377717L;

    public BasicTableModel() {
        this(new ArrayList(), Object.class);
    }

    public BasicTableModel(List<T> list, Class<?> clazz) {
        this(list, IntrospectorManager.getIntrospector(clazz));
    }

    public BasicTableModel(List<T> list, Class<?> clazz, IntrospectorContext introspectorContext) {
        this(list, IntrospectorManager.getIntrospector(clazz, introspectorContext));
    }

    public BasicTableModel(List<T> list, Class<?> clazz, String[] stringArray) throws IntrospectionException {
        this(list, new BeanIntrospector(clazz, stringArray, 2));
    }

    public BasicTableModel(List<T> list, Introspector introspector) {
        this._objects = list;
        this._introspector = introspector;
        this._propertyNames = this._introspector.getPropertyNames();
    }

    @Override
    public int getRowCount() {
        return this._objects.size();
    }

    public T getObject(int n) {
        return n >= 0 && n < this._objects.size() ? (T)this._objects.get(n) : null;
    }

    public void setObject(T t, int n) {
        if (n >= 0 && n < this._objects.size()) {
            T t2 = this._objects.set(n, t);
            if (t2 != t) {
                try {
                    if (this.isEditable()) {
                        this.uninstallListener(t2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.isEditable()) {
                        this.installListener(t);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fireTableRowsUpdated(n, n);
        }
    }

    public int indexOf(T t) {
        return this._objects != null ? this._objects.indexOf(t) : -1;
    }

    public void addObject(T t) {
        this.addObject(-1, t, true);
    }

    public void addObject(int n, T t) {
        this.addObject(n, t, true);
    }

    private void addObject(int n, T t, boolean bl) {
        if (n == -1) {
            this._objects.add(t);
        } else {
            this._objects.add(n, t);
        }
        try {
            if (this.isEditable()) {
                this.installListener(t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            if (n == -1) {
                this.fireTableRowsInserted(this._objects.size() - 1, this._objects.size() - 1);
            } else {
                this.fireTableRowsInserted(n, n);
            }
        }
    }

    public void removeObject(T t) {
        int n = this.indexOf(t);
        if (n != -1) {
            this.removeObject(n);
        }
    }

    public void removeObject(int n) {
        if (n != -1) {
            T t = this._objects.remove(n);
            try {
                if (this.isEditable()) {
                    this.uninstallListener(t);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void addObjects(List<T> list) {
        int n = this.getRowCount();
        for (T t : list) {
            this.addObject(-1, t, false);
        }
        int n2 = this.getRowCount();
        if (n2 > n) {
            this.fireTableRowsInserted(n, n2 - 1);
        }
    }

    public void clear() {
        int n = this.getRowCount();
        if (n > 0) {
            try {
                this.unbind(this._objects);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._objects.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    @Override
    public int getColumnCount() {
        return this._introspector.getPropertyCount();
    }

    public Property getPropertyAt(int n) {
        Property property;
        if (this._properties == null) {
            this._properties = new Property[this.getColumnCount()];
        }
        if ((property = this._properties[n]) == null) {
            this._properties[n] = property = this._introspector.getProperty(this._propertyNames[n]);
        }
        return property;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.getPropertyAt(n2);
        this.prepareProperty(property, n, n2);
        return property.getValue();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Property property = this.getPropertyAt(n2);
        this.prepareProperty(property, n, n2);
        property.setValue(object);
        this.fireTableCellUpdated(n, n2);
    }

    protected void prepareProperty(Property property, int n, int n2) {
        if (property instanceof BeanProperty) {
            ((BeanProperty)property).setInstance(this.getObject(n));
        }
    }

    @Override
    public String getColumnName(int n) {
        Property property = this.getPropertyAt(n);
        String string = property.getDisplayName();
        return string != null ? string : this._propertyNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Property property = this.getPropertyAt(n);
        return property.getType();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isEditable()) {
            return false;
        }
        Property property = this.getPropertyAt(n2);
        return property.isEditable();
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        Property property = this.getPropertyAt(n2);
        return property.getConverterContext();
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        Property property = this.getPropertyAt(n2);
        return property.getEditorContext();
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return this.getColumnClass(n2);
    }

    public void bind(List<T> list) throws Exception {
        for (T t : list) {
            this.installListener(t);
        }
    }

    public void unbind(List<T> list) throws Exception {
        for (T t : list) {
            this.uninstallListener(t);
        }
    }

    protected void installListener(T t) throws Exception {
        if (t != null) {
            if (!this._addChecked && this._addPropertyChangeListenerMethod == null) {
                this._addChecked = true;
                this._addPropertyChangeListenerMethod = t.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            }
            if (this._addPropertyChangeListenerMethod != null) {
                this._addPropertyChangeListenerMethod.invoke(t, this);
            }
        }
    }

    protected void uninstallListener(T t) throws Exception {
        if (t != null) {
            if (!this._removeChecked && this._removePropertyChangeListenerMethod == null) {
                this._removeChecked = true;
                this._removePropertyChangeListenerMethod = t.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            }
            if (this._removePropertyChangeListenerMethod != null) {
                this._removePropertyChangeListenerMethod.invoke(t, this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = this.indexOf(propertyChangeEvent.getSource());
        if (n != -1) {
            for (int i = 0; i < this._propertyNames.length; ++i) {
                String string = this._propertyNames[i];
                if (!string.equalsIgnoreCase(propertyChangeEvent.getPropertyName())) continue;
                this.fireTableCellUpdated(n, i);
                break;
            }
        }
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        this._properties = null;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            boolean bl2 = this._editable;
            this._editable = bl;
            this.firePropertyChange(PROPERTY_EDITABLE, bl2, this._editable);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        if (propertyChangeSupport == null || object == object2) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(BasicTableModel.class.getName(), 4);
        }
    }
}

