/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.RendererWrapper;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableFilter;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TextFieldCellEditor;
import com.jidesoft.grid.ValueProvider;
import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import com.jidesoft.hints.ListDataIntelliHints;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

@Deprecated
public class AutoFilterUtils {
    protected JideTable _mainTable;
    protected JideTable _filterTable;
    protected IFilterableTableModel _filterableTableModel;
    private JViewport _subRowHeadViewport;
    private Object[] _filterableColumnIdentifiers;
    private PropertyChangeListener _tablePropertyListener;
    private PropertyChangeListener _headerPropertyListener;
    private MouseAdapter _headerMouseListener;
    private boolean _objectConverterManagerEnabled = false;
    private boolean _objectConverterManagerEnabledConfigured = false;
    private TableModel _tableModel;
    private boolean _intelliHintsEnabled = true;
    private boolean _createFilterableTableModel;
    private int _searchingDelay = 200;
    private CellStyle _cellStyle;
    private Color _filterRowBackground;
    private boolean _filtering;

    public JideScrollPane install(JideTable jideTable) {
        this._mainTable = jideTable;
        JideScrollPane jideScrollPane = jideTable.getParent() instanceof JViewport && jideTable.getParent().getParent() instanceof JideScrollPane ? (JideScrollPane)jideTable.getParent().getParent() : new JideScrollPane(jideTable);
        this.installComponents(jideScrollPane);
        return jideScrollPane;
    }

    public void uninstall(JideTable jideTable) {
        if (this._mainTable != jideTable) {
            return;
        }
        if (jideTable.getParent() instanceof JViewport && jideTable.getParent().getParent() instanceof JideScrollPane) {
            this.uninstallComponents((JideScrollPane)jideTable.getParent().getParent());
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return null;
    }

    protected IFilterableTableModel createDefaultFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel);
        }
        return new FilterableTableModel(tableModel);
    }

    protected TableModel createAutoFilterRowTableModel() {
        return new AutoFilterRowTableModel();
    }

    protected JideTable createAutoFilterRowTable(TableModel tableModel) {
        return new AutoFilterRowTable(tableModel);
    }

    private void installComponents(JideScrollPane jideScrollPane) {
        this.setFilterRowBackground(new Color(253, 253, 244));
        this._cellStyle = new CellStyle();
        TableModel tableModel = this.createAutoFilterRowTableModel();
        this._filterTable = this.createAutoFilterRowTable(tableModel);
        this._filterTable.setNonContiguousCellSelection(true);
        this._filterTable.setAutoStartCellEditing(true);
        this._filterTable.setAlwaysRequestFocusForEditor(true);
        this._filterTable.getActionMap().put("cancel", new AbstractAction(){
            private static final long serialVersionUID = -9146520539920704887L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AutoFilterUtils.this._filterTable.isEditing()) {
                    return;
                }
                ((TextFieldCellEditor)AutoFilterUtils.this._filterTable.getCellEditor())._textField.setText("");
            }
        });
        this._filterTable.setCursor(Cursor.getPredefinedCursor(2));
        jideScrollPane.setSubColumnHeaderView(this._filterTable);
        this._subRowHeadViewport = jideScrollPane.getSubColumnHeader();
        this._subRowHeadViewport.setPreferredSize(new Dimension(this._mainTable.getPreferredSize().width, this._mainTable.getRowHeight()));
        this._tableModel = this._mainTable.getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(this._tableModel, IExpandableTreeTableModel.class);
        TableModel tableModel3 = this.createFilterableTableModel(this._tableModel);
        this._createFilterableTableModel = true;
        if (tableModel3 == null && (tableModel3 = TableModelWrapperUtils.getActualTableModel(this._tableModel, IFilterableTableModel.class)) != null) {
            this._createFilterableTableModel = false;
        }
        this._filterableTableModel = tableModel2 != null && tableModel3 instanceof FilterableTreeTableModel ? tableModel3 : (tableModel2 == null && tableModel3 instanceof IFilterableTableModel ? tableModel3 : this.createDefaultFilterableTableModel(this._tableModel));
        if (this._createFilterableTableModel) {
            this._mainTable.setModel(this._filterableTableModel);
        }
        if (this._filterableTableModel != null) {
            this._filterableTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (AutoFilterUtils.this._filtering || !(tableModelEvent instanceof CompoundTableModelEvent) || ((CompoundTableModelEvent)tableModelEvent).isOriginalChanged()) {
                        return;
                    }
                    AutoFilterUtils.this.updateRowTableFromFilters();
                }
            });
        }
        jideScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.synchronizeTable();
    }

    private void updateRowTableFromFilters() {
        if (this._filterableTableModel == null) {
            return;
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._filterTable.getModel(), AutoFilterRowTableModel.class);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Filter[] filterArray = this._filterableTableModel.getFilters(i);
            String string = "";
            for (Filter filter : filterArray) {
                if (!(filter instanceof TableWildcardFilter)) continue;
                string = ((TableWildcardFilter)filter).getPattern();
            }
            if (JideSwingUtilities.equals(tableModel.getValueAt(0, i), string)) continue;
            tableModel.setValueAt(string, 0, i);
        }
    }

    private void uninstallComponents(JideScrollPane jideScrollPane) {
        this.unsynchronizeTable();
        if (this._mainTable.getModel() == this._filterableTableModel && this._createFilterableTableModel) {
            this._mainTable.setModel(this._tableModel);
        }
        this._filterableTableModel = null;
        jideScrollPane.remove(this._subRowHeadViewport);
        this._subRowHeadViewport = null;
        this._filterTable = null;
    }

    private void synchronizeTable() {
        this._filterTable.setAutoResizeMode(this._mainTable.getAutoResizeMode());
        TableUtils.synchronizeTableColumn(this._mainTable, this._filterTable, false);
        TableUtils.synchronizeTableColumnWidthNow(this._mainTable, this._filterTable);
        JTable[] jTableArray = new JTable[]{this._filterTable, this._mainTable};
        TableUtils.unifyTableCellSelection(jTableArray, this._mainTable);
        TableUtils.unifyTableCellEditing(jTableArray);
        TableUtils.synchronizeNavigationKeysForVerticalTables(jTableArray);
        this._headerPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("draggedColumn".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() instanceof TableColumn) {
                        int n = ((TableColumn)propertyChangeEvent.getNewValue()).getModelIndex();
                        int n2 = AutoFilterUtils.this._filterTable.convertColumnIndexToView(n);
                        TableColumn tableColumn = AutoFilterUtils.this._filterTable.getColumnModel().getColumn(n2);
                        AutoFilterUtils.this._filterTable.getTableHeader().setDraggedColumn(tableColumn);
                    } else {
                        AutoFilterUtils.this._filterTable.getTableHeader().setDraggedColumn(null);
                    }
                    AutoFilterUtils.this._filterTable.invalidate();
                    AutoFilterUtils.this._filterTable.repaint();
                } else if ("draggedDistance".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this._filterTable.getTableHeader().setDraggedDistance((Integer)propertyChangeEvent.getNewValue());
                    AutoFilterUtils.this._filterTable.invalidate();
                    AutoFilterUtils.this._filterTable.repaint();
                }
            }
        };
        this._tablePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("autoResizeMode".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this._filterTable.setAutoResizeMode((Integer)propertyChangeEvent.getNewValue());
                } else if ("tableHeader".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this.installTableHeaderListener();
                } else if ("showHorizontalLines".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this._filterTable.setShowHorizontalLines(AutoFilterUtils.this._mainTable.getShowHorizontalLines());
                } else if ("showVerticalLines".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this._filterTable.setShowVerticalLines(AutoFilterUtils.this._mainTable.getShowVerticalLines());
                } else if ("gridColor".equals(propertyChangeEvent.getPropertyName())) {
                    AutoFilterUtils.this._filterTable.setGridColor(AutoFilterUtils.this._mainTable.getGridColor());
                }
            }
        };
        this._headerMouseListener = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                AutoFilterUtils.this._filterTable.getSelectionModel().clearSelection();
                AutoFilterUtils.this._filterTable.getColumnModel().getSelectionModel().clearSelection();
                AutoFilterUtils.this._filterTable.getTableSelectionModel().clearSelection();
                if (AutoFilterUtils.this._filterTable.isEditing()) {
                    AutoFilterUtils.this._filterTable.getCellEditor().stopCellEditing();
                }
                AutoFilterUtils.this._mainTable.requestFocus();
            }
        };
        this._mainTable.addPropertyChangeListener(this._tablePropertyListener);
        this.installTableHeaderListener();
        this._filterTable.setClickCountToStart(1);
        this._filterTable.setShowHorizontalLines(this._mainTable.getShowHorizontalLines());
        this._filterTable.setShowVerticalLines(this._mainTable.getShowVerticalLines());
        this._filterTable.setGridColor(this._mainTable.getGridColor());
    }

    private void unsynchronizeTable() {
        TableUtils.unsynchronizeTableColumn(this._mainTable, this._filterTable);
        JTable[] jTableArray = new JTable[]{this._mainTable, this._filterTable};
        TableUtils.ununifyTableCellSelection(jTableArray);
        TableUtils.ununifyTableCellEditing(jTableArray);
        TableUtils.unsynchronizeNavigationKeysForVerticalTables(jTableArray);
        this._mainTable.removePropertyChangeListener(this._tablePropertyListener);
        this._mainTable.getTableHeader().removePropertyChangeListener(this._headerPropertyListener);
        this._mainTable.getTableHeader().removeMouseListener(this._headerMouseListener);
        if (SystemInfo.isJdk6Above()) {
            this._mainTable.getTableHeader().removeMouseMotionListener(this._headerMouseListener);
        }
        this._tablePropertyListener = null;
        this._headerPropertyListener = null;
        this._headerMouseListener = null;
    }

    protected String convertElementToString(int n, Object object) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._filterableTableModel, ContextSensitiveTableModel.class);
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ObjectConverterManager.toString(object, ((ContextSensitiveTableModel)tableModel).getCellClassAt(0, n), ((ContextSensitiveTableModel)tableModel).getConverterContextAt(0, n));
        }
        return "" + object;
    }

    private void installTableHeaderListener() {
        this._mainTable.getTableHeader().addPropertyChangeListener(this._headerPropertyListener);
        this._mainTable.getTableHeader().addMouseListener(this._headerMouseListener);
        if (SystemInfo.isJdk6Above()) {
            this._mainTable.getTableHeader().addMouseMotionListener(this._headerMouseListener);
        }
    }

    protected TableFilter createFilter(String string) {
        TableWildcardFilter tableWildcardFilter = new TableWildcardFilter(string);
        tableWildcardFilter.setBeginWith(false);
        tableWildcardFilter.setEndWith(false);
        tableWildcardFilter.setCaseSensitive(false);
        return tableWildcardFilter;
    }

    public boolean isObjectConverterManagerEnabled() {
        return this._objectConverterManagerEnabled;
    }

    public void setObjectConverterManagerEnabled(boolean bl) {
        this._objectConverterManagerEnabled = bl;
        this._objectConverterManagerEnabledConfigured = true;
    }

    private boolean needConvert() {
        if (!this._objectConverterManagerEnabledConfigured) {
            return this._tableModel instanceof ContextSensitiveTableModel;
        }
        return this.isObjectConverterManagerEnabled() && this._tableModel instanceof ContextSensitiveTableModel;
    }

    protected String convertElementToString(Object object, int n, int n2) {
        if (this.needConvert() && this._filterableTableModel instanceof TableModelWrapper && ((TableModelWrapper)((Object)this._filterableTableModel)).getActualModel() instanceof ContextSensitiveTableModel) {
            int n3;
            GrouperContext grouperContext;
            ObjectGrouper objectGrouper;
            ConverterContext converterContext = ((ContextSensitiveTableModel)((TableModelWrapper)((Object)this._filterableTableModel)).getActualModel()).getConverterContextAt(n, n2);
            Class<?> clazz = ((ContextSensitiveTableModel)((TableModelWrapper)((Object)this._filterableTableModel)).getActualModel()).getCellClassAt(n, n2);
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._filterableTableModel, GroupableTableModel.class);
            if (tableModel instanceof GroupableTableModel && (objectGrouper = ObjectGrouperManager.getGrouper(clazz, grouperContext = ((GroupableTableModel)tableModel).getGrouperContext(n3 = TableModelWrapperUtils.getActualColumnAt(((TableModelWrapper)((Object)this._filterableTableModel)).getActualModel(), n2, tableModel)))) != null) {
                clazz = objectGrouper.getType();
                converterContext = objectGrouper.getConverterContext();
            }
            return ObjectConverterManager.toString(object, clazz, converterContext);
        }
        return this.convertElementToString(object);
    }

    protected String convertElementToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private void applyFilter(Object object, int n) {
        n = this._mainTable.convertColumnIndexToModel(n);
        this._filterableTableModel.removeAllFilters(n);
        if (object != null && object.toString().length() != 0 && object instanceof String) {
            this._filterableTableModel.addFilter(n, this.createFilter((String)object));
        }
        this._filtering = true;
        try {
            this._filterableTableModel.setFiltersApplied(true);
        }
        finally {
            this._filtering = false;
        }
    }

    public Object[] getFilterableColumnIdentifiers() {
        return this._filterableColumnIdentifiers;
    }

    public void setFilterableColumnIdentifiers(Object[] objectArray) {
        this._filterableColumnIdentifiers = objectArray;
    }

    public boolean isIntelliHintsEnabled() {
        return this._intelliHintsEnabled;
    }

    public void setIntelliHintsEnabled(boolean bl) {
        this._intelliHintsEnabled = bl;
    }

    public int getSearchingDelay() {
        return this._searchingDelay;
    }

    public void setSearchingDelay(int n) {
        this._searchingDelay = n;
    }

    public Color getFilterRowBackground() {
        return this._filterRowBackground;
    }

    public void setFilterRowBackground(Color color) {
        this._filterRowBackground = color;
    }

    private class FilterListener
    implements DocumentListener,
    ActionListener {
        private Timer timer;

        private FilterListener() {
            this.timer = new Timer(AutoFilterUtils.this.getSearchingDelay(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilterListener.this.applyFilter();
                }
            });
        }

        private void applyFilter() {
            if (!AutoFilterUtils.this._filterTable.isEditing()) {
                return;
            }
            AutoFilterUtils.this.applyFilter(AutoFilterUtils.this._filterTable.getCellEditor().getCellEditorValue(), AutoFilterUtils.this._filterTable.getEditingColumn());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.applyFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.startTimer();
        }

        void startTimer() {
            if (AutoFilterUtils.this.getSearchingDelay() > 0) {
                this.timer.setInitialDelay(AutoFilterUtils.this.getSearchingDelay());
                if (this.timer.isRunning()) {
                    this.timer.restart();
                } else {
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else if (AutoFilterUtils.this.getSearchingDelay() == 0) {
                this.applyFilter();
            }
        }
    }

    protected class TableWildcardFilter
    extends WildcardFilter
    implements TableFilter {
        protected int _rowIndex;
        protected int _columnIndex;
        protected ValueProvider _valueProvider;
        private static final long serialVersionUID = 8557612591275627332L;

        public TableWildcardFilter(String string) {
            super(string);
        }

        @Override
        public void setValueProvider(ValueProvider valueProvider) {
            this._valueProvider = valueProvider;
        }

        @Override
        public ValueProvider getValueProvider() {
            return this._valueProvider;
        }

        @Override
        public void setColumnIndex(int n) {
            this._columnIndex = n;
        }

        @Override
        public void setRowIndex(int n) {
            this._rowIndex = n;
        }

        @Override
        public int getColumnIndex() {
            return this._columnIndex;
        }

        @Override
        public int getRowIndex() {
            return this._rowIndex;
        }

        @Override
        protected String convertElementToString(Object object) {
            if (this.getObjectGrouper() != null) {
                object = this.getObjectGrouper().getValue(object);
            }
            return AutoFilterUtils.this.convertElementToString(object, this._rowIndex, this._columnIndex);
        }
    }

    protected class AutoFilterRowTable
    extends CellStyleTable {
        public AutoFilterRowTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            AutoFilterUtils.this.applyFilter(object, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            return new TextFieldCellEditor(String.class){
                private static final long serialVersionUID = 427326269521380409L;

                @Override
                protected void customizeTextField() {
                    super.customizeTextField();
                    FilterListener filterListener = new FilterListener();
                    this._textField.getDocument().addDocumentListener(filterListener);
                    this._textField.addActionListener(filterListener);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AutoFilterRowTable.this.editingColumn;
                    super.actionPerformed(actionEvent);
                    n = (n + 1) % AutoFilterRowTable.this.getColumnCount();
                    AutoFilterRowTable.this.editCellAt(0, n);
                }
            };
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Object object = this.getValueAt(n, n2);
            boolean bl = this.isCellFocused(n, n2);
            boolean bl2 = (this.isNonContiguousCellSelection() && !this.isTablePrinting() || !this.isNonContiguousCellSelection() && (!SystemInfo.isJdk6Above() || !this.isPaintingForPrint())) && this.isCellSelected(n, n2);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, object, bl2, bl, n, n2);
            if (component != null) {
                if (!this.isEnableIgnored() && !this.isEnabled()) {
                    component.setEnabled(false);
                }
                if (component instanceof RendererWrapper && ((RendererWrapper)((Object)component)).getActualRenderer() != null && !component.isEnabled()) {
                    ((RendererWrapper)((Object)component)).getActualRenderer().setEnabled(false);
                }
            }
            return component;
        }

        @Override
        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            Object object;
            final Component component = super.prepareEditor(tableCellEditor, n, n2);
            if (component != null && AutoFilterUtils.this.isIntelliHintsEnabled() && (object = this.getTextComponentForEditorComponent(component)) instanceof JTextComponent) {
                Object[] objectArray;
                ArrayList<String> arrayList = new ArrayList<String>();
                n2 = this.convertColumnIndexToModel(n2);
                Comparator comparator = ObjectComparatorManager.getComparator(AutoFilterUtils.this._filterableTableModel.getColumnClass(n2));
                for (Object object2 : objectArray = AutoFilterUtils.this._filterableTableModel.getPossibleValues(n2, comparator)) {
                    arrayList.add(AutoFilterUtils.this.convertElementToString(object2, 0, n2));
                }
                new ListDataIntelliHints((JTextComponent)object, arrayList);
            }
            if (component != null) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocus();
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
            return component;
        }

        @Override
        void inheritEditingFieldsFrom(JideTable jideTable) {
            super.inheritEditingFieldsFrom(jideTable);
            if (!this._cellEditingStartedByKey && !this._cellEditingStartedByF2Key) {
                this._cellEditingStartedByKey = true;
            }
            if (this._editingKeyEvent == null) {
                this._editingKeyEvent = new KeyEvent(this, 401, System.currentTimeMillis(), 0, 9, '\t');
            }
        }

        @Override
        public void removeEditor() {
            if (this.getCellEditor() != null && this.getEditingRow() == 0 && this.getEditingColumn() >= 0 && this.getEditingColumn() < this.getColumnCount()) {
                this.setValueAt(this.getCellEditor().getCellEditorValue(), this.getEditingRow(), this.getEditingColumn());
            }
            super.removeEditor();
        }
    }

    protected class AutoFilterRowTableModel
    extends DefaultTableModel
    implements ContextSensitiveTableModel,
    ColumnIdentifierTableModel,
    StyleModel {
        private static final long serialVersionUID = 4312897337838996477L;

        protected AutoFilterRowTableModel() {
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return AutoFilterUtils.this._mainTable.getModel().getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            if (n < 0 || n >= AutoFilterUtils.this._mainTable.getColumnCount()) {
                return "";
            }
            return AutoFilterUtils.this._mainTable.getColumnName(n);
        }

        @Override
        public Object getColumnIdentifier(int n) {
            TableModel tableModel;
            if (AutoFilterUtils.this._mainTable != null && (tableModel = TableModelWrapperUtils.getActualTableModel(AutoFilterUtils.this._mainTable.getModel(), ColumnIdentifierTableModel.class)) instanceof ColumnIdentifierTableModel) {
                int n2 = TableModelWrapperUtils.getActualColumnAt(AutoFilterUtils.this._mainTable.getModel(), n, tableModel);
                return ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(n2);
            }
            return this.getColumnName(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (AutoFilterUtils.this._filterableColumnIdentifiers == null) {
                return true;
            }
            Object object = this.getColumnIdentifier(n2);
            for (Object object2 : AutoFilterUtils.this._filterableColumnIdentifiers) {
                if (object2 == null || !object2.equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ConverterContext getConverterContextAt(int n, int n2) {
            return null;
        }

        @Override
        public EditorContext getEditorContextAt(int n, int n2) {
            return null;
        }

        @Override
        public Class<?> getCellClassAt(int n, int n2) {
            return String.class;
        }

        @Override
        public CellStyle getCellStyleAt(int n, int n2) {
            AutoFilterUtils.this._cellStyle.setHorizontalAlignment(-1);
            AutoFilterUtils.this._cellStyle.setBackground(AutoFilterUtils.this.getFilterRowBackground());
            return AutoFilterUtils.this._cellStyle;
        }

        @Override
        public boolean isCellStyleOn() {
            return true;
        }
    }
}

