/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeaderRenderer;
import com.jidesoft.grid.AutoFilterUtils;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class AutoFillTableViewport
extends JViewport
implements TableColumnModelListener,
PropertyChangeListener,
ListSelectionListener {
    private JTable _table;

    public AutoFillTableViewport(JTable jTable) {
        this._table = jTable;
        this.installListeners();
    }

    private void installListeners() {
        if (this._table == null) {
            return;
        }
        this._table.getColumnModel().addColumnModelListener(this);
        this._table.getSelectionModel().addListSelectionListener(this);
        if (this._table.getTableHeader() != null) {
            this._table.getTableHeader().addPropertyChangeListener("draggedColumn", this);
            this._table.getTableHeader().addPropertyChangeListener("draggedDistance", this);
        }
        this._table.addPropertyChangeListener(this);
    }

    @Override
    public void setView(Component component) {
        if (this._table != component) {
            this.uninstallListeners();
            this._table = null;
        }
        super.setView(component);
        if (this._table != component && component instanceof JTable) {
            this.uninstallListeners();
            this._table = (JTable)component;
            this.installListeners();
        }
    }

    void uninstallListeners() {
        if (this._table == null) {
            return;
        }
        this._table.getColumnModel().removeColumnModelListener(this);
        this._table.getSelectionModel().removeListSelectionListener(this);
        if (this._table.getTableHeader() instanceof DraggingTableHeader) {
            this._table.getTableHeader().removePropertyChangeListener("draggedColumn", this);
            this._table.getTableHeader().removePropertyChangeListener("draggedDistance", this);
        }
        this._table.removePropertyChangeListener(this);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (SystemInfo.isJdk6Above() && this.isPreferredSizeSet()) {
            return dimension;
        }
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof JTable) {
            Object object = ((JTable)this.getComponent(0)).getClientProperty("TableScrollPane.Parent");
            if (!(object instanceof TableScrollPane) || ((TableScrollPane)object).getMainTable() == this.getComponent(0)) {
                return dimension;
            }
            Dimension dimension2 = this.getComponent(0).getPreferredSize();
            if (dimension2.height < dimension.height) {
                return new Dimension(dimension.width, dimension2.height);
            }
        }
        return dimension;
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._table instanceof CellStyleTable && ((CellStyleTable)this._table).isFillsSelection()) {
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 instanceof TableColumnModel) {
                ((TableColumnModel)object2).removeColumnModelListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof TableColumnModel) {
                ((TableColumnModel)object).removeColumnModelListener(this);
                ((TableColumnModel)object).addColumnModelListener(this);
            }
        } else if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object3 = propertyChangeEvent.getOldValue();
            if (object3 instanceof ListSelectionModel) {
                ((ListSelectionModel)object3).removeListSelectionListener(this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof ListSelectionModel) {
                ((ListSelectionModel)object).removeListSelectionListener(this);
                ((ListSelectionModel)object).addListSelectionListener(this);
            }
        } else if ("tableHeader".equals(propertyChangeEvent.getPropertyName())) {
            Object object;
            Object object4 = propertyChangeEvent.getOldValue();
            if (object4 instanceof DraggingTableHeader) {
                ((DraggingTableHeader)object4).removePropertyChangeListener("draggedColumn", this);
                ((DraggingTableHeader)object4).removePropertyChangeListener("draggedDistance", this);
            }
            if ((object = propertyChangeEvent.getNewValue()) instanceof DraggingTableHeader) {
                ((DraggingTableHeader)object).addPropertyChangeListener("draggedColumn", this);
                ((DraggingTableHeader)object).addPropertyChangeListener("draggedDistance", this);
            }
        } else if ("draggedColumn".equals(propertyChangeEvent.getPropertyName()) || "draggedDistance".equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._table != null) {
            this.paintStripedBackground(graphics);
            this.paintHorizontalGridLines(graphics);
            this.paintVerticalGridLines(graphics);
        }
    }

    @Override
    public void setViewPosition(Point point) {
        super.setViewPosition(point);
        this.repaint();
    }

    private int viewIndexForColumn(TableColumn tableColumn, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintStripedBackground(Graphics graphics) {
        int n;
        Color color = graphics.getColor();
        Point point = this.getViewPosition();
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.y = 0;
        rectangle.height = this.getHeight();
        Point point2 = rectangle.getLocation();
        int n2 = this._table.rowAtPoint(new Point(point.x + point2.x, point.y + point2.y));
        int n3 = rectangle.y;
        int n4 = this._table.getRowHeight();
        if (n2 >= 0) {
            n4 = this._table.getRowHeight(n2) - (n3 + point.y - this._table.getCellRect((int)n2, (int)0, (boolean)false).y);
        }
        int n5 = n = this._table.getHeight() <= 0 ? 0 : this._table.getX() + this._table.getWidth();
        if (this._table instanceof CellStyleTable && ((CellStyleTable)this._table).isFillsViewportWithStripe()) {
            int n6;
            int n7;
            int n8;
            int n9 = n8 = n2 < 0 ? 0 : n2;
            if (((JideTable)this._table).isFillsRight()) {
                while (n3 < rectangle.y + rectangle.height && n8 < this._table.getRowCount()) {
                    n7 = n3 + n4;
                    graphics.setColor(((CellStyleTable)this._table).getRowColor(n8));
                    n6 = n7 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0);
                    int n10 = n6 = this._table.getHeight() <= 0 ? n6 : Math.min(this._table.getY() + this._table.getHeight(), n6);
                    if (this.getComponentOrientation().isLeftToRight()) {
                        graphics.fillRect(n, n3, rectangle.x + rectangle.width - n, n6 - n3);
                    } else {
                        graphics.fillRect(0, n3, -point.x - 1, n6 - n3);
                    }
                    n3 = n7;
                    n4 = this._table.getRowHeight(++n8);
                }
            } else {
                n8 = this._table.getRowCount();
                n3 = this._table.getY() + this._table.getHeight();
            }
            if (((JideTable)this._table).isFillsBottom()) {
                n4 = this._table.getRowHeight();
                n7 = rectangle.x + rectangle.width;
                if (!((JideTable)this._table).isFillsRight()) {
                    n7 = Math.min(n7, this._table.getX() + this._table.getWidth() - 1);
                }
                while (n3 < rectangle.y + rectangle.height) {
                    int n11;
                    n6 = n3 + n4;
                    graphics.setColor(((CellStyleTable)this._table).getRowColor(n8));
                    JTableHeader jTableHeader = this._table.getTableHeader();
                    TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
                    boolean bl = true;
                    if (tableColumn != null && (n11 = this.viewIndexForColumn(tableColumn, this._table)) >= 0 && n11 < this._table.getColumnCount()) {
                        bl = false;
                        int n12 = jTableHeader.getDraggedDistance();
                        if (n12 > 0) {
                            n12 = Math.min(n12, tableColumn.getWidth());
                        } else if (n12 < 0) {
                            n12 = Math.max(n12, -tableColumn.getWidth());
                        }
                        Rectangle rectangle2 = jTableHeader.getHeaderRect(n11);
                        int n13 = n12 >= 0 ? rectangle2.x : rectangle2.x + rectangle2.width + n12;
                        int n14 = n12 >= 0 ? rectangle2.x + n12 : rectangle2.x + rectangle2.width;
                        n13 -= point.x;
                        n14 -= point.x;
                        if (((JideTable)this._table).isFillsRight()) {
                            if (this.getComponentOrientation().isLeftToRight()) {
                                n14 = Math.min(n14, this._table.getX() + this._table.getWidth() - 1);
                            } else {
                                n13 = Math.max(n13, -point.x);
                            }
                        }
                        if (n13 > rectangle.x) {
                            graphics.fillRect(rectangle.x, n3, n13 - rectangle.x, n6 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0));
                        }
                        if (n14 < rectangle.x + n7) {
                            graphics.fillRect(n14, n3, rectangle.x + n7 - n14, n6 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0));
                        }
                    }
                    if (bl) {
                        graphics.fillRect(rectangle.x, n3, n7, n6 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0));
                    }
                    n3 = n6;
                    ++n8;
                }
            }
        } else {
            boolean bl;
            graphics.setColor(this._table.getBackground());
            boolean bl2 = !(this._table instanceof JideTable) || ((JideTable)this._table).isFillsBottom();
            boolean bl3 = bl = !(this._table instanceof JideTable) || ((JideTable)this._table).isFillsRight();
            if (bl2) {
                if (bl) {
                    graphics.fillRect(rectangle.x, n3, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                } else if (rectangle.x < this._table.getX() + this._table.getWidth()) {
                    graphics.fillRect(rectangle.x, n3, Math.min(this._table.getX() + this._table.getWidth(), rectangle.x + rectangle.width), rectangle.y + rectangle.height);
                }
            } else if (bl && n3 < this._table.getY() + this._table.getHeight()) {
                graphics.fillRect(rectangle.x, n3, rectangle.x + rectangle.width, Math.min(this._table.getY() + this._table.getHeight(), rectangle.y + rectangle.height));
            }
            if (this._table instanceof CellStyleTable && ((JideTable)this._table).isFillsRight() && ((CellStyleTable)this._table).isFillsSelection()) {
                int n15;
                int n16 = n15 = n2 < 0 ? 0 : n2;
                while (n3 < rectangle.y + rectangle.height && n15 < this._table.getRowCount()) {
                    int n17 = n3 + n4;
                    if (this._table.getSelectionModel().isSelectedIndex(n15)) {
                        graphics.setColor(((CellStyleTable)this._table).getRowColor(n15));
                        int n18 = n17 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0);
                        n18 = this._table.getHeight() <= 0 ? n18 : Math.min(this._table.getY() + this._table.getHeight(), n18);
                        for (int i = n3; i < n18; ++i) {
                            if (this.getComponentOrientation().isLeftToRight()) {
                                graphics.drawLine(n, i, rectangle.x + rectangle.width, i);
                                continue;
                            }
                            if (point.x >= 0) continue;
                            graphics.drawLine(0, i, -point.x - 1, i);
                        }
                    }
                    n3 = n17;
                    n4 = this._table.getRowHeight(++n15);
                }
            }
        }
        graphics.setColor(color);
    }

    private void paintHorizontalGridLines(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this._table == null || !this._table.getShowHorizontalLines()) {
            return;
        }
        Color color = graphics.getColor();
        Point point = this.getViewPosition();
        Rectangle rectangle = graphics.getClipBounds();
        rectangle.y = 0;
        rectangle.height = this.getHeight();
        Point point2 = rectangle.getLocation();
        int n4 = this._table.rowAtPoint(new Point(point.x + point2.x, point.y + point2.y));
        int n5 = rectangle.y;
        int n6 = this._table.getRowHeight();
        if (n4 >= 0) {
            n6 = this._table.getRowHeight(n4) - (n5 + point.y - this._table.getCellRect((int)n4, (int)0, (boolean)false).y);
        }
        Color color2 = this._table.getGridColor();
        if (!(this._table instanceof JideTable) || ((JideTable)this._table).isFillsGridsRight()) {
            int n7 = n3 = n4 < 0 ? 0 : n4;
            while (n5 < rectangle.y + rectangle.height && n3 < this._table.getRowCount()) {
                n2 = n5 + n6;
                if (this._table instanceof JideTable && ((JideTable)this._table).getGridColor(n3) != null) {
                    graphics.setColor(((JideTable)this._table).getGridColor(n3));
                } else {
                    graphics.setColor(color2);
                }
                n = n2 - 1 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0);
                graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
                n5 = n2;
                n6 = this._table.getRowHeight(++n3);
            }
        }
        if (!(this._table instanceof JideTable) || ((JideTable)this._table).isFillsGridsBottom()) {
            n3 = this._table.getRowCount();
            n5 = this._table.getY() + this._table.getHeight();
            n6 = this._table.getRowHeight();
            n2 = rectangle.x + rectangle.width;
            if (!(this._table instanceof JideTable) || !((JideTable)this._table).isFillsRight()) {
                n2 = Math.min(n2, this._table.getX() + this._table.getWidth() - 1);
            }
            while (n5 < rectangle.y + rectangle.height) {
                int n8;
                n = n5 + n6;
                if (this._table instanceof JideTable && ((JideTable)this._table).getGridColor(n3) != null) {
                    graphics.setColor(((JideTable)this._table).getGridColor(n3));
                } else {
                    graphics.setColor(color2);
                }
                int n9 = n - 1 - (this._table instanceof AutoFilterUtils.AutoFilterRowTable ? 1 : 0);
                JTableHeader jTableHeader = this._table.getTableHeader();
                TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
                boolean bl = true;
                if (tableColumn != null && (n8 = this.viewIndexForColumn(tableColumn, this._table)) >= 0 && n8 < this._table.getColumnCount()) {
                    bl = false;
                    int n10 = jTableHeader.getDraggedDistance();
                    if (n10 > 0) {
                        n10 = Math.min(n10, tableColumn.getWidth());
                    } else if (n10 < 0) {
                        n10 = Math.max(n10, -tableColumn.getWidth());
                    }
                    Rectangle rectangle2 = jTableHeader.getHeaderRect(n8);
                    int n11 = n10 >= 0 ? rectangle2.x : rectangle2.x + rectangle2.width + n10;
                    int n12 = n10 >= 0 ? rectangle2.x + n10 : rectangle2.x + rectangle2.width;
                    n11 -= point.x;
                    n12 -= point.x;
                    if (((JideTable)this._table).isFillsRight()) {
                        if (this.getComponentOrientation().isLeftToRight()) {
                            n12 = Math.min(n12, this._table.getX() + this._table.getWidth() - 1);
                        } else {
                            n11 = Math.max(n11, -point.x);
                        }
                    }
                    if (n11 > rectangle.x) {
                        graphics.drawLine(rectangle.x, n9, n11 - 1, n9);
                    }
                    if (n12 < rectangle.x + n2) {
                        graphics.drawLine(n12, n9, rectangle.x + n2, n9);
                    }
                }
                if (bl) {
                    graphics.drawLine(rectangle.x, n9, n2, n9);
                }
                n5 = n;
                ++n3;
            }
        }
        graphics.setColor(color);
    }

    private void paintVerticalGridLines(Graphics graphics) {
        if (this._table == null || !this._table.getShowVerticalLines()) {
            return;
        }
        if (this._table instanceof JideTable && !((JideTable)this._table).isFillsGridsBottom()) {
            return;
        }
        Color color = graphics.getColor();
        int n = -this.getViewPosition().x;
        Color color2 = this._table.getGridColor();
        JTableHeader jTableHeader = this._table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        int n2 = tableColumn == null ? -1 : this.viewIndexForColumn(tableColumn, this._table);
        int n3 = jTableHeader == null ? -1 : jTableHeader.getDraggedDistance();
        int n4 = -1;
        int n5 = -1;
        if (tableColumn != null && n2 >= 0 && n2 < this._table.getColumnCount()) {
            Rectangle rectangle = jTableHeader.getHeaderRect(n2);
            n4 = rectangle.x + n3 - this.getViewPosition().x;
            n5 = n4 + rectangle.width;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            for (int i = 0; i < this._table.getColumnCount(); ++i) {
                TableColumn tableColumn2 = this._table.getColumnModel().getColumn(i);
                n += tableColumn2.getWidth();
                if (this._table instanceof JideTable && ((JideTable)this._table).getVerticalGridColor(i) != null) {
                    graphics.setColor(((JideTable)this._table).getVerticalGridColor(i));
                } else {
                    graphics.setColor(color2);
                }
                int n6 = 0;
                int n7 = this._table.getX() + this._table.getWidth() + this.getViewPosition().x;
                if (tableColumn != null && tableColumn2 == tableColumn) {
                    n6 = n3 > 0 ? n3 : -tableColumn2.getWidth() + n3;
                    if (n3 > 0) {
                        if (n - 1 + n6 - tableColumn2.getWidth() < n7) {
                            graphics.drawLine(n - 1 + n6 - tableColumn2.getWidth(), graphics.getClipBounds().y, n - 1 + n6 - tableColumn2.getWidth(), this.getHeight());
                        }
                    } else if (n - 1 + n6 + tableColumn2.getWidth() < n7) {
                        graphics.drawLine(n - 1 + n6 + tableColumn2.getWidth(), graphics.getClipBounds().y, n - 1 + n6 + tableColumn2.getWidth(), this.getHeight());
                    }
                }
                int n8 = n - 1 + n6;
                if ((n4 >= 0 && n8 > n4 && n8 < n5 || n8 >= n7) && tableColumn != tableColumn2) continue;
                graphics.drawLine(n8, graphics.getClipBounds().y, n8, this.getHeight());
            }
        } else {
            for (int i = this._table.getColumnCount() - 1; i >= 0; --i) {
                TableColumn tableColumn3 = this._table.getColumnModel().getColumn(i);
                n += tableColumn3.getWidth();
                if (this._table instanceof JideTable && ((JideTable)this._table).getVerticalGridColor(i) != null) {
                    graphics.setColor(((JideTable)this._table).getVerticalGridColor(i));
                } else {
                    graphics.setColor(color2);
                }
                int n9 = 0;
                if (tableColumn != null && tableColumn3 == tableColumn) {
                    n9 = n3 > 0 ? n3 : -tableColumn3.getWidth() + n3;
                    if (n3 > 0) {
                        if (n - 1 + n9 - tableColumn3.getWidth() >= -this.getViewPosition().x) {
                            graphics.drawLine(n - 1 + n9 - tableColumn3.getWidth(), graphics.getClipBounds().y, n - 1 + n9 - tableColumn3.getWidth(), this.getHeight());
                        }
                    } else if (n - 1 + n9 + tableColumn3.getWidth() >= -this.getViewPosition().x) {
                        graphics.drawLine(n - 1 + n9 + tableColumn3.getWidth(), graphics.getClipBounds().y, n - 1 + n9 + tableColumn3.getWidth(), this.getHeight());
                    }
                }
                int n10 = n - 1 + n9;
                if ((n4 < 0 || n10 <= n4 || n10 >= n5) && n10 >= -this.getViewPosition().x || tableColumn == tableColumn3) {
                    graphics.drawLine(n10, graphics.getClipBounds().y, n10, this.getHeight());
                }
                if (i != this._table.getColumnCount() - 1 || n4 >= 0 && (n10 -= tableColumn3.getWidth() - 1) >= n4 && n10 <= n5 || n10 < -this.getViewPosition().x) continue;
                graphics.drawLine(n10, graphics.getClipBounds().y, n10, this.getHeight());
            }
        }
        graphics.setColor(color);
    }

    public static JScrollPane createStripedJScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setViewport(new AutoFillTableViewport(jTable));
        jScrollPane.getViewport().setView(jTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setCorner("UPPER_TRAILING_CORNER", AutoFillTableViewport.createCornerComponent(jTable));
        return jScrollPane;
    }

    static JComponent createCornerComponent(JTable jTable) {
        return new CornerFiller(jTable);
    }

    static class CornerFiller
    extends JComponent {
        JTable _table;

        public CornerFiller(JTable jTable) {
            this._table = jTable;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            JTableHeader jTableHeader = this._table.getTableHeader();
            if (this._table != null && this._table.getColumnCount() > 0 && jTableHeader != null) {
                TableCellRenderer tableCellRenderer;
                Component component;
                int n = jTableHeader.getHeight();
                int n2 = 0;
                if (jTableHeader instanceof GroupTableHeader) {
                    n2 = ((GroupTableHeader)jTableHeader).getActualHeaderY();
                    n = ((GroupTableHeader)jTableHeader).getActualHeaderHeight();
                }
                if ((component = (tableCellRenderer = jTableHeader.getDefaultRenderer()).getTableCellRendererComponent(this._table, "", false, false, 0, -2)) instanceof AutoFilterTableHeaderRenderer) {
                    ((AutoFilterTableHeaderRenderer)component).removeAll();
                }
                ((JComponent)component).setOpaque(false);
                component.setBounds(0, n2, this.getWidth() + 1, n);
                CellRendererPane cellRendererPane = new CellRendererPane();
                jTableHeader.add(cellRendererPane);
                cellRendererPane.paintComponent(graphics, component, null, 0, n2, this.getWidth() + 1, n, true);
                jTableHeader.remove(cellRendererPane);
            }
        }
    }
}

