/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.filter.Filter;
import com.jidesoft.grid.AbstractPageTableModel;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.FilterItemSupport;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortItemSupport;
import com.jidesoft.grid.SortListener;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class AdvancePageTableModel
extends AbstractPageTableModel
implements ISortableTableModel,
IFilterableTableModel {
    private static final long serialVersionUID = 4265612126176003128L;
    private int _totalRecordCount = -1;
    protected SortItemSupport _sortItemSupport = new SortItemSupport();
    private boolean[] _columnsSortable;
    protected FilterItemSupport _filterItemSupport = new FilterItemSupport();
    private boolean _isAdjusting = false;
    private static final Logger LOGGER_FILTERABLE_TABLE_MODEL_EVENT = Logger.getLogger(FilterableTableModelEvent.class.getName());
    private TableModel _currentPageModel;

    public AdvancePageTableModel() {
    }

    protected AdvancePageTableModel(int n) {
        super(n);
    }

    @Override
    protected void pageCountChanged(int n, int n2) {
    }

    @Override
    protected void pageIndexChanged(int n, int n2) {
        this.refreshData(this._sortItemSupport, this._filterItemSupport, n2, this.getPageSize());
    }

    @Override
    public void setTotalRecordCount(int n) {
        this._totalRecordCount = n;
        int n2 = this.getTotalRecordCount();
        if (n2 >= 0) {
            this.setPageCount(n2 / this.getPageSize() + (n2 % this.getPageSize() == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getTotalRecordCount() {
        return this._totalRecordCount;
    }

    @Override
    public int getColumnCount() {
        return this.getCurrentPageModel() != null ? this.getCurrentPageModel().getColumnCount() : 0;
    }

    private boolean isRowInRage(int n) {
        return this.getCurrentPageModel() != null && n >= 0 && n < this.getCurrentPageModel().getRowCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = n % this.getPageSize();
        return this.isRowInRage(n3) ? this.getCurrentPageModel().getValueAt(n3, n2) : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        int n3 = n % this.getPageSize();
        return this.isRowInRage(n3) && this.getCurrentPageModel().isCellEditable(n3, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = n % this.getPageSize();
        if (this.isRowInRage(n3)) {
            this.getCurrentPageModel().setValueAt(object, n3, n2);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getCurrentPageModel() != null ? this.getCurrentPageModel().getColumnClass(n) : Object.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.getCurrentPageModel() != null ? this.getCurrentPageModel().getColumnName(n) : "A" + n;
    }

    @Override
    public int getSortedRowAt(int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public int getActualRowAt(int n) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void sortColumn(int n) {
        if (this._sortItemSupport.sortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl) {
        if (this._sortItemSupport.sortColumn(n, bl)) {
            this.resort();
        }
    }

    @Override
    public void unsortColumn(int n) {
        if (this._sortItemSupport.unsortColumn(n)) {
            this.resort();
        }
    }

    @Override
    public void reverseColumnSortOrder(int n) {
        if (this._sortItemSupport.reverseColumnSortOrder(n)) {
            this.resort();
        }
    }

    @Override
    public void sortColumn(int n, boolean bl, boolean bl2) {
        if (this._sortItemSupport.sortColumn(n, bl, bl2)) {
            this.resort();
        }
    }

    @Override
    public boolean isColumnSorted(int n) {
        return this._sortItemSupport.isColumnSorted(n);
    }

    @Override
    public boolean isColumnAscending(int n) {
        return this._sortItemSupport.isColumnAscending(n);
    }

    @Override
    public void reset() {
        if (this._sortItemSupport.reset()) {
            this.resort();
        }
    }

    @Override
    public void toggleSortOrder(int n, boolean bl) {
        if (!this.isColumnSortable(n)) {
            return;
        }
        this._sortItemSupport.toggleSortOrder(n, bl);
        this.resort();
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        return this._sortItemSupport.getSortingColumns();
    }

    @Override
    public void setSortingColumns(List<ISortableTableModel.SortItem> list) {
        this._sortItemSupport.setSortingColumns(list);
        this.resort();
    }

    @Override
    public int getColumnSortRank(int n) {
        return this._sortItemSupport.getColumnSortRank(n);
    }

    @Override
    public void setMasterSortColumns(int[] nArray) {
        this._sortItemSupport.setMasterSortColumns(nArray);
    }

    @Override
    public int[] getMasterSortColumns() {
        return this._sortItemSupport.getMasterSortColumns();
    }

    @Override
    public boolean isMultiColumnSortable() {
        return this._sortItemSupport.isMultiColumnSortable();
    }

    @Override
    public void setMultiColumnSortable(boolean bl) {
        this._sortItemSupport.setMultiColumnSortable(bl);
        this.resort();
    }

    @Override
    public boolean isSortable() {
        return this._sortItemSupport.isSortable();
    }

    @Override
    public void setSortable(boolean bl) {
        this._sortItemSupport.setSortable(bl);
    }

    @Override
    public void resort() {
        this.fireSortingEvent();
        this.sort();
        this.fireTableDataChanged();
        this.fireSortEvent();
    }

    @Override
    public int getSortPriority() {
        return this._sortItemSupport.getSortPriority();
    }

    @Override
    public void setSortPriority(int n) {
        this._sortItemSupport.setSortPriority(n);
    }

    @Override
    public int getMaximumSortColumns() {
        return this._sortItemSupport.getMaximumSortColumns();
    }

    @Override
    public void setMaximumSortColumns(int n) {
        this._sortItemSupport.setMaximumSortColumns(n);
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, SortListener.class, (EventListener)sortListener)) {
            this.listenerList.add(SortListener.class, sortListener);
        }
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    @Override
    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanged(sortEvent);
        }
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanging(sortEvent);
        }
    }

    @Override
    public boolean isColumnSortable(int n) {
        if (this.getColumnCount() == 0) {
            return false;
        }
        if (!this.isSortable()) {
            return false;
        }
        if (n >= 0 && n < this.getColumnCount()) {
            this.initColumnsSortable();
            return this._columnsSortable[n];
        }
        return false;
    }

    @Override
    public void setColumnSortable(int n, boolean bl) {
        if (n >= 0 && n < this.getColumnCount()) {
            this.initColumnsSortable();
            this._columnsSortable[n] = bl;
        }
    }

    private void initColumnsSortable() {
        if (this._columnsSortable == null) {
            this._columnsSortable = new boolean[this.getColumnCount()];
            Arrays.fill(this._columnsSortable, true);
        }
    }

    protected void sort() {
        this.refreshData(this._sortItemSupport, this._filterItemSupport);
    }

    @Override
    public void refresh() {
        this.refreshData(this._sortItemSupport, this._filterItemSupport);
    }

    @Override
    public boolean isColumnFilterable(int n) {
        return true;
    }

    @Override
    public boolean isColumnVisible(int n) {
        return true;
    }

    @Override
    public boolean isColumnAutoFilterable(int n) {
        return true;
    }

    @Override
    public boolean isValuePredetermined(int n) {
        return true;
    }

    @Override
    public void addFilter(int n, Filter filter) {
        this._filterItemSupport.addFilter(n, filter);
    }

    @Override
    public void addFilter(Filter filter) {
        this._filterItemSupport.addFilter(filter);
    }

    @Override
    public void addFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.addFilter(filterItem);
    }

    @Override
    public void removeFilter(int n, Filter filter) {
        this._filterItemSupport.removeFilter(n, filter);
    }

    @Override
    public void removeFilter(Filter filter) {
        this._filterItemSupport.removeFilter(filter);
    }

    @Override
    public void removeFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.removeFilter(filterItem);
    }

    @Override
    public void removeAllFilters(int n) {
        this._filterItemSupport.removeAllFilters(n);
    }

    @Override
    public void removeAllFilters() {
        this._filterItemSupport.removeAllFilters();
    }

    @Override
    public void clearFilters() {
        this._filterItemSupport.clearFilters();
    }

    @Override
    public Filter[] getFilters(int n) {
        return this._filterItemSupport.getFilters(n);
    }

    @Override
    public List<IFilterableTableModel.FilterItem> getFilterItems() {
        return this._filterItemSupport.getFilterItems();
    }

    @Override
    public void setFiltersApplied(boolean bl) {
        this._filterItemSupport.setFiltersApplied(true);
        this.refresh();
    }

    @Override
    public boolean isFiltersApplied() {
        return this._filterItemSupport.isFiltersApplied();
    }

    @Override
    public boolean hasFilter() {
        return this._filterItemSupport.hasFilter();
    }

    @Override
    public boolean hasFilter(int n) {
        return this._filterItemSupport.hasFilter(n);
    }

    @Override
    public boolean isAndMode() {
        return this._filterItemSupport.isAndMode();
    }

    @Override
    public void setAndMode(boolean bl) {
        this._filterItemSupport.setAndMode(bl);
    }

    @Override
    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
            if (!this._isAdjusting) {
                // empty if block
            }
        }
    }

    @Override
    public Object[] getPossibleValues(int n, Comparator comparator) {
        return new Object[0];
    }

    @Override
    public Object[] getPossibleValuesAndConverters(int n, Comparator comparator) {
        return new Object[0];
    }

    @Override
    public boolean isSameConverterAt(int n) {
        return true;
    }

    @Override
    public boolean isSplitArrayOrCollection() {
        return false;
    }

    @Override
    public void setSplitArrayOrCollection(boolean bl) {
    }

    @Override
    public void setFilteringPaused(boolean bl) {
    }

    @Override
    public boolean isFilteringPaused() {
        return false;
    }

    @Override
    public void addFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.add(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public void removeFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.remove(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public FilterableTableModelListener[] getFilterableTableModelListeners() {
        return (FilterableTableModelListener[])this.listenerList.getListeners(FilterableTableModelListener.class);
    }

    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (LOGGER_FILTERABLE_TABLE_MODEL_EVENT.isLoggable(Level.FINE)) {
            switch (filterableTableModelEvent.getID()) {
                case 7099: {
                    LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is added at column index " + filterableTableModelEvent.getColumn());
                    break;
                }
                case 7100: {
                    if (filterableTableModelEvent.getFilter() == null) {
                        LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: all filters are cleared at column index " + filterableTableModelEvent.getColumn());
                        break;
                    }
                    LOGGER_FILTERABLE_TABLE_MODEL_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is removed at column index " + filterableTableModelEvent.getColumn());
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FilterableTableModelListener.class) continue;
            ((FilterableTableModelListener)objectArray[i + 1]).filterableTableModelChanged(filterableTableModelEvent);
        }
    }

    public void fireFilterAdded(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7099, n, filter));
    }

    public void fireFilterRemoved(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7100, n, filter));
    }

    @Override
    public Icon getFilterIcon(int n) {
        return GridIconsFactory.getImageIcon("icons/filter.png");
    }

    private void refreshData(SortItemSupport sortItemSupport, FilterItemSupport filterItemSupport) {
        this.refreshData(sortItemSupport, filterItemSupport, this.getCurrentPage(), this.getPageSize());
    }

    public TableModel getCurrentPageModel() {
        return this._currentPageModel;
    }

    public void setCurrentPageModel(TableModel tableModel) {
        if (this._currentPageModel != tableModel) {
            if (this._currentPageModel != null) {
                this._currentPageModel.removeTableModelListener(this);
            }
            this._currentPageModel = tableModel;
            if (this._currentPageModel != null) {
                this._currentPageModel.addTableModelListener(this);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AdvancePageTableModel.this.fireTableDataChanged();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public abstract void refreshData(SortItemSupport var1, FilterItemSupport var2, int var3, int var4);

    @Override
    public DynamicTableFilter[] getDynamicTableFilters(int n) {
        return new DynamicTableFilter[0];
    }

    @Override
    public boolean isAllowMultipleValues(int n) {
        return true;
    }

    @Override
    public StringConverter getTitleConverter(int n) {
        return null;
    }

    @Override
    public AutoFilterTableHeaderAdapter.FilterTitleFormatter getFilterTitleFormatter(int n) {
        return null;
    }

    @Override
    public ListCellRenderer getListCellRenderer(int n) {
        return null;
    }

    @Override
    public boolean isUseTableCellRenderer(int n) {
        return false;
    }

    @Override
    public boolean isAllowCustomFilter(int n) {
        return true;
    }

    @Override
    public SingleValueFilter createSingleValueFilter(Object object) {
        return new SingleValueFilter<Object>(object);
    }

    @Override
    public MultipleValuesFilter createMultipleValuesFilter(Object[] objectArray) {
        return new MultipleValuesFilter<Object>(objectArray);
    }
}

