/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.gauge.Dial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class DialIntervalMarker
implements Drawable,
ZOrder {
    private Dial dial;
    private double from;
    private double to;
    private Paint fill;
    private Color borderColor;
    private BasicStroke borderStroke;
    private double outerRadius = 1.0;
    private double innerRadius = 0.85;
    private int zOrder = -1;

    public DialIntervalMarker(Dial dial, double d, double d2, Paint paint) {
        this.dial = dial;
        this.from = d;
        this.to = d2;
        this.fill = paint;
    }

    public DialIntervalMarker(Dial dial, double d, double d2, double d3, double d4, Paint paint) {
        this.dial = dial;
        this.from = d;
        this.to = d2;
        this.innerRadius = d3;
        this.outerRadius = d4;
        this.fill = paint;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public double getFrom() {
        return this.from;
    }

    public void setFrom(double d) {
        this.from = d;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d) {
        this.innerRadius = d;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d) {
        this.outerRadius = d;
    }

    public double getTo() {
        return this.to;
    }

    public void setTo(double d) {
        this.to = d;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(BasicStroke basicStroke) {
        this.borderStroke = basicStroke;
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int n) {
        this.zOrder = n;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.dial.getAngle(this.from);
        double d2 = this.dial.getAngle(this.to);
        GeneralPath generalPath = this.createSegment(d, d2, this.innerRadius, this.outerRadius);
        if (this.fill != null) {
            graphics2D.setPaint(this.fill);
            graphics2D.fill(generalPath);
        }
        if (this.borderColor != null) {
            graphics2D.setColor(this.borderColor);
            if (this.borderStroke != null) {
                graphics2D.setStroke(this.borderStroke);
                float f = this.dial.getRadius();
                float f2 = f == 0.0f ? 0.0f : this.borderStroke.getLineWidth() / f;
                generalPath = this.createSegment(d, d2, this.innerRadius - (double)(f2 / 2.0f), this.outerRadius + (double)(f2 / 2.0f));
                graphics2D.draw(generalPath);
            }
        }
    }

    public GeneralPath createSegment(double d, double d2, double d3, double d4) {
        int n = this.dial.getPivotX();
        int n2 = this.dial.getPivotY();
        float f = this.dial.getRadius();
        double d5 = Math.toRadians(d);
        double d6 = Math.toRadians(d2);
        GeneralPath generalPath = new GeneralPath();
        double d7 = d3 * (double)f;
        double d8 = d4 * (double)f;
        Point2D.Double double_ = new Point2D.Double((double)n + d7 * Math.cos(d5), (double)n2 - d7 * Math.sin(d5));
        Point2D.Double double_2 = new Point2D.Double((double)n + d8 * Math.cos(d6), (double)n2 - d8 * Math.sin(d6));
        generalPath.moveTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        Arc2D.Double double_3 = new Arc2D.Double((double)n - d7, (double)n2 - d7, d7 * 2.0, d7 * 2.0, d, d2 - d, 0);
        generalPath.append(double_3, true);
        generalPath.lineTo(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        Arc2D.Double double_4 = new Arc2D.Double((double)n - d8, (double)n2 - d8, d8 * 2.0, d8 * 2.0, d2, d - d2, 0);
        generalPath.append(double_4, true);
        generalPath.lineTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        generalPath.closePath();
        return generalPath;
    }
}

