/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.gauge.Dial;
import com.jidesoft.gauge.DialLinearPaint;
import com.jidesoft.gauge.DialRadialPaint;
import com.jidesoft.gauge.Pivot;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class DialIndicator
implements Drawable,
ZOrder,
Serializable {
    private Dial dial;
    private Pivot pivot;
    private int zOrder;
    private Color color;
    private Paint offPaint;
    private Paint onPaint;
    private boolean active;

    public DialIndicator(Dial dial, float f, float f2, float f3, Color color) {
        this.color = color;
        this.dial = dial;
        this.offPaint = this.createIndicatorPaint(f, f2, f3, color);
        this.onPaint = this.createIndicatorPaint(f, f2, f3, ColorUtils.getDerivedColor(color, 0.6f));
        this.pivot = new Pivot(dial, f, this.offPaint);
        this.pivot.setOffsetAngle(f3);
        this.pivot.setOffsetRadius(f2);
        this.setZOrder(50);
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    private Paint createIndicatorPaint(float f, float f2, float f3, Color color) {
        return new DialRadialPaint(this.dial, new float[]{0.0f, f / 2.0f, f}, new Color[]{color.brighter(), color.brighter(), color.darker()}, f2, f3);
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D point2D = this.pivot.getCenter();
        double d = this.dial.getRadius();
        float f = (float)(d * this.pivot.getOuterRadius());
        Paint paint = JideSwingUtilities.getRadialGradientPaint(point2D, 1.5f * f, new float[]{0.75f, 1.0f}, new Color[]{Color.darkGray, new Color(192, 192, 192, 0)});
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - (double)(2.0f * f), point2D.getY() - (double)(2.0f * f), f * 4.0f, f * 4.0f);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        this.pivot.setFill(this.active ? this.onPaint : this.offPaint);
        this.pivot.draw(graphics);
        float f2 = f * 1.1f;
        float f3 = f2 / 2.0f;
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() - (double)(f2 / 2.0f), point2D.getY() - (double)(1.25f * f3), f2, f3);
        DialLinearPaint dialLinearPaint = new DialLinearPaint(this.dial, 0.0f, 90.0f, f3, 90.0f, new float[]{0.0f, (float)(this.pivot.getOuterRadius() / 8.0)}, new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 100)});
        dialLinearPaint.setOffsetAngle((float)this.pivot.getOffsetAngle());
        dialLinearPaint.setOffsetRadius((float)this.pivot.getOffsetRadius());
        graphics2D.setPaint(dialLinearPaint);
        graphics2D.fill(double_2);
        if (this.active) {
            Color color = ColorUtils.getDerivedColor(this.color, 0.6f);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(point2D.getX() - (double)(2.0f * f), point2D.getY() - (double)(2.0f * f), f * 4.0f, f * 4.0f);
            DialRadialPaint dialRadialPaint = new DialRadialPaint(this.dial, new float[]{0.0f, (float)(this.pivot.getOuterRadius() * 2.0)}, new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), 150), new Color(color.getRed(), color.getGreen(), color.getBlue(), 0)}, (float)this.pivot.getOffsetRadius(), (float)this.pivot.getOffsetAngle());
            graphics2D.setPaint(dialRadialPaint);
            graphics2D.fill(double_3);
        }
    }
}

