/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.gauge.AbstractGauge;
import com.jidesoft.gauge.AbstractGaugeTickStyle;
import com.jidesoft.gauge.DefaultGaugeModel;
import com.jidesoft.gauge.DefaultNeedleRenderer;
import com.jidesoft.gauge.DialAxis;
import com.jidesoft.gauge.DialFrame;
import com.jidesoft.gauge.DialLabelOrientation;
import com.jidesoft.gauge.DialTickStyle;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.NeedleDescriptor;
import com.jidesoft.gauge.NeedleRenderer;
import com.jidesoft.gauge.NeedleStyle;
import com.jidesoft.range.Positionable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

public class Dial
extends AbstractGauge<DialAxis> {
    public static final String PROPERTY_DIAL_BACKGROUND = "Dial Background";
    private boolean animateOnChange = false;
    private double startAngle = 0.0;
    private double endAngle = 360.0;
    private int pivotX;
    private int pivotY;
    private float radius;
    private double pivotXPos = 0.0;
    private double pivotYPos = 0.0;
    private List<DialAxis> axes = new CopyOnWriteArrayList<DialAxis>();
    private double velocity;
    private double needleAnimationSpeed = 3.0;
    private int needleAnimationPeriod = 150;
    private NeedleRenderer defaultNeedleRenderer = null;
    private ActionListener needleAnimator;
    private Color faceColor = Color.white;
    private Paint facePaint = null;
    private DialFrame frame;
    private BufferedImage dialImage = null;
    private Shape faceClip = null;
    private Dimension imageSize = null;
    private Timer timer;
    private GaugeModel animatedModel;
    private List<String> needles = new CopyOnWriteArrayList<String>();
    private Map<String, NeedleRenderer> renderers = new HashMap<String, NeedleRenderer>();
    private Map<String, NeedleStyle> styles = new HashMap<String, NeedleStyle>();
    private final AxisChangeListener axisChangeListener = new AxisChangeListener();
    private List<Drawable> drawables = new CopyOnWriteArrayList<Drawable>();
    private Map<String, Shape> needleShapes = new HashMap<String, Shape>();

    public Dial() {
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(300, 300));
        this.needleAnimator = new NeedleAnimator();
        this.setAnimateOnChange(this.animateOnChange);
        this.setAxis(new DialAxis(0.0, 100.0, 10.0, 2.0));
        this.setModel(new DefaultGaugeModel());
        this.setAnimatedModel(new DefaultGaugeModel());
    }

    public List<String> getNeedleNames() {
        return this.needles;
    }

    public GaugeModel getAnimatedModel() {
        return this.animatedModel;
    }

    public void setAnimatedModel(GaugeModel gaugeModel) {
        this.animatedModel = gaugeModel;
    }

    public DialAxis getAxis() {
        if (this.axes == null || this.axes.size() == 0) {
            return null;
        }
        return this.axes.get(0);
    }

    public void setAxis(DialAxis dialAxis) {
        if (this.axes == null) {
            this.axes = new CopyOnWriteArrayList<DialAxis>();
        } else {
            for (DialAxis dialAxis2 : this.axes) {
                dialAxis2.removePropertyChangeListener(this.axisChangeListener);
            }
            this.axes.clear();
        }
        this.axes.add(dialAxis);
        if (dialAxis != null) {
            dialAxis.addPropertyChangeListener(this.axisChangeListener);
        }
    }

    public void addAxis(DialAxis dialAxis) {
        if (this.axes == null) {
            this.axes = new CopyOnWriteArrayList<DialAxis>();
        }
        this.axes.add(dialAxis);
        if (dialAxis != null) {
            dialAxis.addPropertyChangeListener(this.axisChangeListener);
        }
    }

    public void removeAxis(DialAxis dialAxis) {
        if (this.axes == null) {
            this.axes = new CopyOnWriteArrayList<DialAxis>();
        }
        if (this.axes.contains(dialAxis)) {
            dialAxis.removePropertyChangeListener(this.axisChangeListener);
            this.axes.remove(dialAxis);
        }
    }

    public void addNeedle(String string, NeedleStyle needleStyle) {
        this.needles.add(string);
        this.styles.put(string, needleStyle);
        this.repaint();
    }

    public void setNeedleStyle(String string, NeedleStyle needleStyle) {
        assert (this.needles.contains(string));
        this.styles.put(string, needleStyle);
        this.repaint();
    }

    public NeedleStyle getNeedleStyle(String string) {
        NeedleStyle needleStyle = this.styles.get(string);
        if (needleStyle == null) {
            needleStyle = new NeedleStyle();
        }
        return needleStyle;
    }

    public void removeNeedle(String string) {
        this.needles.remove(string);
        this.styles.remove(string);
        this.renderers.remove(string);
        this.repaint();
    }

    public void removeNeedles() {
        ArrayList<String> arrayList = new ArrayList<String>(this.needles);
        for (String string : arrayList) {
            this.needles.remove(string);
            this.styles.remove(string);
            this.renderers.remove(string);
        }
        GaugeModel gaugeModel = this.getModel();
        if (gaugeModel != null) {
            gaugeModel.clearValues();
        }
        if (this.animatedModel != null) {
            this.animatedModel.clearValues();
        }
        this.repaint();
    }

    public void setNeedleRenderer(String string, NeedleRenderer needleRenderer) {
        this.renderers.put(string, needleRenderer);
    }

    public void removeNeedleRenderer(String string) {
        this.renderers.remove(string);
    }

    public NeedleRenderer getNeedleRenderer(String string) {
        return this.renderers.get(string);
    }

    public void addDrawable(Drawable drawable) {
        this.drawables.add(drawable);
        this.repaint();
    }

    public void removeDrawable(Drawable drawable) {
        this.drawables.remove(drawable);
        this.repaint();
    }

    public void removeDrawables() {
        this.drawables.clear();
        this.repaint();
    }

    public boolean isAnimateOnChange() {
        return this.animateOnChange;
    }

    public void setAnimateOnChange(boolean bl) {
        this.animateOnChange = bl;
        if (bl) {
            this.createTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private void createTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer = new Timer(this.needleAnimationPeriod, this.needleAnimator);
        this.timer.start();
    }

    public double getNeedleAnimationSpeed() {
        return this.needleAnimationSpeed;
    }

    public void setNeedleAnimationSpeed(double d) {
        this.needleAnimationSpeed = d;
    }

    public int getNeedleAnimationPeriod() {
        return this.needleAnimationPeriod;
    }

    public void setNeedleAnimationPeriod(int n) {
        this.needleAnimationPeriod = n;
        this.createTimer();
    }

    @Override
    public void setValue(String string, Positionable positionable, boolean bl) {
        Double d;
        GaugeModel gaugeModel = this.getModel();
        if (gaugeModel == null) {
            throw new IllegalStateException("Model is not set!");
        }
        Positionable positionable2 = gaugeModel.getValue(string);
        Double d2 = positionable2 == null ? null : Double.valueOf(positionable2.position());
        DialAxis dialAxis = this.getAxis();
        double d3 = dialAxis.minimum();
        double d4 = dialAxis.maximum();
        Double d5 = d = positionable == null ? null : Double.valueOf(positionable.position());
        if (d != null) {
            if (d < d3) {
                d = d3;
            } else if (d > d4) {
                d = d4;
            }
        }
        gaugeModel.setValue(string, positionable, bl);
        if (!this.animateOnChange || this.animatedModel.getValue(string) == null) {
            this.animatedModel.setValue(string, positionable, false);
        }
        this.firePropertyChange(string, d2, d);
    }

    public Color getFaceColor() {
        return this.faceColor;
    }

    public void setFaceColor(Color color) {
        this.faceColor = color;
        this.dialImage = null;
        this.repaint();
    }

    public Paint getFacePaint() {
        return this.facePaint;
    }

    public void setFacePaint(Paint paint) {
        this.facePaint = paint;
        this.dialImage = null;
        this.repaint();
    }

    public void setDialBackground(Paint paint) {
        Paint paint2 = this.getBackgroundPaint();
        this.setBackgroundPaint(paint);
        this.firePropertyChange(PROPERTY_DIAL_BACKGROUND, paint2, paint);
    }

    public Paint getDialBackground() {
        return this.getBackgroundPaint();
    }

    public Color getTickColor() {
        DialAxis dialAxis = this.getAxis();
        if (dialAxis == null) {
            return Color.black;
        }
        DialTickStyle dialTickStyle = (DialTickStyle)dialAxis.getMajorTickStyle();
        return dialTickStyle == null ? Color.black : dialTickStyle.getTickColor();
    }

    public void setTickColor(Color color) {
        for (DialAxis dialAxis : this.axes) {
            ((DialTickStyle)dialAxis.getMajorTickStyle()).setTickColor(color);
            ((DialTickStyle)dialAxis.getMinorTickStyle()).setTickColor(color);
        }
        this.dialImage = null;
        this.repaint();
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.repaint();
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setEndAngle(double d) {
        this.endAngle = d;
        this.repaint();
    }

    Double getAngle(String string) {
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable = this.animateOnChange ? this.animatedModel.getValue(string) : (gaugeModel == null ? null : gaugeModel.getValue(string));
        Double d = positionable == null ? null : Double.valueOf(positionable.position());
        return this.getAngle(d);
    }

    public NeedleDescriptor needleAt(Point2D point2D) {
        for (Map.Entry<String, Shape> entry : this.needleShapes.entrySet()) {
            Shape shape = entry.getValue();
            if (!shape.contains(point2D)) continue;
            return new NeedleDescriptor(entry.getKey(), shape);
        }
        return null;
    }

    public Collection<NeedleDescriptor> needlesAt(Point2D point2D) {
        ArrayList<NeedleDescriptor> arrayList = new ArrayList<NeedleDescriptor>();
        for (Map.Entry<String, Shape> entry : this.needleShapes.entrySet()) {
            Shape shape = entry.getValue();
            if (!shape.contains(point2D)) continue;
            NeedleDescriptor needleDescriptor = new NeedleDescriptor(entry.getKey(), shape);
            arrayList.add(needleDescriptor);
        }
        return arrayList;
    }

    public NeedleDescriptor rendered(String string) {
        Shape shape = this.needleShapes.get(string);
        if (shape == null) {
            return null;
        }
        int n = this.needles.indexOf(string);
        return new NeedleDescriptor(string, shape, n);
    }

    public Double getAngle(Double d) {
        return this.getAngle(this.getAxis(), d);
    }

    public Double getAngle(DialAxis dialAxis, Double d) {
        if (d == null) {
            return null;
        }
        double d2 = dialAxis.getEndAngle() - dialAxis.getStartAngle();
        double d3 = dialAxis.minimum();
        double d4 = dialAxis.maximum();
        return dialAxis.getStartAngle() + d2 * (d - d3) / (d4 - d3);
    }

    private void updateNeedles() {
        for (String string : this.needles) {
            this.updateNeedle(string);
        }
        this.repaint();
    }

    private void updateNeedle(String string) {
        Double d;
        Positionable positionable = this.animatedModel.getValue(string);
        GaugeModel gaugeModel = this.getModel();
        Positionable positionable2 = gaugeModel == null ? null : gaugeModel.getValue(string);
        Double d2 = positionable == null ? null : Double.valueOf(positionable.position());
        Double d3 = d = positionable2 == null ? null : Double.valueOf(positionable2.position());
        if (d2 != null && d != null) {
            double d4 = d - d2;
            this.velocity = Math.signum(d4) + this.needleAnimationSpeed * (double)this.needleAnimationPeriod / 1000.0 * d4;
            if (Math.abs(d2 - d) <= 1.0) {
                this.animatedModel.setValue(string, this.createPositionable(d));
            } else {
                this.animatedModel.setValue(string, this.createPositionable(d2 + this.velocity));
            }
        }
    }

    Pair<Double, Double> normalizeAngleRange(double d, double d2) {
        double d3 = d2 - d;
        if (Math.abs(d3) > 360.0) {
            if (d3 > 0.0) {
                while (Math.abs(d3 = (d2 -= 360.0) - d) > 360.0) {
                }
            } else {
                while (Math.abs(d3 = d2 - (d += 360.0)) > 360.0) {
                }
            }
        }
        while (Math.min(d, d2) < 0.0) {
            d += 360.0;
            d2 += 360.0;
        }
        while (Math.max(d, d2) >= 360.0) {
            d -= 360.0;
            d2 -= 360.0;
        }
        return new Pair<Double, Double>(d, d2);
    }

    boolean crosses(double d, double d2, double d3) {
        assert (d >= 0.0 && d < 360.0);
        Pair<Double, Double> pair = this.normalizeAngleRange(d2, d3);
        return Math.min(pair.getFirst(), pair.getSecond()) < d && Math.max(pair.getFirst(), pair.getSecond()) > d;
    }

    public static double normalizeAngle(double d) {
        while (d < 0.0) {
            d += 360.0;
        }
        while (d >= 360.0) {
            d -= 360.0;
        }
        return d;
    }

    double nearestToAngle(double d, double d2, double d3) {
        double d4;
        double d5 = Dial.normalizeAngle(d);
        double d6 = d3;
        double d7 = d2;
        if (d6 == d7) {
            d6 += 360.0;
        }
        while (d6 <= 0.0) {
            d7 += 360.0;
            d6 += 360.0;
        }
        double d8 = Math.max(d7, d6);
        double d9 = Math.min(d7, d6);
        if (d9 < d5 && d8 > d5) {
            return d5;
        }
        if (d9 < d5 - 360.0 && d8 > d5 - 360.0) {
            return d5;
        }
        if (d9 < d5 + 360.0 && d8 > d5 + 360.0) {
            return d5;
        }
        double d10 = Math.abs(d5 - d8);
        if (d10 > 180.0) {
            d10 = 360.0 - d10;
        }
        if ((d4 = Math.abs(d9 - d5)) > 180.0) {
            d4 = 360.0 - d4;
        }
        if (d10 < d4) {
            return d8;
        }
        return d9;
    }

    protected Paint deriveFacePaint(Color color, float f, float f2, float f3) {
        Color color2 = ColorUtils.getDerivedColor(color, 0.75f);
        return JideSwingUtilities.getRadialGradientPaint(f - 0.2f * f3, f2 - 0.2f * f3, f3, new float[]{0.2f, 1.0f}, new Color[]{color2, color});
    }

    private Pair<Point2D, Float> computeDialDimensions(Dimension dimension, Insets insets) {
        double d = this.startAngle;
        double d2 = this.endAngle;
        if (this.frame != null) {
            double d3 = this.frame.getArcEndAngle();
            if (d < d2) {
                d -= d3;
                d2 += d3;
            } else {
                d += d3;
                d2 -= d3;
            }
        }
        int n = dimension == null ? 0 : dimension.width - insets.left - insets.right;
        int n2 = dimension == null ? 0 : dimension.height - insets.top - insets.bottom;
        return this.computeDialDimensions(d, d2, n, n2, true);
    }

    private Pair<Point2D, Float> computeDialDimensions(double d, double d2, int n, int n2, boolean bl) {
        double d3;
        double d4 = this.nearestToAngle(90.0, d, d2);
        double d5 = this.nearestToAngle(270.0, d, d2);
        double d6 = this.nearestToAngle(180.0, d, d2);
        double d7 = this.nearestToAngle(0.0, d, d2);
        if (d5 > 0.0 && d5 < 180.0) {
            d5 = 0.0;
        }
        if (d4 > 180.0 && d4 < 360.0) {
            d4 = 0.0;
        }
        double d8 = this.frame == null ? 0.0 : this.frame.getMidChordRadius();
        double d9 = this.getFrameWidthRatio();
        double d10 = d9 + Math.max(d8, Math.abs(Math.sin(Math.toRadians(d4))));
        double d11 = d9 + Math.max(d8, Math.abs(Math.sin(Math.toRadians(d5))));
        double d12 = d9 + Math.max(d8, Math.abs(Math.cos(Math.toRadians(d6))));
        double d13 = d9 + Math.max(d8, Math.abs(Math.cos(Math.toRadians(d7))));
        double d14 = d10 + d11;
        double d15 = d12 + d13;
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        double d16 = (double)n / d15;
        double d17 = d16 * d14;
        double d18 = n;
        double d19 = d17;
        if (d17 > (double)n2) {
            d3 = (double)n2 / d14;
            d18 = d3 * d15;
            d19 = n2;
        }
        d3 = d2 - d;
        float f = (float)((d15 - 0.0 * d9) / d15 * (d18 / d15));
        if (bl) {
            double d20 = f;
            double d21 = (double)f * (1.0 + this.getFrameWidthRatio());
            int n3 = (int)(d21 - d20);
            double d22 = Math.asin((float)n3 / f);
            double d23 = Math.toDegrees(d22);
            if (d < d2) {
                return this.computeDialDimensions(d - d23, d2 + d23, n, n2, false);
            }
            return this.computeDialDimensions(d + d23, d2 - d23, n, n2, false);
        }
        float f2 = 0.0f;
        for (String string : this.needles) {
            float f3;
            NeedleStyle needleStyle = this.getNeedleStyle(string);
            if (needleStyle == null) continue;
            BasicStroke basicStroke = needleStyle.getOutlineStroke();
            float f4 = f3 = basicStroke == null ? 0.0f : basicStroke.getLineWidth();
            float f5 = (float)((double)f * needleStyle.getTailLength() + (double)f3);
            if (!(f5 > f2)) continue;
            f2 = f5;
        }
        float f6 = d3 <= 180.0 ? f2 : 0.0f;
        float f7 = (float)((double)((float)n / 2.0f) - (d13 - d12) * 0.5 * d18 / d15);
        float f8 = (float)(d10 * (d19 - (double)f6) / d14 + ((double)n2 - d19) / 2.0);
        return new Pair<Point2D, Float>(new Point2D.Double(f7, f8), Float.valueOf(f -= f6));
    }

    private Image createDialImage(Dimension dimension, Insets insets) {
        int n;
        int n2 = dimension == null ? 0 : dimension.width - insets.left - insets.right;
        int n3 = n = dimension == null ? 0 : dimension.height - insets.top - insets.bottom;
        if (this.getFontComparisonSize() == null && dimension != null && dimension.width > 0 && dimension.height > 0) {
            int n4 = Math.min(n2, n);
            this.setFontComparisonSize(new Dimension(n4, n4));
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n <= 0) {
            n = 1;
        }
        if (this.dialImage != null && this.dialImage.getWidth() == n2 && this.dialImage.getHeight() == n) {
            ChartUtils.clearBufferedImage(this.dialImage, Color.black);
        } else {
            this.dialImage = new BufferedImage(n2, n, 2);
        }
        Graphics2D graphics2D = (Graphics2D)this.dialImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Pair<Point2D, Float> pair = this.computeDialDimensions(dimension, insets);
        Point2D point2D = pair.getFirst();
        Float f = pair.getSecond();
        float f2 = (float)point2D.getX();
        float f3 = (float)point2D.getY();
        if (f.floatValue() > 0.0f) {
            int n4;
            Color color;
            Object object;
            int color2;
            ZOrder zOrder;
            Paint paint;
            int n7 = insets.left;
            int n8 = insets.top;
            if (this.facePaint != null) {
                paint = this.facePaint instanceof Color ? this.deriveFacePaint((Color)this.facePaint, f2 + (float)n7, f3 + (float)n8, f.floatValue()) : this.facePaint;
            } else {
                if (this.faceColor == null) {
                    this.faceColor = Color.white;
                }
                paint = this.faceColor;
            }
            graphics2D.translate(-n7, -n8);
            graphics2D.setPaint(paint);
            GeneralPath generalPath = this.createFrameInner(null, f2 + (float)n7, f3 + (float)n8, f.floatValue());
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.translate(n7, n8);
            Shape shape = graphics2D.getClip();
            generalPath = this.createFrameInner(null, f2, f3, f.floatValue() + 1.0f);
            this.paintAxes(graphics2D, n7, n8);
            int n9 = 1 + (this.frame == null ? 0 : this.frame.getInnerBorderWidth());
            GeneralPath generalPath2 = this.createFrameInner(null, f2, f3, f.floatValue() + (float)n9);
            graphics2D.setClip(generalPath2);
            graphics2D.translate(-n7, -n8);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n7, n8);
            this.faceClip = affineTransform.createTransformedShape(generalPath);
            for (Drawable object22 : this.drawables) {
                if (!(object22 instanceof ZOrder) || (zOrder = (ZOrder)((Object)object22)).getZOrder() >= 0) continue;
                object22.draw(graphics2D);
            }
            graphics2D.setClip(shape);
            Shape shape2 = this.createFrame(f2 + (float)n7, f3 + (float)n8, f.floatValue());
            Color color3 = this.frame == null ? Color.black : this.frame.getFill();
            graphics2D.setPaint(color3);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.fill(shape2);
            graphics2D.translate(n7, n8);
            ZOrder zOrder2 = zOrder = this.frame == null ? null : this.frame.getOuterBorderColor();
            if (this.frame != null && zOrder != null && (color2 = this.frame.getOuterBorderWidth()) > 0) {
                double n5 = f.floatValue();
                double list = (double)f.floatValue() * (1.0 + this.getFrameWidthRatio());
                double fontMetrics = list - n5;
                object = this.createFrameOuter(null, f2, f3, list, fontMetrics);
                ((Path2D)object).closePath();
                graphics2D.setStroke(new BasicStroke(color2));
                graphics2D.setColor((Color)((Object)zOrder));
                graphics2D.draw((Shape)object);
            }
            Color color4 = color = this.frame == null ? null : this.frame.getInnerBorderColor();
            if (this.frame != null && color != null && (n4 = this.frame.getInnerBorderWidth()) > 0) {
                graphics2D.setStroke(new BasicStroke(n4));
                graphics2D.setColor(color);
                generalPath = this.createFrameInner(null, f2, f3, f.floatValue());
                graphics2D.draw(generalPath);
            }
            for (DialAxis dialAxis : this.axes) {
                Object object2;
                double d;
                double d2;
                List<Tick> list = dialAxis.ticks();
                Font font = this.tickLabelFontForAxis(dialAxis);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                List<Tick> list2 = this.isAllowTickLabelOverlap() ? list : this.filterTicksToRemoveOverlap(graphics2D, dialAxis, list, fontMetrics);
                object = this.longestTickLabel(list2, fontMetrics);
                boolean bl = dialAxis.getLabelRadius() < dialAxis.getInnerRadius();
                for (Tick tick : list) {
                    assert (tick != null);
                    d2 = tick.getPosition();
                    d = this.getAngle(dialAxis, d2);
                    object2 = tick.isMajor() ? (DialTickStyle)dialAxis.getMajorTickStyle() : (DialTickStyle)dialAxis.getMinorTickStyle();
                    if (!((AbstractGaugeTickStyle)object2).isVisible()) continue;
                    graphics2D.setColor(((AbstractGaugeTickStyle)object2).getTickColor());
                    this.paintTick(graphics2D, dialAxis, f2, f3, d, f.floatValue(), (DialTickStyle)object2);
                }
                if (!dialAxis.isTickLabelsVisible()) continue;
                for (Tick tick : list2) {
                    d2 = tick.getPosition();
                    d = this.getAngle(dialAxis, d2);
                    if (!tick.isMajor() || (object2 = dialAxis.getTickLabelColor()) == null) continue;
                    graphics2D.setColor((Color)object2);
                    String string = tick.getLabel();
                    if (string == null) continue;
                    this.paintTickLabel(graphics2D, dialAxis, f2, f3, d, f.floatValue(), string, (String)object, bl);
                }
            }
        }
        graphics2D.dispose();
        this.updatePivotPosition();
        return this.dialImage;
    }

    @Override
    protected Point2D calculatePixelPoint2D(DialAxis dialAxis, double d) {
        double d2 = this.getAngle(dialAxis, d);
        double d3 = Math.toRadians(d2);
        int n = this.getPivotX();
        int n2 = this.getPivotY();
        float f = this.getRadius();
        double d4 = dialAxis.getLabelRadius();
        double d5 = (double)n + d4 * (double)f * Math.cos(d3);
        double d6 = (double)n2 - d4 * (double)f * Math.sin(d3);
        return new Point2D.Double(d5, d6);
    }

    private List<Tick> filterTicksToRemoveOverlap(Graphics2D graphics2D, DialAxis dialAxis, List<Tick> list, FontMetrics fontMetrics) {
        boolean bl;
        int n = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        do {
            int n2 = 0;
            bl = false;
            Shape shape = null;
            arrayList.clear();
            String string = this.longestTickLabel(list, fontMetrics);
            int n3 = fontMetrics.stringWidth(string);
            boolean bl2 = dialAxis.getLabelRadius() < dialAxis.getInnerRadius();
            for (Tick tick : list) {
                if (tick.isMajor()) {
                    if (n2 == 0) {
                        Point2D point2D = this.calculatePixelPoint2D(dialAxis, tick.getPosition());
                        DialLabelOrientation dialLabelOrientation = dialAxis.getLabelOrientation();
                        double d = this.getAngle(dialAxis, tick.getPosition());
                        String string2 = tick.getLabel();
                        int n4 = string2 == null ? 0 : fontMetrics.stringWidth(string2);
                        double d2 = Math.toRadians(d);
                        double d3 = this.getLabelRotation(dialLabelOrientation, d);
                        Insets insets = this.getInsets();
                        double d4 = point2D.getX() - (double)insets.left;
                        double d5 = point2D.getY() - (double)insets.top;
                        if (dialLabelOrientation == DialLabelOrientation.UPRIGHT) {
                            int n5 = (n3 - n4 - fontMetrics.stringWidth("0")) / 2;
                            double d6 = bl2 ? Math.cos(d2) * (double)n5 : -Math.cos(d2) * (double)n5;
                            d4 += d6;
                        }
                        Shape shape2 = this.calculateRotatedStringBounds(fontMetrics, tick.getLabel(), d4, d5, d3);
                        if (shape != null && shape2 != null) {
                            Area area = new Area(shape2);
                            Area area2 = new Area(shape);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        shape = shape2;
                    }
                    if (++n2 != n) continue;
                    n2 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n;
        } while (bl);
        graphics2D2.dispose();
        return arrayList;
    }

    private double getFrameWidthRatio() {
        double d = this.frame == null ? 0.02 : this.frame.getFrameWidth();
        return d;
    }

    private Shape createFrame(float f, float f2, float f3) {
        assert (f3 > 0.0f);
        double d = f3;
        double d2 = (double)f3 * (1.0 + this.getFrameWidthRatio());
        double d3 = d2 - d;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = this.createFrameInner(generalPath, f, f2, d);
        this.createFrameOuter(generalPath, f, f2, d2, d3);
        generalPath2.closePath();
        return generalPath2;
    }

    private GeneralPath createFrameInner(GeneralPath generalPath, float f, float f2, double d) {
        double d2;
        assert (this.radius > 0.0f);
        double d3 = this.endAngle - this.startAngle;
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        double d4 = (double)f + d * Math.cos(Math.toRadians(this.startAngle));
        double d5 = (double)f2 - d * Math.sin(Math.toRadians(this.startAngle));
        generalPath.moveTo(d4, d5);
        Arc2D.Double double_ = new Arc2D.Double((double)f - d, (double)f2 - d, d * 2.0, d * 2.0, this.startAngle, d3, 0);
        generalPath.append(double_, false);
        double d6 = d2 = this.frame == null ? 0.0 : this.frame.getArcEndAngle();
        if (d3 < 360.0 - 2.0 * d2) {
            double d7 = this.frame == null ? 0.0 : this.frame.getMidChordRadius();
            double d8 = Dial.normalizeAngle((this.startAngle + this.endAngle) / 2.0 + 180.0);
            double d9 = d7 * d;
            double d10 = (double)f + d9 * Math.cos(Math.toRadians(d8));
            double d11 = (double)f2 - d9 * Math.sin(Math.toRadians(d8));
            double d12 = (double)f + d * Math.cos(Math.toRadians(this.endAngle + d2 * Math.signum(d3)));
            double d13 = (double)f2 - d * Math.sin(Math.toRadians(this.endAngle + d2 * Math.signum(d3)));
            double d14 = d3 >= 0.0 ? (double)f - d10 : d10 - (double)f;
            double d15 = d3 >= 0.0 ? (double)f2 - d11 : d11 - (double)f2;
            double d16 = d10 + d15;
            double d17 = d11 - d14;
            double d18 = d10 - d15;
            double d19 = d11 + d14;
            double d20 = (double)f + d * Math.cos(Math.toRadians(this.startAngle - d2 * Math.signum(d3)));
            double d21 = (double)f2 - d * Math.sin(Math.toRadians(this.startAngle - d2 * Math.signum(d3)));
            generalPath.curveTo(d12, d13, d16, d17, d10, d11);
            generalPath.curveTo(d18, d19, d20, d21, d4, d5);
        }
        return generalPath;
    }

    private GeneralPath createFrameOuter(GeneralPath generalPath, float f, float f2, double d, double d2) {
        double d3;
        double d4;
        assert (this.radius > 0.0f);
        double d5 = this.endAngle - this.startAngle;
        double d6 = Math.asin(d2 / (2.0 * d));
        double d7 = 2.0 * Math.toDegrees(d6);
        double d8 = d5 >= 0.0 ? this.startAngle - d7 : this.startAngle + d7;
        double d9 = d4 = d5 >= 0.0 ? this.endAngle + d7 : this.endAngle - d7;
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        double d10 = (double)f + d * Math.cos(Math.toRadians(d8));
        double d11 = (double)f2 - d * Math.sin(Math.toRadians(d8));
        double d12 = (double)f + d * Math.cos(Math.toRadians(d4));
        double d13 = (double)f2 - d * Math.sin(Math.toRadians(d4));
        generalPath.moveTo(d10, d11);
        double d14 = d3 = this.frame == null ? 0.0 : this.frame.getArcEndAngle();
        if (d5 < 360.0 - 2.0 * d3) {
            double d15 = this.frame == null ? 0.0 : this.frame.getMidChordRadius();
            double d16 = Dial.normalizeAngle((this.startAngle + this.endAngle) / 2.0 + 180.0);
            double d17 = d15 * d + d2;
            double d18 = (double)f + d17 * Math.cos(Math.toRadians(d16));
            double d19 = (double)f2 - d17 * Math.sin(Math.toRadians(d16));
            double d20 = (double)f + d * Math.cos(Math.toRadians(d4 + d3 * Math.signum(d5)));
            double d21 = (double)f2 - d * Math.sin(Math.toRadians(d4 + d3 * Math.signum(d5)));
            double d22 = d5 >= 0.0 ? (double)f - d18 : d18 - (double)f;
            double d23 = d5 >= 0.0 ? (double)f2 - d19 : d19 - (double)f2;
            double d24 = d18 + d23;
            double d25 = d19 - d22;
            double d26 = d18 - d23;
            double d27 = d19 + d22;
            double d28 = (double)f + d * Math.cos(Math.toRadians(d8 - d3 * Math.signum(d5)));
            double d29 = (double)f2 - d * Math.sin(Math.toRadians(d8 - d3 * Math.signum(d5)));
            generalPath.curveTo(d28, d29, d26, d27, d18, d19);
            generalPath.curveTo(d24, d25, d20, d21, d12, d13);
        }
        Arc2D.Double double_ = new Arc2D.Double((double)f - d, (double)f2 - d, d * 2.0, d * 2.0, d4, -d5, 0);
        generalPath.append(double_, true);
        return generalPath;
    }

    private void paintAxes(Graphics2D graphics2D, int n, int n2) {
        graphics2D.translate(-n, -n2);
        for (DialAxis dialAxis : this.axes) {
            GeneralPath generalPath = this.createSegment(dialAxis.getStartAngle(), dialAxis.getEndAngle(), dialAxis.getInnerRadius(), dialAxis.getOuterRadius());
            Paint paint = dialAxis.getFill();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(generalPath);
            }
            Color color = dialAxis.getBorderColor();
            BasicStroke basicStroke = dialAxis.getBorderStroke();
            if (color == null) continue;
            graphics2D.setColor(color);
            if (basicStroke == null) continue;
            graphics2D.setStroke(basicStroke);
            float f = basicStroke.getLineWidth() / this.radius;
            generalPath = this.createSegment(dialAxis.getStartAngle(), dialAxis.getEndAngle(), dialAxis.getInnerRadius() - (double)(f / 2.0f), dialAxis.getOuterRadius() + (double)(f / 2.0f));
            graphics2D.draw(generalPath);
        }
        graphics2D.translate(n, n2);
    }

    public DialFrame getFrame() {
        return this.frame;
    }

    public void setFrame(DialFrame dialFrame) {
        this.frame = dialFrame;
    }

    public float getRadius() {
        return this.radius;
    }

    private void updatePivotPosition() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        Pair<Point2D, Float> pair = this.computeDialDimensions(dimension, insets);
        Point2D point2D = pair.getFirst();
        this.radius = pair.getSecond().floatValue();
        this.pivotX = insets == null ? (int)point2D.getX() : insets.left + (int)point2D.getX();
        this.pivotY = insets == null ? (int)point2D.getY() : insets.top + (int)point2D.getY();
    }

    public int getPivotX() {
        return this.pivotX;
    }

    public int getPivotY() {
        return this.pivotY;
    }

    public void update() {
        this.dialImage = null;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = graphics2D.getClip();
        Rectangle rectangle2 = rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
        if (this.isOpaque()) {
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        assert (dimension != null);
        if (!dimension.equals(this.imageSize)) {
            this.dialImage = null;
        }
        this.imageSize = dimension;
        Dimension dimension2 = this.getFontComparisonSize();
        if (this.isResizeFonts() && dimension.height > 0 && dimension2 != null) {
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            float f = (float)n2 / (float)dimension2.height;
            float f2 = (float)n / (float)dimension2.width;
            this.setFontSizeRatio(Math.min(f, f2));
        }
        if (this.dialImage == null) {
            this.updatePivotPosition();
            this.createDialImage(dimension, insets);
        }
        graphics2D.drawImage((Image)this.dialImage, insets == null ? 0 : insets.left, insets == null ? 0 : insets.top, this);
        Area area = shape == null ? new Area() : new Area(shape);
        area.intersect(new Area(this.faceClip));
        graphics2D.setClip(area);
        for (Drawable drawable : this.drawables) {
            if (drawable instanceof ZOrder) {
                ZOrder zOrder = (ZOrder)((Object)drawable);
                if (zOrder.getZOrder() < 0 || zOrder.getZOrder() >= 100) continue;
                drawable.draw(graphics2D);
                continue;
            }
            drawable.draw(graphics2D);
        }
        this.paintNeedles(graphics2D);
        for (Drawable drawable : this.drawables) {
            ZOrder zOrder;
            if (!(drawable instanceof ZOrder) || (zOrder = (ZOrder)((Object)drawable)).getZOrder() < 100) continue;
            drawable.draw(graphics2D);
        }
        graphics2D.setClip(shape);
    }

    private void paintNeedles(Graphics2D graphics2D) {
        float f = this.getRadius();
        this.needleShapes.clear();
        for (String string : this.needles) {
            Shape shape;
            NeedleStyle needleStyle;
            Double d;
            GaugeModel gaugeModel = this.getModel();
            Positionable positionable = this.animateOnChange ? this.animatedModel.getValue(string) : (gaugeModel == null ? null : gaugeModel.getValue(string));
            Double d2 = d = positionable == null ? null : Double.valueOf(positionable.position());
            Double d3 = this.getAngle(string);
            if (d3 == null) continue;
            NeedleRenderer needleRenderer = this.renderers.get(string);
            if (needleRenderer == null) {
                if (this.defaultNeedleRenderer == null) {
                    this.defaultNeedleRenderer = new DefaultNeedleRenderer();
                }
                needleRenderer = this.defaultNeedleRenderer;
            }
            if (!(needleStyle = this.styles.get(string)).isVisible() || (shape = needleRenderer.paintNeedle(graphics2D, this, d, this.pivotX, this.pivotY, d3, f, needleStyle)) == null) continue;
            this.needleShapes.put(string, shape);
        }
    }

    private void paintTick(Graphics2D graphics2D, DialAxis dialAxis, float f, float f2, double d, float f3, DialTickStyle dialTickStyle) {
        double d2 = dialAxis.getInnerRadius();
        double d3 = dialAxis.getOuterRadius();
        double d4 = d3 - d2;
        double d5 = Math.toRadians(d);
        double d6 = d3 - d4 * dialTickStyle.getTickStart();
        double d7 = d3 - d4 * (dialTickStyle.getTickStart() + dialTickStyle.getTickLength());
        double d8 = (double)f + d6 * (double)f3 * Math.cos(d5);
        double d9 = (double)f2 - d6 * (double)f3 * Math.sin(d5);
        double d10 = (double)f + d7 * (double)f3 * Math.cos(d5);
        double d11 = (double)f2 - d7 * (double)f3 * Math.sin(d5);
        double d12 = dialTickStyle.getTickWidth();
        float f4 = (float)((double)f3 * d12 / 100.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        BasicStroke basicStroke = new BasicStroke(f4, 1, 1);
        graphics2D.setStroke(basicStroke);
        Line2D.Double double_ = new Line2D.Double(d8, d9, d10, d11);
        graphics2D.draw(double_);
    }

    private double getLabelRotation(DialLabelOrientation dialLabelOrientation, double d) {
        double d2 = Math.toRadians(d);
        double d3 = dialLabelOrientation == DialLabelOrientation.PERPENDICULAR_OUTWARD ? d2 : (dialLabelOrientation == DialLabelOrientation.PERPENDICULAR_INWARD ? d2 - Math.PI : (dialLabelOrientation == DialLabelOrientation.TANGENTIAL_CLOCKWISE ? d2 - 1.5707963267948966 : (dialLabelOrientation == DialLabelOrientation.TANGENTIAL_ANTICLOCKWISE ? d2 + 1.5707963267948966 : 0.0)));
        return d3;
    }

    private void paintTickLabel(Graphics2D graphics2D, DialAxis dialAxis, float f, float f2, double d, float f3, String string, String string2, boolean bl) {
        double d2 = Math.toRadians(d);
        DialLabelOrientation dialLabelOrientation = dialAxis.getLabelOrientation();
        double d3 = dialAxis.getLabelRadius();
        Font font = this.tickLabelFontForAxis(dialAxis);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringWidth(string2);
        float f4 = f + (float)(d3 * (double)f3 * Math.cos(d2)) - (float)n / 2.0f;
        float f5 = f2 - (float)(d3 * (double)f3 * Math.sin(d2));
        double d4 = this.getLabelRotation(dialLabelOrientation, d);
        if (dialLabelOrientation == DialLabelOrientation.UPRIGHT) {
            int n3 = (n2 - n - fontMetrics.stringWidth("0")) / 2;
            double d5 = bl ? Math.cos(d2) * (double)n3 : -Math.cos(d2) * (double)n3;
            f4 = f + (float)(d3 * (double)f3 * Math.cos(d2) - (double)((float)n / 2.0f) + d5);
        }
        this.drawRotatedStringIfWithinBounds(graphics2D, font, string, Math.round(f4), Math.round(f5), d4);
    }

    private Shape calculateRotatedStringBounds(FontMetrics fontMetrics, String string, double d, double d2, double d3) {
        if (string == null || "".equals(string)) {
            return null;
        }
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d - (double)n / 2.0 - 1.0, d2 - (double)fontMetrics.getHeight() / 2.0 - 0.0, n + 2, n2 + 0);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d3, d, d2);
        return affineTransform.createTransformedShape(double_);
    }

    public GeneralPath createSegment(double d, double d2, double d3, double d4) {
        int n = this.getPivotX();
        int n2 = this.getPivotY();
        float f = this.getRadius();
        double d5 = Math.toRadians(d);
        double d6 = Math.toRadians(d2);
        GeneralPath generalPath = new GeneralPath();
        double d7 = d3 * (double)f;
        double d8 = d4 * (double)f;
        Point2D.Double double_ = new Point2D.Double((double)n + d7 * Math.cos(d5), (double)n2 - d7 * Math.sin(d5));
        Point2D.Double double_2 = new Point2D.Double((double)n + d8 * Math.cos(d6), (double)n2 - d8 * Math.sin(d6));
        generalPath.moveTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        Arc2D.Double double_3 = new Arc2D.Double((double)n - d7, (double)n2 - d7, d7 * 2.0, d7 * 2.0, d, d2 - d, 0);
        generalPath.append(double_3, true);
        generalPath.lineTo(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        Arc2D.Double double_4 = new Arc2D.Double((double)n - d8, (double)n2 - d8, d8 * 2.0, d8 * 2.0, d2, d - d2, 0);
        generalPath.append(double_4, true);
        generalPath.lineTo(((Point2D)double_).getX(), ((Point2D)double_).getY());
        generalPath.closePath();
        return generalPath;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Dial.class.getName(), 4096);
        }
    }

    class AxisChangeListener
    implements PropertyChangeListener {
        AxisChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Dial.this.dialImage = null;
            Dial.this.repaint();
        }
    }

    class NeedleAnimator
    implements ActionListener,
    Serializable {
        NeedleAnimator() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dial.this.updateNeedles();
        }
    }
}

