/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.GaugeModelEvent;
import com.jidesoft.gauge.GaugeModelListener;
import com.jidesoft.range.Positionable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultGaugeModel
implements GaugeModel {
    private static int modelCounter = 0;
    private String name;
    private Map<String, Positionable> values = new HashMap<String, Positionable>();
    private List<GaugeModelListener> listeners = new CopyOnWriteArrayList<GaugeModelListener>();

    public DefaultGaugeModel() {
        this(String.format("%d", ++modelCounter));
    }

    public DefaultGaugeModel(String string) {
        this.name = string;
    }

    @Override
    public void addGaugeModelListener(GaugeModelListener gaugeModelListener) {
        this.listeners.add(gaugeModelListener);
    }

    @Override
    public void removeGaugeModelListener(GaugeModelListener gaugeModelListener) {
        this.listeners.remove(gaugeModelListener);
    }

    protected void fireGaugeChanged(String string, Positionable positionable) {
        GaugeModelEvent gaugeModelEvent = new GaugeModelEvent(this, string, positionable);
        for (GaugeModelListener gaugeModelListener : this.listeners) {
            gaugeModelListener.gaugeChanged(gaugeModelEvent);
        }
    }

    @Override
    public Positionable getValue(String string) {
        return this.values.get(string);
    }

    public void setValue(String string, Double d) {
        RealPosition realPosition = new RealPosition(d);
        this.setValue(string, realPosition);
    }

    @Override
    public void setValue(String string, Positionable positionable) {
        this.values.put(string, positionable);
        this.fireGaugeChanged(string, positionable);
    }

    @Override
    public void setValue(String string, Positionable positionable, boolean bl) {
        this.values.put(string, positionable);
        if (bl) {
            this.fireGaugeChanged(string, positionable);
        }
    }

    @Override
    public int getValueCount() {
        return this.values == null ? 0 : this.values.size();
    }

    @Override
    public void clearValues() {
        this.values.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultGaugeModel defaultGaugeModel = (DefaultGaugeModel)object;
        if (this.name != null ? !this.name.equals(defaultGaugeModel.name) : defaultGaugeModel.name != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(defaultGaugeModel.values) : defaultGaugeModel.values != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 31 * n + (this.values != null ? this.values.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "DefaultGaugeModel{name='" + this.name + '\'' + ", values=" + this.values + '}';
    }
}

