/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BulletPointMarker
implements Drawable {
    private Bullet bullet;
    private double value;
    private Paint fill = Color.GRAY;
    private double breadthProportion = 0.75;
    private double lengthProportion = 0.1;

    public BulletPointMarker(Bullet bullet, double d) {
        this(bullet, Color.GRAY, d);
    }

    public BulletPointMarker(Bullet bullet, Paint paint, double d) {
        this.bullet = bullet;
        this.setFill(paint);
        this.value = d;
    }

    public double getBreadthProportion() {
        return this.breadthProportion;
    }

    public void setBreadthProportion(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.breadthProportion = d;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BulletAxis bulletAxis = this.bullet.getAxis();
        Point2D point2D = this.bullet.calculatePixelPoint2D(bulletAxis, this.value);
        if (point2D != null) {
            double d = this.breadthProportion * this.bullet.getBulletBreadth();
            double d2 = d * this.lengthProportion;
            Orientation orientation = this.bullet.getOrientation();
            double d3 = orientation == Orientation.horizontal ? point2D.getX() - d2 / 2.0 : point2D.getX() - d / 2.0;
            double d4 = orientation == Orientation.horizontal ? point2D.getY() - d / 2.0 : point2D.getY() - d2 / 2.0;
            double d5 = orientation == Orientation.horizontal ? d2 : d;
            double d6 = orientation == Orientation.horizontal ? d : d2;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
            graphics2D.setPaint(this.fill);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }
}

