/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Orientation;
import com.jidesoft.gauge.Bullet;
import com.jidesoft.gauge.BulletAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BulletIntervalMarker
implements Drawable {
    private Bullet bullet;
    private double from;
    private double to;
    private Paint fill = Color.GRAY;
    private double breadthProportion = 1.0;

    public BulletIntervalMarker(Bullet bullet, double d, double d2) {
        this(bullet, Color.GRAY, d, d2);
    }

    public BulletIntervalMarker(Bullet bullet, Paint paint, double d, double d2) {
        this.bullet = bullet;
        this.setFill(paint);
        this.from = d;
        this.to = d2;
    }

    public void setInterval(double d, double d2) {
        if (d2 < d) {
            throw new IllegalArgumentException(String.format("The from value (%f) should be less than the to value (%f)", d, d2));
        }
        this.from = d;
        this.to = d2;
    }

    public double getFrom() {
        return this.from;
    }

    public double getTo() {
        return this.to;
    }

    public double getBreadthProportion() {
        return this.breadthProportion;
    }

    public void setBreadthProportion(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The breadth proportion should be a value in the range [0,1]");
        }
        this.breadthProportion = d;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BulletAxis bulletAxis = this.bullet.getAxis();
        Point2D point2D = this.bullet.calculatePixelPoint2D(bulletAxis, this.from);
        Point2D point2D2 = this.bullet.calculatePixelPoint2D(bulletAxis, this.to);
        if (point2D != null && point2D2 != null) {
            double d;
            double d2;
            double d3 = this.breadthProportion * this.bullet.getBulletBreadth();
            Orientation orientation = this.bullet.getOrientation();
            double d4 = 0.0;
            double d5 = 0.0;
            if (orientation == Orientation.horizontal) {
                d2 = point2D.getX();
                d = point2D.getY() - d3 / 2.0;
                if (point2D2.getX() != point2D.getX()) {
                    d4 = 1.0 + point2D2.getX() - point2D.getX();
                }
                if (d3 > 0.0) {
                    d5 = (int)Math.ceil(d3);
                }
            } else {
                d2 = point2D.getX() - d3 / 2.0;
                d = point2D2.getY();
                if (d3 > 0.0) {
                    d4 = (int)Math.ceil(d3);
                }
                if (point2D.getY() != point2D2.getY()) {
                    d5 = 1.0 + point2D.getY() - point2D2.getY();
                }
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d, d4, d5);
            graphics2D.setPaint(this.fill);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
    }
}

