/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class PaintedTexture {
    private final int _width;
    private final int _height;

    public PaintedTexture(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    protected abstract void drawTexture(Graphics2D var1);

    public TexturePaint createTexturePaint() {
        BufferedImage bufferedImage = new BufferedImage(this._width, this._height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.drawTexture(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, this._width, this._height));
    }

    public static TexturePaint createDiagonalLines(int n, int n2, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n, n2){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                if (bl) {
                    graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
                }
                if (bl2) {
                    graphics2D.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }

    public static TexturePaint createLines(int n, int n2, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n, n2){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                if (bl) {
                    graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
                }
                if (bl2) {
                    graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }
}

