/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.DefaultPeriodBackgroundPainter;
import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.scale.DatePeriod;
import com.jidesoft.scale.DatePeriodConverter;
import com.jidesoft.scale.ScaleArea;
import java.util.Date;

public class DateGanttChart<S extends GanttEntry<Date>>
extends GanttChart<Date, S> {
    private static final long serialVersionUID = 4549526960944599061L;

    public DateGanttChart() {
        this.initGanttChart();
    }

    public DateGanttChart(GanttModel<Date, S> ganttModel) {
        super(ganttModel);
        this.initGanttChart();
    }

    public DateGanttChart(ScaleArea<Date> scaleArea) {
        super(scaleArea);
        this.initGanttChart();
    }

    public DateGanttChart(GanttModel<Date, S> ganttModel, ScaleArea<Date> scaleArea) {
        super(ganttModel, scaleArea);
        this.initGanttChart();
    }

    private void initGanttChart() {
        ScaleArea<Date> scaleArea = this.getScaleArea();
        scaleArea.setDefaultPeriodConverter(DatePeriodConverter.createDefaultPeriodConverter(scaleArea));
        for (DatePeriod datePeriod : DatePeriod.getDefaultDatePeriods()) {
            scaleArea.setPeriodConverter(datePeriod, DatePeriodConverter.createPeriodConverter(scaleArea, datePeriod));
        }
        DefaultPeriodBackgroundPainter defaultPeriodBackgroundPainter = new DefaultPeriodBackgroundPainter(DatePeriod.MONTH);
        this.addPeriodBackgroundPainter(defaultPeriodBackgroundPainter);
    }
}

