/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.AbstractPeriodBackgroundPainter;
import com.jidesoft.scale.Period;
import java.awt.Paint;
import java.awt.Stroke;

public abstract class AbstractPeriodMarker<T>
extends AbstractPeriodBackgroundPainter<T> {
    private final Paint _backgroundPaint;
    private final Paint _outlinePaint;
    private final Stroke _outlineStroke;

    public abstract boolean isPeriodMarked(T var1, T var2);

    public abstract boolean isPreviousPeriodMarked(T var1, T var2);

    public abstract boolean isNextPeriodMarked(T var1, T var2);

    public AbstractPeriodMarker(Period period, Paint paint, Paint paint2, Stroke stroke) {
        super(period);
        this._backgroundPaint = paint;
        this._outlinePaint = paint2;
        this._outlineStroke = stroke;
    }

    @Override
    public Paint getBackgroundPaint(T t, T t2) {
        if (this.isPeriodMarked(t, t2)) {
            return this._backgroundPaint;
        }
        return null;
    }

    @Override
    public Paint getOutlinePaint(T t, T t2) {
        if (this.isPeriodMarked(t, t2)) {
            return this._outlinePaint;
        }
        return null;
    }

    @Override
    public Stroke getOutlineStroke(T t, T t2) {
        if (this.isPeriodMarked(t, t2)) {
            return this._outlineStroke;
        }
        return null;
    }

    @Override
    public int getOutlineSides(T t, T t2) {
        int n = 0;
        if (this.isPeriodMarked(t, t2)) {
            if (!this.isPreviousPeriodMarked(t, t2)) {
                n |= 1;
            }
            if (!this.isNextPeriodMarked(t, t2)) {
                n |= 2;
            }
        }
        return n;
    }
}

