/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.status;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.status.CaretStatusBarItem;
import javax.swing.text.BadLocationException;

class CaretContextStatusBarItem
extends CaretStatusBarItem {
    private int _scope = 2;

    public CaretContextStatusBarItem() {
    }

    public CaretContextStatusBarItem(String string) {
        super(string);
    }

    public int getScope() {
        return this._scope;
    }

    public void setScope(int n) {
        this._scope = n;
    }

    @Override
    public void caretUpdated(CodeEditor codeEditor) {
        int n = codeEditor.getCaretModel().getOffset();
        if (n > codeEditor.getDocument().getLength()) {
            return;
        }
        int n2 = Math.max(0, n - this.getScope());
        int n3 = Math.min(codeEditor.getDocumentLength(), n + this.getScope());
        try {
            String string = codeEditor.getDocument().getText(n2, n - n2);
            String string2 = codeEditor.getDocument().getText(n, n3 - n);
            StringBuffer stringBuffer = new StringBuffer("<html>");
            this.appendSpecialChars(string, stringBuffer);
            stringBuffer.append("<font color=red>|</font>");
            this.appendSpecialChars(string2, stringBuffer);
            stringBuffer.append("</html>");
            this.setText(stringBuffer.toString());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void appendSpecialChars(String string, StringBuffer stringBuffer) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            stringBuffer.append(CaretContextStatusBarItem.convert(c));
        }
    }

    public static String convert(char c) {
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == ' ') {
            return "_";
        }
        if (c == '\t') {
            return "\\t";
        }
        return "" + c;
    }
}

