/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.marker;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.range.IntegerRange;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;

public class MarkerStripe
extends com.jidesoft.marker.MarkerStripe {
    private CodeEditor _editor;
    private static final int OFFSET = 2;

    public MarkerStripe(MarkerArea markerArea) {
        this(null, markerArea);
    }

    public MarkerStripe(CodeEditor codeEditor, MarkerArea markerArea) {
        super(markerArea);
        this._editor = codeEditor;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        this._editor = codeEditor;
    }

    @Override
    protected List<Marker> getMarkersAt(Point point) {
        Insets insets = this.getInsets();
        int n = Math.max(0, this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom);
        IntegerRange integerRange = this._markerSupport.pointToIndexRange(new Point(Math.max(0, point.x - 2), Math.max(0, point.y - 2)), n);
        IntegerRange integerRange2 = this._markerSupport.pointToIndexRange(new Point(point.x + 2, point.y + 2), n);
        IntegerRange integerRange3 = new IntegerRange(this._editor.viewToModelLine(integerRange.getMin()), this._editor.viewToModelLine(integerRange2.getMax() + 1) - 1);
        MarkerModel markerModel = this._markerSupport.getMarkerModel();
        return markerModel.getMarkersAt(this._editor.modelPositionToOffset(new CaretPosition(integerRange3.getMin(), 0)), this._editor.modelPositionToOffset(new CaretPosition(integerRange3.getMax(), this._editor.getLineLength(integerRange3.getMax()))));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        List<Marker> list = this.getMarkersAt(mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            Marker marker = list.get(0);
            int n = marker.getStartOffset();
            FoldingSpan[] foldingSpanArray = this._editor.getFoldingModel().getFoldingSpans();
            if (foldingSpanArray != null) {
                for (FoldingSpan foldingSpan : foldingSpanArray) {
                    if (foldingSpan == null || foldingSpan.isExpanded() || n < foldingSpan.getStartOffset() || n > foldingSpan.getEndOffset()) continue;
                    this._editor.getFoldingModel().expandFoldingSpan(foldingSpan);
                    break;
                }
            }
            this._editor.select(n, n);
            int n2 = this._editor.getLineNumber(n);
            int n3 = n2 - this._editor.getVisibleLines() / 3;
            this._editor.setFirstLine(Math.max(0, n3));
            this._editor.requestFocus();
        }
    }
}

