/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.folding;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.DefaultSpan;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;

public class DefaultFoldingSpan
extends DefaultSpan
implements FoldingSpan {
    private boolean _expanded = true;
    private String _description;
    private CodeEditor _editor;

    public DefaultFoldingSpan(CodeEditor codeEditor, int n, int n2) {
        this(codeEditor, n, n2, "...");
    }

    public DefaultFoldingSpan(CodeEditor codeEditor, int n, int n2, String string) {
        super(n, n2);
        this._editor = codeEditor;
        this._description = string;
    }

    @Override
    public void setExpanded(boolean bl) {
        FoldingModel foldingModel = this._editor.getFoldingModel();
        if (bl) {
            foldingModel.expandFoldingSpan(this);
        } else {
            foldingModel.collapseFoldingSpan(this);
        }
    }

    @Override
    public boolean isExpanded() {
        return this._expanded;
    }

    void setExpandedInternal(boolean bl) {
        this._expanded = bl;
    }

    @Override
    public void setStartOffset(int n) {
        int n2 = this.getStartOffset();
        if (n2 != n) {
            super.setStartOffset(n);
            this._editor.getFoldingModel().foldingSpanUpdated(this);
        }
    }

    @Override
    public void setEndOffset(int n) {
        int n2 = this.getEndOffset();
        if (n2 != n) {
            super.setEndOffset(n);
            this._editor.getFoldingModel().foldingSpanUpdated(this);
        }
    }

    public void setDescription(String string) {
        this._description = string;
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

