/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.ColorStyle;
import com.jidesoft.editor.EffectStyle;
import com.jidesoft.editor.FontStyle;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SyntaxStyle
implements ColorStyle,
FontStyle,
EffectStyle {
    private int _fontStyle;
    private Color _foreground;
    private Color _background;
    private int _effect;
    private Color _effectColor;
    private Color _stripeColor;
    private transient Font lastFont;
    private transient Font lastStyledFont;
    private transient FontMetrics fontMetrics;

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, int n) {
        this._foreground = color;
        this._fontStyle = n;
    }

    public SyntaxStyle(int n, Color color) {
        this._effect = n;
        this._effectColor = color;
    }

    public SyntaxStyle(int n, Color color, Color color2) {
        this._effect = n;
        this._effectColor = color;
        this._stripeColor = color2;
    }

    public SyntaxStyle(Color color) {
        this._background = color;
    }

    public SyntaxStyle(Color color, Color color2) {
        this._background = color;
        this._foreground = color2;
    }

    public SyntaxStyle(Color color, Color color2, Color color3) {
        this._background = color;
        this._foreground = color2;
        this._stripeColor = color3;
    }

    @Override
    public Color getForeground() {
        return this._foreground;
    }

    @Override
    public void setForeground(Color color) {
        this._foreground = color;
    }

    @Override
    public int getFontStyle() {
        return this._fontStyle;
    }

    @Override
    public void setFontStyle(int n) {
        this._fontStyle = n;
        this.resetFont();
    }

    private void resetFont() {
        this.lastFont = null;
        this.lastStyledFont = null;
        this.fontMetrics = null;
    }

    public boolean isItalic() {
        return (this.getFontStyle() & 2) != 0;
    }

    public boolean isBold() {
        return (this.getFontStyle() & 1) != 0;
    }

    public boolean isPlain() {
        return this.getFontStyle() == 0;
    }

    @Override
    public Color getBackground() {
        return this._background;
    }

    @Override
    public void setBackground(Color color) {
        this._background = color;
    }

    @Override
    public Color getEffectColor() {
        if (this.getEffect() != 0 && this._effectColor == null) {
            return Color.RED;
        }
        return this._effectColor;
    }

    @Override
    public void setEffectColor(Color color) {
        this._effectColor = color;
    }

    @Override
    public int getEffect() {
        return this._effect;
    }

    @Override
    public void setEffect(int n) {
        this._effect = n;
    }

    @Override
    public Color getStripeColor() {
        return this._stripeColor;
    }

    @Override
    public void setStripeColor(Color color) {
        this._stripeColor = color;
    }

    public Font getStyledFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.lastFont)) {
            return this.lastStyledFont;
        }
        return font.deriveFont(this.getFontStyle());
    }

    public FontMetrics getFontMetrics(Font font, Graphics graphics) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.lastFont) && this.fontMetrics != null) {
            return this.fontMetrics;
        }
        this.lastFont = font;
        this.lastStyledFont = font.deriveFont(this.getFontStyle());
        this.fontMetrics = graphics.getFontMetrics(this.lastStyledFont);
        return this.fontMetrics;
    }

    public void setGraphicsFlags(Graphics graphics, Font font) {
        Font font2 = this.getStyledFont(font);
        graphics.setFont(font2);
        graphics.setColor(this._foreground);
    }

    public String toString() {
        return this.getClass().getName() + "[color=" + this._foreground + (this.isItalic() ? ",italic" : "") + (this.isBold() ? ",bold" : "") + "]";
    }

    public void paintMarker(Graphics graphics, int n, int n2, int n3, FontMetrics fontMetrics) {
        Color color = graphics.getColor();
        if (this.getBackground() != null) {
            if (SystemInfo.isJdk6u14Above()) {
                graphics.setXORMode(Color.WHITE);
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n2 - n, fontMetrics.getHeight());
            if (SystemInfo.isJdk6u14Above()) {
                graphics.setPaintMode();
            }
        }
        this.paintEffect(graphics, n, n2, n3, fontMetrics);
        graphics.setColor(color);
    }

    private void paintEffect(Graphics graphics, int n, int n2, int n3, FontMetrics fontMetrics) {
        switch (this.getEffect()) {
            case 2: {
                graphics.setColor(this.getEffectColor());
                int n4 = n3 + fontMetrics.getHeight() + 1;
                for (int i = n; i < n2; i += 4) {
                    if (i + 2 <= n2 - 1) {
                        graphics.drawLine(i, n4 + 2, i + 2, n4);
                    }
                    if (i + 4 > n2 - 1) continue;
                    graphics.drawLine(i + 3, n4 + 1, i + 4, n4 + 2);
                }
                break;
            }
            case 1: {
                graphics.setColor(this.getEffectColor());
                int n5 = n3 + fontMetrics.getHeight() + 1;
                graphics.drawLine(n, n5, n2, n5);
                break;
            }
            case 3: {
                graphics.setColor(this.getEffectColor());
                int n6 = n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent() + fontMetrics.getHeight() / 2 + 1;
                graphics.drawLine(n, n6, n2, n6);
                break;
            }
            case 4: {
                graphics.setColor(this.getEffectColor());
                graphics.drawRect(n, n3 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n2 - n, fontMetrics.getHeight() - 1);
                break;
            }
        }
    }
}

