/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.margin.RowMarginSupport;

public class CodeEditorRowMarginSupport
extends CodeEditorMarginSupport
implements RowMarginSupport {
    public CodeEditorRowMarginSupport(CodeEditor codeEditor) {
        super(codeEditor);
    }

    @Override
    public int getRowCount() {
        return this._codeEditor.getLineCount();
    }

    @Override
    public int getRowHeight(int n) {
        return this._codeEditor.getLineHeight();
    }

    @Override
    public int positionToRow(int n) {
        if (this._codeEditor == null || this._codeEditor.getDocument() == null) {
            return -1;
        }
        int n2 = this._codeEditor.lineToY(this._codeEditor.getFirstLine());
        return this._codeEditor.yToLine(n + n2 + 1);
    }

    @Override
    public int rowToPosition(int n) {
        int n2 = this._codeEditor.lineToY(this._codeEditor.getFirstLine());
        return this._codeEditor.lineToY(n) - n2 - 1;
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        int n3;
        int n4 = n <= n2 ? this._codeEditor.getLineStartOffset(this._codeEditor.viewToModelLine(n)) : this._codeEditor.getLineStartOffset(this._codeEditor.viewToModelLine(n + 1));
        int n5 = n3 = n <= n2 ? this._codeEditor.getLineStartOffset(this._codeEditor.viewToModelLine(n2 + 1)) : this._codeEditor.getLineStartOffset(this._codeEditor.viewToModelLine(n2));
        if (bl) {
            this._codeEditor.select(n4, n3, false);
        }
        if (n == n2) {
            this._codeEditor.getCaretModel().setOffset(n4);
            this._codeEditor.scrollToCaret(false);
        } else {
            this._codeEditor.getCaretModel().setOffset(n3);
            this._codeEditor.scrollToCaret(false);
        }
    }

    @Override
    public int visualRowToActualRow(int n) {
        return this._codeEditor.viewToModelLine(n);
    }

    @Override
    public int actualRowToVisualRow(int n) {
        return this._codeEditor.modelToViewLine(n);
    }

    @Override
    public int getBaselineAdjustment() {
        return 1;
    }
}

