/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.TdiGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrameFloatingDocumentContainer
extends JFrame
implements FloatingDocumentContainer {
    private DocumentPane _documentPane;
    private IDocumentGroup _documentGroup;
    private boolean _routingKeyStrokes;

    public FrameFloatingDocumentContainer(DocumentPane documentPane) throws HeadlessException {
        this.setDefaultCloseOperation(0);
        this.setRoutingKeyStrokes(true);
        this._documentPane = documentPane;
        this.addWindowListener(new WindowAdapter(){
            private boolean _hasDisposed = false;

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (FrameFloatingDocumentContainer.this._documentPane.getFloatingContainerCloseAction() == 0) {
                    FrameFloatingDocumentContainer.this._documentPane.closeDocuments(FrameFloatingDocumentContainer.this);
                } else if (FrameFloatingDocumentContainer.this._documentPane.getFloatingContainerCloseAction() == 1) {
                    FrameFloatingDocumentContainer.this._documentPane.dockDocuments(FrameFloatingDocumentContainer.this);
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (!this._hasDisposed) {
                    this._hasDisposed = true;
                    FrameFloatingDocumentContainer.this.dispose();
                }
            }
        });
        this._documentGroup = this._documentPane.createDocumentGroup();
        ((TdiGroup)this._documentGroup).addContainerListener(new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                if (FrameFloatingDocumentContainer.this._documentGroup.getDocumentCount() == 0) {
                    FrameFloatingDocumentContainer.this.dispose();
                    FrameFloatingDocumentContainer.this._documentPane.removeFloatingContainer(FrameFloatingDocumentContainer.this);
                }
            }
        });
        ((TdiGroup)this._documentGroup).addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FrameFloatingDocumentContainer.this.updateTitle();
            }
        });
        ((TdiGroup)this._documentGroup).addPropertyChangeListener("indexForTitle", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FrameFloatingDocumentContainer.this.updateTitle();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                Component component;
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                if (bl2 || keyEvent.isConsumed() || !FrameFloatingDocumentContainer.this.isRoutingKeyStrokes()) {
                    return bl2;
                }
                if (keyEvent.getSource() instanceof JComponent) {
                    Class<?> clazz;
                    component = ((JComponent)keyEvent.getSource()).getRootPane();
                    for (clazz = component.getClass(); clazz != JComponent.class && clazz != null; clazz = clazz.getSuperclass()) {
                    }
                    try {
                        if (clazz != null) {
                            Method method = clazz.getDeclaredMethod("processKeyBinding", KeyStroke.class, KeyEvent.class, Integer.TYPE, Boolean.TYPE);
                            method.setAccessible(true);
                            bl2 = (Boolean)method.invoke((Object)component, keyStroke, keyEvent, 2, bl);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                }
                if (bl2 || keyEvent.isConsumed()) {
                    return bl2;
                }
                component = FrameFloatingDocumentContainer.this.getRoutingComponent();
                if (component == null) {
                    return false;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(component, keyEvent);
                return keyEvent.isConsumed();
            }
        };
        jPanel.add((Component)((Object)this._documentGroup));
        this.add(jPanel);
    }

    @Override
    public void updateTitle() {
        String string = this._documentPane.getFloatingContainerTitle((TdiGroup)this._documentGroup);
        this.setTitle(string != null ? string : "");
    }

    @Override
    public DocumentPane getDocumentPane() {
        return this._documentPane;
    }

    @Override
    public IDocumentGroup getDocumentGroup() {
        return this._documentGroup;
    }

    @Override
    public Component getRoutingComponent() {
        return this._documentPane;
    }

    @Override
    public void setRoutingKeyStrokes(boolean bl) {
        this._routingKeyStrokes = bl;
    }

    @Override
    public boolean isRoutingKeyStrokes() {
        return this._routingKeyStrokes;
    }
}

