/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.document;

import com.jidesoft.document.DialogFloatingDocumentContainer;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.FrameFloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.PersistenceUtilsCallback;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentPanePersistenceUtils {
    private static final String NODE_DOCUMENT_GROUP = "DocumentGroup";
    private static final String NODE_FLOATING_CONTAINER = "FloatingDocumentContainer";
    private static final String NODE_DOCUMENT = "Document";
    private static final String NODE_BOUNDS = "Bounds";
    private static final String ATTRIBUTE_ORIENTATION = "orientation";
    private static final String ATTRIBUTE_PROPORTION_LAYOUT = "proportionLayout";
    private static final String ATTRIBUTE_INITIALLY_EVEN = "initiallyEven";
    private static final String ATTRIBUTE_PROPORTION = "proportion";
    private static final String ATTRIBUTE_ACTIVE_DOCUMENT = "activeDocument";
    private static final String ATTRIBUTE_PREFERRED_WIDTH = "preferredWidth";
    private static final String ATTRIBUTE_PREFERRED_HEIGHT = "preferredHeight";
    private static final String ATTRIBUTE_SELECTED_DOCUMENT = "selectedComponent";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_X = "x";
    private static final String ATTRIBUTE_Y = "y";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";

    public static void save(DocumentPane documentPane, String string) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DocumentPane documentPane, String string, String string2) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, string, string2, null);
    }

    public static void save(final DocumentPane documentPane, final String string, final String string2, final PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Document document = DocumentPanePersistenceUtils.save(documentPane, save);
            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document document = DocumentPanePersistenceUtils.save(documentPane, save);
                            PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        DocumentPanePersistenceUtils.save(documentPane, outputStream, string, null);
    }

    public static void save(DocumentPane documentPane, OutputStream outputStream, String string, PersistenceUtilsCallback.Save save) throws ParserConfigurationException, IOException {
        Document document = DocumentPanePersistenceUtils.save(documentPane, save);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(DocumentPane documentPane, PersistenceUtilsCallback.Save save) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DocumentPanePersistenceUtils.saveToDocument(documentPane, document, save);
        return document;
    }

    static void saveToDocument(DocumentPane documentPane, Document document, PersistenceUtilsCallback.Save save) {
        Object object;
        if (documentPane == null || documentPane.getLayoutPersistence() == null) {
            return;
        }
        LayoutPersistence layoutPersistence = documentPane.getLayoutPersistence();
        Node node = document.getElementsByTagName("LayoutPersistence").item(0);
        if (node == null) {
            node = document.createElement("LayoutPersistence");
            document.appendChild(node);
        }
        Element element = document.createElement("DocumentPane");
        node.appendChild(element);
        element.setAttribute("version", "" + layoutPersistence.getVersion());
        if (layoutPersistence.getLayoutPersistenceName() != null) {
            element.setAttribute("persistenceName", layoutPersistence.getLayoutPersistenceName());
        }
        element.setAttribute(ATTRIBUTE_ORIENTATION, "" + documentPane.getOrientation());
        element.setAttribute(ATTRIBUTE_PROPORTION_LAYOUT, documentPane.isProportionalLayout() ? "1" : "0");
        element.setAttribute(ATTRIBUTE_INITIALLY_EVEN, documentPane.isInitiallyEven() ? "1" : "0");
        if (documentPane.getProportions() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (double d : documentPane.getProportions()) {
                stringBuffer.append(d).append(';');
            }
            element.setAttribute(ATTRIBUTE_PROPORTION, "" + stringBuffer.substring(0, stringBuffer.length() - 1));
        }
        element.setAttribute(ATTRIBUTE_ACTIVE_DOCUMENT, "" + documentPane.getActiveDocumentName());
        for (int i = 0; i < documentPane.getPaneCount(); ++i) {
            object = documentPane.getDocumentGroupAt(i);
            DocumentPanePersistenceUtils.writeDocumentGroup(document, element, documentPane, (IDocumentGroup)object, save);
        }
        List<FloatingDocumentContainer> list = documentPane.getFloatingContainers();
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                FloatingDocumentContainer floatingDocumentContainer = (FloatingDocumentContainer)object.next();
                DocumentPanePersistenceUtils.writeFloatingContainer(document, element, documentPane, floatingDocumentContainer, save);
            }
        }
    }

    private static void writeFloatingContainer(Document document, Element element, DocumentPane documentPane, FloatingDocumentContainer floatingDocumentContainer, PersistenceUtilsCallback.Save save) {
        Object object;
        if (floatingDocumentContainer == null) {
            return;
        }
        Element element2 = document.createElement(NODE_FLOATING_CONTAINER);
        element.appendChild(element2);
        Rectangle rectangle = floatingDocumentContainer.getBounds();
        if (rectangle != null) {
            object = document.createElement(NODE_BOUNDS);
            element2.appendChild((Node)object);
            object.setAttribute(ATTRIBUTE_X, "" + rectangle.x);
            object.setAttribute(ATTRIBUTE_Y, "" + rectangle.y);
            object.setAttribute(ATTRIBUTE_WIDTH, "" + rectangle.width);
            object.setAttribute(ATTRIBUTE_HEIGHT, "" + rectangle.height);
        }
        object = floatingDocumentContainer.getDocumentGroup();
        DocumentPanePersistenceUtils.writeDocumentGroup(document, element2, documentPane, (IDocumentGroup)object, save);
        if (save != null) {
            save.save(document, element2, floatingDocumentContainer);
        }
    }

    private static void writeDocumentGroup(Document document, Element element, DocumentPane documentPane, IDocumentGroup iDocumentGroup, PersistenceUtilsCallback.Save save) {
        if (iDocumentGroup == null) {
            return;
        }
        Element element2 = document.createElement(NODE_DOCUMENT_GROUP);
        element.appendChild(element2);
        Dimension dimension = ((JComponent)((Object)iDocumentGroup)).getPreferredSize();
        element2.setAttribute(ATTRIBUTE_PREFERRED_WIDTH, "" + dimension.width);
        element2.setAttribute(ATTRIBUTE_PREFERRED_HEIGHT, "" + dimension.height);
        element2.setAttribute(ATTRIBUTE_SELECTED_DOCUMENT, "" + documentPane.getNameOf(iDocumentGroup.getSelectedDocument()));
        int n = iDocumentGroup.getDocumentCount();
        for (int i = 0; i < n; ++i) {
            Component component = iDocumentGroup.getDocumentAt(i);
            if (component == null) continue;
            Element element3 = document.createElement(NODE_DOCUMENT);
            element2.appendChild(element3);
            String string = documentPane.getNameOf(component);
            element3.setAttribute(ATTRIBUTE_NAME, string);
            if (save == null) continue;
            save.save(document, element3, iDocumentGroup);
        }
        if (save != null) {
            save.save(document, element2, iDocumentGroup);
        }
    }

    public static void load(DocumentPane documentPane, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, inputStream, null);
    }

    public static void load(DocumentPane documentPane, InputStream inputStream, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, PersistenceUtils.getDocument(inputStream), load);
    }

    public static void load(DocumentPane documentPane, String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, string, null);
    }

    public static void load(DocumentPane documentPane, String string, PersistenceUtilsCallback.Load load) throws ParserConfigurationException, SAXException, IOException {
        DocumentPanePersistenceUtils.load(documentPane, PersistenceUtils.getDocument(string), load);
    }

    public static void load(final DocumentPane documentPane, final Document document, final PersistenceUtilsCallback.Load load) {
        if (SwingUtilities.isEventDispatchThread()) {
            DocumentPanePersistenceUtils.internalLoad(documentPane, document, load);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentPanePersistenceUtils.internalLoad(documentPane, document, load);
                }
            });
        }
    }

    static boolean internalLoad(DocumentPane documentPane, Document document, PersistenceUtilsCallback.Load load) {
        if (documentPane == null || documentPane.getLayoutPersistence() == null) {
            return false;
        }
        if (document == null) {
            documentPane.getLayoutPersistence().resetToDefault();
            return false;
        }
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            String string;
            Object object4;
            Object object5;
            Node node = document.getElementsByTagName("LayoutPersistence").item(0);
            Node node2 = null;
            if (node != null) {
                object5 = node.getChildNodes();
                for (int i = 0; i < object5.getLength(); ++i) {
                    object4 = object5.item(i);
                    if (!"DocumentPane".equals(object4.getNodeName())) continue;
                    string = null;
                    object3 = object4.getAttributes();
                    for (int j = 0; j < object3.getLength(); ++j) {
                        object2 = object3.item(j);
                        if (!"persistenceName".equals(object2.getNodeName())) continue;
                        string = object2.getNodeValue();
                        break;
                    }
                    if (!JideSwingUtilities.equals(string, documentPane.getLayoutPersistence().getLayoutPersistenceName())) continue;
                    node2 = object4;
                    break;
                }
            }
            if (node2 == null) {
                documentPane.getLayoutPersistence().resetToDefault();
                return false;
            }
            object5 = null;
            String string2 = null;
            object4 = null;
            string = null;
            object3 = null;
            String string3 = null;
            object2 = node2.getAttributes();
            for (n = 0; n < object2.getLength(); ++n) {
                object = object2.item(n);
                if ("version".equals(object.getNodeName())) {
                    object5 = object.getNodeValue();
                    continue;
                }
                if (ATTRIBUTE_ORIENTATION.equals(object.getNodeName())) {
                    string2 = object.getNodeValue();
                    continue;
                }
                if (ATTRIBUTE_ACTIVE_DOCUMENT.equals(object.getNodeName())) {
                    object4 = object.getNodeValue();
                    continue;
                }
                if (ATTRIBUTE_PROPORTION.equals(object.getNodeName())) {
                    string = object.getNodeValue();
                    continue;
                }
                if (ATTRIBUTE_PROPORTION_LAYOUT.equals(object.getNodeName())) {
                    object3 = object.getNodeValue();
                    continue;
                }
                if (!ATTRIBUTE_INITIALLY_EVEN.equals(object.getNodeName())) continue;
                string3 = object.getNodeValue();
            }
            if (object5 != null) {
                documentPane.getLayoutPersistence().setVersion(Short.valueOf((String)object5));
            }
            if (string2 != null) {
                documentPane.setOrientation(Integer.valueOf(string2));
            }
            documentPane.setProportionalLayout("1".equals(object3));
            if (documentPane.isProportionalLayout()) {
                documentPane.setInitiallyEven("1".equals(string3));
                if (string != null) {
                    String[] stringArray = string.split(";");
                    object = new double[stringArray.length];
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        object[i] = Double.valueOf(stringArray[i]);
                    }
                    documentPane.setProportions((double[])object);
                }
            }
            if (documentPane._documentComponentList == null) {
                documentPane._documentComponentList = new ArrayList<DocumentComponent>();
                for (n = 0; n < documentPane.getDocumentCount(); ++n) {
                    documentPane._documentComponentList.add(documentPane.getDocumentAt(n));
                }
            }
            documentPane.closeAll(true);
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object6;
                Node node3 = nodeList.item(i);
                if (NODE_DOCUMENT_GROUP.equals(node3.getNodeName())) {
                    object6 = documentPane.createDocumentGroup();
                    DocumentPanePersistenceUtils.readDocumentGroup(document, documentPane, (IDocumentGroup)object6, node3, load);
                    if (object6.getDocumentCount() <= 0) continue;
                    documentPane.add((Component)((JComponent)object6), "flexible");
                    continue;
                }
                if (!NODE_FLOATING_CONTAINER.equals(node3.getNodeName()) || (object6 = DocumentPanePersistenceUtils.readFloatingContainer(document, documentPane, node3, load)) == null) continue;
                documentPane._floatingContainers.add((FloatingDocumentContainer)object6);
            }
            if (object4 != null && documentPane.isDocumentOpened((String)object4)) {
                documentPane.setActiveDocument((String)object4);
            }
            documentPane.clearOpenedDocuments();
            return true;
        }
        catch (Exception exception) {
            documentPane.getLayoutPersistence().resetToDefault();
            return false;
        }
    }

    private static Rectangle readBounds(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_X.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_Y.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_WIDTH.equals(node2.getNodeName())) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_HEIGHT.equals(node2.getNodeName())) continue;
            string4 = node2.getNodeValue();
        }
        Rectangle rectangle = new Rectangle();
        if (string != null) {
            rectangle.x = Integer.valueOf(string);
        }
        if (string2 != null) {
            rectangle.y = Integer.valueOf(string2);
        }
        if (string3 != null) {
            rectangle.width = Integer.valueOf(string3);
        }
        if (string4 != null) {
            rectangle.height = Integer.valueOf(string4);
        }
        return rectangle;
    }

    private static FloatingDocumentContainer readFloatingContainer(Document document, DocumentPane documentPane, Node node, PersistenceUtilsCallback.Load load) {
        FloatingDocumentContainer floatingDocumentContainer = documentPane.createFloatingDocumentContainer();
        IDocumentGroup iDocumentGroup = floatingDocumentContainer.getDocumentGroup();
        Rectangle rectangle = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (NODE_BOUNDS.equals(node2.getNodeName())) {
                rectangle = DocumentPanePersistenceUtils.readBounds(node2);
                continue;
            }
            if (!NODE_DOCUMENT_GROUP.equals(node2.getNodeName())) continue;
            DocumentPanePersistenceUtils.readDocumentGroup(document, documentPane, iDocumentGroup, node2, load);
        }
        if (iDocumentGroup.getDocumentCount() > 0) {
            floatingDocumentContainer.pack();
            if (rectangle != null) {
                floatingDocumentContainer.setBounds(rectangle);
            }
            floatingDocumentContainer.setVisible(true);
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, floatingDocumentContainer);
            }
            return floatingDocumentContainer;
        }
        if (floatingDocumentContainer instanceof DialogFloatingDocumentContainer) {
            ((DialogFloatingDocumentContainer)floatingDocumentContainer).dispose();
        } else if (floatingDocumentContainer instanceof FrameFloatingDocumentContainer) {
            ((FrameFloatingDocumentContainer)floatingDocumentContainer).dispose();
        }
        return null;
    }

    private static DocumentComponent readDocument(Document document, DocumentPane documentPane, Node node, PersistenceUtilsCallback.Load load) {
        Object object;
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object = namedNodeMap.item(i);
            if (!ATTRIBUTE_NAME.equals(object.getNodeName())) continue;
            string = object.getNodeValue();
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        DocumentComponent documentComponent = documentPane.findDocumentComponent(string);
        if (documentComponent == null && (object = documentPane.getDocumentComponentFactory()) != null && (documentComponent = object.create(string)) != null) {
            documentPane._documentComponentList.add(documentComponent);
        }
        if (documentComponent != null) {
            documentComponent.setDocumentPane(documentPane);
            documentPane.addToMap(documentComponent);
            documentComponent.fireDocumentComponentEvent(5999);
            documentComponent.fireDocumentComponentEvent(6006);
            documentComponent.getComponent().setPreferredSize(new Dimension(200, 200));
            if (load != null && node instanceof Element) {
                load.load(document, (Element)node, documentComponent);
            }
        }
        return documentComponent;
    }

    private static void readDocumentGroup(Document document, DocumentPane documentPane, IDocumentGroup iDocumentGroup, Node node, PersistenceUtilsCallback.Load load) {
        DocumentComponent documentComponent;
        String string = null;
        String string2 = null;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (ATTRIBUTE_PREFERRED_WIDTH.equals(node2.getNodeName())) {
                string = node2.getNodeValue();
                continue;
            }
            if (ATTRIBUTE_PREFERRED_HEIGHT.equals(node2.getNodeName())) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (!ATTRIBUTE_SELECTED_DOCUMENT.equals(node2.getNodeName())) continue;
            string3 = node2.getNodeValue();
        }
        if (string != null && string2 != null) {
            ((JComponent)((Object)iDocumentGroup)).setPreferredSize(new Dimension(Integer.valueOf(string), Integer.valueOf(string2)));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DocumentComponent documentComponent2;
            Node node3 = nodeList.item(i);
            if (!NODE_DOCUMENT.equals(node3.getNodeName()) || (documentComponent2 = DocumentPanePersistenceUtils.readDocument(document, documentPane, node3, load)) == null) continue;
            iDocumentGroup.addDocument(documentComponent2);
        }
        if (string3 != null && (documentComponent = documentPane.findDocumentComponent(string3)) != null) {
            iDocumentGroup.setSelectedDocument(documentComponent.getComponent());
        }
        if (load != null && node instanceof Element) {
            load.load(document, (Element)node, iDocumentGroup);
        }
    }
}

