/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.SlidingOverFrameContainer;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class SlidingAnimator {
    private DockingManager _dockingManager;
    private Handler _handler;
    private DockedFrameContainer _dockedFrameContainer;
    private SlidingOverFrameContainer _animationLayer;
    private Component _component;
    private SlidingOverFrameContainer.SlidingFrameConstraint _componentContstraints;
    private int _delay;
    private Timer _timer;
    private boolean _forceCompleteHide;
    private boolean _playingTransition;
    private boolean _closingTransition;
    private boolean _isOpened;
    private JComponent _sizeSurrogate;

    public SlidingAnimator(DockingManager dockingManager, Handler handler, DockedFrameContainer dockedFrameContainer, SlidingOverFrameContainer slidingOverFrameContainer, DockableFrame dockableFrame, int n, int n2, int n3) {
        if (dockingManager == null || handler == null || dockedFrameContainer == null || slidingOverFrameContainer == null) {
            throw new IllegalArgumentException("dockingManager, handler, dockedFrameContainer, and animationLayer must be non null.");
        }
        this._dockingManager = dockingManager;
        this._handler = handler;
        this._dockedFrameContainer = dockedFrameContainer;
        this._animationLayer = slidingOverFrameContainer;
        this._componentContstraints = new SlidingOverFrameContainer.SlidingFrameConstraint(this._animationLayer);
        this._componentContstraints.frame = dockableFrame;
        this._componentContstraints.side = n;
        this._componentContstraints.steps = n3;
        this._componentContstraints.currentStep = 0;
        this._componentContstraints.isLeftToRight = this._dockedFrameContainer.getComponentOrientation().isLeftToRight();
        this._componentContstraints.dockingComponent = this._dockedFrameContainer;
        this._sizeSurrogate = new JPanel(){

            @Override
            public boolean contains(int n, int n2) {
                return false;
            }
        };
        this._sizeSurrogate.setOpaque(false);
        this._delay = n2;
        this._forceCompleteHide = false;
        this._isOpened = false;
        this._playingTransition = false;
        this._closingTransition = false;
        this._timer = new Timer(this._delay, new TimerActionListener());
    }

    public void startOpen(int n) {
        if (this._forceCompleteHide) {
            return;
        }
        if (this._componentContstraints.currentStep >= this._componentContstraints.steps && this._componentContstraints.opening) {
            return;
        }
        this._componentContstraints.opening = true;
        if (!this.isSliding()) {
            if (n == 0) {
                this.animateSlide();
            }
            this._timer.setInitialDelay(n);
            this._timer.setDelay(this._delay);
            this._timer.restart();
        }
    }

    public void startHide(int n, boolean bl) {
        if (this._componentContstraints.currentStep <= 0 && !this._componentContstraints.opening) {
            return;
        }
        this._closingTransition = true;
        this._forceCompleteHide = bl;
        this._componentContstraints.opening = false;
        if (!this.isSliding()) {
            if (n == 0) {
                this.animateSlide();
            }
            this._timer.setInitialDelay(n);
            this._timer.setDelay(this._delay / 2);
            this._timer.restart();
        }
    }

    public void showImmediately() {
        this.finishShowingComponent();
        if (this._handler != null && !this._isOpened) {
            this._handler.handleOpened(this._componentContstraints.frame);
        }
        this._isOpened = true;
    }

    public void hideImmediately() {
        this.removeShowingComponent();
        if (this._handler != null) {
            if (this._isOpened) {
                this._handler.handleHidden(this._componentContstraints.frame);
            } else {
                this._handler.handleShowingCancelled(this._componentContstraints.frame);
            }
        }
        this._isOpened = false;
        this._closingTransition = false;
    }

    public void removeImmediately() {
        this.removeShowingComponent();
        this._isOpened = false;
        this._closingTransition = false;
    }

    protected DockableFrame getDockableFrame(Component component) {
        DockableFrame dockableFrame = null;
        if (component instanceof DockableFrame) {
            dockableFrame = (DockableFrame)component;
        } else if (component instanceof HeavyweightWrapper) {
            dockableFrame = (DockableFrame)((HeavyweightWrapper)component).getComponent();
        }
        return dockableFrame;
    }

    public boolean isSliding() {
        return this._playingTransition;
    }

    public boolean isClosing() {
        return this._closingTransition;
    }

    public boolean isOpening() {
        return this.isSliding() && this._componentContstraints.opening;
    }

    public Component getSlidingComponent() {
        return this._component;
    }

    public DockableFrame getSlidingFrame() {
        return this._componentContstraints.frame;
    }

    protected void animateSlide() {
        if (this._componentContstraints.frame != null && (this._componentContstraints.frame.isAutohide() || this._componentContstraints.frame.isAutohideShowing())) {
            if (this._componentContstraints.currentStep <= 0) {
                if (this._componentContstraints.opening) {
                    this._componentContstraints.frame.fireDockableFrameEvent(4009);
                    this.beginShowing();
                    if (this._handler != null) {
                        this._handler.handleBeginShowing(this._componentContstraints.frame);
                    }
                } else {
                    this._componentContstraints.frame.fireDockableFrameEvent(4010);
                    this.hideImmediately();
                    return;
                }
            }
            if (this._componentContstraints.opening) {
                ++this._componentContstraints.currentStep;
                if (this._componentContstraints.currentStep > this._componentContstraints.steps) {
                    this._componentContstraints.currentStep = this._componentContstraints.steps;
                }
            } else {
                this._isOpened = false;
                --this._componentContstraints.currentStep;
                if (this._componentContstraints.currentStep < 0) {
                    this._componentContstraints.currentStep = 0;
                }
            }
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                this._componentContstraints.frame.getContentPane().setVisible(false);
            }
            this._playingTransition = true;
            try {
                this._componentContstraints.frame.setAutohideShowing(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.resizeShowingComponent();
            if (this._componentContstraints.currentStep >= this._componentContstraints.steps) {
                this.showImmediately();
            }
        }
    }

    protected void beginShowing() {
        Object object;
        this._animationLayer.setVisible(true);
        this._component = !SystemInfo.isJdk6u14Above() && this._dockingManager.isHeavyweightComponentEnabled() && this._componentContstraints.frame.isSlidingAutohide() ? ((object = this._componentContstraints.frame.getClientProperty("HeavyweightWrapper")) instanceof HeavyweightWrapper ? (HeavyweightWrapper)object : new HeavyweightWrapper(this._componentContstraints.frame, true)) : this._componentContstraints.frame;
        if (!this._componentContstraints.frame.isVisible()) {
            this._componentContstraints.frame.setVisible(true);
        }
        this._componentContstraints.frame.getContext().setCurrentDockSide(this._componentContstraints.side);
        if (this._componentContstraints.frame.isSlidingAutohide()) {
            this.insertFrameOver();
        } else {
            this.insertFrameInto();
        }
    }

    protected void insertFrameOver() {
        if (this._component instanceof HeavyweightWrapper) {
            ((HeavyweightWrapper)this._component).delegateAdd(this._animationLayer, this._componentContstraints);
        } else {
            this._animationLayer.add(this._component, this._componentContstraints);
        }
    }

    protected void insertFrameInto() {
        this._animationLayer.add((Component)this._sizeSurrogate, this._componentContstraints);
        ContainerContainer containerContainer = (ContainerContainer)this._dockedFrameContainer.getParent();
        this._component.setSize(this._componentContstraints.frame.getAutohideWidth(), this._componentContstraints.frame.getAutohideHeight());
        switch (this._componentContstraints.side) {
            case 4: {
                containerContainer.setOrientation(1);
                containerContainer.insertPane(this._component, "flexible", containerContainer.getPaneCount());
                break;
            }
            case 8: {
                containerContainer.setOrientation(1);
                containerContainer.insertPane(this._component, "flexible", 0);
                break;
            }
            case 2: {
                containerContainer.setOrientation(0);
                containerContainer.insertPane(this._component, "flexible", containerContainer.getPaneCount());
                break;
            }
            case 1: {
                containerContainer.setOrientation(0);
                containerContainer.insertPane(this._component, "flexible", 0);
            }
        }
        containerContainer.doLayout();
    }

    protected void resizeShowingComponent() {
        this._animationLayer.validate();
        this._animationLayer.doLayout();
        Window window = SwingUtilities.getWindowAncestor(this._animationLayer);
        if (window != null) {
            window.validate();
        }
        if (this._component != null) {
            if (this._componentContstraints.frame.isSlidingAutohide()) {
                Rectangle rectangle = this._component.getBounds();
                this._animationLayer.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                ContainerContainer containerContainer = (ContainerContainer)this._dockedFrameContainer.getParent();
                switch (this._componentContstraints.side) {
                    case 4: {
                        containerContainer.setDividerLocation(0, containerContainer.getWidth() - containerContainer.getDividerSize() - this._sizeSurrogate.getSize().width);
                        break;
                    }
                    case 8: {
                        containerContainer.setDividerLocation(0, this._sizeSurrogate.getSize().width);
                        break;
                    }
                    case 2: {
                        containerContainer.setDividerLocation(0, containerContainer.getHeight() - containerContainer.getDividerSize() - this._sizeSurrogate.getSize().height);
                        break;
                    }
                    case 1: {
                        containerContainer.setDividerLocation(0, this._sizeSurrogate.getSize().height);
                    }
                }
                this._dockedFrameContainer.getParent().invalidate();
                this._dockedFrameContainer.getParent().doLayout();
                this._dockedFrameContainer.getParent().repaint();
            }
        }
    }

    protected void finishShowingComponent() {
        this._playingTransition = false;
        this._timer.stop();
        this._componentContstraints.currentStep = this._componentContstraints.steps;
        this.resizeShowingComponent();
        if (this._componentContstraints.opening) {
            DockableFrame dockableFrame = this.getDockableFrame(this._component);
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                dockableFrame.getContentPane().setVisible(true);
            }
        }
        this._dockingManager.finishShowingAutohideFrame(this.getDockableFrame(this._component).getKey());
    }

    protected void removeShowingComponent() {
        this._timer.stop();
        this._playingTransition = false;
        this._animationLayer.setVisible(false);
        if (this._component != null) {
            Container container = this._component.getParent();
            if (container != null) {
                if (this._component instanceof HeavyweightWrapper) {
                    ((HeavyweightWrapper)this._component).delegateRemove(container);
                } else {
                    JideSwingUtilities.removeFromParentWithFocusTransfer(this._component);
                }
            }
            this._animationLayer.remove(this._sizeSurrogate);
            this._component = null;
            this._componentContstraints.currentStep = 0;
            this._componentContstraints.opening = false;
            this._forceCompleteHide = false;
        }
        if (this._componentContstraints.frame != null && this._componentContstraints.frame.isAutohideShowing()) {
            if (this._dockingManager.isAutohideShowingContentHidden()) {
                this._componentContstraints.frame.getContentPane().setVisible(true);
            }
            try {
                this._componentContstraints.frame.setAutohide(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this._animationLayer.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateAutohideWidthHeight(DockableFrame dockableFrame) {
        try {
            dockableFrame.setSettingSize(true);
            int n = dockableFrame.getContext().getCurrentDockSide();
            switch (n) {
                case 4: 
                case 8: {
                    dockableFrame.setAutohideWidth(dockableFrame.getWidth());
                    return;
                }
                case 1: 
                case 2: {
                    dockableFrame.setAutohideHeight(dockableFrame.getHeight());
                    return;
                }
            }
            return;
        }
        finally {
            dockableFrame.setSettingSize(false);
        }
    }

    protected class TimerActionListener
    implements ActionListener {
        protected TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlidingAnimator.this.animateSlide();
        }
    }

    public static interface Handler {
        public void handleBeginShowing(DockableFrame var1);

        public void handleShowingCancelled(DockableFrame var1);

        public void handleOpened(DockableFrame var1);

        public void handleHidden(DockableFrame var1);
    }
}

