/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class PreviousState
implements Serializable {
    private static final long serialVersionUID = 1372217730835756351L;
    int mode;
    int dockID;
    int rootID;
    Rectangle rcBounds;
    int side;
    int index;
    int fcID;
    ArrayList<Integer> fcChildren;
    ArrayList<ParentState> parentStates;

    PreviousState() {
    }

    public static PreviousState createPreviousState(DockableFrame dockableFrame) {
        PreviousState previousState = new PreviousState();
        previousState.mode = dockableFrame.getContext().getCurrentMode();
        previousState.dockID = dockableFrame.getDockID();
        if (previousState.mode == 2 || previousState.mode == 3) {
            previousState.side = dockableFrame.getContext().getCurrentDockSide();
            previousState.index = previousState.side == 4 || previousState.side == 8 || previousState.side == 1 || previousState.side == 2 ? (dockableFrame.getDockingManager() == null || dockableFrame.getDockingManager().getAutoHideContainer(previousState.side) == null ? 0 : dockableFrame.getDockingManager().getAutoHideContainer(previousState.side).getGroupIndex(dockableFrame)) : 0;
            if (dockableFrame.getDockingManager() != null && dockableFrame.getDockingManager().getAutoHideContainer(previousState.side) != null && dockableFrame.getDockingManager().getAutoHideContainer(previousState.side).getGroups() != null && dockableFrame.getDockingManager().getAutoHideContainer(previousState.side).getGroups().size() > previousState.index && previousState.index >= 0) {
                List<SidePaneGroup> list = dockableFrame.getDockingManager().getAutoHideContainer(previousState.side).getGroups();
                ParentState parentState = new ParentState();
                parentState.ccChildren = new ArrayList();
                SidePaneGroup sidePaneGroup = list.get(previousState.index);
                for (SidePaneItem sidePaneItem : sidePaneGroup) {
                    parentState.ccChildren.add(((DockableFrame)sidePaneItem.getComponent()).getDockID());
                }
                previousState.parentStates = new ArrayList();
                previousState.parentStates.add(parentState);
            }
        } else {
            Serializable serializable;
            Container container = dockableFrame.getParent();
            if (container instanceof FrameContainer) {
                previousState.fcID = ((FrameContainer)container).getDockID();
                previousState.fcChildren = DockingUtils.getAllChildrenIDOf((FrameContainer)container);
                container = container.getParent();
            }
            previousState.parentStates = new ArrayList();
            int n = previousState.fcID;
            while (container instanceof ContainerContainer) {
                serializable = (ContainerContainer)container;
                ParentState parentState = new ParentState();
                parentState.ccID = ((ContainerContainer)serializable).getDockID();
                parentState.myID = n;
                parentState.orientation = ((JideSplitPane)serializable).getOrientation();
                parentState.ccChildren = DockingUtils.getAllChildrenIDOf((ContainerContainer)serializable);
                parentState.proportions = ((JideSplitPane)serializable).getProportions();
                previousState.parentStates.add(parentState);
                if (parentState.ccChildren.contains(new Integer(-1))) break;
                n = parentState.ccID;
                if (!((container = container.getParent()) instanceof FloatingContainer) && !(container instanceof DockedFrameContainer)) continue;
                break;
            }
            if (container instanceof Workspace) {
                serializable = new ParentState();
                ((ParentState)serializable).ccID = 3;
                ((ParentState)serializable).myID = n;
                previousState.parentStates.add((ParentState)serializable);
            }
            if ((serializable = DockingUtils.getRootContainer(dockableFrame)) != null) {
                previousState.rcBounds = ((Component)serializable).getBounds();
                previousState.side = dockableFrame.getContext().getCurrentDockSide();
                previousState.rootID = 2;
            }
        }
        return previousState;
    }

    public static void disposePreviousState(PreviousState previousState) {
        if (previousState == null) {
            return;
        }
        previousState.rcBounds = null;
        if (previousState.fcChildren != null) {
            previousState.fcChildren.clear();
        }
        if (previousState.parentStates != null) {
            for (ParentState parentState : previousState.parentStates) {
                PreviousState.disposeParentState(parentState);
            }
            if (previousState.parentStates != null) {
                previousState.parentStates.clear();
            }
        }
        previousState.parentStates = null;
    }

    private static void disposeParentState(ParentState parentState) {
        if (parentState == null || parentState.ccChildren == null) {
            return;
        }
        parentState.ccChildren.clear();
    }

    public static Component findComponentByDockID(DockingManager dockingManager, Container container, int n) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (component2 instanceof Dockable && ((Dockable)((Object)component2)).getDockID() == n && ((Dockable)((Object)component2)).getDockingManager() == dockingManager) {
                return component2;
            }
            if (component2 instanceof Workspace && n == 3 && ((Workspace)component2).getDockingManager() == dockingManager) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = PreviousState.findComponentByDockID(dockingManager, (Container)component2, n)) == null) continue;
            return component;
        }
        return null;
    }

    public static Component findDockedComponentByInitState(DockingManager dockingManager, Container container, int n, int n2) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (component2 instanceof DockableFrame && dockingManager == ((DockableFrame)(component = (DockableFrame)component2)).getDockingManager() && ((DockableFrame)component).getContext().getInitIndex() == n2 && ((DockableFrame)component).getContext().getInitSide() == n && ((DockableFrame)component).getContext().getCurrentDockSide() == n) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = PreviousState.findDockedComponentByInitState(dockingManager, (Container)component2, n, n2)) == null) continue;
            return component;
        }
        return null;
    }

    static class ParentState
    implements Serializable {
        private static final long serialVersionUID = 8771757301606568363L;
        int ccID;
        int myID;
        int orientation;
        ArrayList<Integer> ccChildren;
        double[] proportions;

        ParentState() {
        }
    }
}

