/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class FrameFloatingContainer
extends ResizableFrame
implements FloatingContainer {
    private final DockingManager _dockingManager;
    private final FloatingContainer.FloatingContainerManager _floatingContainerManager;
    private int _dockID = 0;

    FrameFloatingContainer() throws HeadlessException {
        this((DockingManager)null, (FloatingContainer.FloatingContainerManager)null);
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager) throws HeadlessException {
        this(dockingManager, floatingContainerManager, "");
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, String string) throws HeadlessException {
        super(string);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                if (!(windowEvent.getOppositeWindow() instanceof FloatingContainer) && FrameFloatingContainer.this._floatingContainerManager != null) {
                    FrameFloatingContainer.this._floatingContainerManager.floatingFrameActivated(windowEvent);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                super.windowDeactivated(windowEvent);
                if (FrameFloatingContainer.this._floatingContainerManager != null) {
                    FrameFloatingContainer.this._floatingContainerManager.floatingFrameDeactivated(windowEvent);
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }
        });
    }

    @Override
    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    @Override
    public Rectangle getInitialBounds(Rectangle rectangle) {
        return rectangle;
    }

    @Override
    public void updateUndecorated() {
        boolean bl = false;
        boolean bl2 = this.isVisible();
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            if (!JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(false);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
            if (this.isUndecorated()) {
                this.getRootPane().setWindowDecorationStyle(1);
            } else {
                this.getRootPane().setWindowDecorationStyle(0);
            }
        } else {
            if (JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(true);
                this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
            }
            this.getRootPane().setWindowDecorationStyle(0);
        }
        if (bl) {
            this.updateBorders();
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (bl2 || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
        this.updateTitle();
    }

    @Override
    public void updateBorders() {
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(255);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    @Override
    public Component getRoutingComponent() {
        return this._dockingManager.getMainContainer();
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void hideItselfIfEmpty() {
        List<DockableFrame> list = DockingUtils.getAllDockableFrameOf(this.getContentPane());
        if (list == null || list.size() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void updateTitle() {
        Component[] componentArray = this.getContentPane().getComponents();
        Component component = null;
        for (Component component2 : componentArray) {
            if (!(component2 instanceof ContainerContainer) && !(component2 instanceof FrameContainer)) continue;
            if (component == null) {
                component = component2;
                continue;
            }
            component = null;
            break;
        }
        if (component != null) {
            if (component instanceof ContainerContainer) {
                String string;
                Object e;
                List<Component> list = DockingUtils.getAllChildrenOf((ContainerContainer)component);
                if (list.size() == 1) {
                    String string2;
                    Object e2 = list.get(0);
                    if (e2 instanceof DockableFrame && !(string2 = ((DockableFrame)e2).getTitle()).equals(this.getTitle())) {
                        this.setTitle(string2);
                    }
                } else if (list.size() > 1 && (e = list.get(0)) instanceof DockableFrame && !(string = ((DockableFrame)e).getTitle() + " (" + list.size() + ")").equals(this.getTitle())) {
                    this.setTitle(string);
                }
            } else {
                String string;
                int n = ((FrameContainer)component).getTabCount();
                if (n == 1) {
                    String string3;
                    String string4 = string3 = ((FrameContainer)component).getSelectedFrame() == null ? "" : ((FrameContainer)component).getSelectedFrame().getTitle();
                    if (!string3.equals(this.getTitle())) {
                        this.setTitle(string3);
                    }
                } else if (n > 1 && !(string = ((FrameContainer)component).getFrame(0).getTitle() + " (" + n + ")").equals(this.getTitle())) {
                    this.setTitle(string);
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int n) {
        this._dockID = n;
    }

    @Override
    public void resetDockID() {
        this._dockID = -1;
        if (this._dockingManager != null) {
            this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component component2 = this.getContentPane().getComponent(0);
        List<Component> list = null;
        if (component2 instanceof ContainerContainer) {
            list = DockingUtils.getAllChildrenOf((ContainerContainer)component2);
        } else if (component2 instanceof FrameContainer) {
            list = DockingUtils.getAllChildrenOf((FrameContainer)component2);
        }
        if (list == null || list.size() <= 0 || !((component = list.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container container = dockableFrame.getParent();
        if (container != null && container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            DockableFrame dockableFrame2 = frameContainer.getSelectedFrame();
            if (dockableFrame2 == null) return frameContainer;
            Component component3 = dockableFrame2.getFocusedComponent();
            if (component3 == null || component3 == dockableFrame2) {
                component3 = dockableFrame2.getDefaultFocusComponent();
            }
            if (component3 == dockableFrame2) return super.getMostRecentFocusOwner();
            return component3;
        }
        Component component4 = dockableFrame.getFocusedComponent();
        if (component4 == dockableFrame) {
            component4 = dockableFrame.getDefaultFocusComponent();
        }
        if (component4 == dockableFrame) return super.getMostRecentFocusOwner();
        return component4;
    }

    @Override
    public void setResizable(boolean bl) {
        super.setResizable(bl);
        this.getResizable().setResizableCorners(bl ? 255 : 0);
    }

    @Override
    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }
}

