/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

class DockableFrameMouseInputAdapter
extends MouseInputAdapter
implements SwingConstants {
    private int _eventMouseScreenX;
    private int _eventMouseScreenY;
    private int _eventMouseRelativeX;
    private int _eventMouseRelativeY;
    private static Rectangle _startingBounds;
    private int _resizeDir;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private boolean _glassPaneVisibility;
    private int resizeCornerSize = 16;
    private DockableFrame _frame;
    private FrameContainer _tabbedPane;
    private boolean _needClearTabbedPane;
    private JComponent _component;
    private Object _mouseOnComponent;
    private DockingManager _dockingManager;
    private Rectangle[] _savedTabRects;
    private boolean _dragged = false;

    public DockableFrameMouseInputAdapter(DockableFrame dockableFrame) {
        this._frame = dockableFrame;
        this._component = this._frame;
    }

    public DockableFrameMouseInputAdapter(FrameContainer frameContainer) {
        this._tabbedPane = frameContainer;
        this._component = this._tabbedPane;
    }

    private void initDockingManager(MouseEvent mouseEvent) {
        if (this._tabbedPane != null && this._tabbedPane.getTabCount() > 0) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tabbedPane);
            int n = this._tabbedPane.getTabAtLocation(point.x, point.y);
            if (n != -1) {
                this._frame = (DockableFrame)this._tabbedPane.getComponentAt(n);
                this._dockingManager = this._frame.getDockingManager();
            } else {
                this._dockingManager = this._tabbedPane.getFrame(0).getDockingManager();
                this._frame = this._tabbedPane.getSelectedFrame();
            }
        } else if (this._component instanceof Dockable) {
            this._dockingManager = ((Dockable)((Object)this._component)).getDockingManager();
        } else {
            throw new IllegalStateException("Internal Error: Non-dockable is passed to BorderListener.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        block60: {
            block59: {
                Insets insets;
                block61: {
                    int n;
                    Object object;
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        return;
                    }
                    this.initDockingManager(mouseEvent);
                    if (this._dockingManager != null) {
                        this._dockingManager.setActiveMouseInputListener(this);
                    }
                    if (this.isFrameDisabled()) {
                        return;
                    }
                    if (((Dockable)((Object)this._component)).getDockingManager() == null) {
                        JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._frame);
                        return;
                    }
                    this.setDrag(false);
                    if (this._mouseOnComponent != null && mouseEvent.getSource() != this._mouseOnComponent) {
                        return;
                    }
                    this._mouseOnComponent = mouseEvent.getSource();
                    if (mouseEvent.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
                        this.showContextMenu(mouseEvent);
                    }
                    if (this._component != null) {
                        object = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._component);
                        this._eventMouseRelativeX = ((Point)object).x;
                        this._eventMouseRelativeY = ((Point)object).y;
                    }
                    object = this._component.getClientProperty("HeavyweightWrapper");
                    _startingBounds = this._frame != null && this._frame.isAutohideShowing() && object instanceof HeavyweightWrapper ? ((HeavyweightWrapper)object).getBounds() : this._component.getBounds();
                    double d = (double)this._eventMouseRelativeX / (double)DockableFrameMouseInputAdapter._startingBounds.width;
                    double d2 = (double)this._eventMouseRelativeY / (double)(DockableFrameMouseInputAdapter._startingBounds.height + (this._tabbedPane != null && this._tabbedPane.isTabShown() ? 22 : 0));
                    this._resizeDir = 0;
                    Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)((Dockable)((Object)this._component)).getDockingManager().getRootPaneContainer()));
                    this._eventMouseScreenX = point.x;
                    this._eventMouseScreenY = point.y;
                    Component component = null;
                    if (this._frame != null && (component = this._frame.getDraggingTarget(mouseEvent)) == this._frame && this._frame.getParent() instanceof FrameContainer && this._tabbedPane == null) {
                        this._tabbedPane = (FrameContainer)this._frame.getParent();
                        this._needClearTabbedPane = true;
                    }
                    if (this._frame != null && this.isDraggingTarget(mouseEvent) && component != this._frame) {
                        if (!this._frame.isDockable() && this._frame.isDocked()) {
                            this._frame.getDockingManager().activateFrame(this._frame.getKey());
                            return;
                        }
                        if (!this._frame.isAutohide() && !this._frame.isAutohideShowing()) {
                            this._dockingManager.beginDraggingFrame(this._component, this._eventMouseScreenX, this._eventMouseScreenY, d, d2, false);
                            return;
                        }
                        this._frame.getDockingManager().activateFrame(this._frame.getKey());
                        return;
                    }
                    if (this._tabbedPane != null && this.isTabPanelEvent(mouseEvent)) {
                        Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tabbedPane);
                        n = this._tabbedPane.getTabAtLocation(point2.x, point2.y);
                        if (n == -1) {
                            this._dockingManager.beginDraggingFrame((DockableFrame)this._tabbedPane.getSelectedComponent(), this._eventMouseScreenX, this._eventMouseScreenY, d, d2, false);
                            this._savedTabRects = new Rectangle[this._tabbedPane.getTabCount()];
                            int n2 = 0;
                            while (true) {
                                if (n2 >= this._savedTabRects.length) {
                                    return;
                                }
                                this._savedTabRects[n2] = SwingUtilities.convertRectangle(this._tabbedPane, this._tabbedPane.getUI().getTabBounds(this._tabbedPane, n2), (Component)mouseEvent.getSource());
                                ++n2;
                            }
                        }
                    }
                    if (this._tabbedPane != null && (this.isTabPanelEvent(mouseEvent) || component == this._frame)) {
                        FrameContainer frameContainer;
                        Point point3 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tabbedPane);
                        n = this._tabbedPane.getTabAtLocation(point3.x, point3.y);
                        DockableFrame dockableFrame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                        if (n != -1) {
                            dockableFrame = this._tabbedPane.getFrame(n);
                        }
                        if (dockableFrame != null && dockableFrame.getParent() != null && dockableFrame.getParent() instanceof FrameContainer && (frameContainer = (FrameContainer)dockableFrame.getParent()).isTabEditing()) {
                            return;
                        }
                        if (this._dockingManager != null) {
                            this._dockingManager.beginDraggingFrame(dockableFrame, this._eventMouseScreenX, this._eventMouseScreenY, d, d2, true);
                            this._savedTabRects = new Rectangle[this._tabbedPane.getTabCount()];
                            for (int i = 0; i < this._savedTabRects.length; ++i) {
                                this._savedTabRects[i] = SwingUtilities.convertRectangle(this._tabbedPane, this._tabbedPane.getUI().getTabBounds(this._tabbedPane, i), (Component)mouseEvent.getSource());
                            }
                        }
                        return;
                    }
                    if (!(this._component.getTopLevelAncestor() instanceof FloatingContainer) && this._component instanceof DockableFrame && ((DockableFrame)this._component).isDocked()) {
                        return;
                    }
                    if (!(!(this._component.getTopLevelAncestor() instanceof FloatingContainer) || this._component instanceof DockableFrame && ((DockableFrame)this._component).isFloated() || DockingUtils.getFrameContainerCount(this._dockingManager, ((FloatingContainer)((Object)this._component.getTopLevelAncestor())).getContentPane()) <= 1)) {
                        return;
                    }
                    if (this._component instanceof FrameContainer && !(this._component.getTopLevelAncestor() instanceof FloatingContainer)) {
                        return;
                    }
                    if (!this._dockingManager.isResizable()) {
                        return;
                    }
                    if (this._frame != null && !this._frame.isSlidingAutohide()) {
                        return;
                    }
                    if (mouseEvent.getSource() != this._component) break block60;
                    insets = this._component.getInsets();
                    if (!(this._component instanceof FrameContainer)) break block61;
                    if (insets.right > 0 && mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                        this._resizeDir = insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3;
                        break block59;
                    } else if (insets.bottom > 0 && mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                        this._resizeDir = insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5;
                        break block59;
                    } else {
                        this._discardRelease = true;
                        return;
                    }
                }
                if (mouseEvent.getX() <= insets.left) {
                    this._resizeDir = insets.top > 0 && mouseEvent.getY() < this.resizeCornerSize + insets.top ? 8 : (insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom ? 6 : 7);
                } else if (insets.right > 0 && mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                    this._resizeDir = insets.top > 0 && mouseEvent.getY() < this.resizeCornerSize + insets.top ? 2 : (insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3);
                } else if (insets.top > 0 && mouseEvent.getY() <= insets.top) {
                    this._resizeDir = insets.left > 0 && mouseEvent.getX() < this.resizeCornerSize + insets.left ? 8 : (insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right ? 2 : 1);
                } else if (insets.bottom > 0 && mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                    this._resizeDir = insets.left > 0 && mouseEvent.getX() < this.resizeCornerSize + insets.left ? 6 : (insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5);
                } else {
                    this._discardRelease = true;
                    return;
                }
            }
            Cursor cursor = Cursor.getDefaultCursor();
            switch (this._resizeDir) {
                case 5: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        cursor = JideCursors.getPredefinedCursor(21);
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 1: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        cursor = JideCursors.getPredefinedCursor(21);
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 7: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        cursor = JideCursors.getPredefinedCursor(20);
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 3: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        cursor = JideCursors.getPredefinedCursor(20);
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 4: {
                    cursor = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 6: {
                    cursor = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 8: {
                    cursor = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 2: {
                    cursor = Cursor.getPredefinedCursor(7);
                    break;
                }
            }
            Container container = this._component.getTopLevelAncestor();
            if (this._dockingManager.isUseGlassPaneEnabled()) {
                if (container instanceof JFrame) {
                    this._glassPaneVisibility = ((JFrame)container).getGlassPane().isVisible();
                    ((JFrame)container).getGlassPane().setVisible(true);
                    ((JFrame)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JApplet) {
                    this._glassPaneVisibility = ((JApplet)container).getGlassPane().isVisible();
                    ((JApplet)container).getGlassPane().setVisible(true);
                    ((JApplet)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JWindow) {
                    this._glassPaneVisibility = ((JWindow)container).getGlassPane().isVisible();
                    ((JWindow)container).getGlassPane().setVisible(true);
                    ((JWindow)container).getGlassPane().setCursor(cursor);
                } else if (container instanceof JDialog) {
                    this._glassPaneVisibility = ((JDialog)container).getGlassPane().isVisible();
                    ((JDialog)container).getGlassPane().setVisible(true);
                    ((JDialog)container).getGlassPane().setCursor(cursor);
                }
            }
            this._dockingManager.beginResizingFrame(this._component, this._resizeDir);
        }
    }

    private boolean isFrameDisabled() {
        int n;
        return this._frame != null && this._component instanceof FrameContainer && (n = ((FrameContainer)this._component).indexOfComponent(this._frame)) >= 0 && n < ((FrameContainer)this._component).getTabCount() && !((FrameContainer)this._component).isEnabledAt(n);
    }

    private boolean isTabPanelEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._tabbedPane) {
            Point point = mouseEvent.getPoint();
            Component component = ((JideTabbedPaneUI)this._tabbedPane.getUI()).getTabPanel();
            Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, component);
            return component.contains(point2);
        }
        if (this._frame.isConsideredAsTitleBar(mouseEvent.getSource())) {
            Point point = mouseEvent.getPoint();
            Component component = this._frame.getUI().getTitlePane();
            Point point3 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, component);
            return component.contains(point3);
        }
        return false;
    }

    private void setDrag(boolean bl) {
        if (this._dragged != bl) {
            this._dragged = bl;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            return;
        }
        this.initDockingManager(mouseEvent);
        if (this.isFrameDisabled()) {
            return;
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._frame);
            return;
        }
        if (this._mouseOnComponent != null && mouseEvent.getSource() != this._mouseOnComponent) {
            return;
        }
        this._mouseOnComponent = mouseEvent.getSource();
        this.setDrag(true);
        if ((this._frame == null || this._frame.isDockable()) && !(mouseEvent.getSource() instanceof Gripper) && !(mouseEvent.getSource() instanceof DockableFrame) && ((Component)mouseEvent.getSource()).contains(mouseEvent.getPoint())) {
            if (this._tabbedPane != null && this.isTabPanelEvent(mouseEvent) && this._tabbedPane.getTabCount() > 1) {
                if (!this._dockingManager.isTabReorderAllowed()) {
                    this._discardRelease = true;
                    return;
                }
                this._dockingManager.pauseDragFrame();
                int n4 = -1;
                if (this._savedTabRects != null) {
                    DockableFrame dockableFrame;
                    for (int i = 0; i < this._savedTabRects.length; ++i) {
                        if (!this._savedTabRects[i].contains(mouseEvent.getPoint())) continue;
                        n4 = i;
                        break;
                    }
                    if (n4 >= 0 && n4 < this._tabbedPane.getTabCount() && n4 != this._tabbedPane.getSelectedIndex() && (dockableFrame = this._tabbedPane.getSelectedFrame()) != null && this._dockingManager.isDropAllowed(dockableFrame, this._tabbedPane.getComponentAt(n4), dockableFrame.getContext().getCurrentDockSide())) {
                        this._dockingManager.addUndo(this._dockingManager.getResourceString("Undo.moving"));
                        this._tabbedPane.moveSelectedTabTo(n4);
                        dockableFrame.fireDockableFrameEvent(4014);
                    }
                }
                return;
            }
            if (this._frame != null && this._frame.isDocked() && this.isTabPanelEvent(mouseEvent)) {
                this._dockingManager.pauseDragFrame();
                return;
            }
        }
        if (_startingBounds == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)((Dockable)((Object)this._component)).getDockingManager().getRootPaneContainer()));
        int n5 = this._eventMouseScreenX - point.x;
        int n6 = this._eventMouseScreenY - point.y;
        if (this._frame != null && this.isDraggingTarget(mouseEvent)) {
            if (this._frame != null && !this._frame.isDockable() && this._frame.isDocked()) {
                return;
            }
            if (this._frame.isMaximized() || this._frame.isAutohide() || this._frame.isAutohideShowing() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this._dockingManager.dragFrame(this._frame, point.x, point.y, PortingUtils.getMouseModifiers(mouseEvent));
            return;
        }
        if (this._tabbedPane != null) {
            DockableFrame dockableFrame = (DockableFrame)this._tabbedPane.getSelectedComponent();
            if (dockableFrame == null) {
                return;
            }
            if (!dockableFrame.isDockable() && dockableFrame.isDocked()) {
                return;
            }
            if (dockableFrame.isMaximized() || dockableFrame.isAutohide() || dockableFrame.isAutohideShowing() || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this._dockingManager.dragFrame(dockableFrame, point.x, point.y, PortingUtils.getMouseModifiers(mouseEvent));
            return;
        }
        if (!this._dockingManager.isResizable()) {
            return;
        }
        if (this._frame != null && !this._frame.isSlidingAutohide()) {
            return;
        }
        Dimension dimension = this._component.getMinimumSize();
        Dimension dimension2 = this._component.getMaximumSize();
        int n7 = this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getX() : this._component.getX();
        int n8 = n3 = this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getY() : this._component.getY();
        Rectangle rectangle = this._component instanceof FrameContainer || this._component.getParent() == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : (this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getParent().getBounds() : this._component.getParent().getBounds());
        switch (this._resizeDir) {
            case 0: {
                return;
            }
            case 1: {
                if (DockableFrameMouseInputAdapter._startingBounds.height + n6 < dimension.height) {
                    n6 = -(DockableFrameMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + n6 > dimension2.height) {
                    n6 = dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - n6 < 0) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                n7 = DockableFrameMouseInputAdapter._startingBounds.x;
                n3 = DockableFrameMouseInputAdapter._startingBounds.y - n6;
                n2 = DockableFrameMouseInputAdapter._startingBounds.width;
                n = DockableFrameMouseInputAdapter._startingBounds.height + n6;
                break;
            }
            case 2: {
                if (DockableFrameMouseInputAdapter._startingBounds.height + n6 < dimension.height) {
                    n6 = -(DockableFrameMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + n6 > dimension2.height) {
                    n6 = dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - n6 < 0) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.width - n5 < dimension.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - n5 > dimension2.width) {
                    n5 = -(dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - n5 > rectangle.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n7 = DockableFrameMouseInputAdapter._startingBounds.x;
                n3 = DockableFrameMouseInputAdapter._startingBounds.y - n6;
                n2 = DockableFrameMouseInputAdapter._startingBounds.width - n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height + n6;
                break;
            }
            case 3: {
                if (DockableFrameMouseInputAdapter._startingBounds.width - n5 < dimension.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - n5 > dimension2.width) {
                    n5 = -(dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - n5 > rectangle.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                n2 = DockableFrameMouseInputAdapter._startingBounds.width - n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height;
                break;
            }
            case 4: {
                if (DockableFrameMouseInputAdapter._startingBounds.width - n5 < dimension.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.width - dimension.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - n5 > dimension2.width) {
                    n5 = -(dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - n5 > rectangle.width) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - rectangle.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.height - n6 < dimension.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - n6 > dimension2.height) {
                    n6 = -(dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - n6 > rectangle.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n2 = DockableFrameMouseInputAdapter._startingBounds.width - n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height - n6;
                break;
            }
            case 5: {
                if (DockableFrameMouseInputAdapter._startingBounds.height - n6 < dimension.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - n6 > dimension2.height) {
                    n6 = -(dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - n6 > rectangle.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                n2 = DockableFrameMouseInputAdapter._startingBounds.width;
                n = DockableFrameMouseInputAdapter._startingBounds.height - n6;
                break;
            }
            case 6: {
                if (DockableFrameMouseInputAdapter._startingBounds.height - n6 < dimension.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.height - dimension.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - n6 > dimension2.height) {
                    n6 = -(dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - n6 > rectangle.height) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - rectangle.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.width + n5 < dimension.width) {
                    n5 = -(DockableFrameMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + n5 > dimension2.width) {
                    n5 = dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - n5 < 0) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                n7 = DockableFrameMouseInputAdapter._startingBounds.x - n5;
                n3 = DockableFrameMouseInputAdapter._startingBounds.y;
                n2 = DockableFrameMouseInputAdapter._startingBounds.width + n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height - n6;
                break;
            }
            case 7: {
                if (DockableFrameMouseInputAdapter._startingBounds.width + n5 < dimension.width) {
                    n5 = -(DockableFrameMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + n5 > dimension2.width) {
                    n5 = dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - n5 < 0) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                n7 = DockableFrameMouseInputAdapter._startingBounds.x - n5;
                n3 = DockableFrameMouseInputAdapter._startingBounds.y;
                n2 = DockableFrameMouseInputAdapter._startingBounds.width + n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height;
                break;
            }
            case 8: {
                if (DockableFrameMouseInputAdapter._startingBounds.width + n5 < dimension.width) {
                    n5 = -(DockableFrameMouseInputAdapter._startingBounds.width - dimension.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + n5 > dimension2.width) {
                    n5 = dimension2.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - n5 < 0) {
                    n5 = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.height + n6 < dimension.height) {
                    n6 = -(DockableFrameMouseInputAdapter._startingBounds.height - dimension.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + n6 > dimension2.height) {
                    n6 = dimension2.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - n6 < 0) {
                    n6 = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                n7 = DockableFrameMouseInputAdapter._startingBounds.x - n5;
                n3 = DockableFrameMouseInputAdapter._startingBounds.y - n6;
                n2 = DockableFrameMouseInputAdapter._startingBounds.width + n5;
                n = DockableFrameMouseInputAdapter._startingBounds.height + n6;
                break;
            }
            default: {
                return;
            }
        }
        if (this._frame != null && this._frame.isAutohideShowing()) {
            Rectangle rectangle2 = this._dockingManager.getDockedFrameContainer().getBounds();
            Rectangle rectangle3 = SwingUtilities.convertRectangle(this._dockingManager.getDockedFrameContainer().getParent(), rectangle2, this._component.getParent());
            if (n3 < rectangle3.y) {
                n3 = rectangle3.y;
            }
            if (n7 < rectangle3.x) {
                n7 = rectangle3.x;
            }
            if (n2 > rectangle3.width) {
                n2 = rectangle3.width;
            }
            if (n > rectangle3.height) {
                n = rectangle3.height;
            }
        }
        this._dockingManager.resizingFrame(this._component, n7, n3, n2, n);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.initDockingManager(mouseEvent);
        if (this._frame == null) {
            return;
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._frame);
            return;
        }
        if (this.isFrameDisabled()) {
            this._dockingManager.setActiveMouseInputListener(null);
            return;
        }
        if (mouseEvent.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(mouseEvent);
        }
        _startingBounds = null;
        this._mouseOnComponent = null;
        if (this._needClearTabbedPane) {
            this._tabbedPane = null;
        }
        this._needClearTabbedPane = false;
        if (!this._dragged) {
            MouseInputListener mouseInputListener = this._dockingManager.getActiveMouseInputListener();
            if (mouseInputListener != this && mouseInputListener != null) {
                mouseInputListener.mouseReleased(mouseEvent);
                return;
            }
            this._dockingManager.cancelDragging();
            this._dockingManager.setActiveMouseInputListener(null);
            return;
        }
        this.setDrag(false);
        this._dockingManager.setActiveMouseInputListener(null);
        if (this._discardRelease) {
            this._dockingManager.cancelDragging();
            this._discardRelease = false;
            return;
        }
        if (this._resizeDir == 0) {
            if (this._frame != null) {
                this._dockingManager.endDraggingFrame(this._frame);
                return;
            }
            if (this._tabbedPane != null && this.isTabPanelEvent(mouseEvent)) {
                DockableFrame dockableFrame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                this._dockingManager.endDraggingFrame(dockableFrame);
                this._savedTabRects = null;
                return;
            }
        } else {
            if (this._dockingManager.isUseGlassPaneEnabled()) {
                Container container = this._component.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JApplet)container).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JWindow)container).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JDialog)container).getGlassPane().setVisible(this._glassPaneVisibility);
                }
                this._glassPaneVisibility = false;
            }
            this._dockingManager.endResizingFrame(this._component);
        }
        this._eventMouseScreenX = 0;
        this._eventMouseScreenY = 0;
        this._eventMouseRelativeX = 0;
        this._eventMouseRelativeY = 0;
        _startingBounds = null;
        this._resizeDir = 0;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._frame == null || this._component == null) {
            JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._frame);
            return;
        }
        if (!this._frame.isAutohideShowing()) {
            return;
        }
        if (!this._frame.isSlidingAutohide()) {
            return;
        }
        this.initDockingManager(mouseEvent);
        if (!this._dockingManager.isResizable()) {
            return;
        }
        if (mouseEvent.getSource() == this._component) {
            if (!(this._component.getTopLevelAncestor() instanceof FloatingContainer) && this._component instanceof DockableFrame && ((DockableFrame)this._component).isDocked()) {
                return;
            }
            if (this._component instanceof FrameContainer && !(this._component.getTopLevelAncestor() instanceof FloatingContainer)) {
                return;
            }
            if (!(!(this._component.getTopLevelAncestor() instanceof FloatingContainer) || this._component instanceof DockableFrame && ((DockableFrame)this._component).isFloated() || DockingUtils.getFrameContainerCount(this._dockingManager, ((FloatingContainer)((Object)this._component.getTopLevelAncestor())).getContentPane()) <= 1)) {
                return;
            }
            Insets insets = this._component.getInsets();
            if (this._component instanceof FrameContainer) {
                if (mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                    if (insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom) {
                        this._component.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this._component.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                    if (insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right) {
                        this._component.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this._component.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    this._component.setCursor(null);
                }
                return;
            }
            if (mouseEvent.getX() <= insets.left) {
                if (insets.top > 0 && mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                    this._component.setCursor(Cursor.getPredefinedCursor(6));
                } else if (insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom) {
                    this._component.setCursor(Cursor.getPredefinedCursor(4));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(20));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(10));
                }
            } else if (mouseEvent.getX() >= this._component.getWidth() - insets.right) {
                if (insets.top > 0 && mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                    this._component.setCursor(Cursor.getPredefinedCursor(7));
                } else if (insets.bottom > 0 && mouseEvent.getY() > this._component.getHeight() - this.resizeCornerSize - insets.bottom) {
                    this._component.setCursor(Cursor.getPredefinedCursor(5));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(20));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(11));
                }
            } else if (mouseEvent.getY() <= insets.top) {
                if (insets.left > 0 && mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                    this._component.setCursor(Cursor.getPredefinedCursor(6));
                } else if (insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right) {
                    this._component.setCursor(Cursor.getPredefinedCursor(7));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(21));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else if (mouseEvent.getY() >= this._component.getHeight() - insets.bottom) {
                if (insets.left > 0 && mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                    this._component.setCursor(Cursor.getPredefinedCursor(4));
                } else if (insets.right > 0 && mouseEvent.getX() > this._component.getWidth() - this.resizeCornerSize - insets.right) {
                    this._component.setCursor(Cursor.getPredefinedCursor(5));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(21));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(9));
                }
            } else {
                this._component.setCursor(null);
            }
            return;
        }
        this._component.setCursor(null);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._frame == null) {
            return;
        }
        this.initDockingManager(mouseEvent);
        this._frame.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(mouseEvent);
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, this._frame);
            return;
        }
        if (mouseEvent.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(mouseEvent);
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._frame != null) {
            this._frame.requestFocusInInternalWindow();
        }
        if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Object object = mouseEvent.getSource();
            if (this._frame != null && (object == this._frame.getUI().getTitlePane() || object == this._frame.getTitleBarComponent() || object == this._frame.getTitleLabelComponent() || object instanceof Gripper)) {
                Action action;
                if (this._dockingManager.getDoubleClickAction() == 0) {
                    this._frame.getFloatingAction(!this._dockingManager.isFloatAllTabs()).actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_FLOAT"));
                } else if (this._dockingManager.getDoubleClickAction() == 1) {
                    this._frame.getMaximizeAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_MAXIMIZE"));
                } else if (this._dockingManager.getDoubleClickAction() == 2) {
                    this._frame.getAutohideAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_AUTOHIDE"));
                } else if (this._dockingManager.getDoubleClickAction() == -2 && (action = this._frame.getCustomDoubleClickAction()) != null) {
                    action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_CUSTOM"));
                }
                return;
            }
            if (this._tabbedPane != null && this.isTabPanelEvent(mouseEvent)) {
                Action action;
                Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tabbedPane);
                int n = this._tabbedPane.getUI().tabForCoordinate(this._tabbedPane, point.x, point.y);
                if (n >= 0 && n < this._tabbedPane.getTabCount() && !this._tabbedPane.isEnabledAt(n)) {
                    return;
                }
                DockableFrame dockableFrame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                if (this._dockingManager.getDoubleClickAction() == 0) {
                    dockableFrame.getFloatingAction(!this._dockingManager.isFloatAllTabs() || n != -1).actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_FLOAT"));
                } else if (this._dockingManager.getDoubleClickAction() == 1) {
                    dockableFrame.getMaximizeAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_MAXIMIZE"));
                } else if (this._dockingManager.getDoubleClickAction() == 2) {
                    dockableFrame.getAutohideAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_TO_AUTOHIDE"));
                } else if (this._dockingManager.getDoubleClickAction() == -2 && (action = dockableFrame.getCustomDoubleClickAction()) != null) {
                    action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "DOUBLE_CLICK_CUSTOM"));
                }
            }
        }
    }

    private boolean isDraggingTarget(MouseEvent mouseEvent) {
        return this._frame.isDraggingTarget(mouseEvent);
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (this._frame != null && (object == this._frame.getUI().getTitlePane() || object == this._frame.getTitleBarComponent() || object == this._frame.getTitleLabelComponent())) {
            this._dockingManager.showContextMenu((Component)object, mouseEvent.getPoint(), this._frame, false);
        } else if (this._tabbedPane != null && this.isTabPanelEvent(mouseEvent)) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._tabbedPane);
            int n = this._tabbedPane.getTabAtLocation(point.x, point.y);
            if (n != -1) {
                DockableFrame dockableFrame = this._tabbedPane.getFrame(n);
                dockableFrame.getDockingManager().activateFrame(dockableFrame.getKey());
                this._dockingManager.showContextMenu((Component)mouseEvent.getSource(), mouseEvent.getPoint(), (DockableFrame)this._tabbedPane.getComponentAt(n), true);
            }
        }
        mouseEvent.consume();
    }
}

