/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Conflict;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.Difference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Merge<T> {
    protected List<T> a;
    protected List<T> b;
    protected List<T> c;
    protected List<Conflict> conflicts = new ArrayList<Conflict>();
    private Comparator<T> _comparator;

    public Merge(T[] TArray, T[] TArray2, T[] TArray3, Comparator<T> comparator) {
        this(Arrays.asList(TArray), Arrays.asList(TArray2), Arrays.asList(TArray3), comparator);
    }

    public Merge(T[] TArray, T[] TArray2, T[] TArray3) {
        this(TArray, TArray2, TArray3, null);
    }

    public Merge(List<T> list, List<T> list2, List<T> list3, Comparator<T> comparator) {
        this.a = list;
        this.b = list2;
        this.c = list3;
        this._comparator = comparator;
    }

    public Merge(List<T> list, List<T> list2, List<T> list3) {
        this(list, list2, list3, null);
    }

    private void checkedAdd(List<Difference> list, Difference difference) {
        if (!list.contains(difference)) {
            list.add(difference);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Conflict> merge() {
        Diff<T> diff = new Diff<T>(this.a, this.b, this._comparator);
        Diff<T> diff2 = new Diff<T>(this.c, this.b, this._comparator);
        List<Difference> list = diff.diff();
        List<Difference> list2 = diff2.diff();
        this.conflicts = new ArrayList<Conflict>();
        int n = 0;
        int n2 = 0;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
        while (true) {
            block14: {
                Difference difference;
                Difference difference2 = n < list.size() ? list.get(n) : null;
                Difference difference3 = difference = n2 < list2.size() ? list2.get(n2) : null;
                if (difference2 == null && difference == null) break;
                if (difference2 == null) {
                    this.checkedAdd(arrayList2, difference);
                    this.mergeDifference(arrayList, arrayList2);
                    ++n2;
                    continue;
                }
                if (difference == null) {
                    this.checkedAdd(arrayList, difference2);
                    this.mergeDifference(arrayList, arrayList2);
                    ++n;
                    continue;
                }
                if (this.isLess(difference2, difference)) {
                    this.checkedAdd(arrayList, difference2);
                    if (this.hasAdjacent(list, n, list2, n2)) {
                        this.checkedAdd(arrayList2, list2.get(n2++));
                        break block14;
                    } else {
                        this.mergeDifference(arrayList, arrayList2);
                        ++n;
                        continue;
                    }
                }
                if (this.isGreater(difference2, difference)) {
                    this.checkedAdd(arrayList2, difference);
                    if (this.hasAdjacent(list2, n2, list, n)) {
                        this.checkedAdd(arrayList, list.get(n++));
                        break block14;
                    } else {
                        this.mergeDifference(arrayList, arrayList2);
                        ++n2;
                        continue;
                    }
                }
                if (this.overlap(difference2, difference)) {
                    this.checkedAdd(arrayList, difference2);
                    this.checkedAdd(arrayList2, difference);
                    boolean bl = this.hasAdjacent(list, n, list2, n2 + 1);
                    boolean bl2 = this.hasAdjacent(list2, n2, list, n + 1);
                    if (!bl && !bl2) {
                        this.mergeDifference(arrayList, arrayList2);
                        ++n;
                        ++n2;
                        continue;
                    }
                    if (bl) {
                        difference = list2.get(++n2);
                        this.checkedAdd(arrayList2, difference);
                        ++n2;
                    }
                    if (bl2) {
                        difference2 = list.get(++n);
                        this.checkedAdd(arrayList, difference2);
                        ++n;
                    }
                }
            }
            if (n == list.size() - 1 && n2 == list2.size() - 1) break;
        }
        if (arrayList.size() != 0 || arrayList2.size() != 0) {
            this.mergeDifference(arrayList, arrayList2);
        }
        return this.conflicts;
    }

    private Difference merge(List<Difference> list) {
        Difference difference = list.get(0);
        Difference difference2 = list.get(list.size() - 1);
        return new Difference(difference.getDeletedStart(), difference2.getDeletedEnd() == -1 ? difference2.getDeletedStart() - 1 : difference2.getDeletedEnd(), difference.getAddedStart(), difference2.getAddedEnd() == -1 ? difference2.getAddedStart() - 1 : difference2.getAddedEnd());
    }

    private void mergeDifference(List<Difference> list, List<Difference> list2) {
        Difference difference;
        Difference difference2 = list.size() == 0 ? null : (difference = list.size() == 1 ? list.get(0) : this.merge(list));
        Difference difference3 = list2.size() == 0 ? null : (list2.size() == 1 ? list2.get(0) : this.merge(list2));
        Conflict conflict = this.processMerge(difference, difference3);
        list.clear();
        list2.clear();
        if (conflict != null) {
            this.conflicts.add(conflict);
        }
    }

    private Conflict processMerge(Difference difference, Difference difference2) {
        if (difference != null && difference2 == null) {
            return new Conflict(difference.getDeletedStart(), difference.getDeletedEnd(), difference.getAddedStart(), difference.getAddedEnd(), -1, -1);
        }
        if (difference == null && difference2 != null) {
            return new Conflict(-1, -1, difference2.getAddedStart(), difference2.getAddedEnd(), difference2.getDeletedStart(), difference2.getDeletedEnd());
        }
        if (difference != null) {
            int n;
            int n2;
            int n3 = difference.getDeletedStart();
            int n4 = difference.getDeletedEnd();
            int n5 = Math.min(difference.getAddedStart(), difference2.getAddedStart());
            int n6 = Math.max(difference.getAddedEnd(), difference2.getAddedEnd());
            int n7 = difference2.getDeletedStart();
            int n8 = difference2.getDeletedEnd();
            if (difference.getAddedStart() > difference2.getAddedStart()) {
                n3 -= difference.getAddedStart() - difference2.getAddedStart();
            }
            if (difference.getAddedStart() < difference2.getAddedStart()) {
                n7 -= difference2.getAddedStart() - difference.getAddedStart();
            }
            if ((n2 = difference.getAddedEnd()) == -1) {
                n2 = difference.getAddedStart() - 1;
            }
            if ((n = difference2.getAddedEnd()) == -1) {
                n = difference2.getAddedStart() - 1;
            }
            if (n2 < n) {
                n4 = n4 == -1 ? n3 + (n - n2) - 1 : (n4 += n - n2);
            }
            if (n2 > n) {
                n8 = n8 == -1 ? n7 + (n2 - n) - 1 : (n8 += n2 - n);
            }
            return new Conflict(n3, n4, n5, n6, n7, n8);
        }
        return null;
    }

    private boolean isLess(Difference difference, Difference difference2) {
        if (difference == null) {
            return true;
        }
        if (difference2 == null) {
            return false;
        }
        return this.getAddedEnd(difference) < this.getAddedStart(difference2);
    }

    private boolean isGreater(Difference difference, Difference difference2) {
        if (difference == null) {
            return false;
        }
        if (difference2 == null) {
            return true;
        }
        return this.getAddedEnd(difference2) < this.getAddedStart(difference);
    }

    private boolean overlap(Difference difference, Difference difference2) {
        if (difference.getAddedStart() == difference2.getAddedStart()) {
            return true;
        }
        if (difference.getAddedEnd() == -1) {
            return difference.getAddedStart() >= difference2.getAddedStart() - 1 && difference.getAddedStart() <= difference2.getAddedEnd() + 1;
        }
        if (difference2.getAddedEnd() == -1) {
            return difference2.getAddedStart() >= difference.getAddedStart() - 1 && difference2.getAddedStart() <= difference.getAddedEnd() + 1;
        }
        if (difference2.getAddedEnd() != -1 && difference2.getAddedEnd() != -1) {
            if (difference.getAddedEnd() < difference2.getAddedStart() - 1) {
                return false;
            }
            return difference2.getAddedEnd() >= difference.getAddedStart() - 1;
        }
        return false;
    }

    private int getAddedEnd(Difference difference) {
        return difference.getAddedEnd() != -1 ? difference.getAddedEnd() : difference.getAddedStart();
    }

    private int getAddedStart(Difference difference) {
        return difference.getAddedStart();
    }

    private boolean hasAdjacent(List<Difference> list, int n, List<Difference> list2, int n2) {
        if (n2 < list2.size()) {
            int n3 = this.getAddedEnd(list.get(n));
            return n3 >= this.getAddedStart(list2.get(n2));
        }
        return false;
    }
}

